/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.config.VersatileConfig;
import com.hbm.interfaces.HalfLifeType;
import com.hbm.items.machine.ItemRTGPellet;
import net.minecraft.item.ItemStack;

public class RTGUtil {
    public static short getPower(ItemRTGPellet fuel, ItemStack stack) {
        return VersatileConfig.scaleRTGPower() ? ItemRTGPellet.getScaledPower(fuel, stack) : fuel.getHeat();
    }

    public static boolean hasHeat(ItemStack[] inventory, int[] rtgSlots) {
        for (int slot : rtgSlots) {
            if (inventory[slot] == null || !(inventory[slot].func_77973_b() instanceof ItemRTGPellet)) continue;
            return true;
        }
        return false;
    }

    public static int updateRTGs(ItemStack[] inventory, int[] rtgSlots) {
        int newHeat = 0;
        for (int slot : rtgSlots) {
            if (inventory[slot] == null || !(inventory[slot].func_77973_b() instanceof ItemRTGPellet)) continue;
            ItemRTGPellet pellet = (ItemRTGPellet)inventory[slot].func_77973_b();
            newHeat += RTGUtil.getPower(pellet, inventory[slot]);
            inventory[slot] = ItemRTGPellet.handleDecay(inventory[slot], pellet);
        }
        return newHeat;
    }

    public static long getLifespan(float halfLife, HalfLifeType type, boolean realYears) {
        float life = 0.0f;
        switch (type) {
            case LONG: {
                life = (float)(48000 * (realYears ? 365 : 100) * 100) * halfLife;
                break;
            }
            case MEDIUM: {
                life = (float)(48000 * (realYears ? 365 : 100)) * halfLife;
                break;
            }
            case SHORT: {
                life = 48000.0f * halfLife;
            }
        }
        return (long)life;
    }
}

