/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.container.ContainerMachineOilWell;
import com.hbm.inventory.gui.GUIMachineOilWell;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.machine.oil.TileEntityOilDrillBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachineOilWell
extends TileEntityOilDrillBase {
    protected static int maxPower = 100000;
    protected static int consumption = 100;
    protected static int delay = 50;
    protected static int oilPerDepsoit = 500;
    protected static int gasPerDepositMin = 100;
    protected static int gasPerDepositMax = 500;
    protected static double drainChance = 0.05;
    AxisAlignedBB bb = null;

    @Override
    public String getName() {
        return "container.oilWell";
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public int getPowerReq() {
        return consumption;
    }

    @Override
    public int getDelay() {
        return delay;
    }

    @Override
    public void onDrill(int y) {
        int[] ids;
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        ItemStack stack = new ItemStack(b);
        int[] nArray = ids = OreDictionary.getOreIDs((ItemStack)stack);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int k;
            int j;
            Integer i2 = nArray[i];
            String name = OreDictionary.getOreName((int)i2);
            if ("oreUranium".equals(name)) {
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        if (!this.field_145850_b.func_147439_a(this.field_145851_c + j, this.field_145848_d + 10, this.field_145849_e + j).isReplaceable((IBlockAccess)this.field_145850_b, this.field_145851_c + j, this.field_145848_d + 7, this.field_145849_e + k)) continue;
                        this.field_145850_b.func_147449_b(this.field_145851_c + k, this.field_145848_d + 10, this.field_145849_e + k, ModBlocks.gas_radon_dense);
                    }
                }
            }
            if (!"oreAsbestos".equals(name)) continue;
            for (j = -1; j <= 1; ++j) {
                for (k = -1; k <= 1; ++k) {
                    if (!this.field_145850_b.func_147439_a(this.field_145851_c + j, this.field_145848_d + 10, this.field_145849_e + j).isReplaceable((IBlockAccess)this.field_145850_b, this.field_145851_c + j, this.field_145848_d + 7, this.field_145849_e + k)) continue;
                    this.field_145850_b.func_147449_b(this.field_145851_c + k, this.field_145848_d + 10, this.field_145849_e + k, ModBlocks.gas_asbestos);
                }
            }
        }
    }

    @Override
    public void onSuck(int x, int y, int z) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "game.neutral.swim.splash", 2.0f, 0.5f);
        this.tanks[0].setFill(this.tanks[0].getFill() + oilPerDepsoit);
        if (this.tanks[0].getFill() > this.tanks[0].getMaxFill()) {
            this.tanks[0].setFill(this.tanks[0].getMaxFill());
        }
        this.tanks[1].setFill(this.tanks[1].getFill() + (gasPerDepositMin + this.field_145850_b.field_73012_v.nextInt(gasPerDepositMax - gasPerDepositMin + 1)));
        if (this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
            this.tanks[1].setFill(this.tanks[1].getMaxFill());
        }
        if (this.field_145850_b.field_73012_v.nextDouble() < drainChance) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.ore_oil_empty);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 10), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @Override
    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    @Override
    public String getConfigName() {
        return "derrick";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "I:powerCap", maxPower);
        consumption = IConfigurableMachine.grab(obj, "I:consumption", consumption);
        delay = IConfigurableMachine.grab(obj, "I:delay", delay);
        oilPerDepsoit = IConfigurableMachine.grab(obj, "I:oilPerDeposit", oilPerDepsoit);
        gasPerDepositMin = IConfigurableMachine.grab(obj, "I:gasPerDepositMin", gasPerDepositMin);
        gasPerDepositMax = IConfigurableMachine.grab(obj, "I:gasPerDepositMax", gasPerDepositMax);
        drainChance = IConfigurableMachine.grab(obj, "D:drainChance", drainChance);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:powerCap").value((long)maxPower);
        writer.name("I:consumption").value((long)consumption);
        writer.name("I:delay").value((long)delay);
        writer.name("I:oilPerDeposit").value((long)oilPerDepsoit);
        writer.name("I:gasPerDepositMin").value((long)gasPerDepositMin);
        writer.name("I:gasPerDepositMax").value((long)gasPerDepositMax);
        writer.name("D:drainChance").value(drainChance);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineOilWell(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineOilWell(player.field_71071_by, this);
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_well));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 10 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.AFTERBURN) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.burn", level * 10, level * 50));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }
}

