/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.mob.EntityCyberCrab;
import com.hbm.entity.mob.EntityTaintCrab;
import com.hbm.entity.mob.EntityTeslaCrab;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ArmorUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTesla
extends TileEntityMachineBase
implements IEnergyReceiverMK2 {
    public long power;
    public static final long maxPower = 100000L;
    public static int range = 10;
    public static double offset = 1.75;
    public List<double[]> targets = new ArrayList<double[]>();

    public TileEntityTesla() {
        super(0);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.targets.clear();
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ModBlocks.meteor_battery) {
                this.power = 100000L;
            }
            if (this.power >= 5000L) {
                this.power -= 5000L;
                double dx = (double)this.field_145851_c + 0.5;
                double dy = (double)this.field_145848_d + offset;
                double dz = (double)this.field_145849_e + 0.5;
                this.targets = TileEntityTesla.zap(this.field_145850_b, dx, dy, dz, range, null);
            }
            this.networkPackNT(100);
        }
    }

    private void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
    }

    public static List<double[]> zap(World worldObj, double x, double y, double z, double radius, Entity source) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        List targets = worldObj.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius)));
        for (EntityLivingBase e : targets) {
            Vec3 vec;
            if (e instanceof EntityOcelot || e == source || (vec = Vec3.func_72443_a((double)(e.field_70165_t - x), (double)(e.field_70163_u + (double)(e.field_70131_O / 2.0f) - y), (double)(e.field_70161_v - z))).func_72433_c() > (double)range || Library.isObstructed(worldObj, x, y, z, e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v)) continue;
            if (e instanceof EntityTaintCrab) {
                ret.add(new double[]{e.field_70165_t, e.field_70163_u + 1.25, e.field_70161_v});
                e.func_70691_i(15.0f);
                continue;
            }
            if (e instanceof EntityTeslaCrab) {
                ret.add(new double[]{e.field_70165_t, e.field_70163_u + 1.0, e.field_70161_v});
                e.func_70691_i(10.0f);
                continue;
            }
            if (e instanceof EntityCyberCrab) {
                ret.add(new double[]{e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v});
                continue;
            }
            if (e instanceof EntityCreeper) {
                ((EntityCreeper)e).func_70096_w().func_75692_b(17, (Object)1);
                ret.add(new double[]{e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v});
                continue;
            }
            if (!(e instanceof EntityPlayer && ArmorUtil.checkForFaraday((EntityPlayer)e) || !e.func_70097_a(ModDamageSource.electricity, MathHelper.func_76131_a((float)(e.func_110138_aP() * 0.5f), (float)3.0f, (float)20.0f) / (float)targets.size()))) {
                worldObj.func_72956_a((Entity)e, "hbm:weapon.tesla", 1.0f, 1.0f);
            }
            double offset = 0.0;
            if (source != null && e instanceof EntityPlayer && worldObj.field_72995_K) {
                offset = e.field_70131_O;
            }
            ret.add(new double[]{e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f) - offset, e.field_70161_v});
        }
        return ret;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeShort((int)((short)this.targets.size()));
        for (double[] d : this.targets) {
            buf.writeDouble(d[0]);
            buf.writeDouble(d[1]);
            buf.writeDouble(d[2]);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        int s = buf.readShort();
        this.targets.clear();
        for (int i = 0; i < s; ++i) {
            this.targets.add(new double[]{buf.readDouble(), buf.readDouble(), buf.readDouble()});
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

