/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerCrystallizer;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUICrystallizer;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCrystallizer
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiver,
IGUIProvider,
IUpgradeInfoProvider,
IFluidCopiable {
    public long power;
    public static final long maxPower = 1000000L;
    public static final int demand = 1000;
    public short progress;
    public short duration = (short)600;
    public boolean isOn;
    public float angle;
    public float prevAngle;
    public FluidTank tank;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT(this);
    AxisAlignedBB bb = null;

    public TileEntityMachineCrystallizer() {
        super(8);
        this.tank = new FluidTank(Fluids.PEROXIDE, 8000);
    }

    @Override
    public String getName() {
        return "container.crystallizer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.isOn = false;
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 1000000L);
            this.tank.setType(7, this.slots);
            this.tank.loadTank(3, 4, this.slots);
            this.upgradeManager.checkSlots(this.slots, 5, 6);
            int i = 0;
            while ((float)i < this.getCycleCount()) {
                if (this.canProcess()) {
                    this.progress = (short)(this.progress + 1);
                    this.power -= (long)this.getPowerRequired();
                    this.isOn = true;
                    if (this.progress > this.getDuration()) {
                        this.progress = 0;
                        this.processItem();
                        this.func_70296_d();
                    }
                } else {
                    this.progress = 0;
                }
                ++i;
            }
            this.networkPackNT(25);
        } else {
            this.prevAngle = this.angle;
            if (this.isOn) {
                this.angle += 5.0f * this.getCycleCount();
                if (this.angle >= 360.0f) {
                    this.angle -= 360.0f;
                    this.prevAngle -= 360.0f;
                }
                if (this.field_145850_b.field_73012_v.nextInt(20) == 0 && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 6), (double)this.field_145849_e + 0.5) < 50.0) {
                    this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_145848_d + 6.5, (double)this.field_145849_e + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.1, 0.0);
                }
            }
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.25), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.25), (double)((double)this.field_145851_c + 0.75), (double)(this.field_145848_d + 6), (double)((double)this.field_145849_e + 0.75)).func_72317_d((double)rot.offsetX * 1.5, 0.0, (double)rot.offsetZ * 1.5));
        for (EntityPlayer player : players) {
            HbmPlayerProps props = HbmPlayerProps.getData(player);
            props.isOnLadder = true;
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeShort((int)this.progress);
        buf.writeShort((int)this.getDuration());
        buf.writeLong(this.power);
        buf.writeBoolean(this.isOn);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.progress = buf.readShort();
        this.duration = buf.readShort();
        this.power = buf.readLong();
        this.isOn = buf.readBoolean();
        this.tank.deserialize(buf);
    }

    private void processItem() {
        CrystallizerRecipes.CrystallizerRecipe result = CrystallizerRecipes.getOutput(this.slots[0], this.tank.getTankType());
        if (result == null) {
            return;
        }
        ItemStack stack = result.output.func_77946_l();
        if (this.slots[2] == null) {
            this.slots[2] = stack;
        } else if (this.slots[2].field_77994_a + stack.field_77994_a <= this.slots[2].func_77976_d()) {
            this.slots[2].field_77994_a += stack.field_77994_a;
        }
        this.tank.setFill(this.tank.getFill() - this.getRequiredAcid(result.acidAmount));
        float freeChance = this.getFreeChance(result);
        if (freeChance == 0.0f || freeChance < this.field_145850_b.field_73012_v.nextFloat()) {
            this.func_70298_a(0, result.itemAmount);
        }
    }

    private boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        if (this.power < (long)this.getPowerRequired()) {
            return false;
        }
        CrystallizerRecipes.CrystallizerRecipe result = CrystallizerRecipes.getOutput(this.slots[0], this.tank.getTankType());
        if (result == null) {
            return false;
        }
        if (this.slots[0].field_77994_a < result.itemAmount) {
            return false;
        }
        if (this.tank.getFill() < this.getRequiredAcid(result.acidAmount)) {
            return false;
        }
        ItemStack stack = result.output.func_77946_l();
        if (this.slots[2] != null && (this.slots[2].func_77973_b() != stack.func_77973_b() || this.slots[2].func_77960_j() != stack.func_77960_j())) {
            return false;
        }
        return this.slots[2] == null || this.slots[2].field_77994_a + stack.field_77994_a <= this.slots[2].func_77976_d();
    }

    public int getRequiredAcid(int base) {
        return base;
    }

    public float getFreeChance(CrystallizerRecipes.CrystallizerRecipe recipe) {
        int efficiency = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT);
        if (efficiency > 0) {
            return Math.min((float)efficiency * recipe.productivity, 0.99f);
        }
        return 0.0f;
    }

    public short getDuration() {
        CrystallizerRecipes.CrystallizerRecipe result = CrystallizerRecipes.getOutput(this.slots[0], this.tank.getTankType());
        int base = result != null ? result.duration : 600;
        int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
        if (speed > 0) {
            return (short)Math.ceil((float)base * Math.max(1.0f - 0.25f * (float)speed, 0.25f));
        }
        return (short)base;
    }

    public int getPowerRequired() {
        int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
        int effect = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT);
        return 1000 + speed * 1000 + effect * 1000 * 2;
    }

    public float getCycleCount() {
        int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
        return Math.min(1 + speed * 2, 7);
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 1000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.duration;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && CrystallizerRecipes.getOutput(itemStack, this.tank.getTankType()) != null) {
            return true;
        }
        return i == 1 && itemStack.func_77973_b() instanceof IBatteryItem;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 2};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 10), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 5 && i <= 6 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCrystallizer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICrystallizer(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.EFFECT || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_crystallizer));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.EFFECT) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.efficiency", "x" + level));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 200 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.EFFECT, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }

    @Override
    public int[] getFluidIDToCopy() {
        return new int[]{this.tank.getTankType().getID()};
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tank;
    }
}

