/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mods.XWeaponModManager;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderStarFAkimbo
extends ItemRenderWeaponBase {
    @Override
    public boolean isAkimbo(EntityLivingBase entity) {
        return true;
    }

    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.25f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        float offset = 0.8f;
        for (int i = -1; i <= 1; i += 2) {
            int index = i == -1 ? 0 : 1;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.star_f_elite_tex);
            GL11.glPushMatrix();
            ItemRenderStarFAkimbo.standardAimingTransform(stack, -2.0f * offset * (float)i, -1.75f * offset, 2.5f * offset, 0.0, -0.953125, 1.0);
            double scale = 0.25;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            double[] equip = HbmAnimations.getRelevantTransformation("EQUIP", index);
            double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL", index);
            double[] hammer = HbmAnimations.getRelevantTransformation("HAMMER", index);
            double[] tilt = HbmAnimations.getRelevantTransformation("TILT", index);
            double[] turn = HbmAnimations.getRelevantTransformation("TURN", index);
            double[] mag = HbmAnimations.getRelevantTransformation("MAG", index);
            double[] bullet = HbmAnimations.getRelevantTransformation("BULLET", index);
            double[] slide = HbmAnimations.getRelevantTransformation("SLIDE", index);
            GL11.glTranslated((double)0.0, (double)-2.0, (double)-8.0);
            GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)2.0, (double)8.0);
            GL11.glTranslated((double)0.0, (double)1.0, (double)-3.0);
            GL11.glRotated((double)(turn[2] * (double)i), (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)tilt[0], (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)-1.0, (double)3.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)recoil[2]);
            GL11.glShadeModel((int)7425);
            ResourceManager.star_f.renderPart("Gun");
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.75, (double)-4.25);
            GL11.glRotated((double)(60.0 * (hammer[0] - 1.0)), (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)-1.75, (double)4.25);
            ResourceManager.star_f.renderPart("Hammer");
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)(slide[2] * 2.3125));
            ResourceManager.star_f.renderPart("Slide");
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)mag[0], (double)mag[1], (double)mag[2]);
            ResourceManager.star_f.renderPart("Mag");
            GL11.glTranslated((double)bullet[0], (double)bullet[1], (double)bullet[2]);
            ResourceManager.star_f.renderPart("Bullet");
            GL11.glPopMatrix();
            if (this.hasSilencer(stack, index)) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)2.375, (double)-0.25);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.uzi_tex);
                ResourceManager.uzi.renderPart("Silencer");
                GL11.glPopMatrix();
            } else {
                double smokeScale = 0.5;
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)3.0, (double)6.125);
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
                ItemRenderStarFAkimbo.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)index).smokeNodes, 0.75);
                GL11.glPopMatrix();
                GL11.glShadeModel((int)7424);
                this.renderMuzzleFlash(gun.shotRand, gun.lastShot[index]);
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        GL11.glTranslated((double)0.0, (double)-0.25, (double)1.75);
        double scale = 0.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
    }

    @Override
    public void setupThirdPersonAkimbo(ItemStack stack) {
        super.setupThirdPersonAkimbo(stack);
        GL11.glTranslated((double)0.0, (double)-0.25, (double)1.75);
        double scale = 0.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
    }

    @Override
    public void setupInv(ItemStack stack) {
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3008);
        GL11.glScaled((double)1.0, (double)1.0, (double)-1.0);
        GL11.glTranslated((double)8.0, (double)8.0, (double)0.0);
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -6.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.25, (double)-5.0);
    }

    @Override
    public void renderEquipped(ItemStack stack, Object ... data) {
        this.renderStandardGun(stack, 1);
        if (!this.hasSilencer(stack, 1)) {
            this.renderThirdPersonFlash((Entity)((EntityLivingBase)data[1]), stack, 1);
        }
    }

    @Override
    public void renderEquippedAkimbo(ItemStack stack, EntityLivingBase ent) {
        this.renderStandardGun(stack, 0);
        if (!this.hasSilencer(stack, 0)) {
            this.renderThirdPersonFlash((Entity)ent, stack, 0);
        }
    }

    @Override
    public void renderModTable(ItemStack stack, int index) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.star_f_elite_tex);
        ResourceManager.star_f.renderPart("Gun");
        ResourceManager.star_f.renderPart("Slide");
        ResourceManager.star_f.renderPart("Mag");
        ResourceManager.star_f.renderPart("Hammer");
        if (this.hasSilencer(stack, index)) {
            GL11.glTranslated((double)0.0, (double)2.375, (double)-0.25);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.uzi_tex);
            ResourceManager.uzi.renderPart("Silencer");
        }
        GL11.glShadeModel((int)7424);
    }

    @Override
    public void renderEntity(ItemStack stack) {
        boolean anySilenced;
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        boolean bl = anySilenced = this.hasSilencer(stack, 0) || this.hasSilencer(stack, 1);
        if (anySilenced) {
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)-1.0, (double)1.0, (double)0.0);
        this.renderStandardGun(stack, 1);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
        this.renderStandardGun(stack, 0);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
        double scale;
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        boolean anySilenced = this.hasSilencer(stack, 0) || this.hasSilencer(stack, 1);
        GL11.glPushMatrix();
        GL11.glRotated((double)225.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
        if (anySilenced) {
            scale = 0.625;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-4.0);
        }
        this.renderStandardGun(stack, 1);
        GL11.glPopMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)5.0);
        GL11.glPushMatrix();
        GL11.glRotated((double)225.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)-45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)0.0, (double)0.0);
        if (anySilenced) {
            scale = 0.625;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-4.0);
        }
        this.renderStandardGun(stack, 0);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
    }

    public boolean hasSilencer(ItemStack stack, int cfg) {
        return XWeaponModManager.hasUpgrade(stack, cfg, 201);
    }

    public void renderStandardGun(ItemStack stack, int index) {
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.star_f_elite_tex);
        ResourceManager.star_f.renderPart("Gun");
        ResourceManager.star_f.renderPart("Slide");
        ResourceManager.star_f.renderPart("Mag");
        ResourceManager.star_f.renderPart("Hammer");
        boolean silenced = this.hasSilencer(stack, index);
        if (silenced) {
            GL11.glTranslated((double)0.0, (double)2.375, (double)-0.25);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.uzi_tex);
            ResourceManager.uzi.renderPart("Silencer");
        }
        GL11.glShadeModel((int)7424);
    }

    public void renderThirdPersonFlash(Entity ent, ItemStack stack, int config) {
        long shot;
        double shotRand = 0.0;
        if (ent == Minecraft.func_71410_x().field_71439_g) {
            ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
            shot = gun.lastShot[config];
            shotRand = gun.shotRand;
        } else {
            shot = ItemRenderWeaponBase.flashMap.getOrDefault(ent, -1L);
            if (shot < 0L) {
                return;
            }
        }
        this.renderMuzzleFlash(shotRand, shot);
    }

    public void renderMuzzleFlash(double shotRand, long shot) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)3.0, (double)6.125);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(90.0 * shotRand), (double)1.0, (double)0.0, (double)0.0);
        ItemRenderStarFAkimbo.renderMuzzleFlash(shot, 75, 7.5);
        GL11.glPopMatrix();
    }
}

