/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockConcreteColoredExt;
import com.hbm.blocks.generic.BlockRebar;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.SlotPattern;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.ItemInventory;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.util.ChatBuilder;
import com.hbm.util.InventoryUtil;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.Tuple;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ItemRebarPlacer
extends Item
implements IGUIProvider {
    public static List<Tuple.Pair<Block, Integer>> acceptableConk = new ArrayList<Tuple.Pair<Block, Integer>>();

    public ItemRebarPlacer() {
        int i;
        this.func_77625_d(1);
        acceptableConk.add(new Tuple.Pair<Block, Integer>(ModBlocks.concrete, 0));
        acceptableConk.add(new Tuple.Pair<Block, Integer>(ModBlocks.concrete_rebar, 0));
        acceptableConk.add(new Tuple.Pair<Block, Integer>(ModBlocks.concrete_smooth, 0));
        acceptableConk.add(new Tuple.Pair<Block, Integer>(ModBlocks.concrete_pillar, 0));
        for (i = 0; i < 16; ++i) {
            acceptableConk.add(new Tuple.Pair<Block, Integer>(ModBlocks.concrete_colored, i));
        }
        for (i = 0; i < BlockConcreteColoredExt.EnumConcreteType.values().length; ++i) {
            acceptableConk.add(new Tuple.Pair<Block, Integer>(ModBlocks.concrete_colored_ext, i));
        }
    }

    public static boolean isValidConk(Item item, int meta) {
        for (Tuple.Pair<Block, Integer> conk : acceptableConk) {
            if (item != Item.func_150898_a((Block)conk.getKey()) || meta != conk.getValue()) continue;
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("pos")) {
            ItemStack theConk = ItemStackUtil.readStacksFromNBT(stack, 1)[0];
            if (!held || theConk == null) {
                stack.field_77990_d.func_82580_o("pos");
                return;
            }
            if (!ItemRebarPlacer.isValidConk(theConk.func_77973_b(), theConk.func_77960_j())) {
                stack.field_77990_d.func_82580_o("pos");
                return;
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af()) {
            player.openGui((Object)MainRegistry.instance, 0, world, 0, 0, 0);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        ItemStack theConk;
        boolean hasConk;
        if (world.field_72995_K) {
            return true;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
            ItemStackUtil.addStacksToNBT(stack, new ItemStack(ModBlocks.concrete_rebar));
        }
        boolean bl = hasConk = (theConk = ItemStackUtil.readStacksFromNBT(stack, 1)[0]) != null && ItemRebarPlacer.isValidConk(theConk.func_77973_b(), theConk.func_77960_j());
        if (!hasConk) {
            player.func_145747_a((IChatComponent)ChatBuilder.start("[").color(EnumChatFormatting.DARK_AQUA).nextTranslation(this.func_77658_a() + ".name", new Object[0]).color(EnumChatFormatting.DARK_AQUA).next("] ").color(EnumChatFormatting.DARK_AQUA).next("No valid concrete type set!").color(EnumChatFormatting.RED).flush());
            return true;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (!stack.field_77990_d.func_74764_b("pos")) {
            stack.field_77990_d.func_74783_a("pos", new int[]{x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ});
        } else {
            int rebarLeft = InventoryUtil.countAStackMatches(player, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rebar), true);
            if (rebarLeft <= 0) {
                player.func_145747_a((IChatComponent)ChatBuilder.start("[").color(EnumChatFormatting.DARK_AQUA).nextTranslation(this.func_77658_a() + ".name", new Object[0]).color(EnumChatFormatting.DARK_AQUA).next("] ").color(EnumChatFormatting.DARK_AQUA).next("Out of rebar!").color(EnumChatFormatting.RED).flush());
                stack.field_77990_d.func_82580_o("pos");
                return true;
            }
            int[] pos = stack.field_77990_d.func_74759_k("pos");
            int iX = x + dir.offsetX;
            int iY = y + dir.offsetY;
            int iZ = z + dir.offsetZ;
            int minX = Math.min(pos[0], iX);
            int maxX = Math.max(pos[0], iX);
            int minY = Math.min(pos[1], iY);
            int maxY = Math.max(pos[1], iY);
            int minZ = Math.min(pos[2], iZ);
            int maxZ = Math.max(pos[2], iZ);
            int rebarUsed = 0;
            block0: for (int k = minY; k <= maxY; ++k) {
                for (int j = minZ; j <= maxZ; ++j) {
                    for (int i = minX; i <= maxX; ++i) {
                        if (rebarLeft <= 0) break block0;
                        if (!world.func_147439_a(i, k, j).isReplaceable((IBlockAccess)world, i, k, j) || !player.func_82247_a(i, k, j, side, stack)) continue;
                        world.func_147449_b(i, k, j, ModBlocks.rebar);
                        TileEntity tile = world.func_147438_o(i, k, j);
                        if (tile instanceof BlockRebar.TileEntityRebar) {
                            ((BlockRebar.TileEntityRebar)tile).setup(Block.func_149634_a((Item)theConk.func_77973_b()), theConk.func_77960_j());
                        }
                        ++rebarUsed;
                        --rebarLeft;
                    }
                }
            }
            InventoryUtil.tryConsumeAStack(player.field_71071_by.field_70462_a, 0, player.field_71071_by.field_70462_a.length - 1, new RecipesCommon.ComparableStack(ModBlocks.rebar, rebarUsed));
            player.func_145747_a((IChatComponent)ChatBuilder.start("[").color(EnumChatFormatting.DARK_AQUA).nextTranslation(this.func_77658_a() + ".name", new Object[0]).color(EnumChatFormatting.DARK_AQUA).next("] ").color(EnumChatFormatting.DARK_AQUA).next("Placed " + rebarUsed + " rebar!").color(EnumChatFormatting.GREEN).flush());
            stack.field_77990_d.func_82580_o("pos");
            player.field_71069_bz.func_75142_b();
        }
        return true;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRebar(player.field_71071_by, new InventoryRebar(player, player.func_70694_bm()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRebar(player.field_71071_by, new InventoryRebar(player, player.func_70694_bm()));
    }

    public static class GUIRebar
    extends GuiInfoContainer {
        private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_rebar.png");
        private final InventoryRebar inventory;

        public GUIRebar(InventoryPlayer invPlayer, InventoryRebar box) {
            super(new ContainerRebar(invPlayer, box));
            this.inventory = box;
            this.field_146999_f = 176;
            this.field_147000_g = 182;
        }

        public void func_73863_a(int mouseX, int mouseY, float f) {
            super.func_73863_a(mouseX, mouseY, f);
            if (this.func_146981_a(this.field_147002_h.func_75139_a(0), mouseX, mouseY) && !this.field_147002_h.func_75139_a(0).func_75216_d()) {
                ArrayList<Object[]> lines = new ArrayList<Object[]>();
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (Tuple.Pair<Block, Integer> conk : acceptableConk) {
                    list.add(new ItemStack(conk.getKey(), 1, conk.getValue().intValue()));
                }
                ItemStack selected = (ItemStack)list.get(0);
                if (list.size() > 1) {
                    int cycle = (int)(System.currentTimeMillis() % (long)(1000 * list.size()) / 1000L);
                    selected = ((ItemStack)list.get(cycle)).func_77946_l();
                    selected.field_77994_a = 0;
                    list.set(cycle, selected);
                }
                if (list.size() < 10) {
                    lines.add(list.toArray());
                } else if (list.size() < 24) {
                    lines.add(list.subList(0, list.size() / 2).toArray());
                    lines.add(list.subList(list.size() / 2, list.size()).toArray());
                } else {
                    int bound0 = (int)Math.ceil((double)list.size() / 3.0);
                    int bound1 = (int)Math.ceil((double)list.size() / 3.0 * 2.0);
                    lines.add(list.subList(0, bound0).toArray());
                    lines.add(list.subList(bound0, bound1).toArray());
                    lines.add(list.subList(bound1, list.size()).toArray());
                }
                lines.add(new Object[]{I18nUtil.resolveKey(selected.func_82833_r(), new Object[0])});
                this.drawStackText(lines, mouseX, mouseY, this.field_146289_q);
            }
        }

        protected void func_146979_b(int i, int j) {
            String name = I18n.func_135052_a((String)this.inventory.func_145825_b(), (Object[])new Object[0]);
            if (this.inventory.func_145818_k_()) {
                name = this.inventory.target.func_82833_r();
            }
            this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        }

        protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            if (this.inventory.slots[0] == null || !ItemRebarPlacer.isValidConk(this.inventory.slots[0].func_77973_b(), this.inventory.slots[0].func_77960_j())) {
                this.func_73729_b(this.field_147003_i + 87, this.field_147009_r + 17, 176, 0, 56, 56);
            }
        }
    }

    public static class ContainerRebar
    extends Container {
        private InventoryRebar rebar;

        public ContainerRebar(InventoryPlayer invPlayer, InventoryRebar rebar) {
            int i;
            this.rebar = rebar;
            this.func_75146_a(new SlotPattern(rebar, 0, 53, 36));
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 100 + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)invPlayer, i, 8 + i * 18, 158));
            }
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            return null;
        }

        public ItemStack func_75144_a(int index, int button, int mode, EntityPlayer player) {
            if (mode == 2 && button == player.field_71071_by.field_70461_c) {
                return null;
            }
            if (index == player.field_71071_by.field_70461_c + 47) {
                return null;
            }
            if (index != 0) {
                return super.func_75144_a(index, button, mode, player);
            }
            Slot slot = this.func_75139_a(index);
            ItemStack ret = null;
            ItemStack held = player.field_71071_by.func_70445_o();
            if (slot.func_75216_d()) {
                ret = slot.func_75211_c().func_77946_l();
            }
            slot.func_75215_d(held);
            this.rebar.func_70296_d();
            return ret;
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.rebar.func_70300_a(player);
        }

        public void func_75134_a(EntityPlayer player) {
            super.func_75134_a(player);
        }
    }

    public static class InventoryRebar
    extends ItemInventory {
        public InventoryRebar(EntityPlayer player, ItemStack box) {
            ItemStack[] fromNBT;
            this.player = player;
            this.target = box;
            this.slots = new ItemStack[this.func_70302_i_()];
            if (!box.func_77942_o()) {
                box.func_77982_d(new NBTTagCompound());
            }
            if ((fromNBT = ItemStackUtil.readStacksFromNBT(box, this.slots.length)) != null) {
                System.arraycopy(fromNBT, 0, this.slots, 0, this.slots.length);
            }
        }

        public int func_70302_i_() {
            return 1;
        }

        public String func_145825_b() {
            return "container.rebar";
        }

        public boolean func_145818_k_() {
            return this.target.func_82837_s();
        }

        @Override
        public int func_70297_j_() {
            return 1;
        }
    }
}

