/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.machine.ItemScraps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RotaryFurnaceRecipes
extends SerializableRecipe {
    public static List<RotaryFurnaceRecipe> recipes = new ArrayList<RotaryFurnaceRecipe>();

    @Override
    public void registerDefaults() {
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_STEEL, MaterialShapes.INGOT.q(1)), 100, 100, new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), new RecipesCommon.OreDictStack(OreDictManager.COAL.gem())));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_STEEL, MaterialShapes.INGOT.q(1)), 100, 100, new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem())));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_STEEL, MaterialShapes.INGOT.q(2)), 200, 25, new RecipesCommon.OreDictStack(OreDictManager.IRON.fragment(), 9), new RecipesCommon.OreDictStack(OreDictManager.COAL.gem())));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_STEEL, MaterialShapes.INGOT.q(3)), 200, 25, new RecipesCommon.OreDictStack(OreDictManager.IRON.fragment(), 9), new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem())));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_STEEL, MaterialShapes.INGOT.q(4)), 400, 25, new RecipesCommon.OreDictStack(OreDictManager.IRON.fragment(), 9), new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem()), new RecipesCommon.ComparableStack(ModItems.powder_flux)));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_DESH, MaterialShapes.INGOT.q(1)), 100, 200, new FluidStack(Fluids.LIGHTOIL, 100), new RecipesCommon.ComparableStack(ModItems.powder_desh_ready)));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_GUNMETAL, MaterialShapes.INGOT.q(4)), 200, 100, new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.AL.ingot(), 1)));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_WEAPONSTEEL, MaterialShapes.INGOT.q(1)), 200, 400, new FluidStack(Fluids.GAS_COKER, 100), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.powder_flux, 2)));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_SATURN, MaterialShapes.INGOT.q(2)), 200, 400, new FluidStack(Fluids.REFORMGAS, 250), new RecipesCommon.OreDictStack(OreDictManager.DURA.dust(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.dust())));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_SATURN, MaterialShapes.INGOT.q(4)), 200, 300, new FluidStack(Fluids.REFORMGAS, 250), new RecipesCommon.OreDictStack(OreDictManager.DURA.dust(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.dust()), new RecipesCommon.OreDictStack(OreDictManager.BORAX.dust())));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_ALUMINIUM, MaterialShapes.INGOT.q(2)), 100, 400, new FluidStack(Fluids.SODIUM_ALUMINATE, 150), new RecipesCommon.AStack[0]));
        recipes.add(new RotaryFurnaceRecipe(new Mats.MaterialStack(Mats.MAT_ALUMINIUM, MaterialShapes.INGOT.q(3)), 40, 200, new FluidStack(Fluids.SODIUM_ALUMINATE, 150), new RecipesCommon.ComparableStack(ModItems.powder_flux, 2)));
    }

    public static HashMap getRecipes() {
        HashMap<Object[], ItemStack> recipes = new HashMap<Object[], ItemStack>();
        for (RotaryFurnaceRecipe recipe : RotaryFurnaceRecipes.recipes) {
            int size = recipe.ingredients.length + (recipe.fluid != null ? 1 : 0);
            Object[] array = new Object[size];
            for (int i = 0; i < recipe.ingredients.length; ++i) {
                array[i] = recipe.ingredients[i];
            }
            if (recipe.fluid != null) {
                array[size - 1] = ItemFluidIcon.make(recipe.fluid);
            }
            recipes.put(array, ItemScraps.create(recipe.output, true));
        }
        return recipes;
    }

    public static RotaryFurnaceRecipe getRecipe(ItemStack ... inputs) {
        block0: for (RotaryFurnaceRecipe recipe : recipes) {
            ArrayList<RecipesCommon.AStack> recipeList = new ArrayList<RecipesCommon.AStack>();
            for (RecipesCommon.AStack ingredient : recipe.ingredients) {
                recipeList.add(ingredient);
            }
            for (int i = 0; i < inputs.length; ++i) {
                ItemStack inputStack = inputs[i];
                if (inputStack == null) continue;
                boolean hasMatch = false;
                for (RecipesCommon.AStack recipeStack : recipeList) {
                    if (!recipeStack.matchesRecipe(inputStack, true) || inputStack.field_77994_a < recipeStack.stacksize) continue;
                    hasMatch = true;
                    recipeList.remove(recipeStack);
                    break;
                }
                if (!hasMatch) continue block0;
            }
            if (!recipeList.isEmpty()) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public String getFileName() {
        return "hbmRotaryFurnace.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack[] inputs = RotaryFurnaceRecipes.readAStackArray(obj.get("inputs").getAsJsonArray());
        FluidStack fluid = obj.has("fluid") ? RotaryFurnaceRecipes.readFluidStack(obj.get("fluid").getAsJsonArray()) : null;
        JsonArray array = obj.get("output").getAsJsonArray();
        Mats.MaterialStack stack = new Mats.MaterialStack(Mats.matByName.get(array.get(0).getAsString()), array.get(1).getAsInt());
        int duration = obj.get("duration").getAsInt();
        int steam = obj.get("steam").getAsInt();
        recipes.add(new RotaryFurnaceRecipe(stack, duration, steam, fluid, inputs));
    }

    @Override
    public void writeRecipe(Object obj, JsonWriter writer) throws IOException {
        RotaryFurnaceRecipe recipe = (RotaryFurnaceRecipe)obj;
        writer.name("inputs").beginArray();
        for (RecipesCommon.AStack aStack : recipe.ingredients) {
            RotaryFurnaceRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        if (recipe.fluid != null) {
            writer.name("fluid");
            RotaryFurnaceRecipes.writeFluidStack(recipe.fluid, writer);
        }
        writer.name("output").beginArray();
        writer.setIndent("");
        writer.value(recipe.output.material.names[0]).value((long)recipe.output.amount);
        writer.endArray();
        writer.setIndent("  ");
        writer.name("duration").value((long)recipe.duration);
        writer.name("steam").value((long)recipe.steam);
    }

    public static class RotaryFurnaceRecipe {
        public RecipesCommon.AStack[] ingredients;
        public FluidStack fluid;
        public Mats.MaterialStack output;
        public int duration;
        public int steam;

        public RotaryFurnaceRecipe(Mats.MaterialStack output, int duration, int steam, FluidStack fluid, RecipesCommon.AStack ... ingredients) {
            this.ingredients = ingredients;
            this.fluid = fluid;
            this.output = output;
            this.duration = duration;
            this.steam = steam;
        }

        public RotaryFurnaceRecipe(Mats.MaterialStack output, int duration, int steam, RecipesCommon.AStack ... ingredients) {
            this(output, duration, steam, (FluidStack)null, ingredients);
        }
    }
}

