/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.config.GeneralConfig;
import com.hbm.handler.imc.IMCBlastFurnace;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BlastFurnaceRecipes
extends SerializableRecipe {
    private static final ArrayList<Tuple.Triplet<Object, Object, ItemStack>> blastFurnaceRecipes = new ArrayList();
    private static final ArrayList<RecipesCommon.ComparableStack> hiddenRecipes = new ArrayList();

    @Override
    public void registerDefaults() {
        BlastFurnaceRecipes.addRecipe(OreDictManager.IRON, OreDictManager.COAL, new ItemStack(ModItems.ingot_steel, 1));
        BlastFurnaceRecipes.addRecipe(OreDictManager.IRON, OreDictManager.ANY_COKE, new ItemStack(ModItems.ingot_steel, 1));
        BlastFurnaceRecipes.addRecipe(OreDictManager.IRON.ore(), OreDictManager.COAL, new ItemStack(ModItems.ingot_steel, 2));
        BlastFurnaceRecipes.addRecipe(OreDictManager.IRON.ore(), OreDictManager.ANY_COKE, new ItemStack(ModItems.ingot_steel, 3));
        BlastFurnaceRecipes.addRecipe(OreDictManager.IRON.ore(), new RecipesCommon.ComparableStack(ModItems.powder_flux), new ItemStack(ModItems.ingot_steel, 3));
        BlastFurnaceRecipes.addRecipe(OreDictManager.CU, OreDictManager.REDSTONE, new ItemStack(ModItems.ingot_red_copper, 2));
        BlastFurnaceRecipes.addRecipe(OreDictManager.STEEL, OreDictManager.MINGRADE, new ItemStack(ModItems.ingot_advanced_alloy, 2));
        BlastFurnaceRecipes.addRecipe(OreDictManager.W, OreDictManager.COAL, new ItemStack(ModItems.neutron_reflector, 2));
        BlastFurnaceRecipes.addRecipe(OreDictManager.W, OreDictManager.ANY_COKE, new ItemStack(ModItems.neutron_reflector, 2));
        BlastFurnaceRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.canister_full, 1, Fluids.GASOLINE.getID()), "slimeball", new ItemStack(ModItems.canister_napalm));
        BlastFurnaceRecipes.addRecipe(OreDictManager.W, OreDictManager.SA326.nugget(), new ItemStack(ModItems.ingot_magnetized_tungsten));
        BlastFurnaceRecipes.addRecipe(OreDictManager.STEEL, OreDictManager.TC99.nugget(), new ItemStack(ModItems.ingot_tcalloy));
        BlastFurnaceRecipes.addRecipe(OreDictManager.GOLD.plate(), ModItems.plate_mixed, new ItemStack(ModItems.plate_paa, 2));
        BlastFurnaceRecipes.addRecipe(OreDictManager.BIGMT, ModItems.ingot_meteorite, new ItemStack(ModItems.ingot_starmetal, 2));
        BlastFurnaceRecipes.addRecipe(OreDictManager.CO, ModItems.powder_meteorite, new ItemStack(ModItems.ingot_meteorite));
        BlastFurnaceRecipes.addRecipe(ModItems.meteorite_sword_hardened, OreDictManager.CO, new ItemStack(ModItems.meteorite_sword_alloyed));
        if (GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry) {
            BlastFurnaceRecipes.addRecipe(ModItems.canister_empty, OreDictManager.COAL, new ItemStack(ModItems.canister_full, 1, Fluids.OIL.getID()));
        }
        if (!IMCBlastFurnace.buffer.isEmpty()) {
            blastFurnaceRecipes.addAll(IMCBlastFurnace.buffer);
            MainRegistry.logger.info("Fetched " + IMCBlastFurnace.buffer.size() + " IMC blast furnace recipes!");
            IMCBlastFurnace.buffer.clear();
        }
        hiddenRecipes.add(new RecipesCommon.ComparableStack(ModItems.meteorite_sword_alloyed));
    }

    public static void addRecipe(Object in1, Object in2, ItemStack out) {
        if (in1 instanceof Item) {
            in1 = new RecipesCommon.ComparableStack((Item)in1);
        }
        if (in1 instanceof Block) {
            in1 = new RecipesCommon.ComparableStack((Block)in1);
        }
        if (in2 instanceof Item) {
            in2 = new RecipesCommon.ComparableStack((Item)in2);
        }
        if (in2 instanceof Block) {
            in2 = new RecipesCommon.ComparableStack((Block)in2);
        }
        blastFurnaceRecipes.add(new Tuple.Triplet<Object, Object, ItemStack>(in1, in2, out));
    }

    @CheckForNull
    public static ItemStack getOutput(ItemStack in1, ItemStack in2) {
        for (Tuple.Triplet<Object, Object, ItemStack> recipe : blastFurnaceRecipes) {
            RecipesCommon.AStack[] recipeItem1 = BlastFurnaceRecipes.getRecipeStacks(recipe.getX());
            RecipesCommon.AStack[] recipeItem2 = BlastFurnaceRecipes.getRecipeStacks(recipe.getY());
            if ((!BlastFurnaceRecipes.doStacksMatch(recipeItem1, in1) || !BlastFurnaceRecipes.doStacksMatch(recipeItem2, in2)) && (!BlastFurnaceRecipes.doStacksMatch(recipeItem2, in1) || !BlastFurnaceRecipes.doStacksMatch(recipeItem1, in2))) continue;
            return recipe.getZ().func_77946_l();
        }
        return null;
    }

    private static boolean doStacksMatch(RecipesCommon.AStack[] recipe, ItemStack in) {
        boolean flag = false;
        for (int i = 0; !flag && i < recipe.length; i = (int)((byte)(i + 1))) {
            flag = recipe[i].matchesRecipe(in, true);
        }
        return flag;
    }

    private static RecipesCommon.AStack[] getRecipeStacks(Object in) {
        RecipesCommon.AStack[] recipeItem1 = new RecipesCommon.AStack[]{};
        if (in instanceof OreDictManager.DictFrame) {
            OreDictManager.DictFrame recipeItem = (OreDictManager.DictFrame)in;
            recipeItem1 = new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(recipeItem.ingot()), new RecipesCommon.OreDictStack(recipeItem.plate()), new RecipesCommon.OreDictStack(recipeItem.gem()), new RecipesCommon.OreDictStack(recipeItem.dust())};
        } else if (in instanceof RecipesCommon.AStack) {
            recipeItem1 = new RecipesCommon.AStack[]{(RecipesCommon.AStack)in};
        } else if (in instanceof String) {
            recipeItem1 = new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack((String)in)};
        }
        return recipeItem1;
    }

    public static Map<List<ItemStack>[], ItemStack> getRecipesForNEI() {
        HashMap<List[], ItemStack> recipes = new HashMap<List[], ItemStack>();
        for (Tuple.Triplet<Object, Object, ItemStack> recipe : blastFurnaceRecipes) {
            if (hiddenRecipes.contains(new RecipesCommon.ComparableStack(recipe.getZ()))) continue;
            ItemStack nothing = new ItemStack(ModItems.nothing).func_151001_c("If you're reading this, an error has occured! Check the console.");
            ArrayList<ItemStack> in1 = new ArrayList<ItemStack>();
            ArrayList<ItemStack> in2 = new ArrayList<ItemStack>();
            in1.add(nothing);
            in2.add(nothing);
            for (RecipesCommon.AStack stack : BlastFurnaceRecipes.getRecipeStacks(recipe.getX())) {
                if (stack.extractForNEI().isEmpty()) continue;
                in1.remove(nothing);
                in1.addAll(stack.extractForNEI());
                break;
            }
            if (in1.contains(nothing)) {
                MainRegistry.logger.error("Blast furnace cannot compile recipes for NEI: apparent nonexistent item #1 in recipe for item: " + recipe.getZ().func_82833_r());
            }
            for (RecipesCommon.AStack stack : BlastFurnaceRecipes.getRecipeStacks(recipe.getY())) {
                if (stack.extractForNEI().isEmpty()) continue;
                in2.remove(nothing);
                in2.addAll(stack.extractForNEI());
                break;
            }
            if (in2.contains(nothing)) {
                MainRegistry.logger.error("Blast furnace cannot compile recipes for NEI: apparent nonexistent item #2 in recipe for item: " + recipe.getZ().func_82833_r());
            }
            List[] inputs = new List[]{in1, in2};
            recipes.put(inputs, recipe.getZ());
        }
        return ImmutableMap.copyOf(recipes);
    }

    public static List<Tuple.Triplet<RecipesCommon.AStack[], RecipesCommon.AStack[], ItemStack>> getRecipes() {
        ArrayList<Tuple.Triplet<RecipesCommon.AStack[], RecipesCommon.AStack[], ItemStack>> subRecipes = new ArrayList<Tuple.Triplet<RecipesCommon.AStack[], RecipesCommon.AStack[], ItemStack>>();
        for (Tuple.Triplet<Object, Object, ItemStack> recipe : blastFurnaceRecipes) {
            subRecipes.add(new Tuple.Triplet<RecipesCommon.AStack[], RecipesCommon.AStack[], ItemStack>(BlastFurnaceRecipes.getRecipeStacks(recipe.getX()), BlastFurnaceRecipes.getRecipeStacks(recipe.getY()), recipe.getZ()));
        }
        return ImmutableList.copyOf(subRecipes);
    }

    @Override
    public String getFileName() {
        return "hbmBlastFurnace.json";
    }

    @Override
    public String getComment() {
        return "Inputs can use the unique 'dictframe' type which is an ore dictionary material suffix. The recipes will accept most ore dictionary entries equivalent to one ingot (gems, dust, plates, etc).";
    }

    @Override
    public Object getRecipeObject() {
        return blastFurnaceRecipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonArray array2;
        JsonObject rec = (JsonObject)recipe;
        ItemStack output = BlastFurnaceRecipes.readItemStack(rec.get("output").getAsJsonArray());
        Object input1 = null;
        Object input2 = null;
        JsonArray array1 = rec.get("input1").getAsJsonArray();
        if (array1.get(0).getAsString().equals("item")) {
            input1 = BlastFurnaceRecipes.readAStack(array1);
        }
        if (array1.get(0).getAsString().equals("dict")) {
            input1 = ((RecipesCommon.OreDictStack)BlastFurnaceRecipes.readAStack((JsonArray)array1)).name;
        }
        if (array1.get(0).getAsString().equals("dictframe")) {
            input1 = BlastFurnaceRecipes.readDictFrame(array1);
        }
        if ((array2 = rec.get("input2").getAsJsonArray()).get(0).getAsString().equals("item")) {
            input2 = BlastFurnaceRecipes.readAStack(array2);
        }
        if (array2.get(0).getAsString().equals("dict")) {
            input2 = ((RecipesCommon.OreDictStack)BlastFurnaceRecipes.readAStack((JsonArray)array2)).name;
        }
        if (array2.get(0).getAsString().equals("dictframe")) {
            input2 = BlastFurnaceRecipes.readDictFrame(array2);
        }
        if (input1 != null && input2 != null) {
            BlastFurnaceRecipes.addRecipe(input1, input2, output);
            if (rec.has("hidden") && rec.get("hidden").getAsBoolean()) {
                hiddenRecipes.add(new RecipesCommon.ComparableStack(output));
            }
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Tuple.Triplet rec = (Tuple.Triplet)recipe;
        writer.name("output");
        BlastFurnaceRecipes.writeItemStack((ItemStack)rec.getZ(), writer);
        writer.name("input1");
        if (rec.getX() instanceof RecipesCommon.ComparableStack) {
            BlastFurnaceRecipes.writeAStack((RecipesCommon.ComparableStack)rec.getX(), writer);
        }
        if (rec.getX() instanceof String) {
            BlastFurnaceRecipes.writeAStack(new RecipesCommon.OreDictStack((String)rec.getX()), writer);
        }
        if (rec.getX() instanceof OreDictManager.DictFrame) {
            BlastFurnaceRecipes.writeDictFrame((OreDictManager.DictFrame)rec.getX(), writer);
        }
        writer.name("input2");
        if (rec.getY() instanceof RecipesCommon.ComparableStack) {
            BlastFurnaceRecipes.writeAStack((RecipesCommon.ComparableStack)rec.getY(), writer);
        }
        if (rec.getY() instanceof String) {
            BlastFurnaceRecipes.writeAStack(new RecipesCommon.OreDictStack((String)rec.getY()), writer);
        }
        if (rec.getY() instanceof OreDictManager.DictFrame) {
            BlastFurnaceRecipes.writeDictFrame((OreDictManager.DictFrame)rec.getY(), writer);
        }
        if (hiddenRecipes.contains(new RecipesCommon.ComparableStack((ItemStack)rec.getZ()))) {
            writer.name("hidden").value(true);
        }
    }

    public static void writeDictFrame(OreDictManager.DictFrame frame, JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.setIndent("");
        writer.value("dictframe");
        writer.value(frame.mats[0]);
        writer.endArray();
        writer.setIndent("  ");
    }

    public static OreDictManager.DictFrame readDictFrame(JsonArray array) {
        return new OreDictManager.DictFrame(array.get(1).getAsString());
    }

    @Override
    public void deleteRecipes() {
        blastFurnaceRecipes.clear();
        hiddenRecipes.clear();
    }
}

