/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerFusionTorus;
import com.hbm.inventory.gui.GUIScreenRecipeSelector;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.inventory.recipes.FusionRecipe;
import com.hbm.inventory.recipes.FusionRecipes;
import com.hbm.items.machine.ItemBlueprints;
import com.hbm.render.util.GaugeUtil;
import com.hbm.tileentity.machine.fusion.TileEntityFusionTorus;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class GUIFusionTorus
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/reactors/gui_fusion_torus.png");
    private TileEntityFusionTorus torus;

    public GUIFusionTorus(InventoryPlayer invPlayer, TileEntityFusionTorus torus) {
        super(new ContainerFusionTorus(invPlayer, torus));
        this.torus = torus;
        this.field_146999_f = 230;
        this.field_147000_g = 244;
    }

    public void func_73863_a(int mouseX, int mouseY, float interp) {
        super.func_73863_a(mouseX, mouseY, interp);
        this.drawElectricityInfo(this, mouseX, mouseY, this.field_147003_i + 8, this.field_147009_r + 18, 16, 62, this.torus.power, this.torus.getMaxPower());
        this.torus.tanks[0].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 44, this.field_147009_r + 18, 16, 52);
        this.torus.tanks[1].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 62, this.field_147009_r + 18, 16, 52);
        this.torus.tanks[2].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 80, this.field_147009_r + 18, 16, 52);
        this.torus.tanks[3].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 152, this.field_147009_r + 18, 16, 52);
        this.torus.coolantTanks[0].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 188, this.field_147009_r + 46, 16, 52);
        this.torus.coolantTanks[1].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 206, this.field_147009_r + 46, 16, 52);
        FusionRecipe recipe = (FusionRecipe)FusionRecipes.INSTANCE.recipeNameMap.get(this.torus.fusionModule.recipe);
        if (recipe != null) {
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 43, this.field_147009_r + 115, 18, 18, mouseX, mouseY, EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + BobMathUtil.getShortNumber(this.torus.klystronEnergy) + "KyU / " + BobMathUtil.getShortNumber(recipe.ignitionTemp) + "KyU");
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 79, this.field_147009_r + 115, 18, 18, mouseX, mouseY, EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + BobMathUtil.getShortNumber(this.torus.plasmaEnergy) + "TU / " + BobMathUtil.getShortNumber(recipe.outputTemp) + "TU");
            String[] lines = new String[recipe.inputFluid.length];
            for (int i = 0; i < lines.length; ++i) {
                int consumption = (int)Math.ceil((double)recipe.inputFluid[i].fill * this.torus.fuelConsumption);
                lines[i] = EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + consumption + "mB/t " + recipe.inputFluid[i].type.getLocalizedName();
            }
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 115, this.field_147009_r + 115, 18, 18, mouseX, mouseY, lines);
        } else {
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 43, this.field_147009_r + 115, 18, 18, mouseX, mouseY, "0KyU / 0KyU");
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 79, this.field_147009_r + 115, 18, 18, mouseX, mouseY, "0TU / 0TU");
        }
        if (this.field_147003_i + 43 <= mouseX && this.field_147003_i + 43 + 18 > mouseX && this.field_147009_r + 80 < mouseY && this.field_147009_r + 80 + 18 >= mouseY) {
            if (recipe != null) {
                this.func_146283_a(recipe.print(), mouseX, mouseY);
            } else {
                this.func_146279_a(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("gui.recipe.setRecipe", new Object[0]), mouseX, mouseY);
            }
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (this.checkClick(x, y, 43, 80, 18, 18)) {
            GUIScreenRecipeSelector.openSelector(FusionRecipes.INSTANCE, this.torus, this.torus.fusionModule.recipe, 0, ItemBlueprints.grabPool(this.torus.slots[1]), (GuiScreen)this);
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.torus.func_145818_k_() ? this.torus.func_145825_b() : I18n.func_135052_a((String)this.torus.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, 106 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 35, this.field_147000_g - 93, 0x404040);
        this.field_146289_q.func_78276_b(EnumChatFormatting.AQUA + "/123K", 190, 32, 0x404040);
        int heat = (int)Math.ceil(this.torus.temperature);
        String label = (heat > 123 ? EnumChatFormatting.RED : EnumChatFormatting.AQUA) + "" + heat + "K";
        this.field_146289_q.func_78276_b(label, 220 - this.field_146289_q.func_78256_a(label), 22, 0x404040);
    }

    protected void func_146976_a(float interp, int x, int y) {
        int heat;
        FusionRecipe recipe;
        int j;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int p = (int)(this.torus.power * 62L / this.torus.getMaxPower());
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 80 - p, 230, 62 - p, 16, p);
        if (this.torus.fusionModule.progress > 0.0) {
            j = (int)Math.ceil(70.0 * this.torus.fusionModule.progress);
            this.func_73729_b(this.field_147003_i + 98, this.field_147009_r + 81, 0, 244, j, 6);
        }
        if (this.torus.fusionModule.bonus > 0.0) {
            j = (int)Math.min(Math.ceil(70.0 * this.torus.fusionModule.bonus), 70.0);
            this.func_73729_b(this.field_147003_i + 98, this.field_147009_r + 91, 0, 250, j, 6);
        }
        if ((recipe = (FusionRecipe)FusionRecipes.INSTANCE.recipeNameMap.get(this.torus.fusionModule.recipe)) != null && this.torus.power >= recipe.power) {
            this.func_73729_b(this.field_147003_i + 160, this.field_147009_r + 115, 246, 14, 8, 8);
        }
        if ((heat = (int)Math.ceil(this.torus.temperature)) <= 123) {
            this.func_73729_b(this.field_147003_i + 170, this.field_147009_r + 115, 246, 14, 8, 8);
        }
        if (this.torus.didProcess) {
            this.func_73729_b(this.field_147003_i + 180, this.field_147009_r + 115, 246, 14, 8, 8);
        }
        if (this.torus.didProcess) {
            this.func_73729_b(this.field_147003_i + 87, this.field_147009_r + 76, 249, 0, 3, 6);
        } else if (recipe != null) {
            this.func_73729_b(this.field_147003_i + 87, this.field_147009_r + 76, 246, 0, 3, 6);
        }
        if (this.torus.didProcess) {
            this.func_73729_b(this.field_147003_i + 92, this.field_147009_r + 76, 249, 0, 3, 6);
        } else if (recipe != null && this.torus.power >= this.torus.power) {
            this.func_73729_b(this.field_147003_i + 92, this.field_147009_r + 76, 246, 0, 3, 6);
        }
        double inputGauge = recipe == null ? 0.0 : Math.min((double)this.torus.klystronEnergy / (double)recipe.ignitionTemp, 1.5) / 1.5;
        double outputGauge = recipe == null ? 0.0 : Math.min((double)this.torus.plasmaEnergy / (double)recipe.outputTemp, 1.0);
        GaugeUtil.drawSmoothGauge(this.field_147003_i + 52, this.field_147009_r + 124, this.field_73735_i, inputGauge, 5.0, 2.0, 1.0, 0xA00000);
        GaugeUtil.drawSmoothGauge(this.field_147003_i + 88, this.field_147009_r + 124, this.field_73735_i, outputGauge, 5.0, 2.0, 1.0, 0xA00000);
        GaugeUtil.drawSmoothGauge(this.field_147003_i + 124, this.field_147009_r + 124, this.field_73735_i, this.torus.fuelConsumption, 5.0, 2.0, 1.0, 0xA00000);
        this.renderItem(recipe != null ? recipe.getIcon() : TEMPLATE_FOLDER, 44, 81);
        this.torus.tanks[0].renderTank(this.field_147003_i + 44, this.field_147009_r + 70, this.field_73735_i, 16, 52);
        this.torus.tanks[1].renderTank(this.field_147003_i + 62, this.field_147009_r + 70, this.field_73735_i, 16, 52);
        this.torus.tanks[2].renderTank(this.field_147003_i + 80, this.field_147009_r + 70, this.field_73735_i, 16, 52);
        this.torus.tanks[3].renderTank(this.field_147003_i + 152, this.field_147009_r + 70, this.field_73735_i, 16, 52);
        this.torus.coolantTanks[0].renderTank(this.field_147003_i + 188, this.field_147009_r + 98, this.field_73735_i, 16, 52);
        this.torus.coolantTanks[1].renderTank(this.field_147003_i + 206, this.field_147009_r + 98, this.field_73735_i, 16, 52);
    }
}

