/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.imc.ICompatNHNEI;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.CrucibleRecipes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class CrucibleSmeltingHandler
extends TemplateRecipeHandler
implements ICompatNHNEI {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();

    @Override
    public ItemStack[] getMachinesForRecipe() {
        return new ItemStack[]{new ItemStack(ModBlocks.machine_crucible)};
    }

    @Override
    public String getRecipeID() {
        return "ntmCrucibleSmelting";
    }

    public String getRecipeName() {
        return "Crucible Smelting";
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_crucible_smelting.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ntmCrucibleSmelting")) {
            HashMap<RecipesCommon.AStack, List<ItemStack>> smelting = CrucibleRecipes.getSmeltingRecipes();
            for (Map.Entry<RecipesCommon.AStack, List<ItemStack>> recipe : smelting.entrySet()) {
                this.arecipes.add(new RecipeSet(recipe.getKey(), recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<RecipesCommon.AStack, List<ItemStack>> smelting = CrucibleRecipes.getSmeltingRecipes();
        block0: for (Map.Entry<RecipesCommon.AStack, List<ItemStack>> recipe : smelting.entrySet()) {
            for (ItemStack stack : recipe.getValue()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)result)) continue;
                this.arecipes.add(new RecipeSet(recipe.getKey(), recipe.getValue()));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("ntmCrucibleSmelting")) {
            this.loadCraftingRecipes("ntmCrucibleSmelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        HashMap<RecipesCommon.AStack, List<ItemStack>> smelting = CrucibleRecipes.getSmeltingRecipes();
        for (Map.Entry<RecipesCommon.AStack, List<ItemStack>> recipe : smelting.entrySet()) {
            if (!recipe.getKey().matchesRecipe(ingredient, true)) continue;
            this.arecipes.add(new RecipeSet(recipe.getKey(), recipe.getValue()));
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 23, 36, 18), "ntmCrucibleSmelting", new Object[0]));
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack crucible;
        List<PositionedStack> outputs;

        public RecipeSet(RecipesCommon.AStack input, List<ItemStack> outputs) {
            super((TemplateRecipeHandler)CrucibleSmeltingHandler.this);
            this.outputs = new ArrayList<PositionedStack>();
            this.input = new PositionedStack(input.extractForNEI(), 48, 24);
            this.crucible = new PositionedStack((Object)new ItemStack(ModBlocks.machine_crucible), 75, 42);
            for (int i = 0; i < outputs.size(); ++i) {
                PositionedStack pos = new PositionedStack((Object)outputs.get(i), 102 + i % 3 * 18, 6 + i / 3 * 18);
                this.outputs.add(pos);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrucibleSmeltingHandler.this.cycleticks / 20, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.outputs.get(0);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> other = new ArrayList<PositionedStack>();
            other.add(this.input);
            other.add(this.crucible);
            other.addAll(this.outputs);
            return this.getCycledIngredients(CrucibleSmeltingHandler.this.cycleticks / 20, other);
        }
    }
}

