/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityDroneBase
extends Entity {
    protected int turnProgress;
    protected double syncPosX;
    protected double syncPosY;
    protected double syncPosZ;
    @SideOnly(value=Side.CLIENT)
    protected double velocityX;
    @SideOnly(value=Side.CLIENT)
    protected double velocityY;
    @SideOnly(value=Side.CLIENT)
    protected double velocityZ;
    public double targetX = -1.0;
    public double targetY = -1.0;
    public double targetZ = -1.0;

    public EntityDroneBase(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.75f);
    }

    public void setTarget(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_85031_j(Entity attacker) {
        if (attacker instanceof EntityPlayer) {
            this.func_70106_y();
        }
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)new Byte(0));
    }

    public void setAppearance(int style) {
        this.field_70180_af.func_75692_b(10, (Object)((byte)style));
    }

    public int getAppearance() {
        return this.field_70180_af.func_75683_a(10);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.turnProgress > 0) {
                double interpX = this.field_70165_t + (this.syncPosX - this.field_70165_t) / (double)this.turnProgress;
                double interpY = this.field_70163_u + (this.syncPosY - this.field_70163_u) / (double)this.turnProgress;
                double interpZ = this.field_70161_v + (this.syncPosZ - this.field_70161_v) / (double)this.turnProgress;
                --this.turnProgress;
                this.func_70107_b(interpX, interpY, interpZ);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t + 1.125, this.field_70163_u + 0.75, this.field_70161_v, 0.0, -0.2, 0.0);
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t - 1.125, this.field_70163_u + 0.75, this.field_70161_v, 0.0, -0.2, 0.0);
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.75, this.field_70161_v + 1.125, 0.0, -0.2, 0.0);
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.75, this.field_70161_v - 1.125, 0.0, -0.2, 0.0);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.targetY != -1.0) {
                Vec3 dist = Vec3.func_72443_a((double)(this.targetX - this.field_70165_t), (double)(this.targetY - this.field_70163_u), (double)(this.targetZ - this.field_70161_v));
                double speed = Math.min(this.getSpeed(), dist.func_72433_c());
                dist = dist.func_72432_b();
                this.field_70159_w = dist.field_72450_a * speed;
                this.field_70181_x = dist.field_72448_b * speed;
                this.field_70179_y = dist.field_72449_c * speed;
            }
            if (this.field_70123_F) {
                this.field_70181_x += 1.0;
            }
            this.loadNeighboringChunks();
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        super.func_70071_h_();
    }

    protected void loadNeighboringChunks() {
    }

    public double getSpeed() {
        return 0.125;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.velocityX = this.field_70159_w = motionX;
        this.velocityY = this.field_70181_x = motionY;
        this.velocityZ = this.field_70179_y = motionZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int theNumberThree) {
        this.syncPosX = x;
        this.syncPosY = y;
        this.syncPosZ = z;
        this.turnProgress = theNumberThree;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("tX", this.targetX);
        nbt.func_74780_a("tY", this.targetY);
        nbt.func_74780_a("tZ", this.targetZ);
        nbt.func_74774_a("app", this.field_70180_af.func_75683_a(10));
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tY")) {
            this.targetX = nbt.func_74769_h("tX");
            this.targetY = nbt.func_74769_h("tY");
            this.targetZ = nbt.func_74769_h("tZ");
        }
        this.field_70180_af.func_75692_b(10, (Object)nbt.func_74771_c("app"));
    }
}

