/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import api.hbm.conveyor.IConveyorBelt;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.items.machine.ItemStamp;
import com.hbm.tileentity.machine.TileEntityConveyorPress;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineConveyorPress
extends BlockDummyable
implements IConveyorBelt,
ILookOverlay,
IToolable,
ITooltipProvider {
    public MachineConveyorPress(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityConveyorPress();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 0, 0, 0, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityConveyorPress)) {
            return false;
        }
        TileEntityConveyorPress press = (TileEntityConveyorPress)te;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemStamp && press.slots[0] == null) {
            press.slots[0] = player.func_70694_bm().func_77946_l();
            press.slots[0].field_77994_a = 1;
            --player.func_70694_bm().field_77994_a;
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
            press.markChanged();
            world.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityConveyorPress)) {
            return false;
        }
        TileEntityConveyorPress press = (TileEntityConveyorPress)te;
        if (press.slots[0] == null) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(press.slots[0].func_77946_l())) {
            EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + this.field_149756_F, (double)z + 0.5, press.slots[0].func_77946_l());
            world.func_72838_d((Entity)item);
        } else {
            player.field_71069_bz.func_75142_b();
        }
        press.slots[0] = null;
        press.markChanged();
        return true;
    }

    @Override
    public Vec3 getTravelLocation(World world, int x, int y, int z, Vec3 itemPos, double speed) {
        ForgeDirection dir = this.getTravelDirection(world, x, y, z, itemPos);
        Vec3 snap = this.getClosestSnappingPosition(world, x, y, z, itemPos);
        Vec3 dest = Vec3.func_72443_a((double)(snap.field_72450_a - (double)dir.offsetX * speed), (double)(snap.field_72448_b - (double)dir.offsetY * speed), (double)(snap.field_72449_c - (double)dir.offsetZ * speed));
        Vec3 motion = Vec3.func_72443_a((double)(dest.field_72450_a - itemPos.field_72450_a), (double)(dest.field_72448_b - itemPos.field_72448_b), (double)(dest.field_72449_c - itemPos.field_72449_c));
        double len = motion.func_72433_c();
        Vec3 ret = Vec3.func_72443_a((double)(itemPos.field_72450_a + motion.field_72450_a / len * speed), (double)(itemPos.field_72448_b + motion.field_72448_b / len * speed), (double)(itemPos.field_72449_c + motion.field_72449_c / len * speed));
        return ret;
    }

    public ForgeDirection getTravelDirection(World world, int x, int y, int z, Vec3 itemPos) {
        int meta = world.func_72805_g(x, y - 1, z) - 10;
        return ForgeDirection.getOrientation((int)meta).getRotation(ForgeDirection.UP);
    }

    @Override
    public Vec3 getClosestSnappingPosition(World world, int x, int y, int z, Vec3 itemPos) {
        ForgeDirection dir = this.getTravelDirection(world, x, y, z, itemPos);
        itemPos.field_72450_a = MathHelper.func_151237_a((double)itemPos.field_72450_a, (double)x, (double)(x + 1));
        itemPos.field_72449_c = MathHelper.func_151237_a((double)itemPos.field_72449_c, (double)z, (double)(z + 1));
        double posX = (double)x + 0.5;
        double posZ = (double)z + 0.5;
        if (dir.offsetX != 0) {
            posX = itemPos.field_72450_a;
        }
        if (dir.offsetZ != 0) {
            posZ = itemPos.field_72449_c;
        }
        return Vec3.func_72443_a((double)posX, (double)((double)y + 0.25), (double)posZ);
    }

    @Override
    public boolean canItemStay(World world, int x, int y, int z, Vec3 itemPos) {
        return world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) >= 12;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityConveyorPress)) {
            return;
        }
        TileEntityConveyorPress press = (TileEntityConveyorPress)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(press.power) + "HE / " + BobMathUtil.getShortNumber(50000L) + "HE");
        text.add("Installed stamp: " + (press.syncStack == null || press.syncStack.func_77973_b() == null ? EnumChatFormatting.RED + "NONE" : press.syncStack.func_82833_r()));
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

