/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.interfaces.IBomb;
import com.hbm.tileentity.DoorDecl;
import com.hbm.tileentity.TileEntityDoorGeneric;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.Rotation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDoorGeneric
extends BlockDummyable
implements IBomb,
IToolable {
    public DoorDecl type;

    public BlockDoorGeneric(Material materialIn, DoorDecl type) {
        super(materialIn);
        this.type = type;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta >= 12) {
            return new TileEntityDoorGeneric();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return this.type.getDimensions();
    }

    @Override
    public int getOffset() {
        return this.type.getBlockOffset();
    }

    @Override
    public IBomb.BombReturnCode explode(World world, int x, int y, int z) {
        int[] pos1 = this.findCore(world, x, y, z);
        if (pos1 == null) {
            return IBomb.BombReturnCode.ERROR_INCOMPATIBLE;
        }
        TileEntityDoorGeneric door = (TileEntityDoorGeneric)world.func_147438_o(pos1[0], pos1[1], pos1[2]);
        if (door != null) {
            DoorDecl decl = door.getDoorType();
            if (!decl.remoteControllable()) {
                return IBomb.BombReturnCode.ERROR_INCOMPATIBLE;
            }
            if (door.tryToggle(null)) {
                return IBomb.BombReturnCode.TRIGGERED;
            }
        }
        return IBomb.BombReturnCode.ERROR_INCOMPATIBLE;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer playerIn, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !playerIn.func_70093_af()) {
            int[] pos1 = this.findCore(world, x, y, z);
            if (pos1 == null) {
                return false;
            }
            TileEntityDoorGeneric door = (TileEntityDoorGeneric)world.func_147438_o(pos1[0], pos1[1], pos1[2]);
            if (door != null) {
                return door.tryToggle(playerIn);
            }
        }
        return !playerIn.func_70093_af();
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER || !player.func_70093_af()) {
            return false;
        }
        int[] pos1 = this.findCore(world, x, y, z);
        if (pos1 == null) {
            return false;
        }
        TileEntityDoorGeneric door = (TileEntityDoorGeneric)world.func_147438_o(pos1[0], pos1[1], pos1[2]);
        if (door == null || !door.getDoorType().hasSkins()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        door.cycleSkinIndex();
        return true;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        TileEntity te = world.func_147438_o(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        boolean open = this.hasExtra(meta) || te instanceof TileEntityDoorGeneric && ((TileEntityDoorGeneric)te).shouldUseBB;
        return this.type.isLadder(open);
    }

    @Override
    public void func_149743_a(World worldIn, int x, int y, int z, AxisAlignedBB entityBox, List collidingBoxes, Entity entityIn) {
        AxisAlignedBB box = this.getBoundingBox(worldIn, x, y, z, true);
        box = AxisAlignedBB.func_72330_a((double)Math.min(box.field_72340_a, box.field_72336_d), (double)Math.min(box.field_72338_b, box.field_72337_e), (double)Math.min(box.field_72339_c, box.field_72334_f), (double)Math.max(box.field_72340_a, box.field_72336_d), (double)Math.max(box.field_72338_b, box.field_72337_e), (double)Math.max(box.field_72339_c, box.field_72334_f));
        if (box.field_72338_b == (double)y && box.field_72337_e == (double)y) {
            return;
        }
        if (box.field_72340_a == box.field_72336_d && box.field_72338_b == box.field_72337_e && box.field_72339_c == box.field_72334_f) {
            return;
        }
        if (box != null && box.func_72326_a(entityBox)) {
            collidingBoxes.add(box);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        AxisAlignedBB aabb = this.getBoundingBox(world, x, y, z, true);
        if (aabb.field_72340_a == aabb.field_72336_d && aabb.field_72338_b == aabb.field_72337_e && aabb.field_72339_c == aabb.field_72334_f) {
            return null;
        }
        return aabb;
    }

    @Override
    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        AxisAlignedBB box = this.getBoundingBox(world, x, y, z, false);
        box = AxisAlignedBB.func_72330_a((double)Math.min(box.field_72340_a, box.field_72336_d), (double)Math.min(box.field_72338_b, box.field_72337_e), (double)Math.min(box.field_72339_c, box.field_72334_f), (double)Math.max(box.field_72340_a, box.field_72336_d), (double)Math.max(box.field_72338_b, box.field_72337_e), (double)Math.max(box.field_72339_c, box.field_72334_f));
        MovingObjectPosition intercept = box.func_72327_a(startVec, endVec);
        if (intercept != null) {
            return new MovingObjectPosition(x, y, z, intercept.field_72310_e, intercept.field_72307_f);
        }
        return null;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return this.hasExtra(world.func_72805_g(x, y, z));
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block blockIn) {
        TileEntity core;
        int[] corePos;
        if (!world.field_72995_K && (corePos = this.findCore(world, x, y, z)) != null && (core = world.func_147438_o(corePos[0], corePos[1], corePos[2])) instanceof TileEntityDoorGeneric) {
            TileEntityDoorGeneric door = (TileEntityDoorGeneric)core;
            door.updateRedstonePower(x, y, z);
        }
        super.func_149695_a(world, x, y, z, blockIn);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.getBoundingBox(world, x, y, z, false);
    }

    public AxisAlignedBB getBoundingBox(World world, int x, int y, int z, boolean forCollision) {
        boolean open;
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        int[] core = this.findCore(world, x, y, z);
        boolean bl = open = this.hasExtra(meta) || te instanceof TileEntityDoorGeneric && ((TileEntityDoorGeneric)te).state != 0;
        if (core == null) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        TileEntity te2 = world.func_147438_o(core[0], core[1], core[2]);
        ForgeDirection dir = ForgeDirection.getOrientation((int)(te2.func_145832_p() - 10));
        BlockPos pos = new BlockPos(x - core[0], y - core[1], z - core[2]).rotate(Rotation.getBlockRotation(dir).add(Rotation.COUNTERCLOCKWISE_90));
        AxisAlignedBB box = this.type.getBlockBound(pos.getX(), pos.getY(), pos.getZ(), open, forCollision);
        switch (te2.func_145832_p() - 10) {
            case 2: {
                return AxisAlignedBB.func_72330_a((double)((double)(x + 1) - box.field_72340_a), (double)((double)y + box.field_72338_b), (double)((double)(z + 1) - box.field_72339_c), (double)((double)(x + 1) - box.field_72336_d), (double)((double)y + box.field_72337_e), (double)((double)(z + 1) - box.field_72334_f));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)((double)(x + 1) - box.field_72339_c), (double)((double)y + box.field_72338_b), (double)((double)z + box.field_72340_a), (double)((double)(x + 1) - box.field_72334_f), (double)((double)y + box.field_72337_e), (double)((double)z + box.field_72336_d));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)((double)x + box.field_72340_a), (double)((double)y + box.field_72338_b), (double)((double)z + box.field_72339_c), (double)((double)x + box.field_72336_d), (double)((double)y + box.field_72337_e), (double)((double)z + box.field_72334_f));
            }
            case 5: {
                return AxisAlignedBB.func_72330_a((double)((double)x + box.field_72339_c), (double)((double)y + box.field_72338_b), (double)((double)(z + 1) - box.field_72336_d), (double)((double)x + box.field_72334_f), (double)((double)y + box.field_72337_e), (double)((double)(z + 1) - box.field_72340_a));
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    @Override
    public boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, this.getDimensions(), x, y, z, dir)) {
            return false;
        }
        if (this.type.getExtraDimensions() != null) {
            for (int[] dims : this.type.getExtraDimensions()) {
                if (MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, dims, x, y, z, dir)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, this.getDimensions(), (Block)this, dir);
        if (this.type.getExtraDimensions() != null) {
            for (int[] dims : this.type.getExtraDimensions()) {
                MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, dims, (Block)this, dir);
            }
        }
    }
}

