/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.nbt;

import com.hbm.config.StructureConfig;
import com.hbm.util.Tuple;
import com.hbm.world.gen.nbt.JigsawPiece;
import com.hbm.world.gen.nbt.JigsawPool;
import com.hbm.world.gen.nbt.NBTStructure;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureStart;

public class SpawnCondition {
    public final String name;
    public JigsawPiece structure;
    public Function<Tuple.Quartet<World, Random, Integer, Integer>, StructureStart> start;
    public Predicate<WorldCoordinate> checkCoordinates;
    public Predicate<BiomeGenBase> canSpawn;
    public int spawnWeight = 1;
    public Map<String, JigsawPool> pools;
    public String startPool;
    public int sizeLimit = 8;
    public int rangeLimit = 128;
    public int minHeight = 1;
    public int maxHeight = 128;

    protected SpawnCondition(int weight, Predicate<BiomeGenBase> predicate) {
        this.name = null;
        this.spawnWeight = weight;
        this.canSpawn = predicate;
    }

    public SpawnCondition(String name) {
        this.name = name;
    }

    protected boolean isValid(BiomeGenBase biome) {
        if (this.canSpawn == null) {
            return true;
        }
        return this.canSpawn.test(biome);
    }

    public JigsawPool getPool(String name) {
        JigsawPool pool = this.pools.get(name);
        return pool != null ? pool.clone() : null;
    }

    public void buildAll(World world, int x, int y, int z) {
        if (!StructureConfig.debugStructures) {
            return;
        }
        int padding = 5;
        int oz = 0;
        for (JigsawPool pool : this.pools.values()) {
            int highestWidth = 0;
            int ox = 0;
            for (Tuple.Pair<JigsawPiece, Integer> entry : pool.pieces) {
                NBTStructure structure = ((JigsawPiece)entry.key).structure;
                structure.build(world, x + ox + structure.size.x / 2, y, z + oz + structure.size.z / 2);
                ox += structure.size.x + padding;
                highestWidth = Math.max(highestWidth, structure.size.z);
            }
            oz += highestWidth + padding;
        }
    }

    public static class WorldCoordinate {
        public final World world;
        public final ChunkCoordIntPair coords;
        public final Random rand;

        protected WorldCoordinate(World world, ChunkCoordIntPair coords, Random rand) {
            this.world = world;
            this.coords = coords;
            this.rand = rand;
        }
    }
}

