/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBedrockOreTE;
import com.hbm.config.WorldConfig;
import com.hbm.dim.SolarSystem;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBedrockOre;
import com.hbm.util.WeightedRandomGeneric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BedrockOre {
    public static List<WeightedRandomGeneric<BedrockOreDefinition>> weightedOres = new ArrayList<WeightedRandomGeneric<BedrockOreDefinition>>();
    public static List<WeightedRandomGeneric<BedrockOreDefinition>> weightedOresNether = new ArrayList<WeightedRandomGeneric<BedrockOreDefinition>>();
    public static Map<SolarSystem.Body, List<WeightedRandomGeneric<BedrockOreDefinition>>> weightedPlanetOres = new HashMap<SolarSystem.Body, List<WeightedRandomGeneric<BedrockOreDefinition>>>();
    public static HashMap<String, BedrockOreDefinition> replacements = new HashMap();

    public static void init() {
        BedrockOreDefinition iron = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.IRON, 1);
        BedrockOreDefinition copper = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.COPPER, 1);
        BedrockOreDefinition borax = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.BORAX, 3, new FluidStack(Fluids.SULFURIC_ACID, 500));
        BedrockOreDefinition chlorocalcite = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.CHLOROCALCITE, 3, new FluidStack(Fluids.SULFURIC_ACID, 500));
        BedrockOreDefinition asbestos = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.ASBESTOS, 2);
        BedrockOreDefinition niobium = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.NIOBIUM, 2, new FluidStack(Fluids.PEROXIDE, 500));
        BedrockOreDefinition neodymium = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.NEODYMIUM, 3, new FluidStack(Fluids.PEROXIDE, 500));
        BedrockOreDefinition titanium = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.TITANIUM, 2, new FluidStack(Fluids.SULFURIC_ACID, 500));
        BedrockOreDefinition tungsten = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.TUNGSTEN, 2, new FluidStack(Fluids.PEROXIDE, 500));
        BedrockOreDefinition gold = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.GOLD, 1);
        BedrockOreDefinition uranium = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.URANIUM, 4, new FluidStack(Fluids.SULFURIC_ACID, 500));
        BedrockOreDefinition thorium = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.THORIUM, 4, new FluidStack(Fluids.SULFURIC_ACID, 500));
        BedrockOreDefinition fluorite = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.FLUORITE, 1);
        BedrockOreDefinition coal = new BedrockOreDefinition(new ItemStack(Items.field_151044_h, 8), 1, 0x202020);
        BedrockOreDefinition niter = new BedrockOreDefinition(new ItemStack(ModItems.niter, 4), 2, 0x808080, new FluidStack(Fluids.PEROXIDE, 500));
        BedrockOreDefinition redstone = new BedrockOreDefinition(new ItemStack(Items.field_151137_ax, 4), 1, 0xD01010);
        BedrockOreDefinition emerald = new BedrockOreDefinition(new ItemStack(Items.field_151166_bC, 4), 1, 4185477);
        BedrockOreDefinition rare = new BedrockOreDefinition(OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.RARE), 2, 0x8F9999, new FluidStack(Fluids.PEROXIDE, 500));
        BedrockOreDefinition bauxite = new BedrockOreDefinition(OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.BAUXITE, 2), 1, 15692307);
        BedrockOreDefinition glowstone = new BedrockOreDefinition(new ItemStack(Items.field_151114_aO, 4), 1, 16383821);
        BedrockOreDefinition phosporous = new BedrockOreDefinition(new ItemStack(ModItems.powder_fire, 4), 1, 14103583);
        BedrockOreDefinition quartz = new BedrockOreDefinition(new ItemStack(Items.field_151128_bU, 4), 1, 15790045);
        BedrockOreDefinition nickel = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.NICKEL, 2);
        BedrockOreDefinition cadmium = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.CAD, 3, new FluidStack(Fluids.SULFURIC_ACID, 500));
        BedrockOreDefinition zinc = new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.ZINC, 2);
        BedrockOreDefinition lithium = new BedrockOreDefinition(new ItemStack(ModItems.powder_lithium, 4), 1, 0xFFFFFF);
        BedrockOreDefinition ice = new BedrockOreDefinition(new ItemStack(Blocks.field_150403_cj, 8), 1, 0xAAFFFF);
        BedrockOreDefinition coltan = new BedrockOreDefinition(new ItemStack(ModItems.fragment_coltan), 1, 10980730);
        BedrockOreDefinition lanthanium = new BedrockOreDefinition(new ItemStack(ModItems.powder_lanthanium), 2, 10598841);
        BedrockOreDefinition schrabidium = new BedrockOreDefinition(new ItemStack(ModItems.powder_schrabidium, 1), 4, 65535, new FluidStack(Fluids.NITRIC_ACID, 500));
        BedrockOreDefinition cinnabar = new BedrockOreDefinition(new ItemStack(ModItems.cinnebar, 4), 1, 0xFF0000);
        BedrockOreDefinition hematite = new BedrockOreDefinition(OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.HEMATITE, 2), 1, 15692307);
        BedrockOre.registerBedrockOre(weightedOres, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(weightedOres, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(weightedOres, coal, WorldConfig.bedrockCoalSpawn);
        BedrockOre.registerBedrockOre(weightedOres, bauxite, WorldConfig.bedrockBauxiteSpawn);
        BedrockOre.registerBedrockOre(weightedOresNether, glowstone, WorldConfig.bedrockGlowstoneSpawn);
        BedrockOre.registerBedrockOre(weightedOresNether, phosporous, WorldConfig.bedrockPhosphorusSpawn);
        BedrockOre.registerBedrockOre(weightedOresNether, quartz, WorldConfig.bedrockQuartzSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, lithium, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, niter, WorldConfig.bedrockNiterSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, zinc, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, ice, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, quartz, WorldConfig.bedrockQuartzSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MUN, titanium, WorldConfig.bedrockTitaniumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MINMUS, ice, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MINMUS, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MINMUS, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MINMUS, neodymium, WorldConfig.bedrockNeodymiumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MINMUS, borax, WorldConfig.bedrockBoraxSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MINMUS, tungsten, WorldConfig.bedrockTungstenSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, ice, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, neodymium, WorldConfig.bedrockNeodymiumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, thorium, WorldConfig.bedrockThoriumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, fluorite, WorldConfig.bedrockFluoriteSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, niter, WorldConfig.bedrockNiterSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DUNA, hematite, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.IKE, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.IKE, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.IKE, nickel, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.IKE, zinc, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.IKE, quartz, WorldConfig.bedrockQuartzSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.IKE, titanium, WorldConfig.bedrockTitaniumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.IKE, redstone, WorldConfig.bedrockRedstoneSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DRES, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DRES, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DRES, cadmium, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DRES, coltan, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DRES, lanthanium, 50);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DRES, gold, WorldConfig.bedrockGoldSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.DRES, redstone, WorldConfig.bedrockRedstoneSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.LAYTHE, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.LAYTHE, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.LAYTHE, rare, WorldConfig.bedrockRareEarthSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.LAYTHE, asbestos, WorldConfig.bedrockAsbestosSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.LAYTHE, emerald, WorldConfig.bedrockEmeraldSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.LAYTHE, uranium, WorldConfig.bedrockUraniumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MOHO, iron, WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MOHO, copper, WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MOHO, glowstone, WorldConfig.bedrockGlowstoneSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MOHO, phosporous, WorldConfig.bedrockPhosphorusSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MOHO, chlorocalcite, WorldConfig.bedrockChlorocalciteSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.MOHO, cinnabar, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.EVE, uranium, WorldConfig.bedrockUraniumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.EVE, thorium, WorldConfig.bedrockThoriumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.EVE, niobium, WorldConfig.bedrockNiobiumSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.EVE, rare, WorldConfig.bedrockRareEarthSpawn);
        BedrockOre.registerBedrockOre(SolarSystem.Body.EVE, schrabidium, 100);
        BedrockOre.registerBedrockOre(SolarSystem.Body.EVE, cinnabar, 100);
    }

    public static void registerBedrockOre(List<WeightedRandomGeneric<BedrockOreDefinition>> list, BedrockOreDefinition def, int weight) {
        WeightedRandomGeneric<BedrockOreDefinition> weighted = new WeightedRandomGeneric<BedrockOreDefinition>(def, weight);
        list.add(weighted);
    }

    public static void registerBedrockOre(SolarSystem.Body body, BedrockOreDefinition def, int weight) {
        WeightedRandomGeneric<BedrockOreDefinition> weighted = new WeightedRandomGeneric<BedrockOreDefinition>(def, weight);
        if (!weightedPlanetOres.containsKey((Object)body)) {
            weightedPlanetOres.put(body, new ArrayList());
        }
        List<WeightedRandomGeneric<BedrockOreDefinition>> list = weightedPlanetOres.get((Object)body);
        list.add(weighted);
    }

    public static void generate(World world, int x, int z, ItemStack stack, FluidStack acid, int color, int tier) {
        BedrockOre.generate(world, x, z, stack, acid, color, tier, ModBlocks.stone_depth, Blocks.field_150348_b);
    }

    public static void generate(World world, int x, int z, ItemStack stack, FluidStack acid, int color, int tier, Block depthRock, Block targetBlock) {
        int iz;
        int ix;
        for (ix = x - 1; ix <= x + 1; ++ix) {
            for (iz = z - 1; iz <= z + 1; ++iz) {
                Block b = world.func_147439_a(ix, 0, iz);
                if (!b.isReplaceableOreGen(world, ix, 0, iz, Blocks.field_150357_h) || (ix != x || iz != z) && !world.field_73012_v.nextBoolean()) continue;
                world.func_147449_b(ix, 0, iz, ModBlocks.ore_bedrock);
                BlockBedrockOreTE.TileEntityBedrockOre ore = (BlockBedrockOreTE.TileEntityBedrockOre)world.func_147438_o(ix, 0, iz);
                ore.resource = stack;
                ore.color = color;
                ore.shape = world.field_73012_v.nextInt(10);
                ore.acidRequirement = acid;
                ore.tier = tier;
                world.func_147471_g(ix, 0, iz);
                world.func_147476_b(ix, 0, iz, (TileEntity)ore);
            }
        }
        for (ix = x - 3; ix <= x + 3; ++ix) {
            for (iz = z - 3; iz <= z + 3; ++iz) {
                for (int iy = 1; iy < 7; ++iy) {
                    Block b;
                    if (iy >= 3 && world.func_147439_a(ix, iy, iz) != Blocks.field_150357_h || !(b = world.func_147439_a(ix, iy, iz)).isReplaceableOreGen(world, ix, iy, iz, targetBlock) && !b.isReplaceableOreGen(world, ix, iy, iz, Blocks.field_150357_h)) continue;
                    world.func_147449_b(ix, iy, iz, depthRock);
                }
            }
        }
    }

    public static class BedrockOreDefinition {
        public ItemStack stack;
        public FluidStack acid;
        public String id;
        public int tier;
        public int color;

        public BedrockOreDefinition(ItemStack stack, int tier, int color) {
            this(stack, tier, color, null);
        }

        public BedrockOreDefinition(ItemStack stack, int tier, int color, FluidStack acid) {
            this.stack = stack;
            this.id = stack.toString();
            this.tier = tier;
            this.color = color;
            this.acid = acid;
        }

        public BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre type, int tier) {
            this(type, tier, null);
        }

        public BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre type, int tier, FluidStack acid) {
            this.stack = OreDictManager.DictFrame.fromOne(ModItems.ore_bedrock, (Enum)type);
            this.id = "ore" + type.oreName;
            this.color = type.color;
            this.tier = tier;
            this.acid = acid;
        }
    }
}

