/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ICopiable;
import com.hbm.inventory.container.ContainerRBMKAutoloader;
import com.hbm.inventory.gui.GUIRBMKAutoloader;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityRBMKAutoloader
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
ICopiable {
    public double piston;
    public double renderPiston;
    public double lastPiston;
    private double syncPiston;
    private int turnProgress;
    private boolean isRetracting = true;
    private int delay = 0;
    public static double speed = 0.005;
    public int cycle = 50;
    private AudioWrapper audioLift;
    protected AxisAlignedBB aabb;

    public TileEntityRBMKAutoloader() {
        super(18);
    }

    @Override
    public String getName() {
        return "container.rbmkAutoloader";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntityRBMKRod rod;
            int[] pos;
            TileEntity tile;
            Block below;
            if (this.delay > 0) {
                --this.delay;
            }
            if (this.delay <= 0 && this.isRetracting && this.piston > 0.0) {
                this.piston -= speed;
                if (this.piston <= 0.0) {
                    this.piston = 0.0;
                    this.delay = 40;
                }
            }
            if (this.isRetracting && this.field_145850_b.func_82737_E() % 20L == 0L && this.hasFuel() && this.hasSpace() && (below = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) instanceof RBMKBase && (tile = this.field_145850_b.func_147438_o((pos = ((RBMKBase)below).findCore(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))[0], pos[1], pos[2])) instanceof TileEntityRBMKRod) {
                rod = (TileEntityRBMKRod)tile;
                if (rod.slots[0] == null || rod.slots[0] != null && rod.slots[0].func_77973_b() instanceof ItemRBMKRod && ItemRBMKRod.getEnrichment(rod.slots[0]) * 100.0 < (double)this.cycle) {
                    this.isRetracting = false;
                }
            }
            if (this.delay <= 0 && !this.isRetracting && this.piston < 1.0) {
                this.piston += speed;
                if (this.piston >= 1.0) {
                    this.piston = 1.0;
                    this.delay = 40;
                }
            }
            if (!this.isRetracting && this.piston >= 1.0) {
                this.piston = 1.0;
                below = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                if (below instanceof RBMKBase && (tile = this.field_145850_b.func_147438_o((pos = ((RBMKBase)below).findCore(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))[0], pos[1], pos[2])) instanceof TileEntityRBMKRod) {
                    int i;
                    rod = (TileEntityRBMKRod)tile;
                    if (rod.slots[0] != null && this.hasSpace()) {
                        for (i = 9; i < 18; ++i) {
                            if (this.slots[i] != null) continue;
                            this.slots[i] = rod.slots[0].func_77946_l();
                            rod.slots[0] = null;
                            break;
                        }
                    }
                    if (rod.slots[0] == null) {
                        for (i = 0; i < 9; ++i) {
                            ItemStack stack = this.slots[i];
                            if (stack == null || !(stack.func_77973_b() instanceof ItemRBMKRod) || !(ItemRBMKRod.getEnrichment(stack) * 100.0 >= (double)this.cycle)) continue;
                            rod.slots[0] = stack.func_77946_l();
                            this.slots[i] = null;
                            break;
                        }
                    }
                    this.isRetracting = true;
                    this.delay = 40;
                }
            }
            this.networkPackNT(100);
        } else {
            this.lastPiston = this.renderPiston;
            if (this.turnProgress > 0) {
                this.renderPiston += (this.syncPiston - this.renderPiston) / (double)this.turnProgress;
                --this.turnProgress;
            } else {
                this.renderPiston = this.syncPiston;
            }
            if (this.renderPiston > 0.01 && this.renderPiston < 0.99) {
                if (this.audioLift == null || !this.audioLift.isPlaying()) {
                    this.audioLift = MainRegistry.proxy.getLoopedSound("hbm:door.wgh_start", this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getVolume(0.75f), 25.0f, 1.0f, 5);
                    this.audioLift.startSound();
                }
                this.audioLift.updateVolume(this.getVolume(0.75f));
                this.audioLift.keepAlive();
            } else if (this.audioLift != null) {
                this.audioLift.stopSound();
                this.audioLift = null;
                MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:door.wgh_stop", this.getVolume(2.0f), 1.0f);
            }
            if (this.renderPiston > 0.99) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "tower");
                data.func_74776_a("lift", 0.0f);
                data.func_74776_a("base", 0.25f);
                data.func_74776_a("max", 1.5f);
                data.func_74768_a("life", 70 + this.field_145850_b.field_73012_v.nextInt(30));
                data.func_74780_a("posX", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.125);
                data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.125);
                data.func_74780_a("posY", (double)this.field_145848_d + 0.25);
                data.func_74757_a("noWind", true);
                data.func_74776_a("alphaMod", 2.0f);
                data.func_74776_a("strafe", 0.05f);
                for (int i = 0; i < 3; ++i) {
                    MainRegistry.proxy.effectNT(data);
                }
            }
        }
    }

    public boolean hasFuel() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null || !(stack.func_77973_b() instanceof ItemRBMKRod) || !(ItemRBMKRod.getEnrichment(stack) * 100.0 >= (double)this.cycle)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpace() {
        for (int i = 9; i < 18; ++i) {
            if (this.slots[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.piston);
        buf.writeInt(this.cycle);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.syncPiston = buf.readDouble();
        this.cycle = buf.readInt();
        this.turnProgress = 2;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemRBMKRod && ItemRBMKRod.getEnrichment(stack) * 100.0 >= (double)this.cycle && i < 9;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (this.piston <= 0.0) {
            int[] nArray2 = new int[18];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArray2[6] = 6;
            nArray2[7] = 7;
            nArray2[8] = 8;
            nArray2[9] = 9;
            nArray2[10] = 10;
            nArray2[11] = 11;
            nArray2[12] = 12;
            nArray2[13] = 13;
            nArray2[14] = 14;
            nArray2[15] = 15;
            nArray2[16] = 16;
            nArray = nArray2;
            nArray2[17] = 17;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i >= 9;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.piston = nbt.func_74769_h("piston");
        this.isRetracting = nbt.func_74767_n("ret");
        this.delay = nbt.func_74762_e("delay");
        this.cycle = nbt.func_74762_e("cycle");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("piston", this.piston);
        nbt.func_74757_a("ret", this.isRetracting);
        nbt.func_74768_a("delay", this.delay);
        nbt.func_74768_a("cycle", this.cycle);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.aabb != null) {
            return this.aabb;
        }
        this.aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 9), (double)(this.field_145849_e + 1));
        return this.aabb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("minus") && this.cycle > 5) {
            this.cycle -= 5;
        }
        if (data.func_74764_b("plus") && this.cycle < 95) {
            this.cycle += 5;
        }
        this.cycle = MathHelper.func_76125_a((int)this.cycle, (int)5, (int)95);
        this.markChanged();
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKAutoloader(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKAutoloader(player.field_71071_by, this);
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("cycle", this.cycle);
        return data;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        if (nbt.func_74764_b("cycle")) {
            this.cycle = MathHelper.func_76125_a((int)nbt.func_74762_e("cycle"), (int)5, (int)95);
        }
    }
}

