/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityTurbineBase
extends TileEntityLoadedBase
implements IEnergyProviderMK2,
IFluidStandardTransceiverMK2,
IInfoProviderEC,
IBufPacketReceiver,
IFluidCopiable {
    protected ByteBuf buf;
    public long powerBuffer;
    public FluidTank[] tanks;
    protected double[] info = new double[3];
    public boolean operational = false;

    public abstract double getEfficiency();

    public abstract DirPos[] getConPos();

    public abstract DirPos[] getPowerPos();

    public abstract double consumptionPercent();

    public void generatePower(long power, int steamConsumed) {
        this.powerBuffer += power;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FT_Coolable trait;
            double eff;
            this.powerBuffer = 0L;
            this.info = new double[3];
            if (this.buf != null) {
                this.buf.release();
            }
            this.buf = Unpooled.buffer();
            this.tanks[0].serialize(this.buf);
            this.operational = false;
            FluidType in = this.tanks[0].getTankType();
            boolean valid = false;
            if (in.hasTrait(FT_Coolable.class) && (eff = (trait = in.getTrait(FT_Coolable.class)).getEfficiency(FT_Coolable.CoolingType.TURBINE) * this.getEfficiency()) > 0.0) {
                this.tanks[1].setTankType(trait.coolsTo);
                int inputOps = (int)Math.ceil((double)this.tanks[0].getFill() * this.consumptionPercent() / (double)trait.amountReq);
                int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
                int ops = Math.min(inputOps, outputOps);
                if (ops > 0) {
                    this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
                    this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
                    this.generatePower((long)((double)(ops * trait.heatEnergy) * eff), ops * trait.amountReq);
                }
                this.info[0] = ops * trait.amountReq;
                this.info[1] = ops * trait.amountProduced;
                this.info[2] = (double)(ops * trait.heatEnergy) * eff;
                valid = true;
                this.operational = ops > 0;
            }
            this.onServerTick();
            this.tanks[1].serialize(this.buf);
            this.buf.writeLong(this.powerBuffer);
            if (!valid) {
                this.tanks[1].setTankType(Fluids.NONE);
            }
            for (DirPos pos : this.getPowerPos()) {
                this.tryProvide(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            for (DirPos pos : this.getConPos()) {
                this.tryProvide(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.networkPackNT(150);
        } else {
            this.onClientTick();
        }
    }

    public void onServerTick() {
    }

    public void onClientTick() {
    }

    public void onLeverPull() {
        FluidType type = this.tanks[0].getTankType();
        boolean resize = this.doesResizeCompressor();
        if (type == Fluids.STEAM) {
            this.tanks[0].setTankType(Fluids.HOTSTEAM);
            this.tanks[1].setTankType(Fluids.STEAM);
            if (resize) {
                this.tanks[0].changeTankSize(this.tanks[0].getMaxFill() / 10);
                this.tanks[1].changeTankSize(this.tanks[1].getMaxFill() / 10);
            }
        } else if (type == Fluids.HOTSTEAM) {
            this.tanks[0].setTankType(Fluids.SUPERHOTSTEAM);
            this.tanks[1].setTankType(Fluids.HOTSTEAM);
            if (resize) {
                this.tanks[0].changeTankSize(this.tanks[0].getMaxFill() / 10);
                this.tanks[1].changeTankSize(this.tanks[1].getMaxFill() / 10);
            }
        } else if (type == Fluids.SUPERHOTSTEAM) {
            this.tanks[0].setTankType(Fluids.ULTRAHOTSTEAM);
            this.tanks[1].setTankType(Fluids.SUPERHOTSTEAM);
            if (resize) {
                this.tanks[0].changeTankSize(this.tanks[0].getMaxFill() / 10);
                this.tanks[1].changeTankSize(this.tanks[1].getMaxFill() / 10);
            }
        } else if (type == Fluids.ULTRAHOTSTEAM) {
            this.tanks[0].setTankType(Fluids.STEAM);
            this.tanks[1].setTankType(Fluids.SPENTSTEAM);
            if (resize) {
                this.tanks[0].changeTankSize(this.tanks[0].getMaxFill() * 1000);
                this.tanks[1].changeTankSize(this.tanks[1].getMaxFill() * 1000);
            }
        } else {
            this.tanks[0].setTankType(Fluids.STEAM);
            this.tanks[1].setTankType(Fluids.SPENTSTEAM);
        }
        this.func_70296_d();
    }

    public boolean doesResizeCompressor() {
        return false;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBytes(this.buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.powerBuffer = buf.readLong();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.powerBuffer = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.powerBuffer);
    }

    @Override
    public long getPower() {
        return this.powerBuffer;
    }

    @Override
    public long getMaxPower() {
        return this.powerBuffer;
    }

    @Override
    public void setPower(long power) {
        this.powerBuffer = power;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.info[1] > 0.0);
        data.func_74780_a("consumption", this.info[0]);
        data.func_74780_a("outputmb", this.info[1]);
        data.func_74780_a("output", this.info[2]);
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

