/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.MobConfig;
import com.hbm.entity.projectile.EntityZirnoxDebris;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerReactorZirnox;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIReactorZirnox;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemZirnoxRod;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityReactorZirnox
extends TileEntityMachineBase
implements IControlReceiver,
IFluidStandardTransceiver,
SimpleComponent,
IGUIProvider,
IInfoProviderEC,
CompatHandler.OCComponent {
    public int heat;
    public static final int maxHeat = 100000;
    public boolean redstonePowered = false;
    public int pressure;
    public static final int maxPressure = 100000;
    public boolean isOn = false;
    public FluidTank steam = new FluidTank(Fluids.SUPERHOTSTEAM, 8000);
    public FluidTank carbonDioxide = new FluidTank(Fluids.CARBONDIOXIDE, 16000);
    public FluidTank water = new FluidTank(Fluids.WATER, 32000);
    protected int output;
    private static final int[] slots_io = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    public static final HashMap<RecipesCommon.ComparableStack, ItemStack> fuelMap = new HashMap();

    public TileEntityReactorZirnox() {
        super(28);
    }

    public void setRedstonePowered(boolean powered) {
        if (!powered && this.redstonePowered) {
            this.isOn = false;
        }
        this.redstonePowered = powered;
    }

    @Override
    public String getName() {
        return "container.zirnox";
    }

    @Override
    public int[] func_94128_d(int side) {
        return slots_io;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return i < 24 && stack.func_77973_b() instanceof ItemZirnoxRod;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        return i < 24 && !(stack.func_77973_b() instanceof ItemZirnoxRod);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("heat");
        this.pressure = nbt.func_74762_e("pressure");
        this.isOn = nbt.func_74767_n("isOn");
        this.steam.readFromNBT(nbt, "steam");
        this.carbonDioxide.readFromNBT(nbt, "carbondioxide");
        this.water.readFromNBT(nbt, "water");
        this.redstonePowered = nbt.func_74767_n("redstonePowered");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("pressure", this.pressure);
        nbt.func_74757_a("isOn", this.isOn);
        this.steam.writeToNBT(nbt, "steam");
        this.carbonDioxide.writeToNBT(nbt, "carbondioxide");
        this.water.writeToNBT(nbt, "water");
        nbt.func_74757_a("redstonePowered", this.redstonePowered);
    }

    public int getGaugeScaled(int i, int type) {
        switch (type) {
            case 0: {
                return this.steam.getFill() * i / this.steam.getMaxFill();
            }
            case 1: {
                return this.carbonDioxide.getFill() * i / this.carbonDioxide.getMaxFill();
            }
            case 2: {
                return this.water.getFill() * i / this.water.getMaxFill();
            }
            case 3: {
                return this.heat * i / 100000;
            }
            case 4: {
                return this.pressure * i / 100000;
            }
        }
        return 1;
    }

    private int[] getNeighbouringSlots(int id) {
        switch (id) {
            case 0: {
                return new int[]{1, 7};
            }
            case 1: {
                return new int[]{0, 2, 8};
            }
            case 2: {
                return new int[]{1, 9};
            }
            case 3: {
                return new int[]{4, 10};
            }
            case 4: {
                return new int[]{3, 5, 11};
            }
            case 5: {
                return new int[]{4, 6, 12};
            }
            case 6: {
                return new int[]{5, 13};
            }
            case 7: {
                return new int[]{0, 8, 14};
            }
            case 8: {
                return new int[]{1, 7, 9, 15};
            }
            case 9: {
                return new int[]{2, 8, 16};
            }
            case 10: {
                return new int[]{3, 11, 17};
            }
            case 11: {
                return new int[]{4, 10, 12, 18};
            }
            case 12: {
                return new int[]{5, 11, 13, 19};
            }
            case 13: {
                return new int[]{6, 12, 20};
            }
            case 14: {
                return new int[]{7, 15, 21};
            }
            case 15: {
                return new int[]{8, 14, 16, 22};
            }
            case 16: {
                return new int[]{9, 15, 23};
            }
            case 17: {
                return new int[]{10, 18};
            }
            case 18: {
                return new int[]{11, 17, 19};
            }
            case 19: {
                return new int[]{12, 18, 20};
            }
            case 20: {
                return new int[]{13, 19};
            }
            case 21: {
                return new int[]{14, 22};
            }
            case 22: {
                return new int[]{15, 21, 23};
            }
            case 23: {
                return new int[]{16, 22};
            }
        }
        return null;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.redstonePowered) {
                this.isOn = true;
            }
            this.output = 0;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.carbonDioxide.loadTank(24, 26, this.slots);
            this.water.loadTank(25, 27, this.slots);
            if (this.isOn) {
                for (int i = 0; i < 24; ++i) {
                    if (this.slots[i] == null) continue;
                    if (this.slots[i].func_77973_b() instanceof ItemZirnoxRod) {
                        this.decay(i);
                        continue;
                    }
                    if (this.slots[i].func_77973_b() != ModItems.meteorite_sword_bred) continue;
                    this.slots[i] = new ItemStack(ModItems.meteorite_sword_irradiated);
                }
            }
            this.pressure = this.carbonDioxide.getFill() * 2 + (int)((float)this.heat * ((float)this.carbonDioxide.getFill() / (float)this.carbonDioxide.getMaxFill()));
            if (this.heat > 0 && this.heat < 100000) {
                if (this.water.getFill() > 0 && this.carbonDioxide.getFill() > 0 && this.steam.getFill() < this.steam.getMaxFill()) {
                    this.generateSteam();
                    this.heat -= (int)((float)this.heat * (float)this.pressure / 1000000.0f);
                } else {
                    this.heat -= 10;
                }
            }
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.steam, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.checkIfMeltdown();
            this.networkPackNT(150);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.heat);
        buf.writeInt(this.pressure);
        buf.writeBoolean(this.isOn);
        buf.writeBoolean(this.redstonePowered);
        this.steam.serialize(buf);
        this.carbonDioxide.serialize(buf);
        this.water.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.heat = buf.readInt();
        this.pressure = buf.readInt();
        this.isOn = buf.readBoolean();
        this.redstonePowered = buf.readBoolean();
        this.steam.deserialize(buf);
        this.carbonDioxide.deserialize(buf);
        this.water.deserialize(buf);
    }

    private void generateSteam() {
        if (this.heat > 10256) {
            int cycle;
            this.output = cycle = (int)(((float)this.heat - 10256.0f) / 100000.0f * Math.min((float)this.carbonDioxide.getFill() / 14000.0f, 1.0f) * 25.0f * 5.0f);
            this.water.setFill(this.water.getFill() - cycle);
            this.steam.setFill(this.steam.getFill() + cycle);
            if (this.water.getFill() < 0) {
                this.water.setFill(0);
            }
            if (this.steam.getFill() > this.steam.getMaxFill()) {
                this.steam.setFill(this.steam.getMaxFill());
            }
        }
    }

    private boolean hasFuelRod(int id) {
        if (this.slots[id] != null && this.slots[id].func_77973_b() instanceof ItemZirnoxRod) {
            ItemZirnoxRod.EnumZirnoxType num = (ItemZirnoxRod.EnumZirnoxType)((Object)EnumUtil.grabEnumSafely(ItemZirnoxRod.EnumZirnoxType.class, this.slots[id].func_77960_j()));
            return !num.breeding;
        }
        return false;
    }

    private int getNeighbourCount(int id) {
        int[] neighbours = this.getNeighbouringSlots(id);
        if (neighbours == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < neighbours.length; ++i) {
            if (!this.hasFuelRod(neighbours[i])) continue;
            ++count;
        }
        return count;
    }

    private void decay(int id) {
        int decay = this.getNeighbourCount(id);
        ItemZirnoxRod.EnumZirnoxType num = (ItemZirnoxRod.EnumZirnoxType)((Object)EnumUtil.grabEnumSafely(ItemZirnoxRod.EnumZirnoxType.class, this.slots[id].func_77960_j()));
        if (!num.breeding) {
            ++decay;
        }
        for (int i = 0; i < decay; ++i) {
            this.heat += num.heat;
            ItemZirnoxRod.incrementLifeTime(this.slots[id]);
            if (ItemZirnoxRod.getLifeTime(this.slots[id]) <= num.maxLife) continue;
            this.slots[id] = fuelMap.get(new RecipesCommon.ComparableStack(this.func_70301_a(id))).func_77946_l();
            break;
        }
    }

    private void checkIfMeltdown() {
        if (this.pressure > 100000 || this.heat > 100000) {
            this.meltdown();
        }
    }

    private void spawnDebris(EntityZirnoxDebris.DebrisType type) {
        EntityZirnoxDebris debris = new EntityZirnoxDebris(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 4.0, (double)this.field_145849_e + 0.5, type);
        debris.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.75;
        debris.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.75;
        debris.field_70181_x = 0.01 + this.field_145850_b.field_73012_v.nextDouble() * 1.25;
        if (type == EntityZirnoxDebris.DebrisType.CONCRETE) {
            debris.field_70159_w *= 0.25;
            debris.field_70181_x += this.field_145850_b.field_73012_v.nextDouble();
            debris.field_70179_y *= 0.25;
        }
        if (type == EntityZirnoxDebris.DebrisType.EXCHANGER) {
            debris.field_70159_w += 0.5;
            debris.field_70181_x *= 0.1;
            debris.field_70179_y += 0.5;
        }
        this.field_145850_b.func_72838_d((Entity)debris);
    }

    private void zirnoxDebris() {
        int i;
        for (i = 0; i < 2; ++i) {
            this.spawnDebris(EntityZirnoxDebris.DebrisType.EXCHANGER);
        }
        for (i = 0; i < 20; ++i) {
            this.spawnDebris(EntityZirnoxDebris.DebrisType.CONCRETE);
            this.spawnDebris(EntityZirnoxDebris.DebrisType.BLANK);
        }
        for (i = 0; i < 10; ++i) {
            this.spawnDebris(EntityZirnoxDebris.DebrisType.ELEMENT);
            this.spawnDebris(EntityZirnoxDebris.DebrisType.GRAPHITE);
            this.spawnDebris(EntityZirnoxDebris.DebrisType.SHRAPNEL);
        }
    }

    private void meltdown() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        int[] dimensions = new int[]{1, 0, 2, 2, 2, 2};
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.zirnox_destroyed, this.func_145832_p(), 3);
        MultiblockHandlerXR.fillSpace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dimensions, ModBlocks.zirnox_destroyed, ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)));
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 2), (double)this.field_145849_e, "hbm:block.rbmk_explosion", 10.0f, 1.0f);
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)(this.field_145848_d + 3), (double)this.field_145849_e, 12.0f, true);
        this.zirnoxDebris();
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 35);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(100.0, 100.0, 100.0));
        for (EntityPlayer player : players) {
            player.func_71029_a((StatBase)MainRegistry.achZIRNOXBoom);
        }
        if (MobConfig.enableElementals) {
            for (EntityPlayer player : players) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", true);
            }
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.water.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.carbonDioxide.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d + 3, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c + rot.offsetX * -3, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * -3, rot.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * -3, this.field_145848_d + 3, this.field_145849_e + rot.offsetZ * -3, rot.getOpposite())};
    }

    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.steam);
        list.add(this.carbonDioxide);
        list.add(this.water);
        return list;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("control") && !this.redstonePowered) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (data.func_74764_b("vent")) {
            int fill = this.carbonDioxide.getFill();
            this.carbonDioxide.setFill(fill - 1000);
            if (this.carbonDioxide.getFill() < 0) {
                this.carbonDioxide.setFill(0);
            }
        }
        this.func_70296_d();
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.water, this.carbonDioxide};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.water, this.steam, this.carbonDioxide};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "zirnox_reactor";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTemp(Context context, Arguments args) {
        return new Object[]{Math.round((double)this.heat * 1.0E-5 * 780.0 + 20.0)};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPressure(Context context, Arguments args) {
        return new Object[]{Math.round((double)this.pressure * 1.0E-5 * 30.0)};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getWater(Context context, Arguments args) {
        return new Object[]{this.water.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSteam(Context context, Arguments args) {
        return new Object[]{this.steam.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCarbonDioxide(Context context, Arguments args) {
        return new Object[]{this.carbonDioxide.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isActive(Context context, Arguments args) {
        return new Object[]{this.isOn};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{Math.round((double)this.heat * 1.0E-5 * 780.0 + 20.0), Math.round((double)this.pressure * 1.0E-5 * 30.0), this.water.getFill(), this.steam.getFill(), this.carbonDioxide.getFill(), this.isOn};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setActive(Context context, Arguments args) {
        this.isOn = args.checkBoolean(0);
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] ventCarbonDioxide(Context context, Arguments args) {
        int ventAmount = MathHelper.func_76125_a((int)args.optInteger(0, 1000), (int)0, (int)this.carbonDioxide.getMaxFill());
        int fill = this.carbonDioxide.getFill();
        this.carbonDioxide.setFill(Math.max(fill - ventAmount, 0));
        return new Object[0];
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getTemp", "getPressure", "getWater", "getSteam", "getCarbonDioxide", "isActive", "getInfo", "setActive", "ventCarbonDioxide"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getTemp": {
                return this.getTemp(context, args);
            }
            case "getPressure": {
                return this.getPressure(context, args);
            }
            case "getWater": {
                return this.getWater(context, args);
            }
            case "getSteam": {
                return this.getSteam(context, args);
            }
            case "getCarbonDioxide": {
                return this.getCarbonDioxide(context, args);
            }
            case "isActive": {
                return this.isActive(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
            case "setActive": {
                return this.setActive(context, args);
            }
            case "ventCarbonDioxide": {
                return this.ventCarbonDioxide(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerReactorZirnox(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIReactorZirnox(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74780_a("heat", (double)Math.round((double)this.heat * 1.0E-5 * 780.0 + 20.0));
        data.func_74780_a("maxHeat", (double)Math.round(800.0));
        data.func_74772_a("bar", Math.round((double)this.pressure * 1.0E-5 * 30.0));
        data.func_74780_a("consumption", (double)this.output);
        data.func_74780_a("outputmb", (double)this.output);
    }

    static {
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.NATURAL_URANIUM_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_natural_uranium_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.URANIUM_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_uranium_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.TH232.ordinal()), new ItemStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.THORIUM_FUEL.ordinal()));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.THORIUM_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_thorium_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.MOX_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_mox_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.PLUTONIUM_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_plutonium_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.U233_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_u233_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.U235_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_u235_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.LES_FUEL.ordinal()), new ItemStack(ModItems.rod_zirnox_les_fuel_depleted));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.LITHIUM.ordinal()), new ItemStack(ModItems.rod_zirnox_tritium));
        fuelMap.put(new RecipesCommon.ComparableStack((Item)ModItems.rod_zirnox, 1, ItemZirnoxRod.EnumZirnoxType.ZFB_MOX.ordinal()), new ItemStack(ModItems.rod_zirnox_zfb_mox_depleted));
    }
}

