/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.machine.TileEntityTurbineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineIndustrialTurbine
extends TileEntityTurbineBase
implements IConfigurableMachine {
    public static int inputTankSize = 512000;
    public static int outputTankSize = 2048000;
    public static double efficiency = 1.0;
    public float rotor;
    public float lastRotor;
    public double spin = 0.0;
    public static double ACCELERATION = 0.0025;
    public long lastPowerTarget = 0L;
    private AudioWrapper audio;
    private float audioDesync;
    AxisAlignedBB bb = null;

    @Override
    public String getConfigName() {
        return "steamturbineIndustrial";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        inputTankSize = IConfigurableMachine.grab(obj, "I:inputTankSize", inputTankSize);
        outputTankSize = IConfigurableMachine.grab(obj, "I:outputTankSize", outputTankSize);
        efficiency = IConfigurableMachine.grab(obj, "D:efficiency", efficiency);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("INFO").value("industrial steam turbine consumes 20% of availible steam per tick");
        writer.name("I:inputTankSize").value((long)inputTankSize);
        writer.name("I:outputTankSize").value((long)outputTankSize);
        writer.name("D:efficiency").value(efficiency);
    }

    public TileEntityMachineIndustrialTurbine() {
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.STEAM, inputTankSize);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, outputTankSize);
        Random rand = new Random();
        this.audioDesync = rand.nextFloat() * 0.05f;
    }

    @Override
    public void generatePower(long power, int steamConsumed) {
        FT_Coolable trait = this.tanks[0].getTankType().getTrait(FT_Coolable.class);
        double eff = trait.getEfficiency(FT_Coolable.CoolingType.TURBINE) * this.getEfficiency();
        int maxOps = (int)Math.ceil((double)this.tanks[0].getMaxFill() * this.consumptionPercent() / (double)trait.amountReq);
        this.lastPowerTarget = (long)((double)(maxOps * trait.heatEnergy) * eff);
        double fraction = (double)steamConsumed / (double)(trait.amountReq * maxOps);
        if (Math.abs(this.spin - fraction) <= ACCELERATION) {
            this.spin = fraction;
        } else if (this.spin < fraction) {
            this.spin += ACCELERATION;
        } else if (this.spin > fraction) {
            this.spin -= ACCELERATION;
        }
    }

    @Override
    public void onServerTick() {
        if (!this.operational) {
            this.spin -= ACCELERATION;
        }
        if (this.spin <= 0.0) {
            this.spin = 0.0;
        } else {
            this.powerBuffer = (long)((double)this.lastPowerTarget * this.spin);
        }
    }

    @Override
    public void onClientTick() {
        this.lastRotor = this.rotor;
        float speed = this.spin >= 0.5 ? 30.0f : (float)(Math.pow(this.spin * 2.0, 0.5) * 30.0);
        this.rotor += speed;
        if (this.rotor >= 360.0f) {
            this.lastRotor -= 360.0f;
            this.rotor -= 360.0f;
        }
        if (this.spin > 0.0 && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 35.0) {
            float spinNum = (float)Math.min(1.0, this.spin * 2.0);
            float volume = this.getVolume(0.25f + spinNum * 0.75f);
            float pitch = 0.5f + spinNum * 0.5f + this.audioDesync;
            if (this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.largeTurbineRunning", (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f, volume, 20.0f, pitch, 20);
                this.audio.startSound();
            }
            this.audio.keepAlive();
            this.audio.updatePitch(pitch);
            this.audio.updateVolume(volume);
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        ForgeDirection myDir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return dir == myDir.getOpposite();
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        if (type != Fluids.SPENTSTEAM && !type.hasTrait(FT_Coolable.class)) {
            return false;
        }
        ForgeDirection myDir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return dir != myDir && dir != myDir.getOpposite();
    }

    @Override
    public double consumptionPercent() {
        return 0.2;
    }

    @Override
    public double getEfficiency() {
        return efficiency;
    }

    @Override
    public boolean doesResizeCompressor() {
        return true;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.spin);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.spin = buf.readDouble();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.lastPowerTarget = nbt.func_74763_f("lastPowerTarget");
        this.spin = nbt.func_74769_h("spin");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("lastPowerTarget", this.lastPowerTarget);
        nbt.func_74780_a("spin", this.spin);
    }

    @Override
    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 3 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + dir.offsetX * 3 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 1 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 1 + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - dir.offsetX * 1 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 1 - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 3, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 3, ForgeDirection.UP), new DirPos(this.field_145851_c - dir.offsetX * 1, this.field_145848_d + 3, this.field_145849_e - dir.offsetZ * 1, ForgeDirection.UP)};
    }

    @Override
    public DirPos[] getPowerPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 4, this.field_145848_d + 1, this.field_145849_e - dir.offsetZ * 4, dir.getOpposite())};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }
}

