/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.dim.trait.CBT_Dyson;
import com.hbm.items.ISatChip;
import com.hbm.items.ModItems;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDysonLauncher
extends TileEntityMachineBase
implements IEnergyReceiverMK2 {
    public int swarmId;
    public int swarmCount;
    public long power;
    public static final long MAX_POWER = 20000000L;
    private static final int MEMBERS_PER_LAUNCH = 4;
    boolean sunsetOverdrive = false;
    public boolean isOperating;
    public boolean isSpinningDown;
    public int operatingTime;
    public float rotation;
    public float lastRotation;
    public float speed;
    public int payloadTicks;
    public int satCount;
    AxisAlignedBB bb = null;

    public TileEntityDysonLauncher() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.machineDysonLauncher";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            for (DirPos pos : this.getInvPos()) {
                this.tryLoad(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.swarmId = ISatChip.getFreqS(this.slots[1]);
            this.swarmCount = CBT_Dyson.count(this.field_145850_b, this.swarmId);
            boolean bl = this.isOperating = !this.isSpinningDown && this.power >= this.getPowerPerTick() && this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.swarm_member && this.swarmId > 0;
            if (this.isSpinningDown) {
                ++this.operatingTime;
                if (this.operatingTime > this.getSpinDownTime()) {
                    this.isSpinningDown = false;
                    this.operatingTime = 0;
                }
            } else if (this.isOperating) {
                if (this.operatingTime == 0) {
                    float pitch = this.sunsetOverdrive ? 1.0f : 0.25f;
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 8), (double)this.field_145849_e, "hbm:misc.spincharge", 1.5f, pitch);
                }
                ++this.operatingTime;
                this.power -= this.getPowerPerTick();
                if (this.operatingTime > this.getSpinUpTime()) {
                    int toLaunch = Math.min(this.slots[0].field_77994_a, 4);
                    CBT_Dyson.launch(this.field_145850_b, this.swarmId, toLaunch);
                    CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_145850_b, CBT_Atmosphere.class);
                    double pressure = atmosphere != null ? atmosphere.getPressure() : 0.0;
                    double scaledPressure = 1.0 - Math.pow(1.0 - pressure, 3.0);
                    float volume = Math.min((float)scaledPressure * 16.0f, 4.0f);
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                    ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                    this.field_145850_b.func_72908_a((double)(this.field_145851_c + rot.offsetX * 6), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + rot.offsetZ * 6), "hbm:misc.spinshot", volume, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f);
                    this.field_145850_b.func_72908_a((double)(this.field_145851_c + rot.offsetX * 6), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + rot.offsetZ * 6), "hbm:misc.spinshot", volume, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f);
                    int count = Math.min(20, (int)(pressure * 80.0));
                    double posX = this.field_145851_c + rot.offsetX * 9;
                    double posY = this.field_145848_d + 12;
                    double posZ = this.field_145849_e + rot.offsetZ * 9;
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74768_a("count", count);
                    data.func_74778_a("type", "spinlaunch");
                    data.func_74776_a("scale", 3.0f);
                    data.func_74780_a("moX", (double)(dir.offsetX * 10));
                    data.func_74780_a("moY", 10.0);
                    data.func_74780_a("moZ", (double)(dir.offsetZ * 10));
                    data.func_74768_a("maxAge", 10 + count / 2 + this.field_145850_b.field_73012_v.nextInt(5));
                    PacketDispatcher.wrapper.sendToAllAround(new AuxParticlePacketNT(data, posX, posY, posZ), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
                    this.slots[0].field_77994_a -= toLaunch;
                    if (this.slots[0].field_77994_a <= 0) {
                        this.slots[0] = null;
                    }
                    this.operatingTime = 0;
                    this.isSpinningDown = true;
                }
            } else {
                this.operatingTime = 0;
            }
            this.networkPackNT(250);
        } else {
            float resetSpeed;
            float acceleration = this.sunsetOverdrive ? 2.5f : 0.75f;
            float deceleration = this.sunsetOverdrive ? 15.0f : 3.0f;
            float f = resetSpeed = this.sunsetOverdrive ? 30.0f : 8.0f;
            if (this.isOperating) {
                this.speed += acceleration;
                if (this.speed > 90.0f) {
                    this.speed = 90.0f;
                }
            } else if (this.speed > 0.1f) {
                this.speed -= deceleration;
                if (this.speed < resetSpeed) {
                    this.speed = resetSpeed;
                }
            }
            this.lastRotation = this.rotation;
            if (!this.isOperating && this.speed <= resetSpeed && (double)this.rotation > 360.0 - (double)resetSpeed * 1.5) {
                this.lastRotation -= 360.0f;
                this.rotation = 0.0f;
                this.speed = 0.0f;
            } else {
                this.rotation += this.speed;
            }
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.lastRotation -= 360.0f;
            }
            this.payloadTicks = this.isSpinningDown ? ++this.payloadTicks : 0;
        }
    }

    private int getSpinUpTime() {
        return this.sunsetOverdrive ? 38 : 132;
    }

    private int getSpinDownTime() {
        return this.sunsetOverdrive ? 12 : 68;
    }

    private long getPowerPerTick() {
        return 20000000L / (long)this.getSpinUpTime();
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 0 - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 0 - rot.offsetZ * 3, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 1 - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 1 - rot.offsetZ * 3, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 3, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 3 - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 3 - rot.offsetZ * 3, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 4 - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 4 - rot.offsetZ * 3, rot.getOpposite())};
    }

    public DirPos[] getInvPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 9, this.field_145848_d, this.field_145849_e - dir.offsetZ * 9, dir.getOpposite())};
    }

    private void tryLoad(int x, int y, int z, ForgeDirection dir) {
        if (this.slots[0] != null && this.slots[0].field_77994_a >= 4) {
            return;
        }
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (!(te instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)te;
        ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        int[] access = sided != null ? sided.func_94128_d(dir.ordinal()) : null;
        for (int i = 0; i < (access != null ? access.length : inv.func_70302_i_()); ++i) {
            int slot = access != null ? access[i] : i;
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null || stack.func_77973_b() != ModItems.swarm_member || sided != null && !sided.func_102008_b(slot, stack, dir.ordinal())) continue;
            ItemStack removed = inv.func_70298_a(slot, 1);
            if (this.slots[0] == null) {
                this.slots[0] = removed;
                break;
            }
            ++this.slots[0].field_77994_a;
            break;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.swarmId);
        buf.writeLong(this.power);
        buf.writeBoolean(this.isOperating);
        buf.writeBoolean(this.isSpinningDown);
        buf.writeInt(this.swarmCount);
        buf.writeBoolean(this.sunsetOverdrive);
        buf.writeInt(this.slots[0] != null ? this.slots[0].field_77994_a : 0);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.swarmId = buf.readInt();
        this.power = buf.readLong();
        this.isOperating = buf.readBoolean();
        this.isSpinningDown = buf.readBoolean();
        this.swarmCount = buf.readInt();
        this.sunsetOverdrive = buf.readBoolean();
        this.satCount = buf.readInt();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("spinDown", this.isSpinningDown);
        nbt.func_74768_a("time", this.operatingTime);
        nbt.func_74757_a("overdrive", this.sunsetOverdrive);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.isSpinningDown = nbt.func_74767_n("spinDown");
        this.operatingTime = nbt.func_74762_e("time");
        this.sunsetOverdrive = nbt.func_74767_n("overdrive");
    }

    @Override
    public int func_70297_j_() {
        return 4;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return itemStack.func_77973_b() == ModItems.swarm_member;
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 20000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 100), (double)this.field_145848_d, (double)(this.field_145849_e - 100), (double)(this.field_145851_c + 100), (double)(this.field_145848_d + 100), (double)(this.field_145849_e + 100));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

