/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.inventory.fluid.trait.FT_Polluting;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAtmosphericEmitter
extends TileEntityLoadedBase
implements IEnergyReceiverMK2,
IFluidStandardReceiverMK2 {
    public FluidTank tank = new FluidTank(Fluids.NONE, 50000);
    public long power;
    public float fan = 0.0f;
    public float prevFan = 0.0f;
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int toSpill;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos);
                    this.trySubscribe(this.field_145850_b, pos);
                }
            }
            this.networkPackNT(50);
            if (this.tank.getFill() > 0 && this.power >= (long)((toSpill = Math.max(this.tank.getFill() / 2, 1)) * 10)) {
                if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Amat.class)) {
                    this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 10.0f, true, true);
                    return;
                }
                this.tank.setFill(this.tank.getFill() - toSpill);
                FT_Polluting.pollute(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType(), FluidTrait.FluidReleaseType.SPILL, toSpill);
                FT_Gaseous.release(this.field_145850_b, this.tank.getTankType(), toSpill);
                this.power -= (long)(toSpill * 10);
            }
        } else {
            this.prevFan = this.fan;
            if (this.power >= (long)(Math.max(this.tank.getFill() / 2, 1) * 10)) {
                this.fan += 45.0f;
                if (this.fan >= 360.0f) {
                    this.fan -= 360.0f;
                    this.prevFan -= 360.0f;
                }
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updateVolume(this.getVolume(0.25f));
                if (this.tank.getFill() > 0 && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 100.0) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                    ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74776_a("lift", 0.5f);
                    data.func_74776_a("base", 0.375f);
                    data.func_74776_a("max", 3.0f);
                    data.func_74768_a("life", 100 + this.field_145850_b.field_73012_v.nextInt(50));
                    data.func_74778_a("type", "tower");
                    data.func_74768_a("color", this.tank.getTankType().getColor());
                    data.func_74780_a("posX", (double)this.field_145851_c + 0.5 - (double)dir.offsetX * 0.5 + (double)rot.offsetX * 0.5);
                    data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * 0.5 + (double)rot.offsetZ * 0.5);
                    data.func_74780_a("posY", (double)this.field_145848_d + 2.5);
                    data.func_74780_a("mY", 0.2);
                    MainRegistry.proxy.effectNT(data);
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.motor", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 10.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "t");
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "t");
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.power);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.power = buf.readLong();
        this.tank.deserialize(buf);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 250000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

