/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardSenderMK2;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAtmosphericCompressor
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardSenderMK2 {
    int consumption = 200;
    public float rot;
    public float prevRot;
    private float rotSpeed;
    public long power = 0L;
    public FluidTank tank = new FluidTank(Fluids.EARTHAIR, 50000);
    AxisAlignedBB bb = null;

    public TileEntityAtmosphericCompressor() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.air";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            CBT_Atmosphere atmosphere;
            this.updateConnections();
            CBT_Atmosphere cBT_Atmosphere = atmosphere = !(this.field_145850_b.field_73011_w instanceof WorldProviderOrbit) && !ChunkAtmosphereManager.proxy.hasAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) ? CelestialBody.getTrait(this.field_145850_b, CBT_Atmosphere.class) : null;
            if (atmosphere != null && atmosphere.getPressure() > 0.0) {
                if (!atmosphere.hasFluid(this.tank.getTankType())) {
                    this.tank.setTankType(atmosphere.getMainFluid());
                }
            } else {
                this.tank.setTankType(Fluids.NONE);
            }
            if (this.hasPower() && this.tank.getTankType() != Fluids.NONE && this.tank.getFill() + 200 <= this.tank.getMaxFill()) {
                this.tank.setFill(this.tank.getFill() + 200);
                this.power -= this.getMaxPower() / 50L;
                FT_Gaseous.capture(this.field_145850_b, this.tank.getTankType(), 200.0);
            }
            this.func_70296_d();
            this.networkPackNT(50);
        } else {
            float maxSpeed = 30.0f;
            if (this.hasPower()) {
                this.rotSpeed = (float)((double)this.rotSpeed + 0.2);
                if (this.rotSpeed > maxSpeed) {
                    this.rotSpeed = maxSpeed;
                }
            } else {
                this.rotSpeed = (float)((double)this.rotSpeed - 0.1);
                if (this.rotSpeed < 0.0f) {
                    this.rotSpeed = 0.0f;
                }
            }
            this.prevRot = this.rot;
            this.rot += this.rotSpeed;
            if (this.rot >= 360.0f) {
                this.rot -= 360.0f;
                this.prevRot -= 360.0f;
            }
        }
    }

    public void cycleGas() {
        CBT_Atmosphere atmosphere;
        CBT_Atmosphere cBT_Atmosphere = atmosphere = !ChunkAtmosphereManager.proxy.hasAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) ? CelestialBody.getTrait(this.field_145850_b, CBT_Atmosphere.class) : null;
        if (atmosphere == null) {
            return;
        }
        atmosphere.sortDescending();
        FluidType currentFluid = this.tank.getTankType();
        for (int i = 0; i < atmosphere.fluids.size(); ++i) {
            if (atmosphere.fluids.get((int)i).fluid != currentFluid) continue;
            int targetIndex = i + 1;
            if (targetIndex >= atmosphere.fluids.size()) {
                targetIndex = 0;
            }
            if (atmosphere.fluids.get((int)targetIndex).pressure <= 1.0E-4) {
                targetIndex = 0;
            }
            this.tank.setTankType(atmosphere.fluids.get((int)targetIndex).fluid);
            break;
        }
    }

    public boolean switchGas(FluidType targetFluid) {
        CBT_Atmosphere atmosphere;
        if (targetFluid == this.tank.getTankType()) {
            return false;
        }
        CBT_Atmosphere cBT_Atmosphere = atmosphere = !ChunkAtmosphereManager.proxy.hasAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) ? CelestialBody.getTrait(this.field_145850_b, CBT_Atmosphere.class) : null;
        if (atmosphere == null) {
            return false;
        }
        for (CBT_Atmosphere.FluidEntry entry : atmosphere.fluids) {
            if (entry.fluid != targetFluid) continue;
            this.tank.setTankType(targetFluid);
            return true;
        }
        return false;
    }

    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos);
            this.tryProvide(this.tank, this.field_145850_b, pos);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.tank.deserialize(buf);
    }

    public boolean hasPower() {
        return this.power >= this.getMaxPower() / 50L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt, "water");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "water");
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ, dir), new DirPos(this.field_145851_c - rot.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ - rot.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - dir.offsetX + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ + rot.offsetZ * 2, rot)};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 10), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

