/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.entity.missile.EntityRideableRocket;
import com.hbm.items.ItemEnumMulti;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class ItemVOTVdrive
extends ItemEnumMulti {
    private IIcon[] overlays;

    public ItemVOTVdrive() {
        super(SolarSystem.Body.class, false, false);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        Destination destination = ItemVOTVdrive.getDestination(stack);
        if (destination.body == SolarSystem.Body.ORBIT) {
            String identifier = stack.field_77990_d.func_74779_i("stationName");
            if (identifier.equals("")) {
                identifier = "0x" + Integer.toHexString(new ChunkCoordIntPair(destination.x, destination.z).hashCode()).toUpperCase();
            }
            list.add("Destination: ORBITAL STATION");
            list.add("Station: " + identifier);
            if (player.field_70170_p.field_73011_w.field_76574_g != destination.body.getDimensionId()) {
                for (String s : I18nUtil.resolveKey("item.hard_drive_full.orbit.desc", new Object[0]).split("\\$")) {
                    list.add(EnumChatFormatting.GOLD + s);
                }
            }
            return;
        }
        int processingLevel = destination.body.getProcessingLevel(CelestialBody.getBody(player.field_70170_p));
        list.add("Destination: " + EnumChatFormatting.AQUA + I18nUtil.resolveKey("body." + destination.body.name, new Object[0]));
        if (destination.x == 0 && destination.z == 0) {
            list.add(EnumChatFormatting.GOLD + "Needs destination coordinates!");
        } else if (!ItemVOTVdrive.getProcessed(stack)) {
            list.add("Process requirement: Level " + processingLevel);
            list.add(EnumChatFormatting.GOLD + "Needs processing!");
            list.add("Target coordinates: " + destination.x + ", " + destination.z);
        } else {
            list.add(EnumChatFormatting.GREEN + "Processed!");
            list.add("Target coordinates: " + destination.x + ", " + destination.z);
        }
        if (player.field_70170_p.field_73011_w.field_76574_g == destination.body.getDimensionId()) {
            for (String s : I18nUtil.resolveKey("item.hard_drive_full.surface.desc", new Object[0]).split("\\$")) {
                list.add(EnumChatFormatting.GOLD + s);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.overlays = new IIcon[SolarSystem.Body.values().length];
        for (int i = 0; i < this.overlays.length; ++i) {
            SolarSystem.Body body = SolarSystem.Body.values()[i];
            String name = body != SolarSystem.Body.ORBIT ? body.name : "orbit";
            this.overlays[i] = iconRegister.func_94245_a("hbm:votv." + name);
        }
        this.field_77791_bV = iconRegister.func_94245_a("hbm:votv_f");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        if (pass == 0) {
            return this.func_77617_a(meta);
        }
        return this.overlays[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        NBTTagCompound stackTag = new NBTTagCompound();
        stackTag.func_74768_a("x", 1);
        stackTag.func_74768_a("ax", 1);
        stackTag.func_74757_a("Processed", true);
        for (int i = 0; i < ((Enum[])this.theEnum.getEnumConstants()).length; ++i) {
            ItemStack stack = new ItemStack(item, 1, i);
            stack.field_77990_d = stackTag;
            list.add(stack);
        }
    }

    public static SolarSystem.Body getBody(ItemStack stack) {
        return SolarSystem.Body.values()[stack.func_77960_j() % SolarSystem.Body.values().length];
    }

    public static Destination getDestination(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        SolarSystem.Body body = ItemVOTVdrive.getBody(stack);
        int x = stack.field_77990_d.func_74762_e("x");
        int z = stack.field_77990_d.func_74762_e("z");
        return new Destination(body, x, z);
    }

    public static Target getTarget(ItemStack stack, World world) {
        if (stack == null) {
            return new Target(null, false, false);
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        Destination destination = ItemVOTVdrive.getDestination(stack);
        if (destination.body == SolarSystem.Body.ORBIT) {
            if (world.field_72995_K) {
                CelestialBody body = CelestialBody.getBody(stack.field_77990_d.func_74762_e("sDim"));
                boolean hasStation = stack.field_77990_d.func_74767_n("sHas");
                return new Target(body, true, hasStation);
            }
            OrbitalStation station = OrbitalStation.getStation(destination.x, destination.z);
            if (!station.hasStation) {
                station.orbiting = CelestialBody.getBody(world);
            }
            stack.field_77990_d.func_74778_a("stationName", station.name);
            stack.field_77990_d.func_74768_a("sDim", station.orbiting.dimensionId);
            stack.field_77990_d.func_74757_a("sHas", station.hasStation);
            return new Target(station.orbiting, true, station.hasStation);
        }
        return new Target(destination.body.getBody(), false, true);
    }

    public static void setCoordinates(ItemStack stack, int x, int z) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("x", x);
        stack.field_77990_d.func_74768_a("z", z);
    }

    public static int getProcessingTier(ItemStack stack, CelestialBody from) {
        SolarSystem.Body body = ItemVOTVdrive.getBody(stack);
        return body.getProcessingLevel(from);
    }

    public static boolean getProcessed(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d.func_74767_n("Processed");
    }

    public static void setProcessed(ItemStack stack, boolean processed) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a("Processed", processed);
    }

    public static Destination getApproximateDestination(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        SolarSystem.Body body = ItemVOTVdrive.getBody(stack);
        if (!stack.field_77990_d.func_74764_b("ax") || !stack.field_77990_d.func_74764_b("az")) {
            stack.field_77990_d.func_74768_a("ax", field_77697_d.nextInt(SpaceConfig.maxProbeDistance * 2) - SpaceConfig.maxProbeDistance);
            stack.field_77990_d.func_74768_a("az", field_77697_d.nextInt(SpaceConfig.maxProbeDistance * 2) - SpaceConfig.maxProbeDistance);
        }
        int ax = stack.field_77990_d.func_74762_e("ax");
        int az = stack.field_77990_d.func_74762_e("az");
        return new Destination(body, ax, az);
    }

    public static void markCopied(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a("copied", true);
    }

    public static boolean wasCopied(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.field_77990_d.func_74767_n("copied");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean onDestination;
        boolean isProcessed = ItemVOTVdrive.getProcessed(stack);
        boolean bl = onDestination = world.field_73011_w.field_76574_g == ItemVOTVdrive.getDestination((ItemStack)stack).body.getDimensionId();
        if (!isProcessed && (player.field_71075_bZ.field_75098_d || onDestination)) {
            isProcessed = true;
            ItemVOTVdrive.setProcessed(stack, true);
        }
        ItemStack newStack = stack;
        if (isProcessed && player.field_70154_o != null && player.field_70154_o instanceof EntityRideableRocket) {
            EntityRideableRocket rocket = (EntityRideableRocket)player.field_70154_o;
            if (!(rocket.getRocket().stages.size() <= 0 && world.field_73011_w.field_76574_g != SpaceConfig.orbitDimension && !rocket.isReusable() || rocket.getState() != EntityRideableRocket.RocketState.LANDED && rocket.getState() != EntityRideableRocket.RocketState.AWAITING)) {
                if (rocket.navDrive != null) {
                    newStack = rocket.navDrive;
                } else {
                    newStack.field_77994_a = 0;
                }
                rocket.navDrive = stack.func_77946_l();
                rocket.navDrive.field_77994_a = 1;
                if (!world.field_72995_K) {
                    rocket.setState(EntityRideableRocket.RocketState.AWAITING);
                }
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hbm:item.upgradePlug", 1.0f, 1.0f);
            }
        }
        return newStack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        boolean onDestination;
        Destination destination = ItemVOTVdrive.getDestination(stack);
        if (destination.body == SolarSystem.Body.ORBIT) {
            if (world.field_73011_w.field_76574_g == SpaceConfig.orbitDimension) {
                return false;
            }
            if (!world.field_72995_K) {
                Destination target;
                OrbitalStation station = OrbitalStation.getStation(destination.x, destination.z);
                if (station.recallPod(target = new Destination(CelestialBody.getEnum(world), x, z))) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + "Recalling drop pod to coordinates: " + x + ", " + z));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + "Could not recall drop pod from station!"));
                }
            }
            return true;
        }
        boolean bl = onDestination = world.field_73011_w.field_76574_g == destination.body.getDimensionId();
        if (!onDestination) {
            return false;
        }
        ItemVOTVdrive.setCoordinates(stack, x, z);
        ItemVOTVdrive.setProcessed(stack, true);
        if (!world.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + "Set landing coordinates to: " + x + ", " + z));
        }
        return true;
    }

    public static class Target {
        public CelestialBody body;
        public boolean inOrbit;
        public boolean isValid;

        public Target(CelestialBody body, boolean inOrbit, boolean isValid) {
            this.body = body;
            this.inOrbit = inOrbit;
            this.isValid = isValid;
        }
    }

    public static class Destination {
        public int x;
        public int z;
        public SolarSystem.Body body;

        public Destination(SolarSystem.Body body, int x, int z) {
            this.body = body;
            this.x = x;
            this.z = z;
        }

        public ChunkCoordIntPair getChunk() {
            return new ChunkCoordIntPair(this.x >> 4, this.z >> 4);
        }
    }
}

