/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockNTMSand;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemScraps;
import com.hbm.items.special.ItemBedrockOreNew;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class ArcFurnaceRecipes
extends SerializableRecipe {
    public static List<Tuple.Pair<RecipesCommon.AStack, ArcFurnaceRecipe>> recipeList = new ArrayList<Tuple.Pair<RecipesCommon.AStack, ArcFurnaceRecipe>>();
    public static HashMap<RecipesCommon.ComparableStack, ArcFurnaceRecipe> fastCacheSolid = new HashMap();
    public static HashMap<RecipesCommon.ComparableStack, ArcFurnaceRecipe> fastCacheLiquid = new HashMap();
    public static HashSet<RecipesCommon.ComparableStack> occupiedSolid = new HashSet();
    public static HashSet<RecipesCommon.ComparableStack> occupiedLiquid = new HashSet();

    @Override
    public void registerDefaults() {
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack("sand"), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.NUGGET.q(1))));
        ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(Items.field_151145_ak), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 4)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.INGOT.q(1, 2))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.QUARTZ.gem()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 3)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.NUGGET.q(3))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.QUARTZ.dust()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 3)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.NUGGET.q(3))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.QUARTZ.block()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 12)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.NUGGET.q(12))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.FIBER.ingot()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 4)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.INGOT.q(1, 2))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.FIBER.block()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 40)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.INGOT.q(9, 2))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 4)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.INGOT.q(1, 2))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.dust()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 4)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.INGOT.q(1, 2))));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.block()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.nugget_silicon, 40)).fluid(new Mats.MaterialStack(Mats.MAT_SILICON, MaterialShapes.INGOT.q(9, 2))));
        ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ModBlocks.sand_mix, 1, (Enum)BlockNTMSand.EnumSandType.QUARTZ), new ArcFurnaceRecipe().solid(new ItemStack(ModBlocks.glass_quartz)));
        ArcFurnaceRecipes.register(new RecipesCommon.OreDictStack(OreDictManager.BORAX.dust()), new ArcFurnaceRecipe().solid(new ItemStack(ModItems.powder_boron_tiny, 3)).fluid(new Mats.MaterialStack(Mats.MAT_BORON, MaterialShapes.NUGGET.q(3))));
        for (ItemBedrockOreNew.CelestialBedrockOreType celestialBedrockOreType : ItemBedrockOreNew.CelestialBedrockOre.getAllTypes()) {
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_BYPRODUCT, celestialBedrockOreType)), new ArcFurnaceRecipe().solid(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_ARC, celestialBedrockOreType, 2)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_ROASTED, celestialBedrockOreType)), new ArcFurnaceRecipe().solid(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_ARC, celestialBedrockOreType, 4)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_BYPRODUCT, celestialBedrockOreType)), new ArcFurnaceRecipe().solid(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_ARC, celestialBedrockOreType, 2)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_ROASTED, celestialBedrockOreType)), new ArcFurnaceRecipe().solid(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_ARC, celestialBedrockOreType, 4)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_BYPRODUCT, celestialBedrockOreType)), new ArcFurnaceRecipe().solid(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_ARC, celestialBedrockOreType, 2)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_ROASTED, celestialBedrockOreType)), new ArcFurnaceRecipe().solid(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_ARC, celestialBedrockOreType, 4)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, celestialBedrockOreType)), new ArcFurnaceRecipe().fluidNull(ItemBedrockOreNew.toFluid(celestialBedrockOreType.primary, 5.0)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, celestialBedrockOreType)), new ArcFurnaceRecipe().fluidNull(ItemBedrockOreNew.toFluid(celestialBedrockOreType.primary, 1.0)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_WASHED, celestialBedrockOreType)), new ArcFurnaceRecipe().fluidNull(ItemBedrockOreNew.toFluid(celestialBedrockOreType.byproductAcid, 3.0)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_WASHED, celestialBedrockOreType)), new ArcFurnaceRecipe().fluidNull(ItemBedrockOreNew.toFluid(celestialBedrockOreType.byproductSolvent, 3.0)));
            ArcFurnaceRecipes.register(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_WASHED, celestialBedrockOreType)), new ArcFurnaceRecipe().fluidNull(ItemBedrockOreNew.toFluid(celestialBedrockOreType.byproductRad, 3.0)));
        }
        for (NTMMaterial nTMMaterial : Mats.orderedList) {
            int in = nTMMaterial.convIn;
            int out = nTMMaterial.convOut;
            NTMMaterial convert = nTMMaterial.smeltsInto;
            if (convert.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) continue;
            for (MaterialShapes shape : MaterialShapes.allShapes) {
                String name;
                if (shape.noAutogen || OreDictionary.getOres((String)(name = shape.name() + nTMMaterial.names[0])).isEmpty()) continue;
                RecipesCommon.OreDictStack dict = new RecipesCommon.OreDictStack(name);
                ArcFurnaceRecipe recipe = new ArcFurnaceRecipe();
                recipe.fluid(new Mats.MaterialStack(convert, shape.q(1) * out / in));
                ArcFurnaceRecipes.register(dict, recipe);
            }
        }
        for (Map.Entry entry : Mats.materialOreEntries.entrySet()) {
            RecipesCommon.OreDictStack dict = new RecipesCommon.OreDictStack((String)entry.getKey());
            ArcFurnaceRecipes.addCustomSmeltable(dict, (List)entry.getValue());
        }
        for (Map.Entry entry : Mats.materialEntries.entrySet()) {
            ArcFurnaceRecipes.addCustomSmeltable((RecipesCommon.AStack)entry.getKey(), (List)entry.getValue());
        }
        ArcFurnaceRecipes.registerFurnaceSmeltables();
    }

    public static void registerFurnaceSmeltables() {
        Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
        while (iterator.hasNext()) {
            RecipesCommon.ComparableStack comp;
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            ItemStack input = (ItemStack)entry.getKey();
            ItemStack output = (ItemStack)entry.getValue();
            if (input == null || output == null || !OreDictManager.arcSmeltable.contains(comp = new RecipesCommon.ComparableStack(input)) && !OreDictManager.arcSmeltable.contains(new RecipesCommon.ComparableStack(output))) continue;
            ArcFurnaceRecipe recipe = new ArcFurnaceRecipe();
            recipe.solid(output.func_77946_l());
            ArcFurnaceRecipes.register(comp, recipe);
        }
    }

    public static void register(RecipesCommon.AStack input, ArcFurnaceRecipe output) {
        RecipesCommon.ComparableStack compStack;
        List<ItemStack> inputs = input.extractForNEI();
        for (ItemStack stack : inputs) {
            compStack = new RecipesCommon.ComparableStack(stack);
            if (compStack.meta == Short.MAX_VALUE) {
                compStack.meta = 0;
            }
            if (output.solidOutput != null && occupiedSolid.contains(compStack)) {
                return;
            }
            if (output.fluidOutput == null || !occupiedLiquid.contains(compStack)) continue;
            return;
        }
        recipeList.add(new Tuple.Pair<RecipesCommon.AStack, ArcFurnaceRecipe>(input, output));
        for (ItemStack stack : inputs) {
            compStack = new RecipesCommon.ComparableStack(stack);
            if (compStack.meta == Short.MAX_VALUE) {
                compStack.meta = 0;
            }
            if (output.solidOutput != null) {
                occupiedSolid.add(compStack);
            }
            if (output.fluidOutput == null) continue;
            occupiedLiquid.add(compStack);
        }
    }

    private static void addCustomSmeltable(RecipesCommon.AStack astack, List<Mats.MaterialStack> mats) {
        ArrayList<Mats.MaterialStack> smeltables = new ArrayList<Mats.MaterialStack>();
        for (Mats.MaterialStack mat : mats) {
            if (mat.material.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) continue;
            smeltables.add(mat);
        }
        if (smeltables.isEmpty()) {
            return;
        }
        ArcFurnaceRecipe recipe = new ArcFurnaceRecipe();
        recipe.fluid(smeltables.toArray(new Mats.MaterialStack[0]));
        ArcFurnaceRecipes.register(astack, recipe);
    }

    public static ArcFurnaceRecipe getOutput(ItemStack stack, boolean liquid) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        if (stack.func_77973_b() == ModItems.scraps && liquid) {
            NTMMaterial mat = Mats.matById.get(stack.func_77960_j());
            if (mat == null) {
                return null;
            }
            Mats.MaterialStack mats = ItemScraps.getMats(stack);
            if (mats.material.smeltable == NTMMaterial.SmeltingBehavior.SMELTABLE) {
                return new ArcFurnaceRecipe().fluid(mats);
            }
        }
        RecipesCommon.ComparableStack cacheKey = new RecipesCommon.ComparableStack(stack).makeSingular();
        if (!liquid && fastCacheSolid.containsKey(cacheKey)) {
            return fastCacheSolid.get(cacheKey);
        }
        if (liquid && fastCacheLiquid.containsKey(cacheKey)) {
            return fastCacheLiquid.get(cacheKey);
        }
        for (Tuple.Pair<RecipesCommon.AStack, ArcFurnaceRecipe> entry : recipeList) {
            if (!entry.getKey().matchesRecipe(stack, true)) continue;
            ArcFurnaceRecipe rec = entry.getValue();
            if ((!liquid || rec.fluidOutput == null) && (liquid || rec.solidOutput == null)) continue;
            if (!liquid) {
                fastCacheSolid.put(cacheKey, rec);
            }
            if (liquid) {
                fastCacheLiquid.put(cacheKey, rec);
            }
            return rec;
        }
        if (!liquid) {
            fastCacheSolid.put(cacheKey, null);
        }
        if (liquid) {
            fastCacheLiquid.put(cacheKey, null);
        }
        return null;
    }

    public static HashMap getSolidRecipes() {
        HashMap<RecipesCommon.AStack, ItemStack> recipes = new HashMap<RecipesCommon.AStack, ItemStack>();
        for (Tuple.Pair<RecipesCommon.AStack, ArcFurnaceRecipe> recipe : recipeList) {
            if (recipe.getValue().solidOutput == null) continue;
            recipes.put(recipe.getKey().copy(), recipe.getValue().solidOutput.func_77946_l());
        }
        return recipes;
    }

    public static HashMap getFluidRecipes() {
        HashMap<RecipesCommon.AStack, Object> recipes = new HashMap<RecipesCommon.AStack, Object>();
        for (Tuple.Pair<RecipesCommon.AStack, ArcFurnaceRecipe> recipe : recipeList) {
            if (recipe.getValue().fluidOutput == null || recipe.getValue().fluidOutput.length <= 0) continue;
            Object[] out = new Object[recipe.getValue().fluidOutput.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = ItemScraps.create(recipe.getValue().fluidOutput[i], true);
            }
            recipes.put(recipe.getKey().copy(), out);
        }
        for (NTMMaterial mat : Mats.orderedList) {
            if (mat.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) continue;
            recipes.put((RecipesCommon.AStack)new ItemStack(ModItems.scraps, 1, mat.id), ItemScraps.create(new Mats.MaterialStack(mat, MaterialShapes.INGOT.q(1)), true));
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmArcFurnace.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipeList;
    }

    @Override
    public void deleteRecipes() {
        occupiedSolid.clear();
        occupiedLiquid.clear();
        recipeList.clear();
        fastCacheSolid.clear();
        fastCacheLiquid.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject rec = (JsonObject)recipe;
        ArcFurnaceRecipe arc = new ArcFurnaceRecipe();
        RecipesCommon.AStack input = ArcFurnaceRecipes.readAStack(rec.get("input").getAsJsonArray());
        if (rec.has("solid")) {
            arc.solid(ArcFurnaceRecipes.readItemStack(rec.get("solid").getAsJsonArray()));
        }
        if (rec.has("fluid")) {
            JsonArray fluids = rec.get("fluid").getAsJsonArray();
            ArrayList<Mats.MaterialStack> mats = new ArrayList<Mats.MaterialStack>();
            for (JsonElement fluid : fluids) {
                JsonArray matStack = fluid.getAsJsonArray();
                Mats.MaterialStack stack = new Mats.MaterialStack(Mats.matByName.get(matStack.get(0).getAsString()), matStack.get(1).getAsInt());
                if (stack.material.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) continue;
                mats.add(stack);
            }
            if (!mats.isEmpty()) {
                arc.fluid(mats.toArray(new Mats.MaterialStack[0]));
            }
        }
        ArcFurnaceRecipes.register(input, arc);
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Tuple.Pair rec = (Tuple.Pair)recipe;
        writer.name("input");
        ArcFurnaceRecipes.writeAStack((RecipesCommon.AStack)rec.getKey(), writer);
        if (((ArcFurnaceRecipe)rec.getValue()).solidOutput != null) {
            writer.name("solid");
            ArcFurnaceRecipes.writeItemStack(((ArcFurnaceRecipe)rec.getValue()).solidOutput, writer);
        }
        if (((ArcFurnaceRecipe)rec.getValue()).fluidOutput != null) {
            writer.name("fluid").beginArray();
            writer.setIndent("");
            for (Mats.MaterialStack stack : ((ArcFurnaceRecipe)rec.getValue()).fluidOutput) {
                writer.beginArray();
                writer.value(stack.material.names[0]).value((long)stack.amount);
                writer.endArray();
            }
            writer.endArray();
            writer.setIndent("  ");
        }
    }

    public static class ArcFurnaceRecipe {
        public Mats.MaterialStack[] fluidOutput;
        public ItemStack solidOutput;

        public ArcFurnaceRecipe fluid(Mats.MaterialStack ... outputs) {
            this.fluidOutput = outputs;
            return this;
        }

        public ArcFurnaceRecipe fluidNull(Mats.MaterialStack ... outputs) {
            ArrayList<Mats.MaterialStack> mat = new ArrayList<Mats.MaterialStack>();
            for (Mats.MaterialStack stack : outputs) {
                if (stack == null) continue;
                mat.add(stack);
            }
            if (!mat.isEmpty()) {
                this.fluidOutput = mat.toArray(new Mats.MaterialStack[0]);
            }
            return this;
        }

        public ArcFurnaceRecipe solid(ItemStack output) {
            this.solidOutput = output;
            return this;
        }
    }
}

