/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerMachineWarController;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.ISatChip;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.packet.toserver.SatActivatePacket;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.saveddata.satellites.SatelliteWar;
import com.hbm.tileentity.machine.TileEntityMachineWarController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIWarController
extends GuiInfoContainer {
    private List<String> commandHistory = new ArrayList<String>();
    private static final int MAX_HISTORY = 6;
    private GuiTextField textField;
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_controlpanel.png");
    private TileEntityMachineWarController sucker;

    public GUIWarController(InventoryPlayer playerInv, TileEntityMachineWarController tile) {
        super(new ContainerMachineWarController(playerInv, tile));
        this.sucker = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 204;
    }

    public void func_73863_a(int x, int y, float interp) {
        super.func_73863_a(x, y, interp);
        this.drawElectricityInfo(this, x, y, this.field_147003_i + 132, this.field_147009_r + 18, 16, 52, this.sucker.getPower(), this.sucker.getMaxPower());
        this.drawCustomInfoStat(x, y, this.field_147003_i + 52, this.field_147009_r + 19, 8, 8, this.field_147003_i + 52, this.field_147009_r + 19, this.getUpgradeInfo(this.sucker));
    }

    protected void func_146979_b(int i, int j) {
        int yOffset = 15;
        for (int x = Math.max(0, this.commandHistory.size() - 6); x < this.commandHistory.size(); ++x) {
            String text = this.commandHistory.get(x);
            float scale = 0.5f;
            GL11.glPushMatrix();
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            this.field_146289_q.func_78276_b(text, (int)(78.0f / scale), (int)((float)yOffset / scale), 65280);
            GL11.glPopMatrix();
            yOffset = (int)((float)yOffset + 12.0f * scale);
        }
        String typedText = this.textField.func_146179_b();
        float textScale = 0.5f;
        GL11.glPushMatrix();
        GL11.glScalef((float)textScale, (float)textScale, (float)textScale);
        this.field_146289_q.func_78276_b("> " + typedText + (this.textField.func_146206_l() && this.field_146297_k.field_71441_e.func_82737_E() % 20L < 10L ? "_" : ""), (int)(78.0f / textScale), (int)(57.0f / textScale), 65280);
        GL11.glPopMatrix();
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.textField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (keyCode == 28) {
            this.processCommand(this.textField.func_146179_b().trim());
            this.textField.func_146180_a("");
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void processCommand(String command) {
        if (command.isEmpty()) {
            return;
        }
        int satId = ISatChip.getFreqS(this.sucker.slots[2]);
        Satellite sat = SatelliteSavedData.getClientSats().get(satId);
        String[] parts = command.split(" ");
        String cmd = parts[0].toLowerCase();
        NBTTagCompound data = new NBTTagCompound();
        switch (cmd) {
            case "setpos": {
                if (parts.length < 3) {
                    this.addCommandHistory("> " + command);
                    this.addCommandHistory("Error, invalid args", EnumChatFormatting.RED);
                    return;
                }
                String xValueStr = parts[1];
                String zValueStr = parts[2];
                if (this.sucker.slots[1] == null) {
                    this.addCommandHistory("> " + command);
                    this.addCommandHistory("No drive.", EnumChatFormatting.RED);
                    return;
                }
                if (!xValueStr.matches("-?\\d+") || !zValueStr.matches("-?\\d+")) {
                    this.addCommandHistory("> " + command);
                    this.addCommandHistory("Invalid number format.", EnumChatFormatting.RED);
                    return;
                }
                int xValue = Integer.parseInt(xValueStr);
                int zValue = Integer.parseInt(zValueStr);
                this.addCommandHistory("> " + command);
                this.addCommandHistory("Set to: X=" + xValue + ", Z=" + zValue);
                data.func_74768_a("xcoord", xValue);
                data.func_74768_a("zcoord", zValue);
                PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.sucker.field_145851_c, this.sucker.field_145848_d, this.sucker.field_145849_e));
                break;
            }
            case "health": {
                this.addCommandHistory("> " + command);
                this.addCommandHistory("Requesting " + cmd + "...");
                if (sat == null) {
                    this.addCommandHistory("Satellite not in orbit!", EnumChatFormatting.RED);
                    break;
                }
                if (!(sat instanceof SatelliteWar)) break;
                this.addCommandHistory("health: " + sat.getInterp());
                break;
            }
            case "fire": {
                if (sat == null) {
                    this.addCommandHistory("Satellite not in orbit!", EnumChatFormatting.RED);
                    break;
                }
                if (sat instanceof SatelliteWar) {
                    this.addCommandHistory("Firing!");
                    PacketDispatcher.wrapper.sendToServer(new SatActivatePacket(satId));
                    break;
                }
                this.addCommandHistory("Wrong satellite" + EnumChatFormatting.RED);
                break;
            }
            case "getsat": {
                this.addCommandHistory("> " + command);
                if (this.sucker.slots[2] == null) {
                    this.addCommandHistory("No satellite chip in slot 2.", EnumChatFormatting.RED);
                    break;
                }
                this.addCommandHistory("Requesting Satellite ID: " + satId);
                if (sat == null) {
                    this.addCommandHistory("Satellite not in orbit!", EnumChatFormatting.RED);
                    break;
                }
                this.addCommandHistory("Satellite: " + sat.getClass().getSimpleName());
                break;
            }
            default: {
                this.addCommandHistory("> " + command);
                this.addCommandHistory("Unknown command.", EnumChatFormatting.RED);
            }
        }
    }

    private void addCommandHistory(String text) {
        this.addToHistory(text, null);
    }

    private void addCommandHistory(String text, EnumChatFormatting color) {
        this.addToHistory(text, color);
    }

    private void addToHistory(String text, EnumChatFormatting color) {
        if (color != null) {
            ChatComponentText chatComponent = new ChatComponentText(text);
            chatComponent.func_150255_a(new ChatStyle().func_150238_a(color));
            this.commandHistory.add(chatComponent.func_150254_d());
        } else {
            this.commandHistory.add(text);
        }
        if (this.commandHistory.size() > 12) {
            this.commandHistory = this.commandHistory.subList(this.commandHistory.size() - 12, this.commandHistory.size());
        }
    }

    protected void func_146976_a(float interp, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.textField = new GuiTextField(this.field_146289_q, this.field_147003_i - 74, this.field_147009_r + 28, 100, 20);
        this.textField.func_146203_f(100);
        this.textField.func_146195_b(true);
        this.textField.func_146185_a(false);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

