/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import api.hbm.redstoneoverradio.IRORValueProvider;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.network.TileEntityRadioTorchReader;
import com.hbm.util.Compat;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIScreenRadioTorchReader
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_rtty_reader.png");
    public TileEntityRadioTorchReader rtty;
    protected int xSize = 256;
    protected int ySize = 204;
    protected int guiLeft;
    protected int guiTop;
    protected GuiTextField[] frequencies;
    protected GuiTextField[] names;

    public GUIScreenRadioTorchReader(TileEntityRadioTorchReader rtty) {
        this.rtty = rtty;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        int oX = 4;
        int oY = 4;
        this.frequencies = new GuiTextField[8];
        this.names = new GuiTextField[8];
        for (int i = 0; i < 8; ++i) {
            this.frequencies[i] = new GuiTextField(this.field_146289_q, this.guiLeft + 25 + oX, this.guiTop + 53 + i * 18 + oY, 72 - oX * 2, 14);
            this.frequencies[i].func_146193_g(65280);
            this.frequencies[i].func_146204_h(65280);
            this.frequencies[i].func_146185_a(false);
            this.frequencies[i].func_146203_f(15);
            this.frequencies[i].func_146180_a(this.rtty.channels[i] == null ? "" : this.rtty.channels[i]);
            this.names[i] = new GuiTextField(this.field_146289_q, this.guiLeft + 119 + oX, this.guiTop + 53 + i * 18 + oY, 126 - oX * 2, 14);
            this.names[i].func_146193_g(65280);
            this.names[i].func_146204_h(65280);
            this.names[i].func_146185_a(false);
            this.names[i].func_146203_f(25);
            this.names[i].func_146180_a(this.rtty.names[i] == null ? "" : this.rtty.names[i]);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
    }

    private void drawGuiContainerForegroundLayer(int x, int y) {
        String name = I18nUtil.resolveKey("container.rttyReader", new Object[0]);
        this.field_146289_q.func_78276_b(name, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(name) / 2, this.guiTop + 6, 0x404040);
        if (this.guiLeft + 173 <= x && this.guiLeft + 173 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.func_146283_a(Arrays.asList(this.rtty.polling ? "Polling" : "State Change"), x, y);
        }
        if (this.guiLeft + 209 <= x && this.guiLeft + 209 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.func_146283_a(Arrays.asList("Save Settings"), x, y);
        }
        if (this.guiLeft + 29 <= x && this.guiLeft + 29 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.rtty.func_145832_p()).getOpposite();
            TileEntity tile = Compat.getTileStandard(this.rtty.func_145831_w(), this.rtty.field_145851_c + dir.offsetX, this.rtty.field_145848_d + dir.offsetY, this.rtty.field_145849_e + dir.offsetZ);
            if (tile instanceof IRORValueProvider) {
                IRORValueProvider prov = (IRORValueProvider)tile;
                String[] info = prov.getFunctionInfo();
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("Readable values:");
                for (String s : info) {
                    if (!s.startsWith("VAL:")) continue;
                    lines.add(EnumChatFormatting.LIGHT_PURPLE + s.substring(4));
                }
                this.func_146283_a(lines, x, y);
            }
        }
    }

    private void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.rtty.polling) {
            this.func_73729_b(this.guiLeft + 173, this.guiTop + 17, 0, 204, 18, 18);
        }
        for (GuiTextField field : this.frequencies) {
            field.func_146194_f();
        }
        for (GuiTextField field : this.names) {
            field.func_146194_f();
        }
    }

    protected void func_73864_a(int x, int y, int i) {
        NBTTagCompound data;
        super.func_73864_a(x, y, i);
        for (GuiTextField field : this.frequencies) {
            field.func_146192_a(x, y, i);
        }
        for (GuiTextField field : this.names) {
            field.func_146192_a(x, y, i);
        }
        if (this.guiLeft + 173 <= x && this.guiLeft + 173 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            data = new NBTTagCompound();
            data.func_74757_a("p", !this.rtty.polling);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.rtty.field_145851_c, this.rtty.field_145848_d, this.rtty.field_145849_e));
        }
        if (this.guiLeft + 209 <= x && this.guiLeft + 209 + 18 > x && this.guiTop + 17 < y && this.guiTop + 17 + 18 >= y) {
            int j;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            data = new NBTTagCompound();
            for (j = 0; j < 8; ++j) {
                data.func_74778_a("c" + j, this.frequencies[j].func_146179_b());
            }
            for (j = 0; j < 8; ++j) {
                data.func_74778_a("n" + j, this.names[j].func_146179_b());
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.rtty.field_145851_c, this.rtty.field_145848_d, this.rtty.field_145849_e));
        }
    }

    protected void func_73869_a(char c, int i) {
        for (GuiTextField field : this.frequencies) {
            if (!field.func_146201_a(c, i)) continue;
            return;
        }
        for (GuiTextField field : this.names) {
            if (!field.func_146201_a(c, i)) continue;
            return;
        }
        if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }
}

