/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import com.hbm.util.ParticleUtil;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ExplosionBalefire {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public World worldObj;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;
    private boolean antimatter = false;

    public void saveToNbt(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name + "posX", this.posX);
        nbt.func_74768_a(name + "posY", this.posY);
        nbt.func_74768_a(name + "posZ", this.posZ);
        nbt.func_74768_a(name + "lastposX", this.lastposX);
        nbt.func_74768_a(name + "lastposZ", this.lastposZ);
        nbt.func_74768_a(name + "radius", this.radius);
        nbt.func_74768_a(name + "radius2", this.radius2);
        nbt.func_74768_a(name + "n", this.n);
        nbt.func_74768_a(name + "nlimit", this.nlimit);
        nbt.func_74768_a(name + "shell", this.shell);
        nbt.func_74768_a(name + "leg", this.leg);
        nbt.func_74768_a(name + "element", this.element);
        nbt.func_74757_a(name + "antimatter", this.antimatter);
    }

    public void readFromNbt(NBTTagCompound nbt, String name) {
        this.posX = nbt.func_74762_e(name + "posX");
        this.posY = nbt.func_74762_e(name + "posY");
        this.posZ = nbt.func_74762_e(name + "posZ");
        this.lastposX = nbt.func_74762_e(name + "lastposX");
        this.lastposZ = nbt.func_74762_e(name + "lastposZ");
        this.radius = nbt.func_74762_e(name + "radius");
        this.radius2 = nbt.func_74762_e(name + "radius2");
        this.n = Math.max(nbt.func_74762_e(name + "n"), 1);
        this.nlimit = nbt.func_74762_e(name + "nlimit");
        this.shell = nbt.func_74762_e(name + "shell");
        this.leg = nbt.func_74762_e(name + "leg");
        this.element = nbt.func_74762_e(name + "element");
        this.antimatter = nbt.func_74767_n(name + "antimatter");
    }

    public ExplosionBalefire(int x, int y, int z, World world, int rad, boolean antimatter) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.worldObj = world;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.nlimit = this.radius2 * 4;
        this.antimatter = antimatter;
    }

    public boolean update() {
        if (this.n == 0) {
            return true;
        }
        this.breakColumn(this.lastposX, this.lastposZ);
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        int shell2 = this.shell * 2;
        if (shell2 == 0) {
            return true;
        }
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        int dist = (int)((double)this.radius - Math.sqrt(x * x + z * z));
        if (dist > 0) {
            int pX = this.posX + x;
            int pZ = this.posZ + z;
            int y = this.worldObj.func_72976_f(pX, pZ);
            int maxdepth = (int)(10.0 + (double)this.radius * 0.25);
            int depth = (int)((double)(maxdepth * dist / this.radius) + Math.sin((double)dist * 0.15 + 2.0) * 2.0);
            depth = Math.max(y - depth, 0);
            while (y > depth) {
                if (this.worldObj.func_147439_a(pX, y, pZ) == ModBlocks.block_schrabidium_cluster && !this.antimatter) {
                    if (this.worldObj.field_73012_v.nextInt(10) == 0) {
                        this.worldObj.func_147449_b(pX, y + 1, pZ, ModBlocks.balefire);
                        this.worldObj.func_147465_d(pX, y, pZ, ModBlocks.block_euphemium_cluster, this.worldObj.func_72805_g(pX, y, pZ), 3);
                    }
                    return;
                }
                Material m = this.worldObj.func_147439_a(pX, y, pZ).func_149688_o();
                if ((m == Material.field_151596_z || m == Material.field_151597_y || m == Material.field_151588_w || m == Material.field_151598_x) && this.antimatter) {
                    ParticleUtil.spawnGasFlame(this.worldObj, pX, y, pZ, x, y, z);
                    continue;
                }
                if (this.worldObj.func_147439_a(pX, y, pZ) != ModBlocks.plasma) {
                    this.worldObj.func_147468_f(pX, y, pZ);
                }
                --y;
            }
            if (this.worldObj.field_73012_v.nextInt(10) == 0 && !this.antimatter) {
                this.worldObj.func_147449_b(pX, depth + 1, pZ, ModBlocks.balefire);
                if (this.worldObj.func_147439_a(pX, y, pZ) == ModBlocks.block_schrabidium_cluster && !this.antimatter) {
                    this.worldObj.func_147465_d(pX, y, pZ, ModBlocks.block_euphemium_cluster, this.worldObj.func_72805_g(pX, y, pZ), 3);
                }
            }
            for (int i = depth; i > depth - 5; --i) {
                Random rand = new Random();
                double d = dist / 100;
                double chance = 1.0 - d;
                if (rand.nextInt(dist) == 0 && this.antimatter) {
                    this.worldObj.func_147449_b(pX, depth, pZ, ModBlocks.volcanic_lava_block);
                }
                if (this.worldObj.func_147439_a(pX, i, pZ) != Blocks.field_150348_b) continue;
                this.worldObj.func_147449_b(pX, i, pZ, ModBlocks.sellafield_slaked);
            }
        }
    }
}

