/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.train;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.rail.IRailNTM;
import com.hbm.items.ModItems;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public abstract class EntityRailCarBase
extends Entity
implements ILookOverlay {
    public LogicalTrainUnit ltu;
    public int ltuIndex = 0;
    public boolean isOnRail = true;
    private int turnProgress;
    private double trainX;
    private double trainY;
    private double trainZ;
    private double trainYaw;
    private double trainPitch;
    private float movementYaw;
    private float movementPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    public double lastRenderX;
    public double lastRenderY;
    public double lastRenderZ;
    public double renderX;
    public double renderY;
    public double renderZ;
    public double cachedSpeed;
    public EntityRailCarBase coupledFront;
    public EntityRailCarBase coupledBack;
    public boolean initDummies = false;
    public BoundingBoxDummyEntity[] dummies = new BoundingBoxDummyEntity[0];

    public EntityRailCarBase(World world) {
        super(world);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.coupling_tool) {
            List intersecting = this.field_70170_p.func_72872_a(EntityRailCarBase.class, this.field_70121_D.func_72314_b(2.0, 0.0, 2.0));
            for (EntityRailCarBase neighbor : intersecting) {
                if (neighbor == this || neighbor.getGauge() != this.getGauge()) continue;
                Enum closestOwnCoupling = null;
                Enum closestNeighborCoupling = null;
                double closestDist = Double.POSITIVE_INFINITY;
                for (TrainCoupling ownCoupling : TrainCoupling.values()) {
                    for (TrainCoupling neighborCoupling : TrainCoupling.values()) {
                        Vec3 delta;
                        double length;
                        Vec3 ownPos = this.getCouplingPos(ownCoupling);
                        Vec3 neighborPos = neighbor.getCouplingPos(neighborCoupling);
                        if (ownPos == null || neighborPos == null || !((length = (delta = Vec3.func_72443_a((double)(ownPos.field_72450_a - neighborPos.field_72450_a), (double)(ownPos.field_72448_b - neighborPos.field_72448_b), (double)(ownPos.field_72449_c - neighborPos.field_72449_c))).func_72433_c()) < 1.0) || !(length < closestDist)) continue;
                        closestDist = length;
                        closestOwnCoupling = ownCoupling;
                        closestNeighborCoupling = neighborCoupling;
                    }
                }
                if (closestOwnCoupling == null || closestNeighborCoupling == null || this.getCoupledTo((TrainCoupling)closestOwnCoupling) != null || neighbor.getCoupledTo((TrainCoupling)closestNeighborCoupling) != null) continue;
                this.couple((TrainCoupling)closestOwnCoupling, neighbor);
                neighbor.couple((TrainCoupling)closestNeighborCoupling, this);
                if (this.ltu != null) {
                    this.ltu.dissolveTrain();
                }
                if (neighbor.ltu != null) {
                    neighbor.ltu.dissolveTrain();
                }
                player.func_71038_i();
                player.func_146105_b((IChatComponent)new ChatComponentText("Coupled " + this.hashCode() + " (" + closestOwnCoupling.name() + ") to " + neighbor.hashCode() + " (" + closestNeighborCoupling.name() + ")"));
                return true;
            }
        }
        if (this.ltu != null) {
            String id = Integer.toHexString(this.ltu.hashCode());
            for (EntityRailCarBase train : this.ltu.trains) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "debug");
                data.func_74768_a("color", 255);
                data.func_74776_a("scale", 1.5f);
                data.func_74778_a("text", id + " (#" + train.ltuIndex + ")");
            }
        }
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (this.turnProgress > 0) {
                this.field_70126_B = this.field_70177_z;
                double x = this.field_70165_t + (this.trainX - this.field_70165_t) / (double)this.turnProgress;
                double y = this.field_70163_u + (this.trainY - this.field_70163_u) / (double)this.turnProgress;
                double z = this.field_70161_v + (this.trainZ - this.field_70161_v) / (double)this.turnProgress;
                double yaw = MathHelper.func_76138_g((double)(this.trainYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + yaw / (double)this.turnProgress);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.trainPitch - (double)this.field_70125_A) / (double)this.turnProgress);
                --this.turnProgress;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            BlockPos anchor = this.getCurrentAnchorPos();
            Vec3 frontPos = this.getRelPosAlongRail(anchor, this.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.FRONT, this.getCollisionSpan() - this.getLengthSpan()));
            Vec3 backPos = this.getRelPosAlongRail(anchor, -this.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.BACK, this.getCollisionSpan() - this.getLengthSpan()));
            this.lastRenderX = this.renderX;
            this.lastRenderY = this.renderY;
            this.lastRenderZ = this.renderZ;
            if (frontPos != null && backPos != null) {
                this.renderX = (frontPos.field_72450_a + backPos.field_72450_a) / 2.0;
                this.renderY = (frontPos.field_72448_b + backPos.field_72448_b) / 2.0;
                this.renderZ = (frontPos.field_72449_c + backPos.field_72449_c) / 2.0;
            } else {
                this.renderX = this.field_70165_t;
                this.renderY = this.field_70163_u;
                this.renderZ = this.field_70161_v;
            }
        } else {
            double z;
            double y;
            double x;
            Vec3 rot;
            BoundingBoxDummyEntity dummy;
            DummyConfig def;
            int i;
            if (!this.isOnRail) {
                if (this.coupledFront != null) {
                    this.coupledFront.couple(this.coupledFront.getCouplingFrom(this), null);
                }
                if (this.coupledBack != null) {
                    this.coupledBack.couple(this.coupledBack.getCouplingFrom(this), null);
                }
                this.coupledFront = null;
                this.coupledBack = null;
            }
            if (this.coupledFront != null && this.coupledFront.field_70128_L) {
                this.coupledFront = null;
                if (this.ltu != null) {
                    this.ltu.dissolveTrain();
                }
            }
            if (this.coupledBack != null && this.coupledBack.field_70128_L) {
                this.coupledBack = null;
                if (this.ltu != null) {
                    this.ltu.dissolveTrain();
                }
            }
            if (this.ltu == null && (this.coupledFront == null || this.coupledBack == null) && this.isOnRail) {
                LogicalTrainUnit.generateTrain(this);
            }
            if (!this.isOnRail) {
                Vec3 motion = Vec3.func_72443_a((double)0.0, (double)0.0, (double)this.cachedSpeed);
                motion.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
                this.func_70091_d(motion.field_72450_a, motion.field_72448_b - 0.04, motion.field_72449_c);
                this.renderX = this.field_70165_t;
                this.renderY = this.field_70163_u;
                this.renderZ = this.field_70161_v;
                this.cachedSpeed *= 0.95;
            }
            DummyConfig[] definitions = this.getDummies();
            if (!this.initDummies) {
                this.dummies = new BoundingBoxDummyEntity[definitions.length];
                for (i = 0; i < definitions.length; ++i) {
                    def = definitions[i];
                    dummy = new BoundingBoxDummyEntity(this.field_70170_p, this, def.width, def.height);
                    rot = Vec3.func_72443_a((double)def.offset.field_72450_a, (double)def.offset.field_72448_b, (double)def.offset.field_72449_c);
                    rot.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
                    x = this.field_70165_t + rot.field_72450_a;
                    y = this.field_70163_u + rot.field_72448_b;
                    z = this.field_70161_v + rot.field_72449_c;
                    dummy.func_70107_b(x, y, z);
                    dummy.func_70105_a(def.width, def.height);
                    this.field_70170_p.func_72838_d((Entity)dummy);
                    this.dummies[i] = dummy;
                }
                this.initDummies = true;
            }
            if (this.renderY != 0.0) {
                for (i = 0; i < definitions.length; ++i) {
                    def = definitions[i];
                    dummy = this.dummies[i];
                    rot = Vec3.func_72443_a((double)def.offset.field_72450_a, (double)def.offset.field_72448_b, (double)def.offset.field_72449_c);
                    rot.func_72440_a((float)((double)this.field_70125_A * Math.PI / 180.0));
                    rot.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
                    x = this.renderX + rot.field_72450_a;
                    y = this.renderY + rot.field_72448_b;
                    z = this.renderZ + rot.field_72449_c;
                    dummy.func_70107_b(x, y, z);
                }
            }
        }
    }

    public Vec3 getRelPosAlongRail(BlockPos anchor, double distanceToCover, IRailNTM.MoveContext context) {
        return EntityRailCarBase.getRelPosAlongRail(anchor, distanceToCover, this.getGauge(), this.field_70170_p, Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), this.field_70177_z, context);
    }

    public static Vec3 getRelPosAlongRail(BlockPos anchor, double distanceToCover, IRailNTM.TrackGauge gauge, World worldObj, Vec3 next, float yaw, IRailNTM.MoveContext context) {
        if (distanceToCover < 0.0) {
            distanceToCover *= -1.0;
            yaw += 180.0f;
        }
        int it = 0;
        do {
            boolean flip;
            IRailNTM rail;
            if (++it > 30) {
                return null;
            }
            int x = anchor.getX();
            int y = anchor.getY();
            int z = anchor.getZ();
            Block block = worldObj.func_147439_a(x, y, z);
            Vec3 rot = Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
            rot.func_72442_b((float)((double)(-yaw) * Math.PI / 180.0));
            if (block instanceof IRailNTM) {
                rail = (IRailNTM)block;
                if (it == 1) {
                    next = rail.getTravelLocation(worldObj, x, y, z, next.field_72450_a, next.field_72448_b, next.field_72449_c, rot.field_72450_a, rot.field_72448_b, rot.field_72449_c, 0.0, new IRailNTM.RailContext(), context);
                }
                boolean bl = flip = distanceToCover < 0.0;
                if (rail.getGauge(worldObj, x, y, z) != gauge) {
                    return null;
                }
            } else {
                return null;
            }
            IRailNTM.RailContext info = new IRailNTM.RailContext();
            Vec3 prev = next;
            next = rail.getTravelLocation(worldObj, x, y, z, prev.field_72450_a, prev.field_72448_b, prev.field_72449_c, rot.field_72450_a, rot.field_72448_b, rot.field_72449_c, distanceToCover, info, context);
            distanceToCover = info.overshoot;
            anchor = info.pos;
            yaw = EntityRailCarBase.generateYaw(next, prev) * (float)(flip ? -1 : 1);
        } while (distanceToCover != 0.0);
        return next;
    }

    public static float generateYaw(Vec3 front, Vec3 back) {
        double deltaX = front.field_72450_a - back.field_72450_a;
        double deltaZ = front.field_72449_c - back.field_72449_c;
        double radians = -Math.atan2(deltaX, deltaZ);
        return (float)MathHelper.func_76138_g((double)(radians * 180.0 / Math.PI));
    }

    public static void updateMotion(World world) {
        HashSet<LogicalTrainUnit> ltus = new HashSet<LogicalTrainUnit>();
        for (Object o : world.field_72996_f) {
            if (!(o instanceof EntityRailCarBase)) continue;
            EntityRailCarBase train = (EntityRailCarBase)o;
            if (train.ltu == null) continue;
            ltus.add(train.ltu);
        }
        for (LogicalTrainUnit ltu : ltus) {
            double speed = ltu.getTotalSpeed() + ltu.pushForce;
            if (Math.abs(speed) < 0.001) {
                speed = 0.0;
            }
            for (EntityRailCarBase car : ltu.trains) {
                car.cachedSpeed = speed;
            }
            if (ltu.trains.length == 1) {
                EntityRailCarBase train = ltu.trains[0];
                BlockPos anchor = new BlockPos(train.field_70165_t, train.field_70163_u, train.field_70161_v);
                Vec3 newPos = train.getRelPosAlongRail(anchor, speed, new IRailNTM.MoveContext(IRailNTM.RailCheckType.CORE, 0.0));
                if (newPos == null) {
                    train.derail();
                    ltu.dissolveTrain();
                    continue;
                }
                train.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
                anchor = train.getCurrentAnchorPos();
                Vec3 frontPos = train.getRelPosAlongRail(anchor, train.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.FRONT, train.getCollisionSpan() - train.getLengthSpan()));
                Vec3 backPos = train.getRelPosAlongRail(anchor, -train.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.BACK, train.getCollisionSpan() - train.getLengthSpan()));
                if (frontPos == null || backPos == null) {
                    train.derail();
                    ltu.dissolveTrain();
                    continue;
                }
                ltu.setRenderPos(train, frontPos, backPos);
                ltu.pushForce = 0.0;
                ltu.collideTrain(speed);
                continue;
            }
            if (speed == 0.0) {
                ltu.combineWagons();
            } else {
                ltu.moveTrainByApproach(speed);
            }
            ltu.pushForce = 0.0;
            ltu.collideTrain(speed);
        }
    }

    public abstract double getCurrentSpeed();

    public abstract double getMaxRailSpeed();

    public abstract IRailNTM.TrackGauge getGauge();

    public abstract double getLengthSpan();

    public abstract double getCollisionSpan();

    public BlockPos getCurrentAnchorPos() {
        return new BlockPos(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v);
    }

    public void derail() {
        this.isOnRail = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double posX, double posY, double posZ, float yaw, float pitch, int turnProg) {
        this.trainX = posX;
        this.trainY = posY;
        this.trainZ = posZ;
        this.trainPitch = pitch;
        this.turnProgress = turnProg + 2;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
        this.trainYaw = this.movementYaw;
        this.trainPitch = this.movementPitch;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double mX, double mY, double mZ) {
        this.movementYaw = (float)this.field_70159_w * 360.0f;
        this.movementPitch = (float)this.field_70181_x * 360.0f;
        this.velocityX = this.field_70159_w = mX;
        this.velocityY = this.field_70181_x = mY;
        this.velocityZ = this.field_70179_y = mZ;
    }

    public DummyConfig[] getDummies() {
        return new DummyConfig[0];
    }

    public double getCouplingDist(TrainCoupling coupling) {
        return 0.0;
    }

    public Vec3 getCouplingPos(TrainCoupling coupling) {
        double dist = this.getCouplingDist(coupling);
        if (dist <= 0.0) {
            return null;
        }
        if (coupling == TrainCoupling.BACK) {
            dist *= -1.0;
        }
        Vec3 rot = Vec3.func_72443_a((double)0.0, (double)0.0, (double)dist);
        rot.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
        rot.field_72450_a += this.renderX;
        rot.field_72448_b += this.renderY;
        rot.field_72449_c += this.renderZ;
        return rot;
    }

    public EntityRailCarBase getCoupledTo(TrainCoupling coupling) {
        return coupling == TrainCoupling.FRONT ? this.coupledFront : (coupling == TrainCoupling.BACK ? this.coupledBack : null);
    }

    public TrainCoupling getCouplingFrom(EntityRailCarBase coupledTo) {
        return coupledTo == this.coupledFront ? TrainCoupling.FRONT : (coupledTo == this.coupledBack ? TrainCoupling.BACK : null);
    }

    public void couple(TrainCoupling coupling, EntityRailCarBase to) {
        if (coupling == TrainCoupling.FRONT) {
            this.coupledFront = to;
        }
        if (coupling == TrainCoupling.BACK) {
            this.coupledBack = to;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
    }

    public static class LogicalTrainUnit {
        protected double pushForce;
        protected EntityRailCarBase[] trains;

        public static LogicalTrainUnit generateTrain(EntityRailCarBase train) {
            ArrayList<EntityRailCarBase> links = new ArrayList<EntityRailCarBase>();
            HashSet<EntityRailCarBase> brake = new HashSet<EntityRailCarBase>();
            LogicalTrainUnit ltu = new LogicalTrainUnit();
            if (train.coupledFront == null && train.coupledBack == null) {
                ltu.trains = new EntityRailCarBase[]{train};
                train.ltu = ltu;
                train.ltuIndex = 0;
                return ltu;
            }
            EntityRailCarBase current = train;
            EntityRailCarBase next = null;
            do {
                next = null;
                if (current.coupledFront != null && !brake.contains(current.coupledFront)) {
                    next = current.coupledFront;
                }
                if (current.coupledBack != null && !brake.contains(current.coupledBack)) {
                    next = current.coupledBack;
                }
                links.add(current);
                brake.add(current);
                current = next;
            } while (next != null);
            ltu.trains = new EntityRailCarBase[links.size()];
            for (int i = 0; i < ltu.trains.length; ++i) {
                ltu.trains[i] = (EntityRailCarBase)links.get(i);
                ltu.trains[i].ltu = ltu;
                ltu.trains[i].ltuIndex = i;
            }
            return ltu;
        }

        public void dissolveTrain() {
            for (EntityRailCarBase train : this.trains) {
                train.ltu = null;
                train.ltuIndex = 0;
            }
        }

        public void combineWagons() {
            EntityRailCarBase next;
            int i;
            EntityRailCarBase center;
            if (this.trains.length <= 1) {
                return;
            }
            boolean odd = this.trains.length % 2 == 1;
            int centerIndex = odd ? this.trains.length / 2 : this.trains.length / 2 - 1;
            EntityRailCarBase prev = center = this.trains[centerIndex];
            for (i = centerIndex - 1; i >= 0; --i) {
                next = this.trains[i];
                this.moveWagonTo(prev, next);
                prev = next;
            }
            prev = center;
            for (i = centerIndex + 1; i < this.trains.length; ++i) {
                next = this.trains[i];
                this.moveWagonTo(prev, next);
                prev = next;
            }
        }

        public void moveWagonTo(EntityRailCarBase moveTo, EntityRailCarBase moving) {
            TrainCoupling prevCouple = moveTo.getCouplingFrom(moving);
            TrainCoupling nextCouple = moving.getCouplingFrom(moveTo);
            Vec3 prevLoc = moveTo.getCouplingPos(prevCouple);
            Vec3 nextLoc = moving.getCouplingPos(nextCouple);
            Vec3 delta = Vec3.func_72443_a((double)(prevLoc.field_72450_a - nextLoc.field_72450_a), (double)0.0, (double)(prevLoc.field_72449_c - nextLoc.field_72449_c));
            double len = delta.func_72433_c();
            len /= 0.5 / (len * len) + 1.0;
            BlockPos anchor = new BlockPos(moving.field_70165_t, moving.field_70163_u, moving.field_70161_v);
            Vec3 trainPos = Vec3.func_72443_a((double)moving.field_70165_t, (double)moving.field_70163_u, (double)moving.field_70161_v);
            float yaw = EntityRailCarBase.generateYaw(prevLoc, nextLoc);
            Vec3 newPos = EntityRailCarBase.getRelPosAlongRail(anchor, len, moving.getGauge(), moving.field_70170_p, trainPos, yaw, new IRailNTM.MoveContext(IRailNTM.RailCheckType.CORE, 0.0));
            moving.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
            anchor = moving.getCurrentAnchorPos();
            Vec3 frontPos = moving.getRelPosAlongRail(anchor, moving.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.FRONT, moving.getCollisionSpan() - moving.getLengthSpan()));
            Vec3 backPos = moving.getRelPosAlongRail(anchor, -moving.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.BACK, moving.getCollisionSpan() - moving.getLengthSpan()));
            if (frontPos == null || backPos == null) {
                moving.derail();
                this.dissolveTrain();
                return;
            }
            this.setRenderPos(moving, frontPos, backPos);
        }

        @Deprecated
        public void moveTrain() {
            EntityRailCarBase prev = this.trains[0];
            TrainCoupling dir = prev.getCouplingFrom(null);
            double totalSpeed = 0.0;
            double maxSpeed = Double.POSITIVE_INFINITY;
            for (EntityRailCarBase train : this.trains) {
                boolean con = train.getCouplingFrom(prev) == dir;
                double speed = train.getCurrentSpeed();
                if (!con) {
                    speed *= -1.0;
                }
                totalSpeed += speed;
                maxSpeed = Math.min(maxSpeed, train.getMaxRailSpeed());
                prev = train;
            }
            if (Math.abs(totalSpeed) > maxSpeed) {
                totalSpeed = maxSpeed * Math.signum(totalSpeed);
            }
            this.moveTrainBy(totalSpeed);
        }

        @Deprecated
        public void moveTrainBy(double totalSpeed) {
            for (EntityRailCarBase train : this.trains) {
                BlockPos anchor = train.getCurrentAnchorPos();
                Vec3 corePos = train.getRelPosAlongRail(anchor, totalSpeed, new IRailNTM.MoveContext(IRailNTM.RailCheckType.CORE, 0.0));
                if (corePos == null) {
                    train.derail();
                    this.dissolveTrain();
                    return;
                }
                train.func_70107_b(corePos.field_72450_a, corePos.field_72448_b, corePos.field_72449_c);
                anchor = train.getCurrentAnchorPos();
                Vec3 frontPos = train.getRelPosAlongRail(anchor, train.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.FRONT, 0.0));
                Vec3 backPos = train.getRelPosAlongRail(anchor, -train.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.BACK, 0.0));
                if (frontPos == null || backPos == null) {
                    train.derail();
                    this.dissolveTrain();
                    return;
                }
                train.renderX = (frontPos.field_72450_a + backPos.field_72450_a) / 2.0;
                train.renderY = (frontPos.field_72448_b + backPos.field_72448_b) / 2.0;
                train.renderZ = (frontPos.field_72449_c + backPos.field_72449_c) / 2.0;
                train.field_70126_B = train.field_70177_z;
                train.field_70177_z = train.movementYaw = EntityRailCarBase.generateYaw(frontPos, backPos);
                train.field_70159_w = (double)train.field_70177_z / 360.0;
                train.field_70133_I = true;
            }
        }

        public double getTotalSpeed() {
            boolean reverseTheReverse;
            EntityRailCarBase prev = this.trains[0];
            double totalSpeed = 0.0;
            double maxSpeed = Double.POSITIVE_INFINITY;
            boolean bl = reverseTheReverse = prev.getCouplingFrom(null) == TrainCoupling.BACK;
            if (this.trains.length == 1) {
                return prev.getCurrentSpeed();
            }
            for (EntityRailCarBase train : this.trains) {
                boolean reverse = false;
                EntityRailCarBase conFront = train.getCoupledTo(TrainCoupling.FRONT);
                EntityRailCarBase conBack = train.getCoupledTo(TrainCoupling.BACK);
                if (conFront != null && conFront.ltuIndex > train.ltuIndex) {
                    reverse = true;
                }
                if (conBack != null && conBack.ltuIndex < train.ltuIndex) {
                    reverse = true;
                }
                double speed = train.getCurrentSpeed();
                if (reverse ^= reverseTheReverse) {
                    speed *= -1.0;
                }
                totalSpeed += speed;
                maxSpeed = Math.min(maxSpeed, train.getMaxRailSpeed());
                prev = train;
            }
            if (Math.abs(totalSpeed) > maxSpeed) {
                totalSpeed = maxSpeed * Math.signum(totalSpeed);
            }
            return totalSpeed;
        }

        public void moveTrainByApproach(double speed) {
            int i;
            EntityRailCarBase previous = null;
            EntityRailCarBase first = this.trains[0];
            boolean forward = speed > 0.0;
            boolean order = forward ^ first.getCouplingFrom(null) == TrainCoupling.BACK;
            int n = i = order ? 0 : this.trains.length - 1;
            while (order ? i < this.trains.length : i >= 0) {
                EntityRailCarBase current = this.trains[i];
                if (previous == null) {
                    if (first == current) {
                        speed *= -1.0;
                    }
                    boolean inReverse = first.getCouplingFrom(null) == current.getCouplingFrom(null);
                    int sigNum = inReverse ? 1 : -1;
                    BlockPos anchor = current.getCurrentAnchorPos();
                    Vec3 frontPos = current.getRelPosAlongRail(anchor, (speed + current.getLengthSpan()) * (double)(-sigNum), new IRailNTM.MoveContext(IRailNTM.RailCheckType.FRONT, current.getCollisionSpan() - current.getLengthSpan()));
                    if (frontPos == null) {
                        current.derail();
                        this.dissolveTrain();
                        return;
                    }
                    anchor = current.getCurrentAnchorPos();
                    Vec3 corePos = current.getRelPosAlongRail(anchor, speed * (double)(-sigNum), new IRailNTM.MoveContext(IRailNTM.RailCheckType.CORE, 0.0));
                    current.func_70107_b(corePos.field_72450_a, corePos.field_72448_b, corePos.field_72449_c);
                    Vec3 backPos = current.getRelPosAlongRail(anchor, (speed - current.getLengthSpan()) * (double)(-sigNum), new IRailNTM.MoveContext(IRailNTM.RailCheckType.BACK, current.getCollisionSpan() - current.getLengthSpan()));
                    if (frontPos == null || backPos == null) {
                        current.derail();
                        this.dissolveTrain();
                        return;
                    }
                    this.setRenderPos(current, inReverse ? backPos : frontPos, inReverse ? frontPos : backPos);
                } else {
                    this.moveWagonTo(previous, current);
                }
                previous = current;
                i += order ? 1 : -1;
            }
        }

        public void setRenderPos(EntityRailCarBase current, Vec3 frontPos, Vec3 backPos) {
            current.renderX = (frontPos.field_72450_a + backPos.field_72450_a) / 2.0;
            current.renderY = (frontPos.field_72448_b + backPos.field_72448_b) / 2.0;
            current.renderZ = (frontPos.field_72449_c + backPos.field_72449_c) / 2.0;
            current.field_70126_B = current.field_70177_z;
            current.field_70177_z = current.movementYaw = EntityRailCarBase.generateYaw(frontPos, backPos);
            Vec3 delta = Vec3.func_72443_a((double)(frontPos.field_72450_a - backPos.field_72450_a), (double)(frontPos.field_72448_b - backPos.field_72448_b), (double)(frontPos.field_72449_c - backPos.field_72449_c));
            current.field_70125_A = current.movementPitch = (float)(Math.asin(delta.field_72448_b / delta.func_72433_c()) * 180.0 / Math.PI);
            current.field_70159_w = (double)current.field_70177_z / 360.0;
            current.field_70181_x = (double)current.field_70125_A / 360.0;
            current.field_70133_I = true;
        }

        public void collideTrain(double speed) {
            EntityRailCarBase[][] whatever;
            EntityRailCarBase collidingTrain = speed > 0.0 ? this.trains[0] : this.trains[this.trains.length - 1];
            List intersect = collidingTrain.field_70170_p.func_72872_a(EntityRailCarBase.class, collidingTrain.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
            EntityRailCarBase collidesWith = null;
            for (EntityRailCarBase train : intersect) {
                if (train.ltu == null || train.ltu == this) continue;
                collidesWith = train;
                break;
            }
            if (collidesWith == null) {
                return;
            }
            Vec3 delta = Vec3.func_72443_a((double)(collidingTrain.field_70165_t - collidesWith.field_70165_t), (double)0.0, (double)(collidingTrain.field_70161_v - collidesWith.field_70161_v));
            double totalSpan = collidingTrain.getCollisionSpan() + collidesWith.getCollisionSpan();
            double diff = delta.func_72433_c();
            if (diff > totalSpan) {
                return;
            }
            double push = totalSpan - diff;
            for (EntityRailCarBase[] array : whatever = new EntityRailCarBase[][]{{collidingTrain, collidesWith}, {collidesWith, collidingTrain}}) {
                LogicalTrainUnit ltu = array[0].ltu;
                if (ltu.trains.length == 1) {
                    Vec3 rot = Vec3.func_72443_a((double)0.0, (double)0.0, (double)array[0].getCollisionSpan());
                    rot.func_72440_a((float)((double)array[0].field_70125_A * Math.PI / 180.0));
                    rot.func_72442_b((float)((double)(-array[0].field_70177_z) * Math.PI / 180.0));
                    Vec3 forward = Vec3.func_72443_a((double)(array[1].field_70165_t - (array[0].field_70165_t + rot.field_72450_a)), (double)0.0, (double)(array[1].field_70161_v - (array[0].field_70161_v + rot.field_72449_c)));
                    Vec3 backward = Vec3.func_72443_a((double)(array[1].field_70165_t - (array[0].field_70165_t - rot.field_72450_a)), (double)0.0, (double)(array[1].field_70161_v - (array[0].field_70161_v - rot.field_72449_c)));
                    if (forward.func_72433_c() > backward.func_72433_c()) {
                        ltu.pushForce += push;
                        continue;
                    }
                    ltu.pushForce -= push;
                    continue;
                }
                if (array[0].ltuIndex < ltu.trains.length / 2) {
                    ltu.pushForce -= push;
                    continue;
                }
                ltu.pushForce += push;
            }
        }
    }

    public static enum TrainCoupling {
        FRONT,
        BACK;

    }

    public static class DummyConfig {
        public Vec3 offset;
        public float width;
        public float height;

        public DummyConfig(float width, float height, Vec3 offset) {
            this.width = width;
            this.height = height;
            this.offset = offset;
        }
    }

    public static class BoundingBoxDummyEntity
    extends Entity
    implements ILookOverlay {
        private int turnProgress;
        private double trainX;
        private double trainY;
        private double trainZ;
        public EntityRailCarBase train;

        public BoundingBoxDummyEntity(World world) {
            this(world, null, 1.0f, 1.0f);
        }

        public BoundingBoxDummyEntity(World world, EntityRailCarBase train, float width, float height) {
            super(world);
            this.func_70105_a(width, height);
            this.train = train;
            if (train != null) {
                this.field_70180_af.func_75692_b(3, (Object)train.func_145782_y());
            }
        }

        protected void func_70105_a(float width, float height) {
            super.func_70105_a(width, height);
            this.field_70180_af.func_75692_b(4, (Object)Float.valueOf(width));
            this.field_70180_af.func_75692_b(5, (Object)Float.valueOf(height));
        }

        protected void func_70088_a() {
            this.field_70180_af.func_75682_a(3, (Object)new Integer(0));
            this.field_70180_af.func_75682_a(4, (Object)new Float(1.0f));
            this.field_70180_af.func_75682_a(5, (Object)new Float(1.0f));
        }

        protected void func_70014_b(NBTTagCompound nbt) {
        }

        public boolean func_70039_c(NBTTagCompound nbt) {
            return false;
        }

        public void func_70037_a(NBTTagCompound nbt) {
            this.func_70106_y();
        }

        public boolean func_70104_M() {
            return true;
        }

        public boolean func_70067_L() {
            return !this.field_70128_L;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (this.train != null) {
                return this.train.func_70097_a(source, amount);
            }
            return super.func_70097_a(source, amount);
        }

        public boolean func_130002_c(EntityPlayer player) {
            if (this.train != null) {
                return this.train.func_130002_c(player);
            }
            return super.func_130002_c(player);
        }

        public void func_70071_h_() {
            if (!this.field_70170_p.field_72995_K) {
                if (this.train == null || this.train.field_70128_L) {
                    this.func_70106_y();
                }
            } else {
                if (this.turnProgress > 0) {
                    this.field_70126_B = this.field_70177_z;
                    double x = this.field_70165_t + (this.trainX - this.field_70165_t) / (double)this.turnProgress;
                    double y = this.field_70163_u + (this.trainY - this.field_70163_u) / (double)this.turnProgress;
                    double z = this.field_70161_v + (this.trainZ - this.field_70161_v) / (double)this.turnProgress;
                    --this.turnProgress;
                    this.func_70107_b(x, y, z);
                } else {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                this.func_70105_a(this.field_70180_af.func_111145_d(4), this.field_70180_af.func_111145_d(5));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70056_a(double posX, double posY, double posZ, float yaw, float pitch, int turnProg) {
            this.trainX = posX;
            this.trainY = posY;
            this.trainZ = posZ;
            this.turnProgress = turnProg + 2;
        }

        @Override
        public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
            Entity e = this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(3));
            if (e instanceof EntityRailCarBase) {
                ((EntityRailCarBase)e).printHook(event, world, x, y, z);
            }
        }
    }
}

