
# 万象系列方案 [![Ask DeepWiki](https://deepwiki.com/badge.svg)](https://deepwiki.com/amzxyz/rime_wanxiang)

---------------------

## 🌌 万象拼音——基于深度优化的词库和语法模型

[万象词库](https://github.com/amzxyz/RIME-LMDG) 是一种带声调的词库，经过 AI 辅助与大基数语料筛选、加频，是一个为“语句流”构建的全方案立体词库。

该词库围绕日常、千行百业、文学及涉及众多基础学科的专业词汇，构建了一个以**日常为主体、知识为核心**的实用词库，结合语法模型让用户获得更准确的整句输出体验。

---

## 核心优势

### 💎 核心基石：万象词库

> **“万象词库中的带声调拼音标注 + 词组构成 + 词频是整个万象项目的核心，是使用体验的基石。”**

* **体验之源**：我们深信优质的输入体验源于数据的质量。词库的精准度直接决定了输入的流畅度。
* **开放生态**：方案的其它功能皆可自定义。我们鼓励使用者通过 **“词库 + 转写”** 的方式，基于万象词库灵活构建属于自己的最佳输入体验。
* **持续打磨**：我们高度重视数据的准确性与时效性，特设专属通道收集反馈。
* 📝 **[万象词库问题收集反馈表](https://docs.qq.com/smartsheet/DWHZsdnZZaGh5bWJI?viewId=vUQPXH&tab=BB08J2)**

### 🚀 核心功能亮点

**🧪 全能拼音标注**
* 拥有最全面的拼音标注数据库，所有词语均**自带音调**。
* **独家能力**：支持多种带调方案、声调注释显示，且是唯一支持**整句拼音串上屏**的方案。


**⚖️ 极致权重与分词**
* 长期死磕首选权重与分词片段最优解，大量应用**错位构词法**。
* 结合语法模型，词库维护与模型优化同步进行，实现行云流水的输入痛快感。


**🔍 深度反查系统**
* 数据库全面，现已支持至 **Unicode 17 (U17)** 标准。
* 提供**两分、多分、笔画**三种反查方式，完美解决生僻字输入与反查难题。


**🧩 创新 Lua 扩展**
* **功能丰富**：支持成对符号包裹首选、多类型 Tips 扩展显示、输入后反查、OpenCC替代、超级注释。
* **交互创新**：实现**手动实时排序**以及**无感造词不调频**、**输入统计**的新鲜用法。


**⌨️ 全面辅码兼容**
* **底层架构**：头部使用全拼编码（可转化为任何双拼编码），支持**拼音 + 辅助码**任意两两组合。
* **内置方案**：维护圈内 6 种主流辅码（墨奇码、鹤形、自然码、虎码首末、五笔前2、汉心码）。



### 🌟 项目愿景

* **极致变革**：万象总结下来，从里到外是一场翻天覆地的巨变。
* **持续追求**：项目所涉及之处，无不要求做到**最优、最精**。这是我们持续的追求！

---------------------

### ✨ 效果预览 & 版本对比
![](https://storage.deepin.org/thread/202502200358104987_%E6%95%88%E6%9E%9C.png)
 
万象拼音提供两个主要版本，请根据您的输入习惯选择：

| 版本差异 | 🟢 标准版 (Standard) | 🔵 增强版 (Pro) |
| --- | --- | --- |
| **方案文件** | `wanxiang.schema.yaml` | `wanxiang_pro.schema.yaml` |
| **支持类型** | 全拼、任意双拼 | **仅支持双拼** |
| **自动调频** | 默认开启 | 默认关闭 |
| **用户词记录** | 自动记录，无差别积累 | 手动造词 `` 引导，词库可控，或者无感造词 |
| **用户词位置** | `wanxiang.userdb` | `zc.userdb` |
| **辅助码** | 仅基于声调的辅助 | **7种辅助码可选**，兼声调辅助 |
| **简码策略** | 全拼开启转写简码，双拼未开启 | 自带部分数据但未配置 (推荐自设) |
| **词库格式** | 你 ➩ `nǐ` ➩ 1000 | 你 ➩ `nǐ;re` ➩ 1000 |

---

### 🚀 新手快速入门

如果您不了解 Rime 的基础（如用户目录、部署、皮肤等），建议先阅读以下教程了解基础运行特性，后面只说万象怎么用，默认认为你已有基础：

> 📚 **基础教程**
> * [Oh My Rime - Rime 安装指南](https://www.mintimate.cc/zh/guide/installRime.html)
> * [Rime 参数配置详解](https://xishansnow.github.io/posts/41ac964d.html)
> 
> 

> **💡 友情提示**
> 如果您是第一次使用万象，**请暂时放下过往对 Rime 配置的固有经验**。万象拥有一套独特的自动化配置逻辑，建议严格按照以下步骤先将方案“跑起来”，体验功能后再进行深度定制。

#### 1. 📦 快速部署 (通用步骤)

1. **安装**：将方案文件解压，直接放入 Rime 的 **用户目录** 中。
* *注：您可以手动下载 Release 包，或使用万象工具箱下载,图形化简单高效易于更新 见:[万象工具箱](#5--万象工具箱-pc-端神器)*


2. **部署**：点击“重新部署”按钮，等待完成。
3. **切换方案**：在输入状态下，输入 **`/` (斜杠)** 引导指令切换双拼/全拼方案（如 `/flypy`）。
* 切换后请根据提示**再次重新部署**。



> **⚙️ 切换指令背后的逻辑**
> 该指令会自动修改 4 个补丁文件的输入类型。
> 若根目录无自定义文件，脚本会自动从 `custom` 文件夹复制模版并修改；若根目录已存在自定义文件，则只修改输入方案参数，**绝不会覆盖您的原有配置**。
> 

---

```
/flypy    → 小鹤双拼
/mspy     → 微软双拼
/zrm      → 自然码
/sogou    → 搜狗双拼
/znabc    → 智能ABC
/ziguang  → 紫光双拼
/pyjj     → 拼音加加
/gbpy     → 国标双拼
/lxsq     → 乱序17
/pinyin   → 全拼
/wxsp     → 万象双拼
/zrlong   → 自然龙(反查是全拼)
/hxlong   → 汉心龙(反查是全拼)
/jjf      → 间接辅助
/zjf      → 直接辅助
```
#### 2. 🍎 iOS 平台特殊操作指南

iOS 平台由于沙盒机制限制，需要额外的文件同步操作。

**仓输入法 (Hamster)**
必须手动将键盘文件覆盖到应用文件才能生效：

1. **下载**：仓设置首页 -> 输入方案设置 -> 右上角 `+` -> 方案下载 -> 下载万象方案（如标准版）。
2. **切换**：在体验输入法界面，长按 `/` (不要上划)，输入切换指令（如 `/flypy`），等待提示“已切换至相应方案”。
3. **覆盖 (关键步骤)**：仓设置首页 -> 文件管理 -> **使用键盘文件覆盖应用文件**。
4. **部署**：仓设置首页 -> RIME -> 重新部署。

**元书输入法 (Hamster3)**
需要配置正则以实现自动文件复制：

1. 从 `RimeSharedSupport` 目录中复制 `include_keyboard_rime_files.txt` 文件到万象方案目录下。
2. 编辑该文件，在底部新增以下正则表达式：
```regex
^.*[.]custom.*$

```
---

#### 3. 🧠 语法模型安装 (推荐)

为了获得更精准的整句预测体验，建议安装语法模型。

1. **安装步骤**：下载语法模型文件，直接放置于 Rime **用户文件夹根目录**，**无需任何额外配置**。
2. **Android 用户特别警告**：
> ⚠️ **关于 Fcitx5 (小企鹅) 等前端的权限问题**
> 部分安卓前端（如 Fcitx5）的数据存储在系统 `/data` 目录下，受严格的 Linux 权限控制。
> * **错误做法**：使用 MT 管理器等工具直接复制文件。这会导致文件所有者/权限组不一致，引发读取失败。
> * **故障表现**：输入法部署报错、极其卡顿、提示内存溢出。
> * **正确做法**：
> 1. 使用输入法 App 自带的“导入文件”功能（调用安卓标准存储框架）。
> 2. (Root 用户) 手动复制后，务必修正文件的 `chown` 和 `chmod` 权限。
>

> 💡 **性能与资源说明**
> 语法模型是一个用于大数据遍历的**静态二进制模块**，旨在弥补单纯词库的不足。
> * **资源消耗**：主要利用 CPU 算力进行计算，**内存占用极低**。
> * **非膨胀数据**：它与那些“越用越大”的热加载用户数据完全不同，它的大小是固定的，不会导致系统臃肿，请放心使用。
> 


---

#### 4. 🛠️ 进阶配置：Custom Patch (长期稳定之选)

**强烈推荐长期使用者掌握此方法。**
`custom.yaml` 是对方案文件的最后一道补丁，属于您个人的私有配置，**永远不会被软件升级所覆盖**。

> **⚙️ 运行机制**
> 在“快速运行”步骤中，通过 `/` 指令切换方案时，脚本实际上已经帮您完成了 `custom` 文件的初始化（从 `custom` 文件夹复制模版到根目录）。
> **请务必注意：** 模版里的内容只是示例！请打开文件详细阅读每一行，保留需要的，删除不需要的，理解每一行代码的含义后再保存。

**⚠️ 核心操作原则**

1. **文件位置原则**：
* `custom` 文件必须位于 **用户目录根目录** (与 `wanxiang.schema.yaml` 同级)。
* **切勿**直接修改 `custom/` 文件夹里的文件！那里只是“仓库”，修改那里不会生效。
* 更多方法参照custom目录携带的patch方法论。

2. **补丁对应关系**：
```text
wanxiang.custom.yaml  👉 补丁对象：wanxiang.schema.yaml
default.custom.yaml   👉 补丁对象：全局配置 (通常留给前端控制)
squirrel.custom.yaml  👉 补丁对象：Mac 鼠须管外观
weasel.custom.yaml    👉 补丁对象：Win 小狼毫外观

```
尽量不要在 `default.custom.yaml` 里修改输入方案配置**！任何对方案的修改（如模糊音、快捷键）都必须针对具体的 `schema` 进行 Patch。`default` 文件请留给输入法前端程序去自动管理。

---

#### 5. 🧰 万象工具箱 (PC 端神器)

PC 端用户推荐使用 **Wanxiang Tools (All-in-one)**，内置在线更新器，一站式解决下载、覆盖、部署问题。

* **智能更新**：自动检测 GitHub / CNB 源，自动下载并解压覆盖。
* **白名单保护 (White-list)**：支持受控的文件覆盖。即使下载包里有同名文件，只要您设置了白名单，工具就不会覆盖您的私人文件（需要您配置严密）。
* **双重重置模式**：
1. **构建重置**：清空 `build` 目录，强制重新编译（解决奇怪的缓存 bug）。
2. **纯净重置**：仅保留白名单文件，其余全部替换为官方最新版（彻底解决文件改名、弃用残留问题）。

👉 **[点击下载万象工具箱](https://github.com/amzxyz/RIME-LMDG/releases/tag/tool)**

---

#### 6. 📜 第三方更新脚本

如果您偏好轻量级脚本或非 Windows 环境，可以使用社区贡献的更新工具：

* **Python / PowerShell 脚本**：
👉 [rime-wanxiang-update-tools](https://github.com/rimeinn/rime-wanxiang-update-tools)
* **Go 语言更新器**：
👉 [rime-wanxiang-updater](https://github.com/ca-x/rime-wanxiang-updater)
---

#### 7. 🌿 东风破 (Plum) 管理器

如果您熟悉命令行操作，推荐使用 Plum (东风破) 进行安装和更新。请确保您已安装小狼毫、鼠须管或 Fcitx5 等前端。

**💻 运行环境要求**

| 操作系统 | 环境要求 | 备注 |
| --- | --- | --- |
| **macOS / Linux** | ✅ **无需处理** | 系统已内置 Bash，直接运行即可。 |
| **Windows** | 🛠️ **需要 Git Bash** | 通常随 [Git for Windows](https://git-scm.com/download/win) 自动安装。 |

> 🚫 **Windows 用户注意**：
> Windows 自带的 **PowerShell** 或 **CMD** 无法直接运行东风破脚本，**必须** 使用 Git Bash 终端。

<details>
<summary><strong>🔽 点击展开：万象系列方案安装命令 (完整列表)</strong></summary>


1. 先安装plum，这是维护在万象仓库plum分支的版本，去掉了默认方案，修改了默认路径，直接复制2个命令粘贴终端直接执行，打开终端的目录由你决定  
```base
git clone -b plum --depth 1 https://github.com/amzxyz/rime_wanxiang.git
cd plum
```
2. 配置用户目录变量，检查状态是否正常：  
对于小狼毫、鼠须管、Fcitx5已经默认配置了变量  
```base
export rime_frontend='rime/weasel'
export rime_frontend='rime/squirrel'
export rime_frontend='fcitx5/fcitx5-rime'
```
但对于Linux、Mac使用ibus、fcitx前端就需要自己设置变量，这个变量可以终端执行，但最好直接写入~/.zshrc  
```base
export rime_frontend=rime/ibus-rime
export rime_frontend=fcitx/fcitx-rime
```
3. 有了上面的工具后你可以切换到刚刚拉取下来的脚本所在目录，执行以下对应的安装目录，即可实现安装和更新

##### 基础版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-base:plum/full
```

##### 基础版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-base:plum/dicts
```
##### 自然码辅助版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-zrm-fuzhu:plum/full
```

##### 自然码辅助版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-zrm-fuzhu:plum/dicts
```
##### 墨奇辅助版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-moqi-fuzhu:plum/full
```

##### 墨奇辅助版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-moqi-fuzhu:plum/dicts
```
##### 小鹤辅助版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-flypy-fuzhu:plum/full
```

##### 小鹤辅助版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-flypy-fuzhu:plum/dicts
```

##### 虎码辅助版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-tiger-fuzhu:plum/full
```

##### 虎码辅助版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-tiger-fuzhu:plum/dicts
```

##### 五笔辅助版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-wubi-fuzhu:plum/full
```

##### 五笔辅助版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-wubi-fuzhu:plum/dicts
```
#### 汉心辅助版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-hanxin-fuzhu:plum/full
```

##### 汉心辅助版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-hanxin-fuzhu:plum/dicts
```
##### 首右辅助版（完整）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-shouyou-fuzhu:plum/full
```

##### 首右辅助版（仅词库）
```bash
bash rime-install amzxyz/rime_wanxiang@wanxiang-shouyou-fuzhu:plum/dicts
```

</details>

#### 8. 📂 自定义扩展-线上数据获取

为了保持方案包精简，部分非必须的扩展数据未随压缩包分发，您可根据需求在在线 `custom` 目录中下载。

**在线数据源清单与用途：**

| 文件名 | 用途 | 安装位置 |
| --- | --- | --- |
| `renming.dict.yaml` | **人名词库，按需下载，pro使用万象工具箱刷新编码即可** | 下载后复制内容，追加到根目录的 `wanxiang.dict.yaml` 中。 |
| `wuzhong.dict.yaml` | **物种词库，含动物植物分类等词条，按需下载，pro使用万象工具箱刷新编码即可** | 下载后复制内容，追加到根目录的 `wanxiang.dict.yaml` 中。 |
| `jm_flypy.txt` | **小鹤双拼简码** | 下载后复制内容，追加到根目录的 `custom_phrase.txt` 中。 |
| `jm_zrm.txt` | **自然码双拼简码** | 下载后复制内容，追加到根目录的 `custom_phrase.txt` 中。 |
| `tips_user.txt` | **Tips 翻译扩展数据** | 下载后放入 `lua/data` 目录中，重新部署即可生效。 |

#### 9. 📂 数据管理
| 文件名 | 用途 | 注意事项 |
| --- | --- | --- |
| `lua/data/chinese_english.txt` | **中文翻译英文数据库** | 数据库位于lua/replacer.userdb中。 |
| `lua/data/english_chinese.txt` | **英文翻译中文数据库** | 数据库位于lua/replacer.userdb中。 |
| `lua/data/emoji.txt` | **emoji数据库** | 数据库位于lua/replacer.userdb中。 |
| `lua/data/abbrev.txt` | **公共简码数据库** | 数据库位于lua/replacer.userdb中。 |
| `lua/data/t9_abbrev.txt` | **t9用公共简码数据库** | 数据库位于lua/replacer.userdb中。数字为键 |
| `lua/data/*Phrases.txt` | **OpenCC简繁转换词组数据库** | 数据库位于lua/replacer.userdb中。HK香港TW台湾 |
| `lua/data/*Characters.txt` | **OpenCC简繁转换单字数据库** | 数据库位于lua/replacer.userdb中。ST简繁、TS繁简 |
| `tips_show.txt` | **Tips 自带数据** | 数据库位于tips.userdb |
| `tips_user.txt` | **Tips 用户数据** | 空文件交给用户自定义，数据库位于lua/tips.userdb  |
| `input_statistics.lua` | **输入统计lua创建的实时数据** | 数据库位于lua/stats.userdb |
| `super_sequence.lua` | **手动排序lua创建的实时数据** | 数据库位于lua/sequence.userdb |

### 答疑

[为什么PRO版本默认关闭调频的说明](https://github.com/amzxyz/RIME-LMDG/wiki/%E4%B8%BA%E4%BB%80%E4%B9%88%E8%A6%81%E5%85%B3%E9%97%AD%E8%B0%83%E9%A2%91%E4%BB%A5%E5%8F%8A%E4%B8%8E%E4%B9%8B%E5%85%B3%E8%81%94%E7%9A%84%E6%8E%AA%E6%96%BD%E6%9C%89%E5%93%AA%E4%BA%9B)   ```enable_user_dict: false # 是否开启自动调频，true为开启```

### 功能一览

#### 辅助码系统

万象辅助码采用“拼音+部首读音”的自然逻辑，无需记忆字根，在双拼/全拼基础上直接追加部首声母即可筛选。

![截图_选择区域_20240704121653.png](https://storage.deepin.org/thread/202407041144502563_截图_选择区域_20240704121653.png)

⚙️**1. 直接辅助码 (仅 PRO 版)**

* **基本用法**：输入双拼后直接追加部首声母。
    * *示例*：输入“镇”字，双拼 `vf` + 金字旁声母 `j` → `vfj`。
    * *进阶*：若未出现，可继续输入主体部件的声母进一步筛选。

![截图_选择区域_20240704121809.png](https://storage.deepin.org/thread/202407041147131421_截图_选择区域_20240704121809.png)

* **重码处理与聚拢**：当“双拼+辅码”与现有词组重码时（均为4码），系统优先显示词组以保证整句流畅。此时在编码末尾追加 `/`，即可强制系统忽略词组，优先展示带辅码的单字。

![截图_选择区域_20240821093644.png](https://storage.deepin.org/thread/202408210142513354_截图_选择区域_20240821093644.png)

![截图_选择区域_20240821093701.png](https://storage.deepin.org/thread/202408210143144721_截图_选择区域_20240821093701.png)

⚙️**2. 间接辅助码 (仅 PRO 版)**

* **基本用法**：使用 `/` 作为分隔符引导辅助码（格式：`拼音/辅码`）。
    * *示例*：`ni/re`。
* **特性**：若不输入 `/`，系统将其视为普通拼音，绝不干扰整句切分。相比直接辅助码，此模式更适合新手或轻量级用户，无需担心重码干扰节奏。

⚙️**3. 候选筛选 (输入后反查)**

针对当前输入的候选词，可通过引导符 ``` ` ``` (Tab上方的键) 进行二次筛选：

* **操作**：输入主拼音 -> 按 ``` ` ``` -> 输入部首读音首字母。
* **示例**：输入拼音后，按 ``` ` ``` 再按 `j` (jin) 筛选金字旁；按 `mu` (mu) 筛选木字旁。

![截图_选择区域_20240704121635.png](https://storage.deepin.org/thread/202407041149125588_截图_选择区域_20240704121635.png)

![截图_选择区域_20240704121611.png](https://storage.deepin.org/thread/202407041149524870_截图_选择区域_20240704121611.png)

对于单字：实际上我们同时支持，```两分：你(ni`rfer，ni`re)、多分：莫（mu`ckrida）、笔画：你ni`pspzhpd```   
对于词组，假设 **“老实说”** 的辅助码序列构造为：`tb` (老) + `gt` (实) + `yd` (说) = **`tbgtyd`**

在输入拼音 `lkuiuo` 后，按下引导符（默认 **`**），你可以这样筛选：

  * **精准打击**：输入 **`gt`** —— 匹配到“实”字，筛选出包含“实”的词。
  * **跨字组合**：输入 **`tg`** —— 匹配 `t` (老) 和 `g` (实)。
  * **极致模糊**：输入 **`ty`** —— 匹配 `t` (老) 和 `y` (说)。
  * **任意跳跃**：输入 **`bd`** —— 匹配 `b` (老的尾码) 和 `d` (说的尾码)。

只要你的输入符合 **`.*t.*b.*g.*t.*y.*d.*`** 的正则逻辑，都能精准命中！  

**声调反查支持** 我们还支持在反查符号后面任意位置按顺序输入数字声调7890,单字只有第一个输入的数字生效，词组，按字数生效  

**例如** 单字：ni\`r9e、ni\`rf9er  词组：nihk\`n9zr9e 为了用户方便声调可随意插入，程序会提取数字应用声调过滤，并将剩余字母编码组成按上面提到的逻辑执行

对于pro版本还可以设置词库中携带的辅助码用于反查，这就类似间接辅助码的功能了，但不同的是间接辅助能够句中任意，而反查只能作用于词库中已有的词组。  

注意刻意设计**词组匹配不支持笔画**这也是为了规避复杂度  

在你的方案文件中配置 `wanxiang_lookup`：

```yaml
wanxiang_lookup:
  tags: [ abc ]            # 生效的 tag
  key: "`"                 # 反查引导符 (建议使用默认，避免与分词符 ' 冲突)
  lookup: [ wanxiang_reverse ] # 反查数据库
  data_source: [ aux, db ] # 【核心】数据源优先级：写在前面的优先！
                               # aux: 从词库注释(辅助码)提取
                               # db: 从反查数据库(拆字/五笔画等)提取
```
反查、笔画都必须wanxiang_reverse.custom配置，默认全拼加大写五笔画，你可以根据自己习惯定制五笔画对应的编码转写，反查则切换为对应的双拼全拼，这个文件与主方案类似，都是在根用户目录生效，打开就明白了。

⚙️**输入前反查**  通过 拼音状态下``` `〔反查：部件|笔画〕``` 来引导拆字模式 举例 ```震```  假设你不认识，你可以通过`雨和辰` 来合并输入，拼音状态输入后，继续输入其它字符字母``` `〔反查：部件|笔画〕```会消失如下图，输入 ```yu if``` 即雨 辰，结果出现了我们要的震字，且给出了辅助码 ```y``` 和  ```i```  ，```y```是雨的声母```y```，```i```是辰的声母```ch```，同时兼容通过hspnz代表横竖撇捺折五笔画。功能3是功能4的另一种表现形式,或者叫用法。这个功能依赖wanxiang_reverse.schema.yaml方案,可以通过custom配置成任意全拼双拼以匹配主方案一致的输入方式,因此是不是输入jn=jin需要看你具体的双拼类型。

 ![截图_选择区域_20240928112256.png](https://storage.deepin.org/thread/202409280324599355_截图_选择区域_20240928112256.png)

⚙️**声调辅助筛选**  句子中间或者单字输入时需要可以使用更精确的聚拢方式"声调辅助"，7890数字按键代表1234声，轻声归并到4声，在功能4中我们可以在双拼两码后面3个编码的位置任意插入声调与两位辅助码混合使用，就是除了不用斜杠了，我们还顺序自由了，下面由两个图片说明问题,其实在键盘上想要安排四个按键是很难得,不是占用这个按键就是占用另外的,还有得朋友觉得离得远,还有得更是不需要声调,要把候选做成9个。这些都是存在的情况,现在的处理也是妥协后的结果,要想完全不占用按键类似的办法可以改成大写字母来代表,像地球拼音则是使用大于小于号这一片的符号来表示,我们的词库有声调这个基础,一定程度上还是要利用起来：

<img src="https://storage.deepin.org/thread/202505120222182012_截图_选择区域_20250512101814.png" height="130" width="520">

<img src="https://storage.deepin.org/thread/20250512022217432_截图_选择区域_20250512101752.png" height="130" width="520">

<img src="https://storage.deepin.org/thread/202505120222163619_截图_选择区域_20250512101713.png" height="130" width="520">

⚙️**大写辅助筛选** 在输入辅助码的时候可以穿插输入小写、大写、声调来定位，如：你ni/ni9/niRE/niR9E/nirE/niRe/ni9RE/niRE9/nire9/ni9re/nir9e.  

⚙️**14/18键设定：**  在万象的的各主方案的custom示例文件中我们已经预设了相关*18jian*、*14jian*的转写段落，位于文件末尾，他的作用就是将方案原来的编码转换成键盘能打出来的字母或者数字，最终相呼应自然就能打出字了，万象默认转换成大写，因此需要键盘发送的也是大写：
```
18jian:
  __append:
    - xlit/qwertyuiopasdfghjklzxcvbnm/QWWRRYUIIPASSFFHJJLZXXVBBM
14jian:
  __append:
    - xlit/qwertyuiopasdfghjklzxcvbnm/QQEETTUUOOAADDGGJJLZZCCBBM
```

开启方式，就是将相应的段落引用到custom头部的拼写运算后面

```
patch:
  speller/algebra:
    __patch:
      #- 模糊音
      - wanxiang_algebra:/base/全拼
      - 18jian    #引用到这里即可，⚠️注意，这一行必须是最后一行，不管前面有什么
```

⚙️**英文方案：**  

①支持英文整句，支持与万象拼音挂接使用，支持独立使用，能在输入中自动完成句中空格的添加  

②尾部\~的含义，在输入句子的时候，当最后一个单词还未输入完全，如this is english只输入到了eng\~这个时候就会出现\~代表了一个不在词库中、未稳定的状态，这能保证你的输入视觉上的完美，也可以随时上屏。其本质是空码补全，因此有时候输入一个如scx\~时候你可以空格上屏也可以拍下回车，兼容多种习惯。 这里还要提到pro版本在开启字符集过滤的时候，有很多三码为空，比如输入: 你来 当编码输入到 nil实际上是一个生僻字，但被字符集过滤删除，变为空码，而这个特性能让“你”依然显示到候选中并注释中显示\~，同样代表这是一种派生，不稳定的状态，当nill完整输入完毕一个词汇将呈现出来，这与基础版nil就能打出"你来"是有极大的差异性的。

③输入hello则得到hello，输入首字母大写Hello则得到Hello和一众首字母大写的联想词，输入前两码大写HEllo则得到全为大写的HELLO和一众大写英文。  

<img src="https://storage.deepin.org/thread/202509260133175234_首字母大写.jpg" height="80">
<img src="https://storage.deepin.org/thread/202509260133175362_双字母大写.jpg" height="80">

④ 英文智能加空格  

- **模式选择**：支持 `off` (关闭)、`before` (总是前加)、`after` (总是后加) 及 `smart` (智能模式) 四种策略。  
- **智能连续逻辑**：在 `smart` 模式下，仅从连续输入的**第二个单词**开始自动前加空格。  
- **状态打断机制**：手动输入【空格】或【回车】将立即重置加空格状态，有效避免在行首或手动分词后出现多余空格。  
- **超时自动销毁**：支持配置状态有效期（默认 5 秒）。若在非输入中停顿超时，自动清除加空状态，防止光标重新定位（如跳转至行首）后误输出空格，但输入中只要不上屏都能继续保持。  
- **路径/网址优化**：输入 `\` 或 `/` 符号后，自动将加空逻辑延后 3 个单词，确保分次输入文件路径或 URL 时内容不被空格截断。  

⚙️**英文数字字母汉字的混合输入**  混合输入:字母、汉字、数字、用于连接的特殊符号等组合，以及英文混输，我们统一放在了wanxiang_mixedcode.schema.yaml混合编码方案里，此功能无需引导，直接输入，不参与组句，类似：1000wclips、AD钙奶、PN结、Type-C以及纯英文，同样可以通过custom来定义你所使用的双拼。

![东风5C](https://storage.deepin.org/thread/202509260105536966_混合编码.jpg)

⚙️**整合说明** 万象方案整合度很高，我们不希望使用户文件夹变得复杂，功能5中我们将两类习惯的五笔画和多分拆字和两分拆字整合到了一起，可以认为是4个挂接方案；在功能6中，我们将 英文输入、中英混合编码、以及一些其他混合编码整合到了一起，共享方案转写，两个功能都保证了可配置性，都能与你所使用的双拼契合，
对于词库也都整合到了dicts里面，为了能更好的统一更新和分发，仓库中我们支持基础版本词库、携带pro的辅助码版本词库、英文词库、混合词库4个类别，在release中各自归类，最终做到了根目录15个文件、4个文件夹示人，其中的custom目录还携带了用户自定义的法宝秘籍，能称得上简约而不简单。
#### 其他亮点功能

⚙️**日期、时间、节日、节气、问候模板：**
可以在按键配置的地方定制引导前缀  

```key_binder/shijian_keys: ["/", "o"]``` 这样的配置以为你你可以/sj也可以osj，某些方案o有别的作用时候可以去掉o,灵活处理。  

输入后N0101四位数模式下,可以输入月日，如果输入完整的八个数字则可以显示年月日，还有他强大的自定义能力，类型、格式、顺序、候选数，每一样都可以自定义，安全的占位逻辑和转译方式，该模式下只要是合法的月日格式、年月日各式都可以在输入完毕后直接用数字上屏，同时也兼容qwerty代表123456等上屏  

```yaml
#shijian:仅仅作为提示使用，编码已经写死，引导键可以在key_binder下修改前缀
#时间：osj 或者 /sj
#日期：orq 或者 /rq
#日期差：orc 或者 /rc 
#之所以单独列出是为了保证rq能直接数字上屏，这个功能需要输入数字，所以/rc这一步不能上屏，
#但我们把逻辑后置用来代表结束就能在结束时也使用数字上屏，使用方法：
#/rc26p,/rc26+,/rc26p= 随意一个都是加上这个差值，得到未来日期；
#/rc26-,/rc26o 随意一个都是减去这个差值，得到过去日期
#以此实现了主键盘不用刻意按下shift，-=两个按键直接按，手机上也有op兼容可用，小键盘-+直接用
#农历：onl 或者 /nl
#星期：oxq 或者 /xq
#今年第几周：oww 或者 /ww
#节气：ojq 或者 /jq
#日期+时间：odt 或者 /dt
#时间戳：ott 或者 /tt
#/utc查询热门城市UTC时间
#大写N日期：N20250315 或者N0312不带年
#节日：ojr 或者 /jr
#问候模板：/day 或者 oday
# 通用日期时间格式化函数（供 /rq、/sj、/dt、N0101、N20150101 场景复用）
# 支持转义：
#   \X       —— 转义单个字符 X，按字面量输出（如 \Y \m \H 等）
#   [[...]]  —— 区块整体按字面量输出
#
# 约定占位符：
# 【日期】
#   Y  四位年份           0000-9999  例：2025
#   y  两位年份           00-99      例：25
#   m  月（前导零）        01-12      例：02
#   n  月（不带前导零）     1-12       例：2
#   d  日（前导零）        01-31      例：09
#   j  日（不带前导零）     1-31       例：9
#
# 【时间】
#   H  24小时（前导零）   00-23      例：08
#   G  24小时（不带零）   0-23       例：8
#   I  12小时（前导零）   01-12      例：08
#   l  12小时（不带零）   1-12       例：8   （注意是小写 L）
#   M  分钟（前导零）     00-59      例：05
#   S  秒（前导零）       00-59      例：09
#   p  am/pm（小写）     am / pm
#   P  AM/PM（大写）     AM / PM
# 【时区】
#   O  带冒号格式        +08:00、-04:30、+05:45
#   o  不带冒号格式      +0800、-0430、+0545
date_formats:
  - "Y年m月d日"
  - "Y-m-d"
  - "Y/m/d"
  - "Y.m.d"
  - "Ymd"
  - "Y年n月j日"
  - "y年n月j日"
  - "n月j日"
time_formats:
  - "H:M"
  - "H点M分"
  - "H:M:S"
  - "H时M分S秒"
  - "下午I:M"
  - "I:M P"
datetime_formats:
  - "Y-m-d H:M:S"
  - "Y-m-dTH:M:S O"
  - "YmdHMS"
  - "Y年m月d日 H点M分"
  - "y/m/d I:M p"
```
<img src="https://storage.deepin.org/thread/202509260107542641_N20250102.jpg" height="80">
<img src="https://storage.deepin.org/thread/202509260108069991_N0102.jpg" height="80">

⚙️**Unicode：** 大写 U 开头，如 U62fc 得到「拼」。

<img src="https://storage.deepin.org/thread/202509260111366093_U码.jpg" height="80">

⚙️**数字、金额大写：**  大写 R 开头，如 R1234 得到「一千二百三十四、壹仟贰佰叁拾肆元整」。输入后该模式下可以采用qwerty...依次代表123456上屏，也可以按下方向键上下进行候选的选择。  

<img src="https://storage.deepin.org/thread/202509260124573417_金额大写.jpg" height="80">

⚙️ **/引导模式：** 通过输入 /sx 快捷输入关于“数学”的特殊符号，具体能输入什么可以打开 wanxiang_symbols.yaml学习。以及前述提到的日期、时间等的引导都共用斜杠开头，可以理解为一种命令模式。其中/wx可以查询仓库连接和当前版本  

<img src="https://storage.deepin.org/thread/202509260126183029_符号数学.jpg" height="80">
<img src="https://storage.deepin.org/thread/202509260126173818_符号大于.jpg" height="80">
<img src="https://storage.deepin.org/thread/202509260126167252_符号圆点.jpg" height="80">

⚙️**输入统计Lua：** 触发方式：/rtj日统计，/ztj周统计，/ytj月统计，/ntj年统计，/tj生涯。

⚙️**计算器：**  通过输入大写V引导继续输入如：V3+5  候选框就会有8和3+5=8，基础功能 `+ - * / % ^` 还支持 `sin(x) cos(x)` 等众多运算方式，打开super_calculator.lua阅读相关用法。

<img src="https://storage.deepin.org/thread/202509260127113759_计算器1.png" height="80">
<img src="https://storage.deepin.org/thread/202509260127126065_计算器2.jpg" height="80">

⚙️**自动上屏：**  例如：三位、四位简码唯一时，自动上屏如`jjkw岌岌可危` `zmhu怎么回事` 。默认未开启，方案文件中`speller:`字段下取消注释这两句开启 `#  auto_select: true  #  auto_select_pattern: ^[a-z]+/|^[a-df-zA-DF-Z]\w{3}|^e\w{4}`

⚙️**空码回溯：** 当输入的时候前面编码有候选，但继续输入无候选了，此时会将上一次的候选显示到候选中并在注释中显示了一个`~`作为表示一种不稳固状态，在英文输入句子的时候也会有这个状态的出现。这样的设计省去了回退键，可以直接空格上屏，同时他也能极大的减少三码是为空给用户带来的异常感知。  

⚙️**数字后自动半角：** 当中文状态输入数字的时候后面立即输入,。将自动转换为数字分割符，例如科学记数法1000,000 小数点 3.1415,如果你加入冒号:还可以优雅的输入时间12:30，当然你还可以双击输入的符号恢复全角符号的输出。但若你完全没有场景使用该功能，则可以通过patch，将其修改为commit  
```punctuator/digit_separators: ",."  >  punctuator/digit_separators: commit```

⚙️**错音错字提示：**  例如：输入`gei yu给予`，获得`jǐ yǔ`提示，此功能与全拼、双拼类型无关全部支持；

<img src="https://storage.deepin.org/thread/202509260127525844_错音给予.jpg" height="80">      <img src="https://storage.deepin.org/thread/202509260127524705_错音崩溃.jpg" height="80">

⚙️**快符Lua：** 例如通过 ```a/``` ，快速自动上屏“！”符号或者定义为任意字符，享受26字母的扩展。其中值设置为`repeat`则意味着按下对应按键能否重复上一次上屏的内容。位于方案中quick_symbol_text段落是可以自定义映射关系的，对于特殊需求用户还可以修改正则表达式让引导策略发生变化，如首字符引导；

⚙️**超级tips：** 支持将表情、化学式、翻译、简码 提示等等你能想到得数据获得提示显示并将通过一个自定义按键直接上屏，默认为“，” 也表现为逗号，避免了这类内容占用候选框，轻量化提示与上屏的能力。如果你设置逗号句号为翻页，逗号翻页如果正好是首选匹配，句号作为下一页则不干扰，当想要回到第一页，此时已经不匹配tips，此时逗号就不被tips占用了，就可以用于翻页。也可以将触发键变更为其他，位于key_binder/tips_key: "comma"。对于加载的类型可以屏蔽某一种，位于tips/disabled_types: []，括号内填入# 可选项为：偏旁，符号，化学式，时间，符号，组字，翻译，表情，货币，车牌等禁用类型。通过Control+t 进行开关。  
⚠️仓输入法、超越输入法设置按键交由rime去处理，没有特殊需求应该一律交给rime，如需关闭将tips开关reset 0即可；  
⚠️某些前端开启嵌入与窗口交互有bug，在开启tips的时候可能会造成异常的编码上屏，此时可以关闭tips在这些窗口使用输入法。

化学式：<img src="https://storage.deepin.org/thread/202509260128462735_tips化学式.jpg" height="80">符号：<img src="https://storage.deepin.org/thread/202509260128454675_tips符号.jpg" height="80">表情：<img src="https://storage.deepin.org/thread/202509260128457494_tips表情.jpg" height="80">

⚙️**短语格式化Lua：** 将首页自定义短语中（custom phrase），诸如\n \s \t 等行中标识符转换为实际的换行、空格、制表符等等，支持重复字符声明，使得类似输入jys可以打出一首带格式的《静夜思》，使用\\3的形式表示前面的字符重复N次。同时还支持对于动态变量的输入自定义，如时间、日期、时刻等等，打开文件即可看到完整占位说明，这个格式化也不拘泥于custom_phrase.txt，而是任何能产生候选的位置都支持，如super_replace提供的功能txt中都可以自定义，比如我在other.txt写入了  此时此刻 孪生一个 午时八刻 这样的候选。  

例：```静夜思\n\s\3李白\n床前明月光\n疑似地上霜\n举头望明月\n低头思故乡	jys```

<img src="https://storage.deepin.org/thread/202509260129305342_格式化.jpg" height="260"> 

⚙️**成对符号包裹Lua：** 将输入中的短语通过输入追加\a 这样的末尾编码，触发相对于a这个字母映射的成对符号，例如：``` sj mk lq lh ji\k=《三毛流浪记》```可以通过custom自定义符号和触发方式。

工作逻辑：输入词汇编码 > 按下锁定按钮\  >  按下映射字符\a  >  《候选包裹成对符号》

<img src="https://storage.deepin.org/thread/202509260130219621_首选成对符号1.jpg" height="80"> <img  src="https://storage.deepin.org/thread/202509260130208277_首选成对符号2.jpg" height="80"> <img  src="https://storage.deepin.org/thread/202509260130199763_首选成对符号3.jpg" height="80">

⚙️**输入模式切换Lua：** 使用shift+space来进行中文候选词、英文候选词、混合候选词之间切换，默认为混合编码输入模式。这种是通过单一方案过滤得到的，当切换到英文模式的时候也可以用来输入英文整句。你也可以单独启用英文方案，可自定义快捷键在英文方案与中文方案之间切换，也是可以的。  

⚙️**辅助码提示Lua（仅PRO）：** 任意长度候选词的辅助码提示能力，默认开启1个字的辅助码，可以在方案文件中定义更长的长度。Ctrl+a可以实时在开启辅助码提示、开启声调全拼提示、关闭注释 三个状态循环，Ctrl+c开启拆分辅助提示，优先级高于普通辅助提示；

<img  src="https://storage.deepin.org/thread/202509260134283927_辅助码提示.jpg" height="80">
<img  src="https://storage.deepin.org/thread/202509260134278003_声调提示.jpg" height="80">
<img  src="https://storage.deepin.org/thread/202509260134284782_拆分提示.jpg" height="80">


⚙️**输入码音调显示Lua：** 通过Ctrl+s可以使得输入码实时动态显示全拼并加音调，这是万象特色功能，你可以通过shift+enter上屏当前显示的编码字符串；

⚙️**用户按需造词（仅PRO）：** 默认通过``` `` ```引导的方式进入用户词自造词模式，继续输入则``` `` ```前缀消失，后面打出来的字上屏后完成造词。 pro版本讲究自主可控，由于辅助码的使用在很多时候不熟悉的时候可能会上屏更加异常的词汇或者生僻字，有的用户还不会使用Esc退出输入，而是选择直接敲下空格。按需造词可以有效把控造出的词是有意义的，而且默认靠后，原因简单基本上有意义的高频词万象已经提供，你应该使用辅助码将其前置。**重点**：在此基础上我们还支持“后触发”当你输入编码后发现没有你要的行业词汇，此时在后面双击``` `` ``` 就可以在不删除编码的情况下完成造词。还有一个是次选造词，如果次选是你想要的，并且是词库组合成的，上屏就会记录下来。

总结一下，造词功能由：①``` `` ```起始的主动造词，②``` `` ```在编码后面的主动造词，③次选造词。三个特性构成

⚙️**中文无感造词Lua（仅PRO）：** 在关闭调频的情况下，通过逐步选字选词的方式上屏将为你记录整段，且不会产生小碎片，所造词汇与db用户词是一回事，遵循用户词管理的相关逻辑，其中直接上屏不造词。相比按需造词更加不打断输入。  

⚙️**英文造词Lua：** 在任意英文输入编码后面，如：```nihao\\```末尾输入两个就可以触发英文造词。然后空格上屏他就记录到了en.userdb，导出和同步与用户词逻辑一致。  

⚙️**用户词删除：** 使用Ctrl+del是rime系统删除用户词,就可以将用户词标记为c<=0，这在rime系统中就表现为不使用，假性删除。

⚙️**字符集过滤（Lua）：** 默认开启过滤，写在charset.dict.yaml的就是可以通过的字表，默认为8105+𰻞𰻞，如果你想什么字在小字集模式可以通过可以写在这里，配套开关【小字集、大字集】，快捷键Ctrl+g ，万象的字符集过滤其实不仅仅是这点，首先我们提供了一个二进制滤镜数据库charset_reverse.bin，内部通过编码层对字做出来标记，也就是除了字符范围，还标记了繁体适用范围.  
```
# a,通用规范汉字表
# b,GB2312,
# g,GBK,
# T,Big5,(台港澳常用)
# j,简体,OpenCC (t2s)
# f,通用繁体,OpenCC (s2t)
# h,香港繁体, OpenCC (s2hk)
# t,台湾繁体, OpenCC (s2tw)
# u,基本区,U+4E00 - U+9FFF
# A-I,扩展 A-I 区,U+3400 及各扩展区 (支持到 Ext-I)
# c,兼容区汉字
```
我们在配置中还可以联动简繁转换的开关，对不同开关想要显示的范围进行配置，注意字母可以列出多个base: aj，还可以单独定义这个开关下对应的基黑白名单，他可以用来微调预设的范围，比如8105其实没有“囧”但常用我们就可以加入白名单里面，让开启过滤的时候能显示出来  
同时不同的option开关之间是求并集，也就是说假设你切换到了s2hk意味着所有香港繁体字都能显示出来，合起来就是8105+香港繁体，这样就不会因为开启了字符集过滤导致某些繁体字丢失显示不出来。这样的设计让你能随意新增开关，定义开关对应的过滤范围，以及对于简繁转换的联动。  
```
charset:
  - option: charset_filter
    base: a  #可以填入多个类别如aj
    addlist:
      - "诶濛硷氽尛躝〇冇吔咗囧屌鲶芶咲畑垅𰻝𰻞"
    blacklist: []
  - option: s2t
    base: f
    addlist: []
    blacklist: []
  - option: s2hk
    base: h
    addlist: []
    blacklist: []
  - option: s2tw
    base: t
    addlist: []
    blacklist: []
```

⚙️**超级替换(lua):** super_replacer.lua一个通过lua创建的用来替代自带OpenCC组件的增强组件，用于实现候选词的动态替换、追加。

#### 🛠️ Super Replacer 参数配置手册

##### 1. 核心全局参数
| 参数 | 说明 | 示例值 |
| :--- | :--- | :--- |
| `db_name` | 数据库/词库加载路径 | `lua/replacer` |
| `delimiter` | 多个候选词之间的分隔符 | `"\|"` |
| `comment_format` | 注释显示的样式模板（`%s` 为占位符） | `"〔%s〕"` |
| `chain` | **流水线模式**：`true` 串行处理（A->B），`false` 并行处理 | `true` |

---

###### 2. 任务项配置 (`types`)
每个 `- option` 代表一个具体的功能模块，其核心参数如下：

| 参数 | 说明 | 可选值 / 示例 |
| :--- | :--- | :--- |
| **`option`** | 绑定的开关名称（需在 `switches` 中定义） | `emoji`, `s2t`实际的开关名称 `true` (常驻开启) |
| **`mode`** | **处理模式**（决定结果如何呈现） | `append`, `replace`, `comment`, `abbrev` |
| **`comment_mode`** | **注释继承模式** | `none` (空), `append` (继承), `text` (原词变注释) |
| **`sentence`** | 是否开启**句子级别**替换（整句转换） | `true`, `false` |
| **`tags`** | 生效的输入段类型（通常对应拼音） | `[abc]` |
| **`prefix`** | 数据检索前缀（用于隔离不同功能的数据） | `_em_`, `_en_`, `_abbr_` |
| **`files`** | 关联的数据源文件列表（支持多个） | `[lua/data/xxx.txt]` |

---

##### 3. 四大模式 (`mode`) 详解

| 模式 | 行为描述 | 典型场景 |
| :--- | :--- | :--- |
| **`append`** | **新增候选**：在原词后面添加新候选词 | `哈哈` -> `1.哈哈 2.😄` |
| **`replace`** | **替换原词**：将原始候选词直接修改为目标词 | `软件` -> `軟體` (简转繁) |
| **`comment`** | **仅注释**：不改变候选文字，仅在括号内提示 | `hello` -> `hello〔你好〕` |
| **`abbrev`** | **简码模式**：匹配**输入编码**而非文本 | `zm` (编码) -> `1.怎么 2.在吗` |

---

##### 4. 数据文件 (`.txt`) 编写规范
数据文件需放置于 `files` 指定路径，使用 **Tab (制表符)** 分隔：
> **`匹配内容 [Tab] 替换内容1 | 替换内容2`**

**举例：**
* `火	🔥`
* `apple	苹果`
* `yyds	永远的神`

⚙️**手动排序（Lua）：** ①词典候选类型：对选中的候选词操作，使用Ctrl+j向左一步，Ctrl+k向右一步，Ctrl+l(零)移除选中排序信息，Ctrl+p 置顶选中候选。其作用于当时编码与候选词；②动态生成的Lua候选，很多时候我们对日期、时间等输出格式首选有着自己的追求，复杂的配置又往往提升了使用难度，于是我们基于排序Lua实现了动态内容的按序号索引的排序，也就是说该序号下原本生成的格式整个发生了位置变化，使用方法一致。信息储存于Lua文件夹下排序数据库中sequence.userdb，支持导出导入数据便于多设备共用。

状态标识：按下ctrl键会显示数据库中已经储存的被移动过的候选，圆点-表示移动过但回到了原位， 其他±各自代表移动的幅度与趋势。  

排序信息同步：

A 先点击同步，多见于右键菜单，保证创建了相应的同步目录，如没有自定义则位于用户目录下/sync

1. 打开用户目录，会有installation.yaml文件，打开后会有如下信息，我们将installation_id认为是设备id，初次会创建自动串号，你也可以将其修改为当前设备名称
```
distribution_code_name: "fcitx-rime"
distribution_name: Rime
distribution_version: 5.1.9
install_time: "Mon Jun 23 18:47:55 2025"
installation_id: "ff9b2823-8733-44bb-a497-daf382b74ca5"  #这里可以随意编辑，比如修改为windows
rime_version: 1.13.1
update_time: "Sat Sep  6 16:08:56 2025"
```
得到这个id后我们就可以下一步构建出同步文件的名称sequence_设备id.txt

2. 首先确定一个主要管理设备，在/sync中创建一个描述设备清单的文件 `sequence_device_list.txt`，这个清单告诉程序要读取同目录下哪些文件进行合并
```内部内容为：
sequence_deepin.txt
sequence_windows.txt
sequence_iPhone.txt
```
3. 按「部署」，会进行以下几步：

①、自动导出数据到 `sequence_deepin.txt` 文件(假设为当前设备)，因此这个当前设备文件会被覆盖，请不要手动修改避免丢失；

②、读取列表中列出的文件，按时序以保留最新动作为依据进行去重合并，合并后数据将会回写到 `sequence_deepin.txt` 文件；

③、将合并后的文件导入db数据库，完成数据合并，注意p=0的重置后的编码不会导入数据库，如数据库原本有对应的词汇，将删除对应的键。

4. 通过云同步将/sync完成同步到windows设备，同步后，编辑 `sequence_device_list.txt`将sequence_windows.txt写入文件，让同步程序再次完成多端同步

此时目录中已经存在如下文件，此时重新部署，稍作等待将会完成`sequence_windows.txt`的输出

`sequence_device_list.txt`

`sequence_deepin.txt`

`sequence_windows.txt`  #同步后新增

再次手动完成手动云同步，及时让文件对齐。

B 重复以上操作完成更多设备的添加和同步

由于此流程为模拟rime同步的方式，rime的同步本质上就是多端的数据合并的过程，可靠性可能相较于原生较弱一些，尤其是iPhone可能遇到更多问题。

⚙️**声调辅助回退（Lua）：** 万象是将7890用来代表1234声，轻声归并到了4，我们支持在例如输入ni9后发现我可能要4声，ni0，此时我们无需删除数字9而是直接输入对的0，类似手动在7890之间轮巡，能有效快速提升声调辅助的效率，减少使用负担，也是万象独创功能。

⚙️**小键盘有妙用（Lua）：** auto模式：可配置输入中数字跟在字母后面不上屏。compose模式：可配置数字持续不上屏，不用区分先后。

⚙️**删除键限制（Lua）：** 可以在输入中当持续按下删除编码为0时会卡住，抬起重新按下才能继续删除已经上屏内容，避免误删除上屏内容。目前仅PC可用，也是万象独创功能。

⚙️**输入长度限制（Lua）：** 对两类场景进行限制，避免数据并发卡顿：1、重复输入8个连续相同的字母，aaaaaaaa会提示:已超最大重复声母。因为连续多个的重复字母会造成严重的卡顿；2、分词片段限制在30个，也就是30个字，过长的语句价值不大还会造成卡顿。

⚙️**Tab循环切换音节：**  当输入多个字词时想要给前面补充辅助码，可以多次按下tab循环切换，这种可能比那些复杂的快捷键好用一些，同样逻辑的按键还包含ctrl+tab相当于逐字确认，错了可以补充编码，对了继续按下直到全部上屏；  

⚙️**“候选切割机”（Lua）：** 这个功能是有候选的时候，通过按下ctrl+1~0中的10组组合键直接上屏首选前N个字，编码按现有音节分割后续编码保留，一般来说在输入句子的时候由于读音和构词的相似性，以及模型数据的偏差可能会出现错误的连续，这个时候恰当的切割让前面正确的直接上屏，残留的编码一般自动变为首选正确的选项了，此时上屏或继续切割或者使用tab补充编码。这个功能在base双拼中具备更高的确定性，而在pro版本中如果遇到直接辅助码的聚拢，那么此时候选估计与你初心不一致，此时可以考虑借助多次按下单引号来循环分词或许能得到你要的候选，如未得到直接esc重新输入更为高效。更为激进的用法直接上屏正确的部分，后面的编码直接遗弃，现在没有写进去，或许可以作为一个选项，如果你也像这样可以issue告诉我，我们可以改造成布尔选项；

⚙️**翻译模式：**  输入状态按下Ctrl+E快捷键进入翻译模式，原理是opencc查表进行中英文互译，能否翻译取决于词表的丰富度；

⚙️**万能键斜杠/：**   
 * 符号扩展输入： rime(大部分前端)是一种最小化ui的输入法，除了输入界面几乎看不到ui设置界面及符号表情面板的组件，因此我们在想要输入一些符号表情等特殊内容的时候会根据类型，设计一个触发条件，这个条件类似以什么编码开始作为标识、或者是某种tag状态。万象又是一个兼容多种输入类型的方案，我们无法找到一个绝对的空码字母作为触发条件，或多或少会冲突，因此我们选择了斜杠作为引导条件，例如/sx可以打出加减乘除等等，/yd可以打出圆点集合等等；  
 * 辅助码聚拢： 我们在转写中将四个字母+/作为高权重的编码，意思就是侧重输入单字，而四个字母则采用abbrev，这种情况有词的情况有限出词，没词才会变成单字，毕竟我们是一个语句流方案，核心还是想输入多长就输入多长的类大厂习惯的输入法，因此单字就不能像字词音形方案那样四码定位一个字；  
 * 间接辅助码引导： 直接辅助码我们是在四个编码末尾追加斜杠/，而间接辅助是在两个编码即双拼后面加斜杠，意思就是后面继续输入编码就能用辅助码对这个单字进行筛选，如果不加斜杠，就与正常的双拼无异，这时vs g=中国就能被打出来，不习惯直接辅助的可以选用这种方式；  
 * 短码英文前置： 对于英文词典中我们常常遇到us以及United States这种缩写，那么在你水平一般的情况下输入两个字母前面可能是一大堆重要的中文词汇和单字，那么这个例子就显得不恰当了，不重要，这个时候输入us/就可以让us编码相关的英文词条前置，此时次选就是United States，有的时候是能输出对应大写，支持1-3个字母，因为但凡输入四个字母以上基本上会获得直接的前置了；  
 * 快符： 输入一个单字母+/完成对应映射上屏，a/这样，还能定义某个按键是用来重复上屏之前的内容例如q/最终形成自己的习惯，原本分号引导包括数字都能用，但是分号太过珍贵，方案层面就不占用了；  
 * 上屏斜杠自己： 通过双击斜杠直接上屏他自己；  

⚙️**按键设置思考：**   
 * 我们说有舍有得，如何合理安排这些按键是一个重要课题，很多新手上来就要遵循自己以前的习惯，但那些习惯又何尝不是其他软件灌输给你的，我们何曾思考过合理性，对于rime不思考就定义不好，定义不好不如继续用大厂。对于万象斜杠/是不可能被挪作他用的，因此莫要针对这件事提问，修改的地方过多没有精力教学。反斜杠是顿号、分号有次选需求、引号要分词，中括号要以词定字，逗号句号在没有tips的时候更倾向于随语句一起上屏，节约按键，在有tips的时候句号在手机电脑上任何键盘大概率都能直接按，因此默认-=作为翻页，这与老祖宗ABC时期用法一样，某种程度7890代表的1234声调与-=凑在一起构成了一个筛选区，在重新选择rime作为输入法的时候我还是建议重新思考一下自己所谓的习惯  

⚙️**自定义短语：** 将根目录中的custom_phrase.txt文本以表导入到rime，实现实际的编码对应你想要的输出，床前明月光\tcqm，其中\t代表制表符，不能输入的复制前面的行修改可见字符，尽量不要使用记事本编辑，换一个更高级的文本编辑器。这个功能主要用来短编码输入长短语、符号数字串等等各种需要置顶的内容，一定要根据万象的初始化在wanxiang.custom中修改名称避免更新被覆盖丢失数据。  

⚙️**自定义词库：** 自定义词库首先要利用工具将你自己的词库刷成与万象同类型的声调、或者声调+辅助码的形态，因为主词库要参与转写。对于custom_phrase则需要手动编辑编码为实际输入的编码。

要保证每个字编码与chars完全一致，这是基础，不再赘述。

##### 固定词库：
#packs法，要保证外部名称`userxx.dict.yaml`与里面`name: userxx`一致，
```
patch:
  translator/packs/+:
    - userxx
```

#重命名法，重命名用户根目录`wanxiang.dict.yaml`为`wanxianguser.dict.yaml`，避免更新被覆盖

#所有主方案文件中使用了这个固定词库的位置都要变更 
```
patch:
  translator/dictionary: wanxianguser
  user_dict_set/dictionary: wanxianguser
  add_user_dict/dictionary: wanxianguser
```
##### 用户词库迁移：

一个前置知识：同步是将用户词按时序合并导入导出的本地操作。

⚠️请不要将这个rime文件夹部署到同步软件下面，这将造成数据库被同步锁定无法正常工作，同步的最高级目录为/sync

确认你的同步目录，默认用户目录下面的/sync，如果自定义在installation.yaml文件中写入

linux\mac\android这样写：
```
sync_dir: "/home/amz/sync"
```
windows这样写：
```
sync_dir: "D:\\home\\amz\\sync"  #双引号
sync_dir: 'D:\home\amz\sync'     #单引号
```

你还可以将installation_id字段改成一个可辨识的名称如按系统命名

知道了这些以后你可以创建以下文件夹，他们的名称来自installation_id字段
```
xxx/sync/windows
xxx/sync/linux
xxx/sync/ios
```

你完全可以在用户目录看到wanxiang.userdb，他就是你实时工作的数据库PRO版本是zc.userdb，当你点击右键菜单，同步用户数据时

系统将会将用户词库以txt方式释放到`xxx/sync/windows/wanxiang.userdb.txt`

每一个wanxiang.userdb.txt表头都有一个表头

```
# Rime user dictionary
#@/db_name	zc
#@/db_type	userdb
#@/rime_version	1.13.1
#@/tick	793
#@/user_id	ff9b2823-8733-44bb-a497-daf382b74ca5
```
关注db_name必须与用户词典文件名一致，且不管多个设备不同设备文件夹下面的文件名称都应该一致，看起来都是wanxiang.userdb.txt

关注user_id=windows(设备文件夹名称)=installation_id字段必须保持一致

如果只有一个设备，你完全可以在同步后删除用户目录的`userdb`，手动编辑`xxx/sync/windows/wanxiang.userdb.txt`

注意这里的编辑必须是经过预处理格式与万象编码完全一致的情形下，万象提供的工具就可以完成声调标注和辅助码标注

编辑好文件，确保放入设备目录，点击同步即可导入数据库

你还可以将你迁移的数据txt内部设备名称都修改成linux，并将文件放入xxx/sync/linux

此时点击同步也能将用户词与windows文件夹下面的合并一起导入数据库，模拟多设备同步，这也是未来真正的多设备同步逻辑

- [词库刷拼音辅助码工具](https://github.com/amzxyz/RIME-LMDG/releases/tag/tool)


<img alt="pay" src="./custom/万象输入方案.png">

## 鸣谢

- 感谢网友的热情提报问题，使得模型和词库体验进一步提升。

## 赞赏

如果觉得项目好用，可以请AMZ喝咖啡

<img alt="pay" src="./custom/赞赏.jpg" height="312" width="446">
