/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class InetAddressUtil {
    private static final Logger logger = LoggerFactory.getLogger(InetAddressUtil.class);

    public static String getInetAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (!InetAddressUtil.isValidAddress((InetAddress)address)) continue;
                    return address.getHostAddress();
                }
            }
            logger.warn("Can not get the server IP address");
            return null;
        }
        catch (Throwable t) {
            logger.error("Can not get the server IP address", t);
            return null;
        }
    }

    public static boolean isValidAddress(InetAddress address) {
        return address != null && !address.isLoopbackAddress() && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.getHostAddress().contains(":");
    }
}

