import type { TranslationMap } from "../lib/types.ts";

export const zh_CN: TranslationMap = {
  common: {
    version: "版本",
    health: "健康状况",
    ok: "正常",
    offline: "离线",
    connect: "连接",
    refresh: "刷新",
    enabled: "已启用",
    disabled: "已禁用",
    na: "不适用",
    docs: "文档",
    resources: "资源",
  },
  nav: {
    chat: "聊天",
    control: "控制",
    agent: "代理",
    settings: "设置",
    expand: "展开侧边栏",
    collapse: "折叠侧边栏",
  },
  tabs: {
    agents: "代理",
    overview: "概览",
    channels: "频道",
    instances: "实例",
    sessions: "会话",
    usage: "使用情况",
    cron: "定时任务",
    skills: "技能",
    nodes: "节点",
    chat: "聊天",
    config: "配置",
    debug: "调试",
    logs: "日志",
  },
  subtitles: {
    agents: "管理代理工作区、工具和身份。",
    overview: "网关状态、入口点和快速健康读取。",
    channels: "管理频道和设置。",
    instances: "来自已连接客户端和节点的在线信号。",
    sessions: "检查活动会话并调整每个会话的默认设置。",
    usage: "监控 API 使用情况和成本。",
    cron: "安排唤醒和重复的代理运行。",
    skills: "管理技能可用性和 API 密钥注入。",
    nodes: "配对设备、功能和命令公开。",
    chat: "用于快速干预的直接网关聊天会话。",
    config: "安全地编辑 ~/.openclaw/openclaw.json。",
    debug: "网关快照、事件和手动 RPC 调用。",
    logs: "网关文件日志的实时追踪。",
  },
  overview: {
    access: {
      title: "网关访问",
      subtitle: "仪表板连接的位置及其身份验证方式。",
      wsUrl: "WebSocket URL",
      token: "网关令牌",
      password: "密码 (不存储)",
      sessionKey: "默认会话密钥",
      language: "语言",
      connectHint: "点击连接以应用连接更改。",
      trustedProxy: "通过受信任代理认证。",
    },
    snapshot: {
      title: "快照",
      subtitle: "最新的网关握手信息。",
      status: "状态",
      uptime: "运行时间",
      tickInterval: "刻度间隔",
      lastChannelsRefresh: "最后频道刷新",
      channelsHint: "使用频道链接 WhatsApp、Telegram、Discord、Signal 或 iMessage。",
    },
    stats: {
      instances: "实例",
      instancesHint: "过去 5 分钟内的在线信号。",
      sessions: "会话",
      sessionsHint: "网关跟踪的最近会话密钥。",
      cron: "定时任务",
      cronNext: "下次唤醒 {time}",
    },
    notes: {
      title: "备注",
      subtitle: "远程控制设置的快速提醒。",
      tailscaleTitle: "Tailscale serve",
      tailscaleText: "首选 serve 模式以通过 tailnet 身份验证将网关保持在回环地址。",
      sessionTitle: "会话清理",
      sessionText: "使用 /new 或 sessions.patch 重置上下文。",
      cronTitle: "定时任务提醒",
      cronText: "为重复运行使用隔离的会话。",
    },
    auth: {
      required: "此网关需要身份验证。添加令牌或密码，然后点击连接。",
      failed: "身份验证失败。请使用 {command} 重新复制令牌化 URL，或更新令牌，然后点击连接。",
    },
    pairing: {
      hint: "此设备需要网关主机的配对批准。",
      mobileHint:
        "在手机上？从桌面运行 openclaw dashboard --no-open 复制完整 URL（包括 #token=...）。",
    },
    insecure: {
      hint: "此页面为 HTTP，因此浏览器阻止设备标识。请使用 HTTPS (Tailscale Serve) 或在网关主机上打开 {url}。",
      stayHttp: "如果您必须保持 HTTP，请设置 {config} (仅限令牌)。",
    },
  },
  chat: {
    disconnected: "已断开与网关的连接。",
    refreshTitle: "刷新聊天数据",
    thinkingToggle: "切换助手思考/工作输出",
    focusToggle: "切换专注模式 (隐藏侧边栏 + 页面页眉)",
    onboardingDisabled: "引导期间禁用",
  },
  languages: {
    en: "English",
    zhCN: "简体中文 (简体中文)",
    zhTW: "繁體中文 (繁体中文)",
    ptBR: "Português (巴西葡萄牙语)",
  },
};
