import type { TranslationMap } from "../lib/types.ts";

export const pt_BR: TranslationMap = {
  common: {
    version: "Versão",
    health: "Saúde",
    ok: "OK",
    offline: "Offline",
    connect: "Conectar",
    refresh: "Atualizar",
    enabled: "Ativado",
    disabled: "Desativado",
    na: "n/a",
    docs: "Docs",
    resources: "Recursos",
  },
  nav: {
    chat: "Chat",
    control: "Controle",
    agent: "Agente",
    settings: "Configurações",
    expand: "Expandir barra lateral",
    collapse: "Recolher barra lateral",
  },
  tabs: {
    agents: "Agentes",
    overview: "Visão Geral",
    channels: "Canais",
    instances: "Instâncias",
    sessions: "Sessões",
    usage: "Uso",
    cron: "Tarefas Cron",
    skills: "Habilidades",
    nodes: "Nós",
    chat: "Chat",
    config: "Config",
    debug: "Debug",
    logs: "Logs",
  },
  subtitles: {
    agents: "Gerenciar espaços de trabalho, ferramentas e identidades de agentes.",
    overview: "Status do gateway, pontos de entrada e leitura rápida de saúde.",
    channels: "Gerenciar canais e configurações.",
    instances: "Beacons de presença de clientes e nós conectados.",
    sessions: "Inspecionar sessões ativas e ajustar padrões por sessão.",
    usage: "Monitorar uso e custos da API.",
    cron: "Agendar despertares e execuções recorrentes de agentes.",
    skills: "Gerenciar disponibilidade de habilidades e injeção de chaves de API.",
    nodes: "Dispositivos pareados, capacidades e exposição de comandos.",
    chat: "Sessão de chat direta com o gateway para intervenções rápidas.",
    config: "Editar ~/.openclaw/openclaw.json com segurança.",
    debug: "Snapshots do gateway, eventos e chamadas RPC manuais.",
    logs: "Acompanhamento ao vivo dos logs de arquivo do gateway.",
  },
  overview: {
    access: {
      title: "Acesso ao Gateway",
      subtitle: "Onde o dashboard se conecta e como ele se autentica.",
      wsUrl: "URL WebSocket",
      token: "Token do Gateway",
      password: "Senha (não armazenada)",
      sessionKey: "Chave de Sessão Padrão",
      language: "Idioma",
      connectHint: "Clique em Conectar para aplicar as alterações de conexão.",
      trustedProxy: "Autenticado por proxy confiável.",
    },
    snapshot: {
      title: "Snapshot",
      subtitle: "Informações mais recentes do handshake do gateway.",
      status: "Status",
      uptime: "Tempo de Atividade",
      tickInterval: "Intervalo de Tick",
      lastChannelsRefresh: "Última Atualização de Canais",
      channelsHint: "Use Canais para vincular WhatsApp, Telegram, Discord, Signal ou iMessage.",
    },
    stats: {
      instances: "Instâncias",
      instancesHint: "Beacons de presença nos últimos 5 minutos.",
      sessions: "Sessões",
      sessionsHint: "Chaves de sessão recentes rastreadas pelo gateway.",
      cron: "Cron",
      cronNext: "Próximo despertar {time}",
    },
    notes: {
      title: "Notas",
      subtitle: "Lembretes rápidos para configurações de controle remoto.",
      tailscaleTitle: "Tailscale serve",
      tailscaleText:
        "Prefira o modo serve para manter o gateway em loopback com autenticação tailnet.",
      sessionTitle: "Higiene de sessão",
      sessionText: "Use /new ou sessions.patch para redefinir o contexto.",
      cronTitle: "Lembretes de Cron",
      cronText: "Use sessões isoladas para execuções recorrentes.",
    },
    auth: {
      required:
        "Este gateway requer autenticação. Adicione um token ou senha e clique em Conectar.",
      failed:
        "Falha na autenticação. Recopie uma URL com token usando {command}, ou atualize o token e clique em Conectar.",
    },
    pairing: {
      hint: "Este dispositivo precisa de aprovação de pareamento do host do gateway.",
      mobileHint:
        "No celular? Copie a URL completa (incluindo #token=...) executando openclaw dashboard --no-open no desktop.",
    },
    insecure: {
      hint: "Esta página é HTTP, então o navegador bloqueia a identidade do dispositivo. Use HTTPS (Tailscale Serve) ou abra {url} no host do gateway.",
      stayHttp: "Se você precisar permanecer em HTTP, defina {config} (apenas token).",
    },
  },
  chat: {
    disconnected: "Desconectado do gateway.",
    refreshTitle: "Atualizar dados do chat",
    thinkingToggle: "Alternar saída de pensamento/trabalho do assistente",
    focusToggle: "Alternar modo de foco (ocultar barra lateral + cabeçalho da página)",
    onboardingDisabled: "Desativado durante a integração",
  },
  languages: {
    en: "English",
    zhCN: "简体中文 (Chinês Simplificado)",
    zhTW: "繁體中文 (Chinês Tradicional)",
    ptBR: "Português (Português Brasileiro)",
  },
};
