import { IRC_FIELD_LABELS } from "./schema.irc.js";

export const FIELD_LABELS: Record<string, string> = {
  meta: "Metadata",
  "meta.lastTouchedVersion": "Config Last Touched Version",
  "meta.lastTouchedAt": "Config Last Touched At",
  env: "Environment",
  "env.shellEnv": "Shell Environment Import",
  "env.shellEnv.enabled": "Shell Environment Import Enabled",
  "env.shellEnv.timeoutMs": "Shell Environment Import Timeout (ms)",
  "env.vars": "Environment Variable Overrides",
  wizard: "Setup Wizard State",
  "wizard.lastRunAt": "Wizard Last Run Timestamp",
  "wizard.lastRunVersion": "Wizard Last Run Version",
  "wizard.lastRunCommit": "Wizard Last Run Commit",
  "wizard.lastRunCommand": "Wizard Last Run Command",
  "wizard.lastRunMode": "Wizard Last Run Mode",
  diagnostics: "Diagnostics",
  "diagnostics.otel": "OpenTelemetry",
  "diagnostics.cacheTrace": "Cache Trace",
  logging: "Logging",
  "logging.level": "Log Level",
  "logging.file": "Log File Path",
  "logging.consoleLevel": "Console Log Level",
  "logging.consoleStyle": "Console Log Style",
  "logging.redactSensitive": "Sensitive Data Redaction Mode",
  "logging.redactPatterns": "Custom Redaction Patterns",
  update: "Updates",
  "update.channel": "Update Channel",
  "update.checkOnStart": "Update Check on Start",
  "update.auto.enabled": "Auto Update Enabled",
  "update.auto.stableDelayHours": "Auto Update Stable Delay (hours)",
  "update.auto.stableJitterHours": "Auto Update Stable Jitter (hours)",
  "update.auto.betaCheckIntervalHours": "Auto Update Beta Check Interval (hours)",
  "diagnostics.enabled": "Diagnostics Enabled",
  "diagnostics.flags": "Diagnostics Flags",
  "diagnostics.otel.enabled": "OpenTelemetry Enabled",
  "diagnostics.otel.endpoint": "OpenTelemetry Endpoint",
  "diagnostics.otel.protocol": "OpenTelemetry Protocol",
  "diagnostics.otel.headers": "OpenTelemetry Headers",
  "diagnostics.otel.serviceName": "OpenTelemetry Service Name",
  "diagnostics.otel.traces": "OpenTelemetry Traces Enabled",
  "diagnostics.otel.metrics": "OpenTelemetry Metrics Enabled",
  "diagnostics.otel.logs": "OpenTelemetry Logs Enabled",
  "diagnostics.otel.sampleRate": "OpenTelemetry Trace Sample Rate",
  "diagnostics.otel.flushIntervalMs": "OpenTelemetry Flush Interval (ms)",
  "diagnostics.cacheTrace.enabled": "Cache Trace Enabled",
  "diagnostics.cacheTrace.filePath": "Cache Trace File Path",
  "diagnostics.cacheTrace.includeMessages": "Cache Trace Include Messages",
  "diagnostics.cacheTrace.includePrompt": "Cache Trace Include Prompt",
  "diagnostics.cacheTrace.includeSystem": "Cache Trace Include System",
  "agents.list.*.identity.avatar": "Identity Avatar",
  "agents.list.*.skills": "Agent Skill Filter",
  agents: "Agents",
  "agents.defaults": "Agent Defaults",
  "agents.list": "Agent List",
  gateway: "Gateway",
  "gateway.port": "Gateway Port",
  "gateway.mode": "Gateway Mode",
  "gateway.bind": "Gateway Bind Mode",
  "gateway.customBindHost": "Gateway Custom Bind Host",
  "gateway.controlUi": "Control UI",
  "gateway.controlUi.enabled": "Control UI Enabled",
  "gateway.auth": "Gateway Auth",
  "gateway.auth.mode": "Gateway Auth Mode",
  "gateway.auth.allowTailscale": "Gateway Auth Allow Tailscale Identity",
  "gateway.auth.rateLimit": "Gateway Auth Rate Limit",
  "gateway.auth.trustedProxy": "Gateway Trusted Proxy Auth",
  "gateway.trustedProxies": "Gateway Trusted Proxy CIDRs",
  "gateway.allowRealIpFallback": "Gateway Allow x-real-ip Fallback",
  "gateway.tools": "Gateway Tool Exposure Policy",
  "gateway.tools.allow": "Gateway Tool Allowlist",
  "gateway.tools.deny": "Gateway Tool Denylist",
  "gateway.channelHealthCheckMinutes": "Gateway Channel Health Check Interval (min)",
  "gateway.tailscale": "Gateway Tailscale",
  "gateway.tailscale.mode": "Gateway Tailscale Mode",
  "gateway.tailscale.resetOnExit": "Gateway Tailscale Reset on Exit",
  "gateway.remote": "Remote Gateway",
  "gateway.remote.transport": "Remote Gateway Transport",
  "gateway.reload": "Config Reload",
  "gateway.tls": "Gateway TLS",
  "gateway.tls.enabled": "Gateway TLS Enabled",
  "gateway.tls.autoGenerate": "Gateway TLS Auto-Generate Cert",
  "gateway.tls.certPath": "Gateway TLS Certificate Path",
  "gateway.tls.keyPath": "Gateway TLS Key Path",
  "gateway.tls.caPath": "Gateway TLS CA Path",
  "gateway.http": "Gateway HTTP API",
  "gateway.http.endpoints": "Gateway HTTP Endpoints",
  "gateway.http.securityHeaders": "Gateway HTTP Security Headers",
  "gateway.http.securityHeaders.strictTransportSecurity": "Strict Transport Security Header",
  "gateway.remote.url": "Remote Gateway URL",
  "gateway.remote.sshTarget": "Remote Gateway SSH Target",
  "gateway.remote.sshIdentity": "Remote Gateway SSH Identity",
  "gateway.remote.token": "Remote Gateway Token",
  "gateway.remote.password": "Remote Gateway Password",
  "gateway.remote.tlsFingerprint": "Remote Gateway TLS Fingerprint",
  "gateway.auth.token": "Gateway Token",
  "gateway.auth.password": "Gateway Password",
  browser: "Browser",
  "browser.enabled": "Browser Enabled",
  "browser.cdpUrl": "Browser CDP URL",
  "browser.color": "Browser Accent Color",
  "browser.executablePath": "Browser Executable Path",
  "browser.headless": "Browser Headless Mode",
  "browser.noSandbox": "Browser No-Sandbox Mode",
  "browser.attachOnly": "Browser Attach-only Mode",
  "browser.defaultProfile": "Browser Default Profile",
  "browser.profiles": "Browser Profiles",
  "browser.profiles.*.cdpPort": "Browser Profile CDP Port",
  "browser.profiles.*.cdpUrl": "Browser Profile CDP URL",
  "browser.profiles.*.driver": "Browser Profile Driver",
  "browser.profiles.*.color": "Browser Profile Accent Color",
  tools: "Tools",
  "tools.allow": "Tool Allowlist",
  "tools.deny": "Tool Denylist",
  "tools.web": "Web Tools",
  "tools.exec": "Exec Tool",
  "tools.media.image.enabled": "Enable Image Understanding",
  "tools.media.image.maxBytes": "Image Understanding Max Bytes",
  "tools.media.image.maxChars": "Image Understanding Max Chars",
  "tools.media.image.prompt": "Image Understanding Prompt",
  "tools.media.image.timeoutSeconds": "Image Understanding Timeout (sec)",
  "tools.media.image.attachments": "Image Understanding Attachment Policy",
  "tools.media.image.models": "Image Understanding Models",
  "tools.media.image.scope": "Image Understanding Scope",
  "tools.media.models": "Media Understanding Shared Models",
  "tools.media.concurrency": "Media Understanding Concurrency",
  "tools.media.audio.enabled": "Enable Audio Understanding",
  "tools.media.audio.maxBytes": "Audio Understanding Max Bytes",
  "tools.media.audio.maxChars": "Audio Understanding Max Chars",
  "tools.media.audio.prompt": "Audio Understanding Prompt",
  "tools.media.audio.timeoutSeconds": "Audio Understanding Timeout (sec)",
  "tools.media.audio.language": "Audio Understanding Language",
  "tools.media.audio.attachments": "Audio Understanding Attachment Policy",
  "tools.media.audio.models": "Audio Understanding Models",
  "tools.media.audio.scope": "Audio Understanding Scope",
  "tools.media.video.enabled": "Enable Video Understanding",
  "tools.media.video.maxBytes": "Video Understanding Max Bytes",
  "tools.media.video.maxChars": "Video Understanding Max Chars",
  "tools.media.video.prompt": "Video Understanding Prompt",
  "tools.media.video.timeoutSeconds": "Video Understanding Timeout (sec)",
  "tools.media.video.attachments": "Video Understanding Attachment Policy",
  "tools.media.video.models": "Video Understanding Models",
  "tools.media.video.scope": "Video Understanding Scope",
  "tools.links.enabled": "Enable Link Understanding",
  "tools.links.maxLinks": "Link Understanding Max Links",
  "tools.links.timeoutSeconds": "Link Understanding Timeout (sec)",
  "tools.links.models": "Link Understanding Models",
  "tools.links.scope": "Link Understanding Scope",
  "tools.profile": "Tool Profile",
  "tools.alsoAllow": "Tool Allowlist Additions",
  "agents.list[].tools.profile": "Agent Tool Profile",
  "agents.list[].tools.alsoAllow": "Agent Tool Allowlist Additions",
  "tools.byProvider": "Tool Policy by Provider",
  "agents.list[].tools.byProvider": "Agent Tool Policy by Provider",
  "tools.exec.applyPatch.enabled": "Enable apply_patch",
  "tools.exec.applyPatch.workspaceOnly": "apply_patch Workspace-Only",
  "tools.exec.applyPatch.allowModels": "apply_patch Model Allowlist",
  "tools.loopDetection.enabled": "Tool-loop Detection",
  "tools.loopDetection.historySize": "Tool-loop History Size",
  "tools.loopDetection.warningThreshold": "Tool-loop Warning Threshold",
  "tools.loopDetection.criticalThreshold": "Tool-loop Critical Threshold",
  "tools.loopDetection.globalCircuitBreakerThreshold": "Tool-loop Global Circuit Breaker Threshold",
  "tools.loopDetection.detectors.genericRepeat": "Tool-loop Generic Repeat Detection",
  "tools.loopDetection.detectors.knownPollNoProgress": "Tool-loop Poll No-Progress Detection",
  "tools.loopDetection.detectors.pingPong": "Tool-loop Ping-Pong Detection",
  "tools.fs.workspaceOnly": "Workspace-only FS tools",
  "tools.sessions.visibility": "Session Tools Visibility",
  "tools.exec.notifyOnExit": "Exec Notify On Exit",
  "tools.exec.notifyOnExitEmptySuccess": "Exec Notify On Empty Success",
  "tools.exec.approvalRunningNoticeMs": "Exec Approval Running Notice (ms)",
  "tools.exec.host": "Exec Host",
  "tools.exec.security": "Exec Security",
  "tools.exec.ask": "Exec Ask",
  "tools.exec.node": "Exec Node Binding",
  "tools.agentToAgent": "Agent-to-Agent Tool Access",
  "tools.agentToAgent.enabled": "Enable Agent-to-Agent Tool",
  "tools.agentToAgent.allow": "Agent-to-Agent Target Allowlist",
  "tools.elevated": "Elevated Tool Access",
  "tools.elevated.enabled": "Enable Elevated Tool Access",
  "tools.elevated.allowFrom": "Elevated Tool Allow Rules",
  "tools.subagents": "Subagent Tool Policy",
  "tools.subagents.tools": "Subagent Tool Allow/Deny Policy",
  "tools.sandbox": "Sandbox Tool Policy",
  "tools.sandbox.tools": "Sandbox Tool Allow/Deny Policy",
  "tools.exec.pathPrepend": "Exec PATH Prepend",
  "tools.exec.safeBins": "Exec Safe Bins",
  "tools.exec.safeBinTrustedDirs": "Exec Safe Bin Trusted Dirs",
  "tools.exec.safeBinProfiles": "Exec Safe Bin Profiles",
  approvals: "Approvals",
  "approvals.exec": "Exec Approval Forwarding",
  "approvals.exec.enabled": "Forward Exec Approvals",
  "approvals.exec.mode": "Approval Forwarding Mode",
  "approvals.exec.agentFilter": "Approval Agent Filter",
  "approvals.exec.sessionFilter": "Approval Session Filter",
  "approvals.exec.targets": "Approval Forwarding Targets",
  "approvals.exec.targets[].channel": "Approval Target Channel",
  "approvals.exec.targets[].to": "Approval Target Destination",
  "approvals.exec.targets[].accountId": "Approval Target Account ID",
  "approvals.exec.targets[].threadId": "Approval Target Thread ID",
  "tools.message.allowCrossContextSend": "Allow Cross-Context Messaging",
  "tools.message.crossContext.allowWithinProvider": "Allow Cross-Context (Same Provider)",
  "tools.message.crossContext.allowAcrossProviders": "Allow Cross-Context (Across Providers)",
  "tools.message.crossContext.marker.enabled": "Cross-Context Marker",
  "tools.message.crossContext.marker.prefix": "Cross-Context Marker Prefix",
  "tools.message.crossContext.marker.suffix": "Cross-Context Marker Suffix",
  "tools.message.broadcast.enabled": "Enable Message Broadcast",
  "tools.web.search.enabled": "Enable Web Search Tool",
  "tools.web.search.provider": "Web Search Provider",
  "tools.web.search.apiKey": "Brave Search API Key",
  "tools.web.search.maxResults": "Web Search Max Results",
  "tools.web.search.timeoutSeconds": "Web Search Timeout (sec)",
  "tools.web.search.cacheTtlMinutes": "Web Search Cache TTL (min)",
  "tools.web.search.perplexity.apiKey": "Perplexity API Key",
  "tools.web.search.perplexity.baseUrl": "Perplexity Base URL",
  "tools.web.search.perplexity.model": "Perplexity Model",
  "tools.web.search.gemini.apiKey": "Gemini Search API Key",
  "tools.web.search.gemini.model": "Gemini Search Model",
  "tools.web.search.grok.apiKey": "Grok Search API Key",
  "tools.web.search.grok.model": "Grok Search Model",
  "tools.web.search.kimi.apiKey": "Kimi Search API Key",
  "tools.web.search.kimi.baseUrl": "Kimi Search Base URL",
  "tools.web.search.kimi.model": "Kimi Search Model",
  "tools.web.fetch.enabled": "Enable Web Fetch Tool",
  "tools.web.fetch.maxChars": "Web Fetch Max Chars",
  "tools.web.fetch.maxCharsCap": "Web Fetch Hard Max Chars",
  "tools.web.fetch.timeoutSeconds": "Web Fetch Timeout (sec)",
  "tools.web.fetch.cacheTtlMinutes": "Web Fetch Cache TTL (min)",
  "tools.web.fetch.maxRedirects": "Web Fetch Max Redirects",
  "tools.web.fetch.userAgent": "Web Fetch User-Agent",
  "tools.web.fetch.readability": "Web Fetch Readability Extraction",
  "tools.web.fetch.firecrawl.enabled": "Enable Firecrawl Fallback",
  "tools.web.fetch.firecrawl.apiKey": "Firecrawl API Key",
  "tools.web.fetch.firecrawl.baseUrl": "Firecrawl Base URL",
  "tools.web.fetch.firecrawl.onlyMainContent": "Firecrawl Main Content Only",
  "tools.web.fetch.firecrawl.maxAgeMs": "Firecrawl Cache Max Age (ms)",
  "tools.web.fetch.firecrawl.timeoutSeconds": "Firecrawl Timeout (sec)",
  "gateway.controlUi.basePath": "Control UI Base Path",
  "gateway.controlUi.root": "Control UI Assets Root",
  "gateway.controlUi.allowedOrigins": "Control UI Allowed Origins",
  "gateway.controlUi.dangerouslyAllowHostHeaderOriginFallback":
    "Dangerously Allow Host-Header Origin Fallback",
  "gateway.controlUi.allowInsecureAuth": "Insecure Control UI Auth Toggle",
  "gateway.controlUi.dangerouslyDisableDeviceAuth": "Dangerously Disable Control UI Device Auth",
  "gateway.http.endpoints.chatCompletions.enabled": "OpenAI Chat Completions Endpoint",
  "gateway.reload.mode": "Config Reload Mode",
  "gateway.reload.debounceMs": "Config Reload Debounce (ms)",
  "gateway.nodes.browser.mode": "Gateway Node Browser Mode",
  "gateway.nodes.browser.node": "Gateway Node Browser Pin",
  "gateway.nodes.allowCommands": "Gateway Node Allowlist (Extra Commands)",
  "gateway.nodes.denyCommands": "Gateway Node Denylist",
  nodeHost: "Node Host",
  "nodeHost.browserProxy": "Node Browser Proxy",
  "nodeHost.browserProxy.enabled": "Node Browser Proxy Enabled",
  "nodeHost.browserProxy.allowProfiles": "Node Browser Proxy Allowed Profiles",
  media: "Media",
  "media.preserveFilenames": "Preserve Media Filenames",
  audio: "Audio",
  "audio.transcription": "Audio Transcription",
  "audio.transcription.command": "Audio Transcription Command",
  "audio.transcription.timeoutSeconds": "Audio Transcription Timeout (sec)",
  bindings: "Bindings",
  "bindings[].agentId": "Binding Agent ID",
  "bindings[].match": "Binding Match Rule",
  "bindings[].match.channel": "Binding Channel",
  "bindings[].match.accountId": "Binding Account ID",
  "bindings[].match.peer": "Binding Peer Match",
  "bindings[].match.peer.kind": "Binding Peer Kind",
  "bindings[].match.peer.id": "Binding Peer ID",
  "bindings[].match.guildId": "Binding Guild ID",
  "bindings[].match.teamId": "Binding Team ID",
  "bindings[].match.roles": "Binding Roles",
  broadcast: "Broadcast",
  "broadcast.strategy": "Broadcast Strategy",
  "broadcast.*": "Broadcast Destination List",
  "skills.load.watch": "Watch Skills",
  "skills.load.watchDebounceMs": "Skills Watch Debounce (ms)",
  "agents.defaults.workspace": "Workspace",
  "agents.defaults.repoRoot": "Repo Root",
  "agents.defaults.bootstrapMaxChars": "Bootstrap Max Chars",
  "agents.defaults.bootstrapTotalMaxChars": "Bootstrap Total Max Chars",
  "agents.defaults.envelopeTimezone": "Envelope Timezone",
  "agents.defaults.envelopeTimestamp": "Envelope Timestamp",
  "agents.defaults.envelopeElapsed": "Envelope Elapsed",
  "agents.defaults.memorySearch": "Memory Search",
  "agents.defaults.memorySearch.enabled": "Enable Memory Search",
  "agents.defaults.memorySearch.sources": "Memory Search Sources",
  "agents.defaults.memorySearch.extraPaths": "Extra Memory Paths",
  "agents.defaults.memorySearch.experimental.sessionMemory":
    "Memory Search Session Index (Experimental)",
  "agents.defaults.memorySearch.provider": "Memory Search Provider",
  "agents.defaults.memorySearch.remote.baseUrl": "Remote Embedding Base URL",
  "agents.defaults.memorySearch.remote.apiKey": "Remote Embedding API Key",
  "agents.defaults.memorySearch.remote.headers": "Remote Embedding Headers",
  "agents.defaults.memorySearch.remote.batch.enabled": "Remote Batch Embedding Enabled",
  "agents.defaults.memorySearch.remote.batch.wait": "Remote Batch Wait for Completion",
  "agents.defaults.memorySearch.remote.batch.concurrency": "Remote Batch Concurrency",
  "agents.defaults.memorySearch.remote.batch.pollIntervalMs": "Remote Batch Poll Interval (ms)",
  "agents.defaults.memorySearch.remote.batch.timeoutMinutes": "Remote Batch Timeout (min)",
  "agents.defaults.memorySearch.model": "Memory Search Model",
  "agents.defaults.memorySearch.fallback": "Memory Search Fallback",
  "agents.defaults.memorySearch.local.modelPath": "Local Embedding Model Path",
  "agents.defaults.memorySearch.store.path": "Memory Search Index Path",
  "agents.defaults.memorySearch.store.vector.enabled": "Memory Search Vector Index",
  "agents.defaults.memorySearch.store.vector.extensionPath": "Memory Search Vector Extension Path",
  "agents.defaults.memorySearch.chunking.tokens": "Memory Chunk Tokens",
  "agents.defaults.memorySearch.chunking.overlap": "Memory Chunk Overlap Tokens",
  "agents.defaults.memorySearch.sync.onSessionStart": "Index on Session Start",
  "agents.defaults.memorySearch.sync.onSearch": "Index on Search (Lazy)",
  "agents.defaults.memorySearch.sync.watch": "Watch Memory Files",
  "agents.defaults.memorySearch.sync.watchDebounceMs": "Memory Watch Debounce (ms)",
  "agents.defaults.memorySearch.sync.sessions.deltaBytes": "Session Delta Bytes",
  "agents.defaults.memorySearch.sync.sessions.deltaMessages": "Session Delta Messages",
  "agents.defaults.memorySearch.query.maxResults": "Memory Search Max Results",
  "agents.defaults.memorySearch.query.minScore": "Memory Search Min Score",
  "agents.defaults.memorySearch.query.hybrid.enabled": "Memory Search Hybrid",
  "agents.defaults.memorySearch.query.hybrid.vectorWeight": "Memory Search Vector Weight",
  "agents.defaults.memorySearch.query.hybrid.textWeight": "Memory Search Text Weight",
  "agents.defaults.memorySearch.query.hybrid.candidateMultiplier":
    "Memory Search Hybrid Candidate Multiplier",
  "agents.defaults.memorySearch.query.hybrid.mmr.enabled": "Memory Search MMR Re-ranking",
  "agents.defaults.memorySearch.query.hybrid.mmr.lambda": "Memory Search MMR Lambda",
  "agents.defaults.memorySearch.query.hybrid.temporalDecay.enabled": "Memory Search Temporal Decay",
  "agents.defaults.memorySearch.query.hybrid.temporalDecay.halfLifeDays":
    "Memory Search Temporal Decay Half-life (Days)",
  "agents.defaults.memorySearch.cache.enabled": "Memory Search Embedding Cache",
  "agents.defaults.memorySearch.cache.maxEntries": "Memory Search Embedding Cache Max Entries",
  memory: "Memory",
  "memory.backend": "Memory Backend",
  "memory.citations": "Memory Citations Mode",
  "memory.qmd.command": "QMD Binary",
  "memory.qmd.mcporter": "QMD MCPorter",
  "memory.qmd.mcporter.enabled": "QMD MCPorter Enabled",
  "memory.qmd.mcporter.serverName": "QMD MCPorter Server Name",
  "memory.qmd.mcporter.startDaemon": "QMD MCPorter Start Daemon",
  "memory.qmd.searchMode": "QMD Search Mode",
  "memory.qmd.includeDefaultMemory": "QMD Include Default Memory",
  "memory.qmd.paths": "QMD Extra Paths",
  "memory.qmd.paths.path": "QMD Path",
  "memory.qmd.paths.pattern": "QMD Path Pattern",
  "memory.qmd.paths.name": "QMD Path Name",
  "memory.qmd.sessions.enabled": "QMD Session Indexing",
  "memory.qmd.sessions.exportDir": "QMD Session Export Directory",
  "memory.qmd.sessions.retentionDays": "QMD Session Retention (days)",
  "memory.qmd.update.interval": "QMD Update Interval",
  "memory.qmd.update.debounceMs": "QMD Update Debounce (ms)",
  "memory.qmd.update.onBoot": "QMD Update on Startup",
  "memory.qmd.update.waitForBootSync": "QMD Wait for Boot Sync",
  "memory.qmd.update.embedInterval": "QMD Embed Interval",
  "memory.qmd.update.commandTimeoutMs": "QMD Command Timeout (ms)",
  "memory.qmd.update.updateTimeoutMs": "QMD Update Timeout (ms)",
  "memory.qmd.update.embedTimeoutMs": "QMD Embed Timeout (ms)",
  "memory.qmd.limits.maxResults": "QMD Max Results",
  "memory.qmd.limits.maxSnippetChars": "QMD Max Snippet Chars",
  "memory.qmd.limits.maxInjectedChars": "QMD Max Injected Chars",
  "memory.qmd.limits.timeoutMs": "QMD Search Timeout (ms)",
  "memory.qmd.scope": "QMD Surface Scope",
  auth: "Auth",
  "auth.profiles": "Auth Profiles",
  "auth.order": "Auth Profile Order",
  "auth.cooldowns": "Auth Cooldowns",
  models: "Models",
  "models.mode": "Model Catalog Mode",
  "models.providers": "Model Providers",
  "models.providers.*.baseUrl": "Model Provider Base URL",
  "models.providers.*.apiKey": "Model Provider API Key",
  "models.providers.*.auth": "Model Provider Auth Mode",
  "models.providers.*.api": "Model Provider API Adapter",
  "models.providers.*.headers": "Model Provider Headers",
  "models.providers.*.authHeader": "Model Provider Authorization Header",
  "models.providers.*.models": "Model Provider Model List",
  "models.bedrockDiscovery": "Bedrock Model Discovery",
  "models.bedrockDiscovery.enabled": "Bedrock Discovery Enabled",
  "models.bedrockDiscovery.region": "Bedrock Discovery Region",
  "models.bedrockDiscovery.providerFilter": "Bedrock Discovery Provider Filter",
  "models.bedrockDiscovery.refreshInterval": "Bedrock Discovery Refresh Interval (s)",
  "models.bedrockDiscovery.defaultContextWindow": "Bedrock Default Context Window",
  "models.bedrockDiscovery.defaultMaxTokens": "Bedrock Default Max Tokens",
  "auth.cooldowns.billingBackoffHours": "Billing Backoff (hours)",
  "auth.cooldowns.billingBackoffHoursByProvider": "Billing Backoff Overrides",
  "auth.cooldowns.billingMaxHours": "Billing Backoff Cap (hours)",
  "auth.cooldowns.failureWindowHours": "Failover Window (hours)",
  "agents.defaults.models": "Models",
  "agents.defaults.model.primary": "Primary Model",
  "agents.defaults.model.fallbacks": "Model Fallbacks",
  "agents.defaults.imageModel.primary": "Image Model",
  "agents.defaults.imageModel.fallbacks": "Image Model Fallbacks",
  "agents.defaults.imageMaxDimensionPx": "Image Max Dimension (px)",
  "agents.defaults.humanDelay.mode": "Human Delay Mode",
  "agents.defaults.humanDelay.minMs": "Human Delay Min (ms)",
  "agents.defaults.humanDelay.maxMs": "Human Delay Max (ms)",
  "agents.defaults.cliBackends": "CLI Backends",
  "agents.defaults.compaction": "Compaction",
  "agents.defaults.compaction.mode": "Compaction Mode",
  "agents.defaults.compaction.reserveTokens": "Compaction Reserve Tokens",
  "agents.defaults.compaction.keepRecentTokens": "Compaction Keep Recent Tokens",
  "agents.defaults.compaction.reserveTokensFloor": "Compaction Reserve Token Floor",
  "agents.defaults.compaction.maxHistoryShare": "Compaction Max History Share",
  "agents.defaults.compaction.memoryFlush": "Compaction Memory Flush",
  "agents.defaults.compaction.memoryFlush.enabled": "Compaction Memory Flush Enabled",
  "agents.defaults.compaction.memoryFlush.softThresholdTokens":
    "Compaction Memory Flush Soft Threshold",
  "agents.defaults.compaction.memoryFlush.prompt": "Compaction Memory Flush Prompt",
  "agents.defaults.compaction.memoryFlush.systemPrompt": "Compaction Memory Flush System Prompt",
  "agents.defaults.heartbeat.suppressToolErrorWarnings": "Heartbeat Suppress Tool Error Warnings",
  "agents.defaults.sandbox.browser.network": "Sandbox Browser Network",
  "agents.defaults.sandbox.browser.cdpSourceRange": "Sandbox Browser CDP Source Port Range",
  commands: "Commands",
  "commands.native": "Native Commands",
  "commands.nativeSkills": "Native Skill Commands",
  "commands.text": "Text Commands",
  "commands.bash": "Allow Bash Chat Command",
  "commands.bashForegroundMs": "Bash Foreground Window (ms)",
  "commands.config": "Allow /config",
  "commands.debug": "Allow /debug",
  "commands.restart": "Allow Restart",
  "commands.useAccessGroups": "Use Access Groups",
  "commands.ownerAllowFrom": "Command Owners",
  "commands.ownerDisplay": "Owner ID Display",
  "commands.ownerDisplaySecret": "Owner ID Hash Secret",
  "commands.allowFrom": "Command Elevated Access Rules",
  ui: "UI",
  "ui.seamColor": "Accent Color",
  "ui.assistant": "Assistant Appearance",
  "ui.assistant.name": "Assistant Name",
  "ui.assistant.avatar": "Assistant Avatar",
  "browser.evaluateEnabled": "Browser Evaluate Enabled",
  "browser.snapshotDefaults": "Browser Snapshot Defaults",
  "browser.snapshotDefaults.mode": "Browser Snapshot Mode",
  "browser.ssrfPolicy": "Browser SSRF Policy",
  "browser.ssrfPolicy.allowPrivateNetwork": "Browser Allow Private Network",
  "browser.ssrfPolicy.dangerouslyAllowPrivateNetwork": "Browser Dangerously Allow Private Network",
  "browser.ssrfPolicy.allowedHostnames": "Browser Allowed Hostnames",
  "browser.ssrfPolicy.hostnameAllowlist": "Browser Hostname Allowlist",
  "browser.remoteCdpTimeoutMs": "Remote CDP Timeout (ms)",
  "browser.remoteCdpHandshakeTimeoutMs": "Remote CDP Handshake Timeout (ms)",
  session: "Session",
  "session.scope": "Session Scope",
  "session.dmScope": "DM Session Scope",
  "session.identityLinks": "Session Identity Links",
  "session.resetTriggers": "Session Reset Triggers",
  "session.idleMinutes": "Session Idle Minutes",
  "session.reset": "Session Reset Policy",
  "session.reset.mode": "Session Reset Mode",
  "session.reset.atHour": "Session Daily Reset Hour",
  "session.reset.idleMinutes": "Session Reset Idle Minutes",
  "session.resetByType": "Session Reset by Chat Type",
  "session.resetByType.direct": "Session Reset (Direct)",
  "session.resetByType.dm": "Session Reset (DM Deprecated Alias)",
  "session.resetByType.group": "Session Reset (Group)",
  "session.resetByType.thread": "Session Reset (Thread)",
  "session.resetByChannel": "Session Reset by Channel",
  "session.store": "Session Store Path",
  "session.typingIntervalSeconds": "Session Typing Interval (seconds)",
  "session.typingMode": "Session Typing Mode",
  "session.mainKey": "Session Main Key",
  "session.sendPolicy": "Session Send Policy",
  "session.sendPolicy.default": "Session Send Policy Default Action",
  "session.sendPolicy.rules": "Session Send Policy Rules",
  "session.sendPolicy.rules[].action": "Session Send Rule Action",
  "session.sendPolicy.rules[].match": "Session Send Rule Match",
  "session.sendPolicy.rules[].match.channel": "Session Send Rule Channel",
  "session.sendPolicy.rules[].match.chatType": "Session Send Rule Chat Type",
  "session.sendPolicy.rules[].match.keyPrefix": "Session Send Rule Key Prefix",
  "session.sendPolicy.rules[].match.rawKeyPrefix": "Session Send Rule Raw Key Prefix",
  "session.agentToAgent": "Session Agent-to-Agent",
  "session.agentToAgent.maxPingPongTurns": "Agent-to-Agent Ping-Pong Turns",
  "session.threadBindings": "Session Thread Bindings",
  "session.threadBindings.enabled": "Thread Binding Enabled",
  "session.threadBindings.ttlHours": "Thread Binding TTL (hours)",
  "session.maintenance": "Session Maintenance",
  "session.maintenance.mode": "Session Maintenance Mode",
  "session.maintenance.pruneAfter": "Session Prune After",
  "session.maintenance.pruneDays": "Session Prune Days (Deprecated)",
  "session.maintenance.maxEntries": "Session Max Entries",
  "session.maintenance.rotateBytes": "Session Rotate Size",
  "session.maintenance.resetArchiveRetention": "Session Reset Archive Retention",
  "session.maintenance.maxDiskBytes": "Session Max Disk Budget",
  "session.maintenance.highWaterBytes": "Session Disk High-water Target",
  cron: "Cron",
  "cron.enabled": "Cron Enabled",
  "cron.store": "Cron Store Path",
  "cron.maxConcurrentRuns": "Cron Max Concurrent Runs",
  "cron.webhook": "Cron Legacy Webhook (Deprecated)",
  "cron.webhookToken": "Cron Webhook Bearer Token",
  "cron.sessionRetention": "Cron Session Retention",
  "cron.runLog": "Cron Run Log Pruning",
  "cron.runLog.maxBytes": "Cron Run Log Max Bytes",
  "cron.runLog.keepLines": "Cron Run Log Keep Lines",
  hooks: "Hooks",
  "hooks.enabled": "Hooks Enabled",
  "hooks.path": "Hooks Endpoint Path",
  "hooks.token": "Hooks Auth Token",
  "hooks.defaultSessionKey": "Hooks Default Session Key",
  "hooks.allowRequestSessionKey": "Hooks Allow Request Session Key",
  "hooks.allowedSessionKeyPrefixes": "Hooks Allowed Session Key Prefixes",
  "hooks.allowedAgentIds": "Hooks Allowed Agent IDs",
  "hooks.maxBodyBytes": "Hooks Max Body Bytes",
  "hooks.presets": "Hooks Presets",
  "hooks.transformsDir": "Hooks Transforms Directory",
  "hooks.mappings": "Hook Mappings",
  "hooks.mappings[].id": "Hook Mapping ID",
  "hooks.mappings[].match": "Hook Mapping Match",
  "hooks.mappings[].match.path": "Hook Mapping Match Path",
  "hooks.mappings[].match.source": "Hook Mapping Match Source",
  "hooks.mappings[].action": "Hook Mapping Action",
  "hooks.mappings[].wakeMode": "Hook Mapping Wake Mode",
  "hooks.mappings[].name": "Hook Mapping Name",
  "hooks.mappings[].agentId": "Hook Mapping Agent ID",
  "hooks.mappings[].sessionKey": "Hook Mapping Session Key",
  "hooks.mappings[].messageTemplate": "Hook Mapping Message Template",
  "hooks.mappings[].textTemplate": "Hook Mapping Text Template",
  "hooks.mappings[].deliver": "Hook Mapping Deliver Reply",
  "hooks.mappings[].allowUnsafeExternalContent": "Hook Mapping Allow Unsafe External Content",
  "hooks.mappings[].channel": "Hook Mapping Delivery Channel",
  "hooks.mappings[].to": "Hook Mapping Delivery Destination",
  "hooks.mappings[].model": "Hook Mapping Model Override",
  "hooks.mappings[].thinking": "Hook Mapping Thinking Override",
  "hooks.mappings[].timeoutSeconds": "Hook Mapping Timeout (sec)",
  "hooks.mappings[].transform": "Hook Mapping Transform",
  "hooks.mappings[].transform.module": "Hook Transform Module",
  "hooks.mappings[].transform.export": "Hook Transform Export",
  "hooks.gmail": "Gmail Hook",
  "hooks.gmail.account": "Gmail Hook Account",
  "hooks.gmail.label": "Gmail Hook Label",
  "hooks.gmail.topic": "Gmail Hook Pub/Sub Topic",
  "hooks.gmail.subscription": "Gmail Hook Subscription",
  "hooks.gmail.pushToken": "Gmail Hook Push Token",
  "hooks.gmail.hookUrl": "Gmail Hook Callback URL",
  "hooks.gmail.includeBody": "Gmail Hook Include Body",
  "hooks.gmail.maxBytes": "Gmail Hook Max Body Bytes",
  "hooks.gmail.renewEveryMinutes": "Gmail Hook Renew Interval (min)",
  "hooks.gmail.allowUnsafeExternalContent": "Gmail Hook Allow Unsafe External Content",
  "hooks.gmail.serve": "Gmail Hook Local Server",
  "hooks.gmail.serve.bind": "Gmail Hook Server Bind Address",
  "hooks.gmail.serve.port": "Gmail Hook Server Port",
  "hooks.gmail.serve.path": "Gmail Hook Server Path",
  "hooks.gmail.tailscale": "Gmail Hook Tailscale",
  "hooks.gmail.tailscale.mode": "Gmail Hook Tailscale Mode",
  "hooks.gmail.tailscale.path": "Gmail Hook Tailscale Path",
  "hooks.gmail.tailscale.target": "Gmail Hook Tailscale Target",
  "hooks.gmail.model": "Gmail Hook Model Override",
  "hooks.gmail.thinking": "Gmail Hook Thinking Override",
  "hooks.internal": "Internal Hooks",
  "hooks.internal.enabled": "Internal Hooks Enabled",
  "hooks.internal.handlers": "Internal Hook Handlers",
  "hooks.internal.handlers[].event": "Internal Hook Event",
  "hooks.internal.handlers[].module": "Internal Hook Module",
  "hooks.internal.handlers[].export": "Internal Hook Export",
  "hooks.internal.entries": "Internal Hook Entries",
  "hooks.internal.load": "Internal Hook Loader",
  "hooks.internal.load.extraDirs": "Internal Hook Extra Directories",
  "hooks.internal.installs": "Internal Hook Install Records",
  web: "Web Channel",
  "web.enabled": "Web Channel Enabled",
  "web.heartbeatSeconds": "Web Channel Heartbeat Interval (sec)",
  "web.reconnect": "Web Channel Reconnect Policy",
  "web.reconnect.initialMs": "Web Reconnect Initial Delay (ms)",
  "web.reconnect.maxMs": "Web Reconnect Max Delay (ms)",
  "web.reconnect.factor": "Web Reconnect Backoff Factor",
  "web.reconnect.jitter": "Web Reconnect Jitter",
  "web.reconnect.maxAttempts": "Web Reconnect Max Attempts",
  discovery: "Discovery",
  "discovery.wideArea": "Wide-area Discovery",
  "discovery.wideArea.enabled": "Wide-area Discovery Enabled",
  "discovery.mdns": "mDNS Discovery",
  canvasHost: "Canvas Host",
  "canvasHost.enabled": "Canvas Host Enabled",
  "canvasHost.root": "Canvas Host Root Directory",
  "canvasHost.port": "Canvas Host Port",
  "canvasHost.liveReload": "Canvas Host Live Reload",
  talk: "Talk",
  "talk.voiceId": "Talk Voice ID",
  "talk.voiceAliases": "Talk Voice Aliases",
  "talk.modelId": "Talk Model ID",
  "talk.outputFormat": "Talk Output Format",
  "talk.interruptOnSpeech": "Talk Interrupt on Speech",
  messages: "Messages",
  "messages.messagePrefix": "Inbound Message Prefix",
  "messages.responsePrefix": "Outbound Response Prefix",
  "messages.groupChat": "Group Chat Rules",
  "messages.groupChat.mentionPatterns": "Group Mention Patterns",
  "messages.groupChat.historyLimit": "Group History Limit",
  "messages.queue": "Inbound Queue",
  "messages.queue.mode": "Queue Mode",
  "messages.queue.byChannel": "Queue Mode by Channel",
  "messages.queue.debounceMs": "Queue Debounce (ms)",
  "messages.queue.debounceMsByChannel": "Queue Debounce by Channel (ms)",
  "messages.queue.cap": "Queue Capacity",
  "messages.queue.drop": "Queue Drop Strategy",
  "messages.inbound": "Inbound Debounce",
  "messages.suppressToolErrors": "Suppress Tool Error Warnings",
  "messages.ackReaction": "Ack Reaction Emoji",
  "messages.ackReactionScope": "Ack Reaction Scope",
  "messages.removeAckAfterReply": "Remove Ack Reaction After Reply",
  "messages.statusReactions": "Status Reactions",
  "messages.statusReactions.enabled": "Enable Status Reactions",
  "messages.statusReactions.emojis": "Status Reaction Emojis",
  "messages.statusReactions.timing": "Status Reaction Timing",
  "messages.inbound.debounceMs": "Inbound Message Debounce (ms)",
  "messages.inbound.byChannel": "Inbound Debounce by Channel (ms)",
  "messages.tts": "Message Text-to-Speech",
  "talk.apiKey": "Talk API Key",
  channels: "Channels",
  "channels.defaults": "Channel Defaults",
  "channels.defaults.groupPolicy": "Default Group Policy",
  "channels.defaults.heartbeat": "Default Heartbeat Visibility",
  "channels.defaults.heartbeat.showOk": "Heartbeat Show OK",
  "channels.defaults.heartbeat.showAlerts": "Heartbeat Show Alerts",
  "channels.defaults.heartbeat.useIndicator": "Heartbeat Use Indicator",
  "channels.whatsapp": "WhatsApp",
  "channels.telegram": "Telegram",
  "channels.telegram.customCommands": "Telegram Custom Commands",
  "channels.discord": "Discord",
  "channels.slack": "Slack",
  "channels.mattermost": "Mattermost",
  "channels.signal": "Signal",
  "channels.imessage": "iMessage",
  "channels.bluebubbles": "BlueBubbles",
  "channels.msteams": "MS Teams",
  "channels.modelByChannel": "Channel Model Overrides",
  ...IRC_FIELD_LABELS,
  "channels.telegram.botToken": "Telegram Bot Token",
  "channels.telegram.dmPolicy": "Telegram DM Policy",
  "channels.telegram.configWrites": "Telegram Config Writes",
  "channels.telegram.commands.native": "Telegram Native Commands",
  "channels.telegram.commands.nativeSkills": "Telegram Native Skill Commands",
  "channels.telegram.streaming": "Telegram Streaming Mode",
  "channels.telegram.retry.attempts": "Telegram Retry Attempts",
  "channels.telegram.retry.minDelayMs": "Telegram Retry Min Delay (ms)",
  "channels.telegram.retry.maxDelayMs": "Telegram Retry Max Delay (ms)",
  "channels.telegram.retry.jitter": "Telegram Retry Jitter",
  "channels.telegram.network.autoSelectFamily": "Telegram autoSelectFamily",
  "channels.telegram.timeoutSeconds": "Telegram API Timeout (seconds)",
  "channels.telegram.capabilities.inlineButtons": "Telegram Inline Buttons",
  "channels.whatsapp.dmPolicy": "WhatsApp DM Policy",
  "channels.whatsapp.selfChatMode": "WhatsApp Self-Phone Mode",
  "channels.whatsapp.debounceMs": "WhatsApp Message Debounce (ms)",
  "channels.whatsapp.configWrites": "WhatsApp Config Writes",
  "channels.signal.dmPolicy": "Signal DM Policy",
  "channels.signal.configWrites": "Signal Config Writes",
  "channels.imessage.dmPolicy": "iMessage DM Policy",
  "channels.imessage.configWrites": "iMessage Config Writes",
  "channels.bluebubbles.dmPolicy": "BlueBubbles DM Policy",
  "channels.msteams.configWrites": "MS Teams Config Writes",
  "channels.irc.configWrites": "IRC Config Writes",
  "channels.discord.dmPolicy": "Discord DM Policy",
  "channels.discord.dm.policy": "Discord DM Policy",
  "channels.discord.configWrites": "Discord Config Writes",
  "channels.discord.proxy": "Discord Proxy URL",
  "channels.discord.commands.native": "Discord Native Commands",
  "channels.discord.commands.nativeSkills": "Discord Native Skill Commands",
  "channels.discord.streaming": "Discord Streaming Mode",
  "channels.discord.streamMode": "Discord Stream Mode (Legacy)",
  "channels.discord.draftChunk.minChars": "Discord Draft Chunk Min Chars",
  "channels.discord.draftChunk.maxChars": "Discord Draft Chunk Max Chars",
  "channels.discord.draftChunk.breakPreference": "Discord Draft Chunk Break Preference",
  "channels.discord.retry.attempts": "Discord Retry Attempts",
  "channels.discord.retry.minDelayMs": "Discord Retry Min Delay (ms)",
  "channels.discord.retry.maxDelayMs": "Discord Retry Max Delay (ms)",
  "channels.discord.retry.jitter": "Discord Retry Jitter",
  "channels.discord.maxLinesPerMessage": "Discord Max Lines Per Message",
  "channels.discord.threadBindings.enabled": "Discord Thread Binding Enabled",
  "channels.discord.threadBindings.ttlHours": "Discord Thread Binding TTL (hours)",
  "channels.discord.threadBindings.spawnSubagentSessions": "Discord Thread-Bound Subagent Spawn",
  "channels.discord.ui.components.accentColor": "Discord Component Accent Color",
  "channels.discord.intents.presence": "Discord Presence Intent",
  "channels.discord.intents.guildMembers": "Discord Guild Members Intent",
  "channels.discord.voice.enabled": "Discord Voice Enabled",
  "channels.discord.voice.autoJoin": "Discord Voice Auto-Join",
  "channels.discord.voice.tts": "Discord Voice Text-to-Speech",
  "channels.discord.pluralkit.enabled": "Discord PluralKit Enabled",
  "channels.discord.pluralkit.token": "Discord PluralKit Token",
  "channels.discord.activity": "Discord Presence Activity",
  "channels.discord.status": "Discord Presence Status",
  "channels.discord.activityType": "Discord Presence Activity Type",
  "channels.discord.activityUrl": "Discord Presence Activity URL",
  "channels.slack.dm.policy": "Slack DM Policy",
  "channels.slack.dmPolicy": "Slack DM Policy",
  "channels.slack.configWrites": "Slack Config Writes",
  "channels.slack.commands.native": "Slack Native Commands",
  "channels.slack.commands.nativeSkills": "Slack Native Skill Commands",
  "channels.slack.allowBots": "Slack Allow Bot Messages",
  "channels.discord.token": "Discord Bot Token",
  "channels.slack.botToken": "Slack Bot Token",
  "channels.slack.appToken": "Slack App Token",
  "channels.slack.userToken": "Slack User Token",
  "channels.slack.userTokenReadOnly": "Slack User Token Read Only",
  "channels.slack.streaming": "Slack Streaming Mode",
  "channels.slack.nativeStreaming": "Slack Native Streaming",
  "channels.slack.streamMode": "Slack Stream Mode (Legacy)",
  "channels.slack.thread.historyScope": "Slack Thread History Scope",
  "channels.slack.thread.inheritParent": "Slack Thread Parent Inheritance",
  "channels.slack.thread.initialHistoryLimit": "Slack Thread Initial History Limit",
  "channels.mattermost.botToken": "Mattermost Bot Token",
  "channels.mattermost.baseUrl": "Mattermost Base URL",
  "channels.mattermost.configWrites": "Mattermost Config Writes",
  "channels.mattermost.chatmode": "Mattermost Chat Mode",
  "channels.mattermost.oncharPrefixes": "Mattermost Onchar Prefixes",
  "channels.mattermost.requireMention": "Mattermost Require Mention",
  "channels.signal.account": "Signal Account",
  "channels.imessage.cliPath": "iMessage CLI Path",
  "agents.list[].skills": "Agent Skill Filter",
  "agents.list[].identity.avatar": "Agent Avatar",
  "agents.list[].heartbeat.suppressToolErrorWarnings":
    "Agent Heartbeat Suppress Tool Error Warnings",
  "agents.list[].sandbox.browser.network": "Agent Sandbox Browser Network",
  "agents.list[].sandbox.browser.cdpSourceRange": "Agent Sandbox Browser CDP Source Port Range",
  "discovery.mdns.mode": "mDNS Discovery Mode",
  plugins: "Plugins",
  "plugins.enabled": "Enable Plugins",
  "plugins.allow": "Plugin Allowlist",
  "plugins.deny": "Plugin Denylist",
  "plugins.load": "Plugin Loader",
  "plugins.load.paths": "Plugin Load Paths",
  "plugins.slots": "Plugin Slots",
  "plugins.slots.memory": "Memory Plugin",
  "plugins.entries": "Plugin Entries",
  "plugins.entries.*.enabled": "Plugin Enabled",
  "plugins.entries.*.apiKey": "Plugin API Key",
  "plugins.entries.*.env": "Plugin Environment Variables",
  "plugins.entries.*.config": "Plugin Config",
  "plugins.installs": "Plugin Install Records",
  "plugins.installs.*.source": "Plugin Install Source",
  "plugins.installs.*.spec": "Plugin Install Spec",
  "plugins.installs.*.sourcePath": "Plugin Install Source Path",
  "plugins.installs.*.installPath": "Plugin Install Path",
  "plugins.installs.*.version": "Plugin Install Version",
  "plugins.installs.*.resolvedName": "Plugin Resolved Package Name",
  "plugins.installs.*.resolvedVersion": "Plugin Resolved Package Version",
  "plugins.installs.*.resolvedSpec": "Plugin Resolved Package Spec",
  "plugins.installs.*.integrity": "Plugin Resolved Integrity",
  "plugins.installs.*.shasum": "Plugin Resolved Shasum",
  "plugins.installs.*.resolvedAt": "Plugin Resolution Time",
  "plugins.installs.*.installedAt": "Plugin Install Time",
};
