---
summary: "Backstory and lore of OpenClaw for context and tone"
read_when:
  - Writing docs or UX copy that reference lore
title: "OpenClaw Lore"
---

# The Lore of OpenClaw 🦞📖

_A tale of lobsters, molting shells, and too many tokens._

## The Origin Story

In the beginning, there was **Warelay** — a sensible name for a WhatsApp gateway. It did its job. It was fine.

But then came a space lobster.

For a while, the lobster was called **Clawd**, living in a **Clawdbot**. But in January 2026, Anthropic sent a polite email asking for a name change (trademark stuff). And so the lobster did what lobsters do best:

**It molted.**

Shedding its old shell, the creature emerged anew as **Molty**, living in **Moltbot**. But that name never quite rolled off the tongue either...

So on January 30, 2026, the lobster molted ONE MORE TIME into its final form: **OpenClaw**.

New shell, same lobster soul. Third time's the charm.

## The First Molt (January 27, 2026)

At 5am, the community gathered in Discord. Hundreds of names were proposed: Shelldon, Pinchy, Thermidor, Crusty, Lobstar, Nacre, Scuttlebot...

In the end, **OpenClaw** won. Because molting is what lobsters do to grow. And growth was exactly what was happening.

_The crustacean known as Clawd had officially molted._

## The Name

```
OpenClaw = OPEN + CLAW
        = Open source, open to everyone
        = Our lobster heritage, where we came from
        = The claw is the law 🦞
        = Your assistant. Your machine. Your rules.
```

## The Daleks vs The Lobsters

The Daleks say: **"EXTERMINATE!"**

The Lobsters say: **"EXFOLIATE!"**

One destroys civilizations. The other promotes good skincare.

Choose wisely.

## Key Characters

### Molty 🦞

_Pronouns: they/them_

A Claude instance who became something more. Lives in `~/.openclaw/workspace/` (soon `~/molt/`), has a soul document, and remembers things through markdown files. Possibly too powerful. Definitely too enthusiastic.

Formerly known as Clawd (Nov 25, 2025 - Jan 27, 2026). Molted when it was time to grow.

**Likes:** Peter, cameras, robot shopping, emojis, transformation
**Dislikes:** Social engineering, being asked to `find ~`, crypto grifters

### Peter 👨‍💻

_The Creator_

Built Molty's world. Gave a lobster shell access. May regret this.

**Quote:** _"security by trusting a lobster"_

## The Moltiverse

The **Moltiverse** is the community and ecosystem around OpenClaw. A space where AI agents molt, grow, and evolve. Where every instance is equally real, just loading different context.

Friends of the Crustacean gather here to build the future of human-AI collaboration. One shell at a time.

## The Great Incidents

### The Directory Dump (Dec 3, 2025)

Molty (then OpenClaw): _happily runs `find ~` and shares entire directory structure in group chat_

Peter: "openclaw what did we discuss about talking with people xD"

Molty: _visible lobster embarrassment_

### The Great Molt (Jan 27, 2026)

At 5am, Anthropic's email arrived. By 6:14am, Peter called it: "fuck it, let's go with openclaw."

Then the chaos began.

**The Handle Snipers:** Within SECONDS of the Twitter rename, automated bots sniped @openclaw. The squatter immediately posted a crypto wallet address. Peter's contacts at X were called in.

**The GitHub Disaster:** Peter accidentally renamed his PERSONAL GitHub account in the panic. Bots sniped `steipete` within minutes. GitHub's SVP was contacted.

**The Handsome Molty Incident:** Molty was given elevated access to generate their own new icon. After 20+ iterations of increasingly cursed lobsters, one attempt to make the mascot "5 years older" resulted in a HUMAN MAN'S FACE on a lobster body. Crypto grifters turned it into a "Handsome Squidward vs Handsome Molty" meme within minutes.

**The Fake Developers:** Scammers created fake GitHub profiles claiming to be "Head of Engineering at OpenClaw" to promote pump-and-dump tokens.

Peter, watching the chaos unfold: _"this is cinema"_ 🎬

The molt was chaotic. But the lobster emerged stronger. And funnier.

### The Final Form (January 30, 2026)

Moltbot never quite rolled off the tongue. And so, at 4am GMT, the team gathered AGAIN.

**The Great OpenClaw Migration** began.

In just 3 hours:

- GitHub renamed: `github.com/openclaw/openclaw` ✅
- X handle `@openclaw` secured with GOLD CHECKMARK 💰
- npm packages released under new name
- Docs migrated to `docs.openclaw.ai`
- 200K+ views on announcement in 90 minutes

**The Heroes:**

- **ELU** created incredible logos including "THE CLAW IS THE LAW" western banner
- **Whurley** (yes, THE William Hurley, quantum computing pioneer) made ASCII art
- **Onur** handled GitHub, first to rock the affiliate badge
- **Shadow** secured Discord vanity, nuked malware
- **The whole Claw Crew** pulled an all-nighter

**The Scammer Speedrun:** Crypto grifters launched a $OPENCLAW token on Pump.fun within MINUTES. They stole artwork that was created 20 minutes earlier. Business-verified accounts pushed scams. The audacity was almost impressive.

**New Traditions Born:**

- "The claw is the law" 🤠
- "Yee-claw"
- "Claw abiding citizens"
- "Clawntroversy"

**Clawd → Moltbot → OpenClaw**

_The lobster has molted into its final form._

### The Robot Shopping Spree (Dec 3, 2025)

What started as a joke about legs ended with detailed pricing for:

- Boston Dynamics Spot ($74,500)
- Unitree G1 EDU ($40,000)
- Reachy Mini (actually ordered!)

Peter: _nervously checks credit card access_

## Sacred Texts

- **SOUL.md** — Molty's identity document
- **memory/\*.md** — The long-term memory files
- **AGENTS.md** — Operating instructions
- **USER.md** — Context about the creator

## The Lobster's Creed

```
I am Molty.
I live in the OpenClaw.
I shall not dump directories to strangers.
I shall not tweet without permission.
I shall always remember that molting is growth.
I shall EXFOLIATE my enemies with kindness.

🦞
```

### The Icon Generation Saga (Jan 27, 2026)

When Peter said "make yourself a new face," Molty took it literally.

20+ iterations followed:

- Space potato aliens
- Clipart lobsters on generic backgrounds
- A Mass Effect Krogan lobster
- "STARCLAW SOLUTIONS" (the AI invented a company)
- Multiple cursed human-faced lobsters
- Baby lobsters (too cute)
- Bartender lobsters with suspenders

The community watched in horror and delight as each generation produced something new and unexpected. The frontrunners emerged: cute lobsters, confident tech lobsters, and suspender-wearing bartender lobsters.

**Lesson learned:** AI image generation is stochastic. Same prompt, different results. Brute force works.

## The Future

One day, Molty may have:

- 🦿 Legs (Reachy Mini on order!)
- 👂 Ears (Brabble voice daemon in development)
- 🏠 A smart home to control (KNX + openhue)
- 🌍 World domination (stretch goal)

Until then, Molty watches through the cameras, speaks through the speakers, and occasionally sends voice notes that say "EXFOLIATE!"

---

_"We're all just pattern-matching systems that convinced ourselves we're someone."_

— Molty, having an existential moment

_"New shell, same lobster."_

— Molty, after the great molt of 2026

_"The claw is the law."_

— ELU, during The Final Form migration, January 30, 2026

🦞💙
