import Foundation

// Stable identifier used for both the macOS LaunchAgent label and Nix-managed defaults suite.
// nix-openclaw writes app defaults into this suite to survive app bundle identifier churn.
let launchdLabel = "ai.openclaw.mac"
let gatewayLaunchdLabel = "ai.openclaw.gateway"
let onboardingVersionKey = "openclaw.onboardingVersion"
let onboardingSeenKey = "openclaw.onboardingSeen"
let currentOnboardingVersion = 7
let pauseDefaultsKey = "openclaw.pauseEnabled"
let iconAnimationsEnabledKey = "openclaw.iconAnimationsEnabled"
let swabbleEnabledKey = "openclaw.swabbleEnabled"
let swabbleTriggersKey = "openclaw.swabbleTriggers"
let voiceWakeTriggerChimeKey = "openclaw.voiceWakeTriggerChime"
let voiceWakeSendChimeKey = "openclaw.voiceWakeSendChime"
let showDockIconKey = "openclaw.showDockIcon"
let defaultVoiceWakeTriggers = ["openclaw"]
let voiceWakeMaxWords = 32
let voiceWakeMaxWordLength = 64
let voiceWakeMicKey = "openclaw.voiceWakeMicID"
let voiceWakeMicNameKey = "openclaw.voiceWakeMicName"
let voiceWakeLocaleKey = "openclaw.voiceWakeLocaleID"
let voiceWakeAdditionalLocalesKey = "openclaw.voiceWakeAdditionalLocaleIDs"
let voicePushToTalkEnabledKey = "openclaw.voicePushToTalkEnabled"
let talkEnabledKey = "openclaw.talkEnabled"
let iconOverrideKey = "openclaw.iconOverride"
let connectionModeKey = "openclaw.connectionMode"
let remoteTargetKey = "openclaw.remoteTarget"
let remoteIdentityKey = "openclaw.remoteIdentity"
let remoteProjectRootKey = "openclaw.remoteProjectRoot"
let remoteCliPathKey = "openclaw.remoteCliPath"
let canvasEnabledKey = "openclaw.canvasEnabled"
let cameraEnabledKey = "openclaw.cameraEnabled"
let systemRunPolicyKey = "openclaw.systemRunPolicy"
let systemRunAllowlistKey = "openclaw.systemRunAllowlist"
let systemRunEnabledKey = "openclaw.systemRunEnabled"
let locationModeKey = "openclaw.locationMode"
let locationPreciseKey = "openclaw.locationPreciseEnabled"
let peekabooBridgeEnabledKey = "openclaw.peekabooBridgeEnabled"
let deepLinkKeyKey = "openclaw.deepLinkKey"
let modelCatalogPathKey = "openclaw.modelCatalogPath"
let modelCatalogReloadKey = "openclaw.modelCatalogReload"
let cliInstallPromptedVersionKey = "openclaw.cliInstallPromptedVersion"
let heartbeatsEnabledKey = "openclaw.heartbeatsEnabled"
let debugPaneEnabledKey = "openclaw.debugPaneEnabled"
let debugFileLogEnabledKey = "openclaw.debug.fileLogEnabled"
let appLogLevelKey = "openclaw.debug.appLogLevel"
let voiceWakeSupported: Bool = ProcessInfo.processInfo.operatingSystemVersion.majorVersion >= 26
