/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2023 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

namespace QuantConnect.Data.Fundamental
{
    /// <summary>
    /// The fundamental property to access
    /// </summary>
    public enum FundamentalProperty
    {
#pragma warning disable CS1591, CA1707
        Market,
        DollarVolume,
        Volume,
        HasFundamentalData,
        PriceFactor,
        SplitFactor,
        Value,
        Price,
        CompanyReference_CompanyId,
        CompanyReference_ShortName,
        CompanyReference_StandardName,
        CompanyReference_LegalName,
        CompanyReference_CountryId,
        CompanyReference_CIK,
        CompanyReference_CompanyStatus,
        CompanyReference_FiscalYearEnd,
        CompanyReference_IndustryTemplateCode,
        CompanyReference_PrimaryShareClassID,
        CompanyReference_PrimarySymbol,
        CompanyReference_PrimaryExchangeID,
        CompanyReference_BusinessCountryID,
        CompanyReference_LegalNameLanguageCode,
        CompanyReference_Auditor,
        CompanyReference_AuditorLanguageCode,
        CompanyReference_Advisor,
        CompanyReference_AdvisorLanguageCode,
        CompanyReference_IsLimitedPartnership,
        CompanyReference_IsREIT,
        CompanyReference_PrimaryMIC,
        CompanyReference_ReportStyle,
        CompanyReference_YearofEstablishment,
        CompanyReference_IsLimitedLiabilityCompany,
        CompanyReference_ExpectedFiscalYearEnd,
        SecurityReference_SecuritySymbol,
        SecurityReference_ExchangeId,
        SecurityReference_CurrencyId,
        SecurityReference_IPODate,
        SecurityReference_IsDepositaryReceipt,
        SecurityReference_DepositaryReceiptRatio,
        SecurityReference_SecurityType,
        SecurityReference_ShareClassDescription,
        SecurityReference_ShareClassStatus,
        SecurityReference_IsPrimaryShare,
        SecurityReference_IsDividendReinvest,
        SecurityReference_IsDirectInvest,
        SecurityReference_InvestmentId,
        SecurityReference_IPOOfferPrice,
        SecurityReference_DelistingDate,
        SecurityReference_DelistingReason,
        SecurityReference_MIC,
        SecurityReference_CommonShareSubType,
        SecurityReference_IPOOfferPriceRange,
        SecurityReference_ExchangeSubMarketGlobalId,
        SecurityReference_ConversionRatio,
        SecurityReference_ParValue,
        SecurityReference_TradingStatus,
        SecurityReference_MarketDataID,
        FinancialStatements_PeriodEndingDate_OneMonth,
        FinancialStatements_PeriodEndingDate_TwoMonths,
        FinancialStatements_PeriodEndingDate_ThreeMonths,
        FinancialStatements_PeriodEndingDate_SixMonths,
        FinancialStatements_PeriodEndingDate_NineMonths,
        FinancialStatements_PeriodEndingDate_TwelveMonths,
        FinancialStatements_FileDate_OneMonth,
        FinancialStatements_FileDate_TwoMonths,
        FinancialStatements_FileDate_ThreeMonths,
        FinancialStatements_FileDate_SixMonths,
        FinancialStatements_FileDate_NineMonths,
        FinancialStatements_FileDate_TwelveMonths,
        FinancialStatements_AccessionNumber_OneMonth,
        FinancialStatements_AccessionNumber_TwoMonths,
        FinancialStatements_AccessionNumber_ThreeMonths,
        FinancialStatements_AccessionNumber_SixMonths,
        FinancialStatements_AccessionNumber_NineMonths,
        FinancialStatements_FormType_OneMonth,
        FinancialStatements_FormType_TwoMonths,
        FinancialStatements_FormType_ThreeMonths,
        FinancialStatements_FormType_SixMonths,
        FinancialStatements_FormType_NineMonths,
        FinancialStatements_FormType_TwelveMonths,
        FinancialStatements_PeriodAuditor_OneMonth,
        FinancialStatements_PeriodAuditor_TwoMonths,
        FinancialStatements_PeriodAuditor_ThreeMonths,
        FinancialStatements_PeriodAuditor_SixMonths,
        FinancialStatements_PeriodAuditor_NineMonths,
        FinancialStatements_PeriodAuditor_TwelveMonths,
        FinancialStatements_AuditorReportStatus_OneMonth,
        FinancialStatements_AuditorReportStatus_TwoMonths,
        FinancialStatements_AuditorReportStatus_ThreeMonths,
        FinancialStatements_AuditorReportStatus_SixMonths,
        FinancialStatements_AuditorReportStatus_NineMonths,
        FinancialStatements_AuditorReportStatus_TwelveMonths,
        FinancialStatements_InventoryValuationMethod_OneMonth,
        FinancialStatements_InventoryValuationMethod_TwoMonths,
        FinancialStatements_InventoryValuationMethod_ThreeMonths,
        FinancialStatements_InventoryValuationMethod_SixMonths,
        FinancialStatements_InventoryValuationMethod_NineMonths,
        FinancialStatements_InventoryValuationMethod_TwelveMonths,
        FinancialStatements_NumberOfShareHolders_OneMonth,
        FinancialStatements_NumberOfShareHolders_TwoMonths,
        FinancialStatements_NumberOfShareHolders_ThreeMonths,
        FinancialStatements_NumberOfShareHolders_SixMonths,
        FinancialStatements_NumberOfShareHolders_NineMonths,
        FinancialStatements_NumberOfShareHolders_TwelveMonths,
        FinancialStatements_PeriodType_OneMonth,
        FinancialStatements_PeriodType_TwoMonths,
        FinancialStatements_PeriodType_ThreeMonths,
        FinancialStatements_PeriodType_SixMonths,
        FinancialStatements_PeriodType_NineMonths,
        FinancialStatements_PeriodType_TwelveMonths,
        FinancialStatements_TotalRiskBasedCapital_OneMonth,
        FinancialStatements_TotalRiskBasedCapital_ThreeMonths,
        FinancialStatements_TotalRiskBasedCapital_SixMonths,
        FinancialStatements_TotalRiskBasedCapital_NineMonths,
        FinancialStatements_TotalRiskBasedCapital_TwelveMonths,
        FinancialStatements_IncomeStatement_ISFileDate_OneMonth,
        FinancialStatements_IncomeStatement_ISFileDate_TwoMonths,
        FinancialStatements_IncomeStatement_ISFileDate_ThreeMonths,
        FinancialStatements_IncomeStatement_ISFileDate_SixMonths,
        FinancialStatements_IncomeStatement_ISFileDate_NineMonths,
        FinancialStatements_IncomeStatement_ISFileDate_TwelveMonths,
        FinancialStatements_IncomeStatement_Amortization_OneMonth,
        FinancialStatements_IncomeStatement_Amortization_TwoMonths,
        FinancialStatements_IncomeStatement_Amortization_ThreeMonths,
        FinancialStatements_IncomeStatement_Amortization_SixMonths,
        FinancialStatements_IncomeStatement_Amortization_NineMonths,
        FinancialStatements_IncomeStatement_Amortization_TwelveMonths,
        FinancialStatements_IncomeStatement_SecuritiesAmortization_OneMonth,
        FinancialStatements_IncomeStatement_SecuritiesAmortization_ThreeMonths,
        FinancialStatements_IncomeStatement_SecuritiesAmortization_SixMonths,
        FinancialStatements_IncomeStatement_SecuritiesAmortization_NineMonths,
        FinancialStatements_IncomeStatement_SecuritiesAmortization_TwelveMonths,
        FinancialStatements_IncomeStatement_CostOfRevenue_OneMonth,
        FinancialStatements_IncomeStatement_CostOfRevenue_TwoMonths,
        FinancialStatements_IncomeStatement_CostOfRevenue_ThreeMonths,
        FinancialStatements_IncomeStatement_CostOfRevenue_SixMonths,
        FinancialStatements_IncomeStatement_CostOfRevenue_NineMonths,
        FinancialStatements_IncomeStatement_CostOfRevenue_TwelveMonths,
        FinancialStatements_IncomeStatement_Depletion_ThreeMonths,
        FinancialStatements_IncomeStatement_Depletion_SixMonths,
        FinancialStatements_IncomeStatement_Depletion_NineMonths,
        FinancialStatements_IncomeStatement_Depletion_TwelveMonths,
        FinancialStatements_IncomeStatement_Depreciation_OneMonth,
        FinancialStatements_IncomeStatement_Depreciation_ThreeMonths,
        FinancialStatements_IncomeStatement_Depreciation_SixMonths,
        FinancialStatements_IncomeStatement_Depreciation_NineMonths,
        FinancialStatements_IncomeStatement_Depreciation_TwelveMonths,
        FinancialStatements_IncomeStatement_DepreciationAndAmortization_OneMonth,
        FinancialStatements_IncomeStatement_DepreciationAndAmortization_TwoMonths,
        FinancialStatements_IncomeStatement_DepreciationAndAmortization_ThreeMonths,
        FinancialStatements_IncomeStatement_DepreciationAndAmortization_SixMonths,
        FinancialStatements_IncomeStatement_DepreciationAndAmortization_NineMonths,
        FinancialStatements_IncomeStatement_DepreciationAndAmortization_TwelveMonths,
        FinancialStatements_IncomeStatement_DepreciationAmortizationDepletion_OneMonth,
        FinancialStatements_IncomeStatement_DepreciationAmortizationDepletion_TwoMonths,
        FinancialStatements_IncomeStatement_DepreciationAmortizationDepletion_ThreeMonths,
        FinancialStatements_IncomeStatement_DepreciationAmortizationDepletion_SixMonths,
        FinancialStatements_IncomeStatement_DepreciationAmortizationDepletion_NineMonths,
        FinancialStatements_IncomeStatement_DepreciationAmortizationDepletion_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeDiscontinuousOperations_OneMonth,
        FinancialStatements_IncomeStatement_NetIncomeDiscontinuousOperations_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncomeDiscontinuousOperations_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeDiscontinuousOperations_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeDiscontinuousOperations_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeDiscontinuousOperations_TwelveMonths,
        FinancialStatements_IncomeStatement_ExciseTaxes_ThreeMonths,
        FinancialStatements_IncomeStatement_ExciseTaxes_SixMonths,
        FinancialStatements_IncomeStatement_ExciseTaxes_NineMonths,
        FinancialStatements_IncomeStatement_ExciseTaxes_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeExtraordinary_OneMonth,
        FinancialStatements_IncomeStatement_NetIncomeExtraordinary_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncomeExtraordinary_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeExtraordinary_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeExtraordinary_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeExtraordinary_TwelveMonths,
        FinancialStatements_IncomeStatement_FeeRevenueAndOtherIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_FeeRevenueAndOtherIncome_SixMonths,
        FinancialStatements_IncomeStatement_FeeRevenueAndOtherIncome_NineMonths,
        FinancialStatements_IncomeStatement_FeeRevenueAndOtherIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_GeneralAndAdministrativeExpense_OneMonth,
        FinancialStatements_IncomeStatement_GeneralAndAdministrativeExpense_TwoMonths,
        FinancialStatements_IncomeStatement_GeneralAndAdministrativeExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_GeneralAndAdministrativeExpense_SixMonths,
        FinancialStatements_IncomeStatement_GeneralAndAdministrativeExpense_NineMonths,
        FinancialStatements_IncomeStatement_GeneralAndAdministrativeExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_GrossProfit_OneMonth,
        FinancialStatements_IncomeStatement_GrossProfit_TwoMonths,
        FinancialStatements_IncomeStatement_GrossProfit_ThreeMonths,
        FinancialStatements_IncomeStatement_GrossProfit_SixMonths,
        FinancialStatements_IncomeStatement_GrossProfit_NineMonths,
        FinancialStatements_IncomeStatement_GrossProfit_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestExpense_OneMonth,
        FinancialStatements_IncomeStatement_InterestExpense_TwoMonths,
        FinancialStatements_IncomeStatement_InterestExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestExpense_SixMonths,
        FinancialStatements_IncomeStatement_InterestExpense_NineMonths,
        FinancialStatements_IncomeStatement_InterestExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestExpenseNonOperating_OneMonth,
        FinancialStatements_IncomeStatement_InterestExpenseNonOperating_TwoMonths,
        FinancialStatements_IncomeStatement_InterestExpenseNonOperating_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestExpenseNonOperating_SixMonths,
        FinancialStatements_IncomeStatement_InterestExpenseNonOperating_NineMonths,
        FinancialStatements_IncomeStatement_InterestExpenseNonOperating_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeAfterProvisionForLoanLoss_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncomeAfterProvisionForLoanLoss_TwoMonths,
        FinancialStatements_IncomeStatement_InterestIncomeAfterProvisionForLoanLoss_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeAfterProvisionForLoanLoss_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeAfterProvisionForLoanLoss_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeAfterProvisionForLoanLoss_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeNonOperating_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncomeNonOperating_TwoMonths,
        FinancialStatements_IncomeStatement_InterestIncomeNonOperating_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeNonOperating_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeNonOperating_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeNonOperating_TwelveMonths,
        FinancialStatements_IncomeStatement_NetNonOperatingInterestIncomeExpense_OneMonth,
        FinancialStatements_IncomeStatement_NetNonOperatingInterestIncomeExpense_TwoMonths,
        FinancialStatements_IncomeStatement_NetNonOperatingInterestIncomeExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_NetNonOperatingInterestIncomeExpense_SixMonths,
        FinancialStatements_IncomeStatement_NetNonOperatingInterestIncomeExpense_NineMonths,
        FinancialStatements_IncomeStatement_NetNonOperatingInterestIncomeExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_LossAdjustmentExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_LossAdjustmentExpense_SixMonths,
        FinancialStatements_IncomeStatement_LossAdjustmentExpense_NineMonths,
        FinancialStatements_IncomeStatement_LossAdjustmentExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_MinorityInterests_OneMonth,
        FinancialStatements_IncomeStatement_MinorityInterests_TwoMonths,
        FinancialStatements_IncomeStatement_MinorityInterests_ThreeMonths,
        FinancialStatements_IncomeStatement_MinorityInterests_SixMonths,
        FinancialStatements_IncomeStatement_MinorityInterests_NineMonths,
        FinancialStatements_IncomeStatement_MinorityInterests_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncome_OneMonth,
        FinancialStatements_IncomeStatement_NetIncome_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncome_SixMonths,
        FinancialStatements_IncomeStatement_NetIncome_NineMonths,
        FinancialStatements_IncomeStatement_NetIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeCommonStockholders_OneMonth,
        FinancialStatements_IncomeStatement_NetIncomeCommonStockholders_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncomeCommonStockholders_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeCommonStockholders_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeCommonStockholders_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeCommonStockholders_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperations_OneMonth,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperations_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperations_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperations_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperations_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperations_TwelveMonths,
        FinancialStatements_IncomeStatement_NetInterestIncome_OneMonth,
        FinancialStatements_IncomeStatement_NetInterestIncome_TwoMonths,
        FinancialStatements_IncomeStatement_NetInterestIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_NetInterestIncome_SixMonths,
        FinancialStatements_IncomeStatement_NetInterestIncome_NineMonths,
        FinancialStatements_IncomeStatement_NetInterestIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_NetInvestmentIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_NetInvestmentIncome_SixMonths,
        FinancialStatements_IncomeStatement_NetInvestmentIncome_NineMonths,
        FinancialStatements_IncomeStatement_NetInvestmentIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalRevenue_OneMonth,
        FinancialStatements_IncomeStatement_TotalRevenue_TwoMonths,
        FinancialStatements_IncomeStatement_TotalRevenue_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalRevenue_SixMonths,
        FinancialStatements_IncomeStatement_TotalRevenue_NineMonths,
        FinancialStatements_IncomeStatement_TotalRevenue_TwelveMonths,
        FinancialStatements_IncomeStatement_NonInterestExpense_OneMonth,
        FinancialStatements_IncomeStatement_NonInterestExpense_TwoMonths,
        FinancialStatements_IncomeStatement_NonInterestExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_NonInterestExpense_SixMonths,
        FinancialStatements_IncomeStatement_NonInterestExpense_NineMonths,
        FinancialStatements_IncomeStatement_NonInterestExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_NonInterestIncome_OneMonth,
        FinancialStatements_IncomeStatement_NonInterestIncome_TwoMonths,
        FinancialStatements_IncomeStatement_NonInterestIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_NonInterestIncome_SixMonths,
        FinancialStatements_IncomeStatement_NonInterestIncome_NineMonths,
        FinancialStatements_IncomeStatement_NonInterestIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_OperatingExpense_OneMonth,
        FinancialStatements_IncomeStatement_OperatingExpense_TwoMonths,
        FinancialStatements_IncomeStatement_OperatingExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_OperatingExpense_SixMonths,
        FinancialStatements_IncomeStatement_OperatingExpense_NineMonths,
        FinancialStatements_IncomeStatement_OperatingExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_OperatingIncome_OneMonth,
        FinancialStatements_IncomeStatement_OperatingIncome_TwoMonths,
        FinancialStatements_IncomeStatement_OperatingIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_OperatingIncome_SixMonths,
        FinancialStatements_IncomeStatement_OperatingIncome_NineMonths,
        FinancialStatements_IncomeStatement_OperatingIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_OperatingRevenue_OneMonth,
        FinancialStatements_IncomeStatement_OperatingRevenue_TwoMonths,
        FinancialStatements_IncomeStatement_OperatingRevenue_ThreeMonths,
        FinancialStatements_IncomeStatement_OperatingRevenue_SixMonths,
        FinancialStatements_IncomeStatement_OperatingRevenue_NineMonths,
        FinancialStatements_IncomeStatement_OperatingRevenue_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherIncomeExpense_OneMonth,
        FinancialStatements_IncomeStatement_OtherIncomeExpense_TwoMonths,
        FinancialStatements_IncomeStatement_OtherIncomeExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherIncomeExpense_SixMonths,
        FinancialStatements_IncomeStatement_OtherIncomeExpense_NineMonths,
        FinancialStatements_IncomeStatement_OtherIncomeExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_PolicyAcquisitionExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_PolicyAcquisitionExpense_SixMonths,
        FinancialStatements_IncomeStatement_PolicyAcquisitionExpense_NineMonths,
        FinancialStatements_IncomeStatement_PolicyAcquisitionExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_NetPolicyholderBenefitsAndClaims_ThreeMonths,
        FinancialStatements_IncomeStatement_NetPolicyholderBenefitsAndClaims_SixMonths,
        FinancialStatements_IncomeStatement_NetPolicyholderBenefitsAndClaims_NineMonths,
        FinancialStatements_IncomeStatement_NetPolicyholderBenefitsAndClaims_TwelveMonths,
        FinancialStatements_IncomeStatement_PreferredStockDividends_OneMonth,
        FinancialStatements_IncomeStatement_PreferredStockDividends_TwoMonths,
        FinancialStatements_IncomeStatement_PreferredStockDividends_ThreeMonths,
        FinancialStatements_IncomeStatement_PreferredStockDividends_SixMonths,
        FinancialStatements_IncomeStatement_PreferredStockDividends_NineMonths,
        FinancialStatements_IncomeStatement_PreferredStockDividends_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalPremiumsEarned_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalPremiumsEarned_SixMonths,
        FinancialStatements_IncomeStatement_TotalPremiumsEarned_NineMonths,
        FinancialStatements_IncomeStatement_TotalPremiumsEarned_TwelveMonths,
        FinancialStatements_IncomeStatement_PretaxIncome_OneMonth,
        FinancialStatements_IncomeStatement_PretaxIncome_TwoMonths,
        FinancialStatements_IncomeStatement_PretaxIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_PretaxIncome_SixMonths,
        FinancialStatements_IncomeStatement_PretaxIncome_NineMonths,
        FinancialStatements_IncomeStatement_PretaxIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_TaxProvision_OneMonth,
        FinancialStatements_IncomeStatement_TaxProvision_TwoMonths,
        FinancialStatements_IncomeStatement_TaxProvision_ThreeMonths,
        FinancialStatements_IncomeStatement_TaxProvision_SixMonths,
        FinancialStatements_IncomeStatement_TaxProvision_NineMonths,
        FinancialStatements_IncomeStatement_TaxProvision_TwelveMonths,
        FinancialStatements_IncomeStatement_CreditLossesProvision_OneMonth,
        FinancialStatements_IncomeStatement_CreditLossesProvision_ThreeMonths,
        FinancialStatements_IncomeStatement_CreditLossesProvision_SixMonths,
        FinancialStatements_IncomeStatement_CreditLossesProvision_NineMonths,
        FinancialStatements_IncomeStatement_CreditLossesProvision_TwelveMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopment_OneMonth,
        FinancialStatements_IncomeStatement_ResearchAndDevelopment_TwoMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopment_ThreeMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopment_SixMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopment_NineMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopment_TwelveMonths,
        FinancialStatements_IncomeStatement_SellingAndMarketingExpense_OneMonth,
        FinancialStatements_IncomeStatement_SellingAndMarketingExpense_TwoMonths,
        FinancialStatements_IncomeStatement_SellingAndMarketingExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_SellingAndMarketingExpense_SixMonths,
        FinancialStatements_IncomeStatement_SellingAndMarketingExpense_NineMonths,
        FinancialStatements_IncomeStatement_SellingAndMarketingExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_SellingGeneralAndAdministration_OneMonth,
        FinancialStatements_IncomeStatement_SellingGeneralAndAdministration_TwoMonths,
        FinancialStatements_IncomeStatement_SellingGeneralAndAdministration_ThreeMonths,
        FinancialStatements_IncomeStatement_SellingGeneralAndAdministration_SixMonths,
        FinancialStatements_IncomeStatement_SellingGeneralAndAdministration_NineMonths,
        FinancialStatements_IncomeStatement_SellingGeneralAndAdministration_TwelveMonths,
        FinancialStatements_IncomeStatement_SpecialIncomeCharges_OneMonth,
        FinancialStatements_IncomeStatement_SpecialIncomeCharges_TwoMonths,
        FinancialStatements_IncomeStatement_SpecialIncomeCharges_ThreeMonths,
        FinancialStatements_IncomeStatement_SpecialIncomeCharges_SixMonths,
        FinancialStatements_IncomeStatement_SpecialIncomeCharges_NineMonths,
        FinancialStatements_IncomeStatement_SpecialIncomeCharges_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalExpenses_OneMonth,
        FinancialStatements_IncomeStatement_TotalExpenses_TwoMonths,
        FinancialStatements_IncomeStatement_TotalExpenses_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalExpenses_SixMonths,
        FinancialStatements_IncomeStatement_TotalExpenses_NineMonths,
        FinancialStatements_IncomeStatement_TotalExpenses_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncome_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncome_TwoMonths,
        FinancialStatements_IncomeStatement_InterestIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncome_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncome_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_EBIT_OneMonth,
        FinancialStatements_IncomeStatement_EBIT_TwoMonths,
        FinancialStatements_IncomeStatement_EBIT_ThreeMonths,
        FinancialStatements_IncomeStatement_EBIT_SixMonths,
        FinancialStatements_IncomeStatement_EBIT_NineMonths,
        FinancialStatements_IncomeStatement_EBIT_TwelveMonths,
        FinancialStatements_IncomeStatement_EBITDA_OneMonth,
        FinancialStatements_IncomeStatement_EBITDA_TwoMonths,
        FinancialStatements_IncomeStatement_EBITDA_ThreeMonths,
        FinancialStatements_IncomeStatement_EBITDA_SixMonths,
        FinancialStatements_IncomeStatement_EBITDA_NineMonths,
        FinancialStatements_IncomeStatement_EBITDA_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperationsNetMinorityInterest_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperationsNetMinorityInterest_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperationsNetMinorityInterest_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeContinuousOperationsNetMinorityInterest_TwelveMonths,
        FinancialStatements_IncomeStatement_CededPremiums_ThreeMonths,
        FinancialStatements_IncomeStatement_CededPremiums_SixMonths,
        FinancialStatements_IncomeStatement_CededPremiums_NineMonths,
        FinancialStatements_IncomeStatement_CededPremiums_TwelveMonths,
        FinancialStatements_IncomeStatement_CommissionExpenses_OneMonth,
        FinancialStatements_IncomeStatement_CommissionExpenses_TwoMonths,
        FinancialStatements_IncomeStatement_CommissionExpenses_ThreeMonths,
        FinancialStatements_IncomeStatement_CommissionExpenses_SixMonths,
        FinancialStatements_IncomeStatement_CommissionExpenses_NineMonths,
        FinancialStatements_IncomeStatement_CommissionExpenses_TwelveMonths,
        FinancialStatements_IncomeStatement_CreditCard_ThreeMonths,
        FinancialStatements_IncomeStatement_CreditCard_SixMonths,
        FinancialStatements_IncomeStatement_CreditCard_NineMonths,
        FinancialStatements_IncomeStatement_CreditCard_TwelveMonths,
        FinancialStatements_IncomeStatement_DividendIncome_OneMonth,
        FinancialStatements_IncomeStatement_DividendIncome_TwoMonths,
        FinancialStatements_IncomeStatement_DividendIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_DividendIncome_SixMonths,
        FinancialStatements_IncomeStatement_DividendIncome_NineMonths,
        FinancialStatements_IncomeStatement_DividendIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_EarningsFromEquityInterest_OneMonth,
        FinancialStatements_IncomeStatement_EarningsFromEquityInterest_TwoMonths,
        FinancialStatements_IncomeStatement_EarningsFromEquityInterest_ThreeMonths,
        FinancialStatements_IncomeStatement_EarningsFromEquityInterest_SixMonths,
        FinancialStatements_IncomeStatement_EarningsFromEquityInterest_NineMonths,
        FinancialStatements_IncomeStatement_EarningsFromEquityInterest_TwelveMonths,
        FinancialStatements_IncomeStatement_Equipment_ThreeMonths,
        FinancialStatements_IncomeStatement_Equipment_SixMonths,
        FinancialStatements_IncomeStatement_Equipment_NineMonths,
        FinancialStatements_IncomeStatement_Equipment_TwelveMonths,
        FinancialStatements_IncomeStatement_ExplorationDevelopmentAndMineralPropertyLeaseExpenses_ThreeMonths,
        FinancialStatements_IncomeStatement_ExplorationDevelopmentAndMineralPropertyLeaseExpenses_SixMonths,
        FinancialStatements_IncomeStatement_ExplorationDevelopmentAndMineralPropertyLeaseExpenses_NineMonths,
        FinancialStatements_IncomeStatement_ExplorationDevelopmentAndMineralPropertyLeaseExpenses_TwelveMonths,
        FinancialStatements_IncomeStatement_FeesAndCommissions_OneMonth,
        FinancialStatements_IncomeStatement_FeesAndCommissions_ThreeMonths,
        FinancialStatements_IncomeStatement_FeesAndCommissions_SixMonths,
        FinancialStatements_IncomeStatement_FeesAndCommissions_NineMonths,
        FinancialStatements_IncomeStatement_FeesAndCommissions_TwelveMonths,
        FinancialStatements_IncomeStatement_ForeignExchangeTradingGains_ThreeMonths,
        FinancialStatements_IncomeStatement_ForeignExchangeTradingGains_SixMonths,
        FinancialStatements_IncomeStatement_ForeignExchangeTradingGains_NineMonths,
        FinancialStatements_IncomeStatement_ForeignExchangeTradingGains_TwelveMonths,
        FinancialStatements_IncomeStatement_Fuel_OneMonth,
        FinancialStatements_IncomeStatement_Fuel_TwoMonths,
        FinancialStatements_IncomeStatement_Fuel_ThreeMonths,
        FinancialStatements_IncomeStatement_Fuel_SixMonths,
        FinancialStatements_IncomeStatement_Fuel_NineMonths,
        FinancialStatements_IncomeStatement_Fuel_TwelveMonths,
        FinancialStatements_IncomeStatement_FuelAndPurchasePower_ThreeMonths,
        FinancialStatements_IncomeStatement_FuelAndPurchasePower_SixMonths,
        FinancialStatements_IncomeStatement_FuelAndPurchasePower_NineMonths,
        FinancialStatements_IncomeStatement_FuelAndPurchasePower_TwelveMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfBusiness_OneMonth,
        FinancialStatements_IncomeStatement_GainOnSaleOfBusiness_TwoMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfBusiness_ThreeMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfBusiness_SixMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfBusiness_NineMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfBusiness_TwelveMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfPPE_OneMonth,
        FinancialStatements_IncomeStatement_GainOnSaleOfPPE_ThreeMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfPPE_SixMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfPPE_NineMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfPPE_TwelveMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfSecurity_OneMonth,
        FinancialStatements_IncomeStatement_GainOnSaleOfSecurity_TwoMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfSecurity_ThreeMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfSecurity_SixMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfSecurity_NineMonths,
        FinancialStatements_IncomeStatement_GainOnSaleOfSecurity_TwelveMonths,
        FinancialStatements_IncomeStatement_GrossPremiumsWritten_ThreeMonths,
        FinancialStatements_IncomeStatement_GrossPremiumsWritten_SixMonths,
        FinancialStatements_IncomeStatement_GrossPremiumsWritten_NineMonths,
        FinancialStatements_IncomeStatement_GrossPremiumsWritten_TwelveMonths,
        FinancialStatements_IncomeStatement_ImpairmentOfCapitalAssets_OneMonth,
        FinancialStatements_IncomeStatement_ImpairmentOfCapitalAssets_TwoMonths,
        FinancialStatements_IncomeStatement_ImpairmentOfCapitalAssets_ThreeMonths,
        FinancialStatements_IncomeStatement_ImpairmentOfCapitalAssets_SixMonths,
        FinancialStatements_IncomeStatement_ImpairmentOfCapitalAssets_NineMonths,
        FinancialStatements_IncomeStatement_ImpairmentOfCapitalAssets_TwelveMonths,
        FinancialStatements_IncomeStatement_IncreaseDecreaseInNetUnearnedPremiumReserves_ThreeMonths,
        FinancialStatements_IncomeStatement_IncreaseDecreaseInNetUnearnedPremiumReserves_SixMonths,
        FinancialStatements_IncomeStatement_IncreaseDecreaseInNetUnearnedPremiumReserves_NineMonths,
        FinancialStatements_IncomeStatement_IncreaseDecreaseInNetUnearnedPremiumReserves_TwelveMonths,
        FinancialStatements_IncomeStatement_InsuranceAndClaims_ThreeMonths,
        FinancialStatements_IncomeStatement_InsuranceAndClaims_SixMonths,
        FinancialStatements_IncomeStatement_InsuranceAndClaims_NineMonths,
        FinancialStatements_IncomeStatement_InsuranceAndClaims_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForDeposit_OneMonth,
        FinancialStatements_IncomeStatement_InterestExpenseForDeposit_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForDeposit_SixMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForDeposit_NineMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForDeposit_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_SixMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_NineMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForLongTermDebtAndCapitalSecurities_OneMonth,
        FinancialStatements_IncomeStatement_InterestExpenseForLongTermDebtAndCapitalSecurities_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForLongTermDebtAndCapitalSecurities_SixMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForLongTermDebtAndCapitalSecurities_NineMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForLongTermDebtAndCapitalSecurities_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForShortTermDebt_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForShortTermDebt_SixMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForShortTermDebt_NineMonths,
        FinancialStatements_IncomeStatement_InterestExpenseForShortTermDebt_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromDeposits_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncomeFromDeposits_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromDeposits_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromDeposits_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromDeposits_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLeases_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncomeFromLeases_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLeases_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLeases_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLeases_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoans_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoans_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoans_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoans_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoans_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoansAndLease_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoansAndLease_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoansAndLease_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoansAndLease_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromLoansAndLease_TwelveMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromSecurities_OneMonth,
        FinancialStatements_IncomeStatement_InterestIncomeFromSecurities_TwoMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromSecurities_ThreeMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromSecurities_SixMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromSecurities_NineMonths,
        FinancialStatements_IncomeStatement_InterestIncomeFromSecurities_TwelveMonths,
        FinancialStatements_IncomeStatement_InvestmentBankingProfit_ThreeMonths,
        FinancialStatements_IncomeStatement_InvestmentBankingProfit_SixMonths,
        FinancialStatements_IncomeStatement_InvestmentBankingProfit_NineMonths,
        FinancialStatements_IncomeStatement_InvestmentBankingProfit_TwelveMonths,
        FinancialStatements_IncomeStatement_MaintenanceAndRepairs_OneMonth,
        FinancialStatements_IncomeStatement_MaintenanceAndRepairs_TwoMonths,
        FinancialStatements_IncomeStatement_MaintenanceAndRepairs_ThreeMonths,
        FinancialStatements_IncomeStatement_MaintenanceAndRepairs_SixMonths,
        FinancialStatements_IncomeStatement_MaintenanceAndRepairs_NineMonths,
        FinancialStatements_IncomeStatement_MaintenanceAndRepairs_TwelveMonths,
        FinancialStatements_IncomeStatement_NetForeignExchangeGainLoss_ThreeMonths,
        FinancialStatements_IncomeStatement_NetForeignExchangeGainLoss_SixMonths,
        FinancialStatements_IncomeStatement_NetForeignExchangeGainLoss_NineMonths,
        FinancialStatements_IncomeStatement_NetForeignExchangeGainLoss_TwelveMonths,
        FinancialStatements_IncomeStatement_NetOccupancyExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_NetOccupancyExpense_SixMonths,
        FinancialStatements_IncomeStatement_NetOccupancyExpense_NineMonths,
        FinancialStatements_IncomeStatement_NetOccupancyExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_NetPremiumsWritten_ThreeMonths,
        FinancialStatements_IncomeStatement_NetPremiumsWritten_SixMonths,
        FinancialStatements_IncomeStatement_NetPremiumsWritten_NineMonths,
        FinancialStatements_IncomeStatement_NetPremiumsWritten_TwelveMonths,
        FinancialStatements_IncomeStatement_NetRealizedGainLossOnInvestments_ThreeMonths,
        FinancialStatements_IncomeStatement_NetRealizedGainLossOnInvestments_SixMonths,
        FinancialStatements_IncomeStatement_NetRealizedGainLossOnInvestments_NineMonths,
        FinancialStatements_IncomeStatement_NetRealizedGainLossOnInvestments_TwelveMonths,
        FinancialStatements_IncomeStatement_OccupancyAndEquipment_ThreeMonths,
        FinancialStatements_IncomeStatement_OccupancyAndEquipment_SixMonths,
        FinancialStatements_IncomeStatement_OccupancyAndEquipment_NineMonths,
        FinancialStatements_IncomeStatement_OccupancyAndEquipment_TwelveMonths,
        FinancialStatements_IncomeStatement_OperationAndMaintenance_OneMonth,
        FinancialStatements_IncomeStatement_OperationAndMaintenance_TwoMonths,
        FinancialStatements_IncomeStatement_OperationAndMaintenance_ThreeMonths,
        FinancialStatements_IncomeStatement_OperationAndMaintenance_SixMonths,
        FinancialStatements_IncomeStatement_OperationAndMaintenance_NineMonths,
        FinancialStatements_IncomeStatement_OperationAndMaintenance_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherCustomerServices_OneMonth,
        FinancialStatements_IncomeStatement_OtherCustomerServices_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherCustomerServices_SixMonths,
        FinancialStatements_IncomeStatement_OtherCustomerServices_NineMonths,
        FinancialStatements_IncomeStatement_OtherCustomerServices_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherInterestExpense_OneMonth,
        FinancialStatements_IncomeStatement_OtherInterestExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherInterestExpense_SixMonths,
        FinancialStatements_IncomeStatement_OtherInterestExpense_NineMonths,
        FinancialStatements_IncomeStatement_OtherInterestExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherInterestIncome_OneMonth,
        FinancialStatements_IncomeStatement_OtherInterestIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherInterestIncome_SixMonths,
        FinancialStatements_IncomeStatement_OtherInterestIncome_NineMonths,
        FinancialStatements_IncomeStatement_OtherInterestIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestExpense_OneMonth,
        FinancialStatements_IncomeStatement_OtherNonInterestExpense_TwoMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestExpense_SixMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestExpense_NineMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherSpecialCharges_TwoMonths,
        FinancialStatements_IncomeStatement_OtherSpecialCharges_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherSpecialCharges_SixMonths,
        FinancialStatements_IncomeStatement_OtherSpecialCharges_NineMonths,
        FinancialStatements_IncomeStatement_OtherSpecialCharges_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherTaxes_OneMonth,
        FinancialStatements_IncomeStatement_OtherTaxes_TwoMonths,
        FinancialStatements_IncomeStatement_OtherTaxes_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherTaxes_SixMonths,
        FinancialStatements_IncomeStatement_OtherTaxes_NineMonths,
        FinancialStatements_IncomeStatement_OtherTaxes_TwelveMonths,
        FinancialStatements_IncomeStatement_PolicyholderBenefitsCeded_TwelveMonths,
        FinancialStatements_IncomeStatement_PolicyholderBenefitsGross_ThreeMonths,
        FinancialStatements_IncomeStatement_PolicyholderBenefitsGross_SixMonths,
        FinancialStatements_IncomeStatement_PolicyholderBenefitsGross_NineMonths,
        FinancialStatements_IncomeStatement_PolicyholderBenefitsGross_TwelveMonths,
        FinancialStatements_IncomeStatement_PolicyholderDividends_ThreeMonths,
        FinancialStatements_IncomeStatement_PolicyholderDividends_SixMonths,
        FinancialStatements_IncomeStatement_PolicyholderDividends_NineMonths,
        FinancialStatements_IncomeStatement_PolicyholderDividends_TwelveMonths,
        FinancialStatements_IncomeStatement_PolicyholderInterest_ThreeMonths,
        FinancialStatements_IncomeStatement_PolicyholderInterest_SixMonths,
        FinancialStatements_IncomeStatement_PolicyholderInterest_NineMonths,
        FinancialStatements_IncomeStatement_PolicyholderInterest_TwelveMonths,
        FinancialStatements_IncomeStatement_ProfessionalExpenseAndContractServicesExpense_OneMonth,
        FinancialStatements_IncomeStatement_ProfessionalExpenseAndContractServicesExpense_TwoMonths,
        FinancialStatements_IncomeStatement_ProfessionalExpenseAndContractServicesExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_ProfessionalExpenseAndContractServicesExpense_SixMonths,
        FinancialStatements_IncomeStatement_ProfessionalExpenseAndContractServicesExpense_NineMonths,
        FinancialStatements_IncomeStatement_ProfessionalExpenseAndContractServicesExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_ProvisionForDoubtfulAccounts_TwoMonths,
        FinancialStatements_IncomeStatement_ProvisionForDoubtfulAccounts_ThreeMonths,
        FinancialStatements_IncomeStatement_ProvisionForDoubtfulAccounts_SixMonths,
        FinancialStatements_IncomeStatement_ProvisionForDoubtfulAccounts_NineMonths,
        FinancialStatements_IncomeStatement_ProvisionForDoubtfulAccounts_TwelveMonths,
        FinancialStatements_IncomeStatement_RentAndLandingFees_OneMonth,
        FinancialStatements_IncomeStatement_RentAndLandingFees_TwoMonths,
        FinancialStatements_IncomeStatement_RentAndLandingFees_ThreeMonths,
        FinancialStatements_IncomeStatement_RentAndLandingFees_SixMonths,
        FinancialStatements_IncomeStatement_RentAndLandingFees_NineMonths,
        FinancialStatements_IncomeStatement_RentAndLandingFees_TwelveMonths,
        FinancialStatements_IncomeStatement_RestructuringAndMergernAcquisition_OneMonth,
        FinancialStatements_IncomeStatement_RestructuringAndMergernAcquisition_TwoMonths,
        FinancialStatements_IncomeStatement_RestructuringAndMergernAcquisition_ThreeMonths,
        FinancialStatements_IncomeStatement_RestructuringAndMergernAcquisition_SixMonths,
        FinancialStatements_IncomeStatement_RestructuringAndMergernAcquisition_NineMonths,
        FinancialStatements_IncomeStatement_RestructuringAndMergernAcquisition_TwelveMonths,
        FinancialStatements_IncomeStatement_SalariesAndWages_OneMonth,
        FinancialStatements_IncomeStatement_SalariesAndWages_TwoMonths,
        FinancialStatements_IncomeStatement_SalariesAndWages_ThreeMonths,
        FinancialStatements_IncomeStatement_SalariesAndWages_SixMonths,
        FinancialStatements_IncomeStatement_SalariesAndWages_NineMonths,
        FinancialStatements_IncomeStatement_SalariesAndWages_TwelveMonths,
        FinancialStatements_IncomeStatement_SecuritiesActivities_ThreeMonths,
        FinancialStatements_IncomeStatement_SecuritiesActivities_SixMonths,
        FinancialStatements_IncomeStatement_SecuritiesActivities_NineMonths,
        FinancialStatements_IncomeStatement_SecuritiesActivities_TwelveMonths,
        FinancialStatements_IncomeStatement_ServiceChargeOnDepositorAccounts_OneMonth,
        FinancialStatements_IncomeStatement_ServiceChargeOnDepositorAccounts_ThreeMonths,
        FinancialStatements_IncomeStatement_ServiceChargeOnDepositorAccounts_SixMonths,
        FinancialStatements_IncomeStatement_ServiceChargeOnDepositorAccounts_NineMonths,
        FinancialStatements_IncomeStatement_ServiceChargeOnDepositorAccounts_TwelveMonths,
        FinancialStatements_IncomeStatement_TradingGainLoss_OneMonth,
        FinancialStatements_IncomeStatement_TradingGainLoss_ThreeMonths,
        FinancialStatements_IncomeStatement_TradingGainLoss_SixMonths,
        FinancialStatements_IncomeStatement_TradingGainLoss_NineMonths,
        FinancialStatements_IncomeStatement_TradingGainLoss_TwelveMonths,
        FinancialStatements_IncomeStatement_TrustFeesbyCommissions_ThreeMonths,
        FinancialStatements_IncomeStatement_TrustFeesbyCommissions_SixMonths,
        FinancialStatements_IncomeStatement_TrustFeesbyCommissions_NineMonths,
        FinancialStatements_IncomeStatement_TrustFeesbyCommissions_TwelveMonths,
        FinancialStatements_IncomeStatement_UnderwritingExpenses_ThreeMonths,
        FinancialStatements_IncomeStatement_UnderwritingExpenses_SixMonths,
        FinancialStatements_IncomeStatement_UnderwritingExpenses_NineMonths,
        FinancialStatements_IncomeStatement_UnderwritingExpenses_TwelveMonths,
        FinancialStatements_IncomeStatement_WriteOff_ThreeMonths,
        FinancialStatements_IncomeStatement_WriteOff_SixMonths,
        FinancialStatements_IncomeStatement_WriteOff_NineMonths,
        FinancialStatements_IncomeStatement_WriteOff_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestIncome_OneMonth,
        FinancialStatements_IncomeStatement_OtherNonInterestIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestIncome_SixMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestIncome_NineMonths,
        FinancialStatements_IncomeStatement_OtherNonInterestIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_AmortizationOfIntangibles_OneMonth,
        FinancialStatements_IncomeStatement_AmortizationOfIntangibles_TwoMonths,
        FinancialStatements_IncomeStatement_AmortizationOfIntangibles_ThreeMonths,
        FinancialStatements_IncomeStatement_AmortizationOfIntangibles_SixMonths,
        FinancialStatements_IncomeStatement_AmortizationOfIntangibles_NineMonths,
        FinancialStatements_IncomeStatement_AmortizationOfIntangibles_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingAndDiscontinuedOperation_OneMonth,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingAndDiscontinuedOperation_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingAndDiscontinuedOperation_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingAndDiscontinuedOperation_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingAndDiscontinuedOperation_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingAndDiscontinuedOperation_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromTaxLossCarryforward_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromTaxLossCarryforward_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromTaxLossCarryforward_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromTaxLossCarryforward_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherOperatingExpenses_OneMonth,
        FinancialStatements_IncomeStatement_OtherOperatingExpenses_TwoMonths,
        FinancialStatements_IncomeStatement_OtherOperatingExpenses_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherOperatingExpenses_SixMonths,
        FinancialStatements_IncomeStatement_OtherOperatingExpenses_NineMonths,
        FinancialStatements_IncomeStatement_OtherOperatingExpenses_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalMoneyMarketInvestments_OneMonth,
        FinancialStatements_IncomeStatement_TotalMoneyMarketInvestments_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalMoneyMarketInvestments_SixMonths,
        FinancialStatements_IncomeStatement_TotalMoneyMarketInvestments_NineMonths,
        FinancialStatements_IncomeStatement_TotalMoneyMarketInvestments_TwelveMonths,
        FinancialStatements_IncomeStatement_ReconciledCostOfRevenue_OneMonth,
        FinancialStatements_IncomeStatement_ReconciledCostOfRevenue_TwoMonths,
        FinancialStatements_IncomeStatement_ReconciledCostOfRevenue_ThreeMonths,
        FinancialStatements_IncomeStatement_ReconciledCostOfRevenue_SixMonths,
        FinancialStatements_IncomeStatement_ReconciledCostOfRevenue_NineMonths,
        FinancialStatements_IncomeStatement_ReconciledCostOfRevenue_TwelveMonths,
        FinancialStatements_IncomeStatement_ReconciledDepreciation_OneMonth,
        FinancialStatements_IncomeStatement_ReconciledDepreciation_TwoMonths,
        FinancialStatements_IncomeStatement_ReconciledDepreciation_ThreeMonths,
        FinancialStatements_IncomeStatement_ReconciledDepreciation_SixMonths,
        FinancialStatements_IncomeStatement_ReconciledDepreciation_NineMonths,
        FinancialStatements_IncomeStatement_ReconciledDepreciation_TwelveMonths,
        FinancialStatements_IncomeStatement_NormalizedIncome_OneMonth,
        FinancialStatements_IncomeStatement_NormalizedIncome_TwoMonths,
        FinancialStatements_IncomeStatement_NormalizedIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_NormalizedIncome_SixMonths,
        FinancialStatements_IncomeStatement_NormalizedIncome_NineMonths,
        FinancialStatements_IncomeStatement_NormalizedIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingOperationNetMinorityInterest_OneMonth,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingOperationNetMinorityInterest_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingOperationNetMinorityInterest_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingOperationNetMinorityInterest_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingOperationNetMinorityInterest_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeFromContinuingOperationNetMinorityInterest_TwelveMonths,
        FinancialStatements_IncomeStatement_GainLossonSaleofAssets_OneMonth,
        FinancialStatements_IncomeStatement_GainLossonSaleofAssets_ThreeMonths,
        FinancialStatements_IncomeStatement_GainLossonSaleofAssets_SixMonths,
        FinancialStatements_IncomeStatement_GainLossonSaleofAssets_NineMonths,
        FinancialStatements_IncomeStatement_GainLossonSaleofAssets_TwelveMonths,
        FinancialStatements_IncomeStatement_GainonSaleofLoans_OneMonth,
        FinancialStatements_IncomeStatement_GainonSaleofLoans_ThreeMonths,
        FinancialStatements_IncomeStatement_GainonSaleofLoans_SixMonths,
        FinancialStatements_IncomeStatement_GainonSaleofLoans_NineMonths,
        FinancialStatements_IncomeStatement_GainonSaleofLoans_TwelveMonths,
        FinancialStatements_IncomeStatement_GainonSaleofInvestmentProperty_ThreeMonths,
        FinancialStatements_IncomeStatement_GainonSaleofInvestmentProperty_SixMonths,
        FinancialStatements_IncomeStatement_GainonSaleofInvestmentProperty_NineMonths,
        FinancialStatements_IncomeStatement_GainonSaleofInvestmentProperty_TwelveMonths,
        FinancialStatements_IncomeStatement_LossonExtinguishmentofDebt_ThreeMonths,
        FinancialStatements_IncomeStatement_LossonExtinguishmentofDebt_SixMonths,
        FinancialStatements_IncomeStatement_LossonExtinguishmentofDebt_NineMonths,
        FinancialStatements_IncomeStatement_LossonExtinguishmentofDebt_TwelveMonths,
        FinancialStatements_IncomeStatement_EarningsfromEquityInterestNetOfTax_OneMonth,
        FinancialStatements_IncomeStatement_EarningsfromEquityInterestNetOfTax_TwoMonths,
        FinancialStatements_IncomeStatement_EarningsfromEquityInterestNetOfTax_ThreeMonths,
        FinancialStatements_IncomeStatement_EarningsfromEquityInterestNetOfTax_SixMonths,
        FinancialStatements_IncomeStatement_EarningsfromEquityInterestNetOfTax_NineMonths,
        FinancialStatements_IncomeStatement_EarningsfromEquityInterestNetOfTax_TwelveMonths,
        FinancialStatements_IncomeStatement_NetIncomeIncludingNoncontrollingInterests_OneMonth,
        FinancialStatements_IncomeStatement_NetIncomeIncludingNoncontrollingInterests_TwoMonths,
        FinancialStatements_IncomeStatement_NetIncomeIncludingNoncontrollingInterests_ThreeMonths,
        FinancialStatements_IncomeStatement_NetIncomeIncludingNoncontrollingInterests_SixMonths,
        FinancialStatements_IncomeStatement_NetIncomeIncludingNoncontrollingInterests_NineMonths,
        FinancialStatements_IncomeStatement_NetIncomeIncludingNoncontrollingInterests_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherunderPreferredStockDividend_OneMonth,
        FinancialStatements_IncomeStatement_OtherunderPreferredStockDividend_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherunderPreferredStockDividend_SixMonths,
        FinancialStatements_IncomeStatement_OtherunderPreferredStockDividend_NineMonths,
        FinancialStatements_IncomeStatement_OtherunderPreferredStockDividend_TwelveMonths,
        FinancialStatements_IncomeStatement_StaffCosts_TwoMonths,
        FinancialStatements_IncomeStatement_StaffCosts_ThreeMonths,
        FinancialStatements_IncomeStatement_StaffCosts_SixMonths,
        FinancialStatements_IncomeStatement_StaffCosts_NineMonths,
        FinancialStatements_IncomeStatement_StaffCosts_TwelveMonths,
        FinancialStatements_IncomeStatement_SocialSecurityCosts_TwelveMonths,
        FinancialStatements_IncomeStatement_PensionCosts_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherOperatingIncomeTotal_TwoMonths,
        FinancialStatements_IncomeStatement_OtherOperatingIncomeTotal_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherOperatingIncomeTotal_SixMonths,
        FinancialStatements_IncomeStatement_OtherOperatingIncomeTotal_NineMonths,
        FinancialStatements_IncomeStatement_OtherOperatingIncomeTotal_TwelveMonths,
        FinancialStatements_IncomeStatement_IncomefromAssociatesandOtherParticipatingInterests_ThreeMonths,
        FinancialStatements_IncomeStatement_IncomefromAssociatesandOtherParticipatingInterests_SixMonths,
        FinancialStatements_IncomeStatement_IncomefromAssociatesandOtherParticipatingInterests_NineMonths,
        FinancialStatements_IncomeStatement_IncomefromAssociatesandOtherParticipatingInterests_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalOtherFinanceCost_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalOtherFinanceCost_SixMonths,
        FinancialStatements_IncomeStatement_TotalOtherFinanceCost_NineMonths,
        FinancialStatements_IncomeStatement_TotalOtherFinanceCost_TwelveMonths,
        FinancialStatements_IncomeStatement_GrossDividendPayment_ThreeMonths,
        FinancialStatements_IncomeStatement_GrossDividendPayment_NineMonths,
        FinancialStatements_IncomeStatement_GrossDividendPayment_TwelveMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionIncome_SixMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionIncome_NineMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionExpense_ThreeMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionExpense_SixMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionExpense_NineMonths,
        FinancialStatements_IncomeStatement_FeesandCommissionExpense_TwelveMonths,
        FinancialStatements_IncomeStatement_NetTradingIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherStaffCosts_TwelveMonths,
        FinancialStatements_IncomeStatement_GainonInvestmentProperties_ThreeMonths,
        FinancialStatements_IncomeStatement_GainonInvestmentProperties_SixMonths,
        FinancialStatements_IncomeStatement_GainonInvestmentProperties_NineMonths,
        FinancialStatements_IncomeStatement_GainonInvestmentProperties_TwelveMonths,
        FinancialStatements_IncomeStatement_AverageDilutionEarnings_ThreeMonths,
        FinancialStatements_IncomeStatement_AverageDilutionEarnings_SixMonths,
        FinancialStatements_IncomeStatement_AverageDilutionEarnings_NineMonths,
        FinancialStatements_IncomeStatement_AverageDilutionEarnings_TwelveMonths,
        FinancialStatements_IncomeStatement_GainLossonFinancialInstrumentsDesignatedasCashFlowHedges_ThreeMonths,
        FinancialStatements_IncomeStatement_GainLossonFinancialInstrumentsDesignatedasCashFlowHedges_SixMonths,
        FinancialStatements_IncomeStatement_GainLossonFinancialInstrumentsDesignatedasCashFlowHedges_NineMonths,
        FinancialStatements_IncomeStatement_GainLossonFinancialInstrumentsDesignatedasCashFlowHedges_TwelveMonths,
        FinancialStatements_IncomeStatement_GainLossonDerecognitionofAvailableForSaleFinancialAssets_ThreeMonths,
        FinancialStatements_IncomeStatement_GainLossonDerecognitionofAvailableForSaleFinancialAssets_SixMonths,
        FinancialStatements_IncomeStatement_GainLossonDerecognitionofAvailableForSaleFinancialAssets_NineMonths,
        FinancialStatements_IncomeStatement_GainLossonDerecognitionofAvailableForSaleFinancialAssets_TwelveMonths,
        FinancialStatements_IncomeStatement_NegativeGoodwillImmediatelyRecognized_ThreeMonths,
        FinancialStatements_IncomeStatement_NegativeGoodwillImmediatelyRecognized_SixMonths,
        FinancialStatements_IncomeStatement_NegativeGoodwillImmediatelyRecognized_TwelveMonths,
        FinancialStatements_IncomeStatement_GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal_ThreeMonths,
        FinancialStatements_IncomeStatement_GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal_SixMonths,
        FinancialStatements_IncomeStatement_GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal_NineMonths,
        FinancialStatements_IncomeStatement_GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal_TwelveMonths,
        FinancialStatements_IncomeStatement_ImpairmentLossesReversalsFinancialInstrumentsNet_ThreeMonths,
        FinancialStatements_IncomeStatement_ImpairmentLossesReversalsFinancialInstrumentsNet_SixMonths,
        FinancialStatements_IncomeStatement_ImpairmentLossesReversalsFinancialInstrumentsNet_NineMonths,
        FinancialStatements_IncomeStatement_ImpairmentLossesReversalsFinancialInstrumentsNet_TwelveMonths,
        FinancialStatements_IncomeStatement_ClaimsandPaidIncurred_ThreeMonths,
        FinancialStatements_IncomeStatement_ClaimsandPaidIncurred_SixMonths,
        FinancialStatements_IncomeStatement_ClaimsandPaidIncurred_NineMonths,
        FinancialStatements_IncomeStatement_ClaimsandPaidIncurred_TwelveMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesClaimsandBenefits_ThreeMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesClaimsandBenefits_SixMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesClaimsandBenefits_NineMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesClaimsandBenefits_TwelveMonths,
        FinancialStatements_IncomeStatement_ChangeinInsuranceLiabilitiesNetofReinsurance_ThreeMonths,
        FinancialStatements_IncomeStatement_ChangeinInsuranceLiabilitiesNetofReinsurance_SixMonths,
        FinancialStatements_IncomeStatement_ChangeinInsuranceLiabilitiesNetofReinsurance_NineMonths,
        FinancialStatements_IncomeStatement_ChangeinInsuranceLiabilitiesNetofReinsurance_TwelveMonths,
        FinancialStatements_IncomeStatement_ChangeinInvestmentContract_ThreeMonths,
        FinancialStatements_IncomeStatement_ChangeinInvestmentContract_SixMonths,
        FinancialStatements_IncomeStatement_ChangeinInvestmentContract_NineMonths,
        FinancialStatements_IncomeStatement_ChangeinInvestmentContract_TwelveMonths,
        FinancialStatements_IncomeStatement_CreditRiskProvisions_ThreeMonths,
        FinancialStatements_IncomeStatement_CreditRiskProvisions_SixMonths,
        FinancialStatements_IncomeStatement_CreditRiskProvisions_NineMonths,
        FinancialStatements_IncomeStatement_CreditRiskProvisions_TwelveMonths,
        FinancialStatements_IncomeStatement_WagesandSalaries_SixMonths,
        FinancialStatements_IncomeStatement_WagesandSalaries_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncomeExpenses_TwoMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncomeExpenses_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncomeExpenses_SixMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncomeExpenses_NineMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncomeExpenses_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncome_SixMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncome_NineMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingExpenses_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingExpenses_SixMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingExpenses_NineMonths,
        FinancialStatements_IncomeStatement_OtherNonOperatingExpenses_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItems_OneMonth,
        FinancialStatements_IncomeStatement_TotalUnusualItems_TwoMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItems_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItems_SixMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItems_NineMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItems_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItemsExcludingGoodwill_OneMonth,
        FinancialStatements_IncomeStatement_TotalUnusualItemsExcludingGoodwill_TwoMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItemsExcludingGoodwill_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItemsExcludingGoodwill_SixMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItemsExcludingGoodwill_NineMonths,
        FinancialStatements_IncomeStatement_TotalUnusualItemsExcludingGoodwill_TwelveMonths,
        FinancialStatements_IncomeStatement_TaxRateForCalcs_OneMonth,
        FinancialStatements_IncomeStatement_TaxRateForCalcs_TwoMonths,
        FinancialStatements_IncomeStatement_TaxRateForCalcs_ThreeMonths,
        FinancialStatements_IncomeStatement_TaxRateForCalcs_SixMonths,
        FinancialStatements_IncomeStatement_TaxRateForCalcs_NineMonths,
        FinancialStatements_IncomeStatement_TaxRateForCalcs_TwelveMonths,
        FinancialStatements_IncomeStatement_TaxEffectOfUnusualItems_OneMonth,
        FinancialStatements_IncomeStatement_TaxEffectOfUnusualItems_TwoMonths,
        FinancialStatements_IncomeStatement_TaxEffectOfUnusualItems_ThreeMonths,
        FinancialStatements_IncomeStatement_TaxEffectOfUnusualItems_SixMonths,
        FinancialStatements_IncomeStatement_TaxEffectOfUnusualItems_NineMonths,
        FinancialStatements_IncomeStatement_TaxEffectOfUnusualItems_TwelveMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDA_OneMonth,
        FinancialStatements_IncomeStatement_NormalizedEBITDA_TwoMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDA_ThreeMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDA_SixMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDA_NineMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDA_TwelveMonths,
        FinancialStatements_IncomeStatement_StockBasedCompensation_ThreeMonths,
        FinancialStatements_IncomeStatement_StockBasedCompensation_SixMonths,
        FinancialStatements_IncomeStatement_StockBasedCompensation_NineMonths,
        FinancialStatements_IncomeStatement_StockBasedCompensation_TwelveMonths,
        FinancialStatements_IncomeStatement_DilutedNIAvailtoComStockholders_ThreeMonths,
        FinancialStatements_IncomeStatement_DilutedNIAvailtoComStockholders_SixMonths,
        FinancialStatements_IncomeStatement_DilutedNIAvailtoComStockholders_NineMonths,
        FinancialStatements_IncomeStatement_DilutedNIAvailtoComStockholders_TwelveMonths,
        FinancialStatements_IncomeStatement_InvestmentContractLiabilitiesIncurred_ThreeMonths,
        FinancialStatements_IncomeStatement_InvestmentContractLiabilitiesIncurred_SixMonths,
        FinancialStatements_IncomeStatement_InvestmentContractLiabilitiesIncurred_NineMonths,
        FinancialStatements_IncomeStatement_InvestmentContractLiabilitiesIncurred_TwelveMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInvestmentContract_ThreeMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInvestmentContract_SixMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInvestmentContract_NineMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInvestmentContract_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofEquityShares_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofEquityShares_SixMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofEquityShares_NineMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofEquityShares_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofNonEquityShares_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofNonEquityShares_SixMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofNonEquityShares_NineMonths,
        FinancialStatements_IncomeStatement_TotalDividendPaymentofNonEquityShares_TwelveMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiums_ThreeMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiums_SixMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiums_NineMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiums_TwelveMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare_ThreeMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare_SixMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare_NineMonths,
        FinancialStatements_IncomeStatement_ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare_TwelveMonths,
        FinancialStatements_IncomeStatement_ClaimsandChangeinInsuranceLiabilities_ThreeMonths,
        FinancialStatements_IncomeStatement_ClaimsandChangeinInsuranceLiabilities_SixMonths,
        FinancialStatements_IncomeStatement_ClaimsandChangeinInsuranceLiabilities_NineMonths,
        FinancialStatements_IncomeStatement_ClaimsandChangeinInsuranceLiabilities_TwelveMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInsuranceLiabilities_ThreeMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInsuranceLiabilities_SixMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInsuranceLiabilities_NineMonths,
        FinancialStatements_IncomeStatement_ReinsuranceRecoveriesofInsuranceLiabilities_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalOperatingIncomeAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalOperatingIncomeAsReported_SixMonths,
        FinancialStatements_IncomeStatement_TotalOperatingIncomeAsReported_NineMonths,
        FinancialStatements_IncomeStatement_TotalOperatingIncomeAsReported_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherGA_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherGA_SixMonths,
        FinancialStatements_IncomeStatement_OtherGA_NineMonths,
        FinancialStatements_IncomeStatement_OtherGA_TwelveMonths,
        FinancialStatements_IncomeStatement_OtherCostofRevenue_ThreeMonths,
        FinancialStatements_IncomeStatement_OtherCostofRevenue_SixMonths,
        FinancialStatements_IncomeStatement_OtherCostofRevenue_NineMonths,
        FinancialStatements_IncomeStatement_OtherCostofRevenue_TwelveMonths,
        FinancialStatements_IncomeStatement_RentandLandingFeesCostofRevenue_ThreeMonths,
        FinancialStatements_IncomeStatement_RentandLandingFeesCostofRevenue_SixMonths,
        FinancialStatements_IncomeStatement_RentandLandingFeesCostofRevenue_NineMonths,
        FinancialStatements_IncomeStatement_RentandLandingFeesCostofRevenue_TwelveMonths,
        FinancialStatements_IncomeStatement_DDACostofRevenue_ThreeMonths,
        FinancialStatements_IncomeStatement_DDACostofRevenue_SixMonths,
        FinancialStatements_IncomeStatement_DDACostofRevenue_NineMonths,
        FinancialStatements_IncomeStatement_DDACostofRevenue_TwelveMonths,
        FinancialStatements_IncomeStatement_RentExpenseSupplemental_ThreeMonths,
        FinancialStatements_IncomeStatement_RentExpenseSupplemental_SixMonths,
        FinancialStatements_IncomeStatement_RentExpenseSupplemental_NineMonths,
        FinancialStatements_IncomeStatement_RentExpenseSupplemental_TwelveMonths,
        FinancialStatements_IncomeStatement_NormalizedPreTaxIncome_ThreeMonths,
        FinancialStatements_IncomeStatement_NormalizedPreTaxIncome_SixMonths,
        FinancialStatements_IncomeStatement_NormalizedPreTaxIncome_NineMonths,
        FinancialStatements_IncomeStatement_NormalizedPreTaxIncome_TwelveMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopmentExpensesSupplemental_ThreeMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopmentExpensesSupplemental_SixMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopmentExpensesSupplemental_NineMonths,
        FinancialStatements_IncomeStatement_ResearchAndDevelopmentExpensesSupplemental_TwelveMonths,
        FinancialStatements_IncomeStatement_DepreciationSupplemental_ThreeMonths,
        FinancialStatements_IncomeStatement_DepreciationSupplemental_SixMonths,
        FinancialStatements_IncomeStatement_DepreciationSupplemental_NineMonths,
        FinancialStatements_IncomeStatement_DepreciationSupplemental_TwelveMonths,
        FinancialStatements_IncomeStatement_AmortizationSupplemental_ThreeMonths,
        FinancialStatements_IncomeStatement_AmortizationSupplemental_SixMonths,
        FinancialStatements_IncomeStatement_AmortizationSupplemental_NineMonths,
        FinancialStatements_IncomeStatement_AmortizationSupplemental_TwelveMonths,
        FinancialStatements_IncomeStatement_TotalRevenueAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_TotalRevenueAsReported_SixMonths,
        FinancialStatements_IncomeStatement_TotalRevenueAsReported_NineMonths,
        FinancialStatements_IncomeStatement_TotalRevenueAsReported_TwelveMonths,
        FinancialStatements_IncomeStatement_OperatingExpenseAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_OperatingExpenseAsReported_SixMonths,
        FinancialStatements_IncomeStatement_OperatingExpenseAsReported_NineMonths,
        FinancialStatements_IncomeStatement_OperatingExpenseAsReported_TwelveMonths,
        FinancialStatements_IncomeStatement_NormalizedIncomeAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_NormalizedIncomeAsReported_SixMonths,
        FinancialStatements_IncomeStatement_NormalizedIncomeAsReported_NineMonths,
        FinancialStatements_IncomeStatement_NormalizedIncomeAsReported_TwelveMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDAAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDAAsReported_SixMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDAAsReported_NineMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITDAAsReported_TwelveMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITAsReported_SixMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITAsReported_NineMonths,
        FinancialStatements_IncomeStatement_NormalizedEBITAsReported_TwelveMonths,
        FinancialStatements_IncomeStatement_NormalizedOperatingProfitAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_NormalizedOperatingProfitAsReported_SixMonths,
        FinancialStatements_IncomeStatement_NormalizedOperatingProfitAsReported_NineMonths,
        FinancialStatements_IncomeStatement_NormalizedOperatingProfitAsReported_TwelveMonths,
        FinancialStatements_IncomeStatement_EffectiveTaxRateAsReported_ThreeMonths,
        FinancialStatements_IncomeStatement_EffectiveTaxRateAsReported_SixMonths,
        FinancialStatements_IncomeStatement_EffectiveTaxRateAsReported_NineMonths,
        FinancialStatements_IncomeStatement_EffectiveTaxRateAsReported_TwelveMonths,
        FinancialStatements_BalanceSheet_BSFileDate_OneMonth,
        FinancialStatements_BalanceSheet_BSFileDate_ThreeMonths,
        FinancialStatements_BalanceSheet_BSFileDate_TwelveMonths,
        FinancialStatements_BalanceSheet_AccountsPayable_OneMonth,
        FinancialStatements_BalanceSheet_AccountsPayable_TwoMonths,
        FinancialStatements_BalanceSheet_AccountsPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_AccountsPayable_SixMonths,
        FinancialStatements_BalanceSheet_AccountsPayable_NineMonths,
        FinancialStatements_BalanceSheet_AccountsPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_AccountsReceivable_OneMonth,
        FinancialStatements_BalanceSheet_AccountsReceivable_TwoMonths,
        FinancialStatements_BalanceSheet_AccountsReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_AccountsReceivable_SixMonths,
        FinancialStatements_BalanceSheet_AccountsReceivable_NineMonths,
        FinancialStatements_BalanceSheet_AccountsReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentAccruedExpenses_OneMonth,
        FinancialStatements_BalanceSheet_CurrentAccruedExpenses_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentAccruedExpenses_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentAccruedExpenses_SixMonths,
        FinancialStatements_BalanceSheet_CurrentAccruedExpenses_NineMonths,
        FinancialStatements_BalanceSheet_CurrentAccruedExpenses_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccruedExpenses_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccruedExpenses_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccruedExpenses_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccruedExpenses_TwelveMonths,
        FinancialStatements_BalanceSheet_AccruedInvestmentIncome_ThreeMonths,
        FinancialStatements_BalanceSheet_AccruedInvestmentIncome_SixMonths,
        FinancialStatements_BalanceSheet_AccruedInvestmentIncome_TwelveMonths,
        FinancialStatements_BalanceSheet_AccumulatedDepreciation_OneMonth,
        FinancialStatements_BalanceSheet_AccumulatedDepreciation_TwoMonths,
        FinancialStatements_BalanceSheet_AccumulatedDepreciation_ThreeMonths,
        FinancialStatements_BalanceSheet_AccumulatedDepreciation_SixMonths,
        FinancialStatements_BalanceSheet_AccumulatedDepreciation_NineMonths,
        FinancialStatements_BalanceSheet_AccumulatedDepreciation_TwelveMonths,
        FinancialStatements_BalanceSheet_GainsLossesNotAffectingRetainedEarnings_OneMonth,
        FinancialStatements_BalanceSheet_GainsLossesNotAffectingRetainedEarnings_TwoMonths,
        FinancialStatements_BalanceSheet_GainsLossesNotAffectingRetainedEarnings_ThreeMonths,
        FinancialStatements_BalanceSheet_GainsLossesNotAffectingRetainedEarnings_SixMonths,
        FinancialStatements_BalanceSheet_GainsLossesNotAffectingRetainedEarnings_NineMonths,
        FinancialStatements_BalanceSheet_GainsLossesNotAffectingRetainedEarnings_TwelveMonths,
        FinancialStatements_BalanceSheet_AdditionalPaidInCapital_OneMonth,
        FinancialStatements_BalanceSheet_AdditionalPaidInCapital_TwoMonths,
        FinancialStatements_BalanceSheet_AdditionalPaidInCapital_ThreeMonths,
        FinancialStatements_BalanceSheet_AdditionalPaidInCapital_SixMonths,
        FinancialStatements_BalanceSheet_AdditionalPaidInCapital_NineMonths,
        FinancialStatements_BalanceSheet_AdditionalPaidInCapital_TwelveMonths,
        FinancialStatements_BalanceSheet_AllowanceForLoansAndLeaseLosses_ThreeMonths,
        FinancialStatements_BalanceSheet_AllowanceForLoansAndLeaseLosses_SixMonths,
        FinancialStatements_BalanceSheet_AllowanceForLoansAndLeaseLosses_NineMonths,
        FinancialStatements_BalanceSheet_AllowanceForLoansAndLeaseLosses_TwelveMonths,
        FinancialStatements_BalanceSheet_AvailableForSaleSecurities_ThreeMonths,
        FinancialStatements_BalanceSheet_AvailableForSaleSecurities_SixMonths,
        FinancialStatements_BalanceSheet_AvailableForSaleSecurities_NineMonths,
        FinancialStatements_BalanceSheet_AvailableForSaleSecurities_TwelveMonths,
        FinancialStatements_BalanceSheet_CapitalStock_OneMonth,
        FinancialStatements_BalanceSheet_CapitalStock_TwoMonths,
        FinancialStatements_BalanceSheet_CapitalStock_ThreeMonths,
        FinancialStatements_BalanceSheet_CapitalStock_SixMonths,
        FinancialStatements_BalanceSheet_CapitalStock_NineMonths,
        FinancialStatements_BalanceSheet_CapitalStock_TwelveMonths,
        FinancialStatements_BalanceSheet_Cash_OneMonth,
        FinancialStatements_BalanceSheet_Cash_TwoMonths,
        FinancialStatements_BalanceSheet_Cash_ThreeMonths,
        FinancialStatements_BalanceSheet_Cash_SixMonths,
        FinancialStatements_BalanceSheet_Cash_NineMonths,
        FinancialStatements_BalanceSheet_Cash_TwelveMonths,
        FinancialStatements_BalanceSheet_CashEquivalents_ThreeMonths,
        FinancialStatements_BalanceSheet_CashEquivalents_SixMonths,
        FinancialStatements_BalanceSheet_CashEquivalents_NineMonths,
        FinancialStatements_BalanceSheet_CashEquivalents_TwelveMonths,
        FinancialStatements_BalanceSheet_CashAndCashEquivalents_OneMonth,
        FinancialStatements_BalanceSheet_CashAndCashEquivalents_TwoMonths,
        FinancialStatements_BalanceSheet_CashAndCashEquivalents_ThreeMonths,
        FinancialStatements_BalanceSheet_CashAndCashEquivalents_SixMonths,
        FinancialStatements_BalanceSheet_CashAndCashEquivalents_NineMonths,
        FinancialStatements_BalanceSheet_CashAndCashEquivalents_TwelveMonths,
        FinancialStatements_BalanceSheet_CashAndDueFromBanks_ThreeMonths,
        FinancialStatements_BalanceSheet_CashAndDueFromBanks_SixMonths,
        FinancialStatements_BalanceSheet_CashAndDueFromBanks_NineMonths,
        FinancialStatements_BalanceSheet_CashAndDueFromBanks_TwelveMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndFederalFundsSold_TwoMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndFederalFundsSold_ThreeMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndFederalFundsSold_SixMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndFederalFundsSold_NineMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndFederalFundsSold_TwelveMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndMarketableSecurities_OneMonth,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndMarketableSecurities_TwoMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndMarketableSecurities_ThreeMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndMarketableSecurities_SixMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndMarketableSecurities_NineMonths,
        FinancialStatements_BalanceSheet_CashCashEquivalentsAndMarketableSecurities_TwelveMonths,
        FinancialStatements_BalanceSheet_CommonStock_OneMonth,
        FinancialStatements_BalanceSheet_CommonStock_TwoMonths,
        FinancialStatements_BalanceSheet_CommonStock_ThreeMonths,
        FinancialStatements_BalanceSheet_CommonStock_SixMonths,
        FinancialStatements_BalanceSheet_CommonStock_NineMonths,
        FinancialStatements_BalanceSheet_CommonStock_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentAssets_OneMonth,
        FinancialStatements_BalanceSheet_CurrentAssets_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentAssets_SixMonths,
        FinancialStatements_BalanceSheet_CurrentAssets_NineMonths,
        FinancialStatements_BalanceSheet_CurrentAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentDebt_OneMonth,
        FinancialStatements_BalanceSheet_CurrentDebt_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentDebt_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentDebt_SixMonths,
        FinancialStatements_BalanceSheet_CurrentDebt_NineMonths,
        FinancialStatements_BalanceSheet_CurrentDebt_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentDebtAndCapitalLeaseObligation_OneMonth,
        FinancialStatements_BalanceSheet_CurrentDebtAndCapitalLeaseObligation_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentDebtAndCapitalLeaseObligation_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentDebtAndCapitalLeaseObligation_SixMonths,
        FinancialStatements_BalanceSheet_CurrentDebtAndCapitalLeaseObligation_NineMonths,
        FinancialStatements_BalanceSheet_CurrentDebtAndCapitalLeaseObligation_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentLiabilities_OneMonth,
        FinancialStatements_BalanceSheet_CurrentLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_CurrentLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_CurrentLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentCapitalLeaseObligation_OneMonth,
        FinancialStatements_BalanceSheet_CurrentCapitalLeaseObligation_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentCapitalLeaseObligation_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentCapitalLeaseObligation_SixMonths,
        FinancialStatements_BalanceSheet_CurrentCapitalLeaseObligation_NineMonths,
        FinancialStatements_BalanceSheet_CurrentCapitalLeaseObligation_TwelveMonths,
        FinancialStatements_BalanceSheet_DeferredAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_DeferredAssets_SixMonths,
        FinancialStatements_BalanceSheet_DeferredAssets_NineMonths,
        FinancialStatements_BalanceSheet_DeferredAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_DeferredCosts_OneMonth,
        FinancialStatements_BalanceSheet_DeferredCosts_TwoMonths,
        FinancialStatements_BalanceSheet_DeferredCosts_ThreeMonths,
        FinancialStatements_BalanceSheet_DeferredCosts_SixMonths,
        FinancialStatements_BalanceSheet_DeferredCosts_NineMonths,
        FinancialStatements_BalanceSheet_DeferredCosts_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredLiabilities_OneMonth,
        FinancialStatements_BalanceSheet_NonCurrentDeferredLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredLiabilities_OneMonth,
        FinancialStatements_BalanceSheet_CurrentDeferredLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_DeferredPolicyAcquisitionCosts_ThreeMonths,
        FinancialStatements_BalanceSheet_DeferredPolicyAcquisitionCosts_SixMonths,
        FinancialStatements_BalanceSheet_DeferredPolicyAcquisitionCosts_NineMonths,
        FinancialStatements_BalanceSheet_DeferredPolicyAcquisitionCosts_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredRevenue_OneMonth,
        FinancialStatements_BalanceSheet_CurrentDeferredRevenue_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredRevenue_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredRevenue_SixMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredRevenue_NineMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredRevenue_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredRevenue_OneMonth,
        FinancialStatements_BalanceSheet_NonCurrentDeferredRevenue_TwoMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredRevenue_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredRevenue_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredRevenue_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredRevenue_TwelveMonths,
        FinancialStatements_BalanceSheet_DeferredTaxAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_DeferredTaxAssets_SixMonths,
        FinancialStatements_BalanceSheet_DeferredTaxAssets_NineMonths,
        FinancialStatements_BalanceSheet_DeferredTaxAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesAssets_OneMonth,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesAssets_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesAssets_SixMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesAssets_NineMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredTaxesLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesAssets_OneMonth,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesAssets_TwoMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesAssets_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesAssets_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesLiabilities_OneMonth,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredTaxesLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_EquityInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_EquityInvestments_NineMonths,
        FinancialStatements_BalanceSheet_EquityInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchase_ThreeMonths,
        FinancialStatements_BalanceSheet_FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchase_SixMonths,
        FinancialStatements_BalanceSheet_FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchase_TwelveMonths,
        FinancialStatements_BalanceSheet_FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_ThreeMonths,
        FinancialStatements_BalanceSheet_FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_SixMonths,
        FinancialStatements_BalanceSheet_FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_NineMonths,
        FinancialStatements_BalanceSheet_FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell_TwelveMonths,
        FinancialStatements_BalanceSheet_FixedMaturityInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_FixedMaturityInvestments_SixMonths,
        FinancialStatements_BalanceSheet_FixedMaturityInvestments_NineMonths,
        FinancialStatements_BalanceSheet_FixedMaturityInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_FuturePolicyBenefits_ThreeMonths,
        FinancialStatements_BalanceSheet_FuturePolicyBenefits_TwelveMonths,
        FinancialStatements_BalanceSheet_GeneralPartnershipCapital_ThreeMonths,
        FinancialStatements_BalanceSheet_GeneralPartnershipCapital_SixMonths,
        FinancialStatements_BalanceSheet_GeneralPartnershipCapital_TwelveMonths,
        FinancialStatements_BalanceSheet_Goodwill_OneMonth,
        FinancialStatements_BalanceSheet_Goodwill_TwoMonths,
        FinancialStatements_BalanceSheet_Goodwill_ThreeMonths,
        FinancialStatements_BalanceSheet_Goodwill_SixMonths,
        FinancialStatements_BalanceSheet_Goodwill_NineMonths,
        FinancialStatements_BalanceSheet_Goodwill_TwelveMonths,
        FinancialStatements_BalanceSheet_GoodwillAndOtherIntangibleAssets_OneMonth,
        FinancialStatements_BalanceSheet_GoodwillAndOtherIntangibleAssets_TwoMonths,
        FinancialStatements_BalanceSheet_GoodwillAndOtherIntangibleAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_GoodwillAndOtherIntangibleAssets_SixMonths,
        FinancialStatements_BalanceSheet_GoodwillAndOtherIntangibleAssets_NineMonths,
        FinancialStatements_BalanceSheet_GoodwillAndOtherIntangibleAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_GrossLoan_ThreeMonths,
        FinancialStatements_BalanceSheet_GrossLoan_SixMonths,
        FinancialStatements_BalanceSheet_GrossLoan_NineMonths,
        FinancialStatements_BalanceSheet_GrossLoan_TwelveMonths,
        FinancialStatements_BalanceSheet_GrossPPE_OneMonth,
        FinancialStatements_BalanceSheet_GrossPPE_TwoMonths,
        FinancialStatements_BalanceSheet_GrossPPE_ThreeMonths,
        FinancialStatements_BalanceSheet_GrossPPE_SixMonths,
        FinancialStatements_BalanceSheet_GrossPPE_NineMonths,
        FinancialStatements_BalanceSheet_GrossPPE_TwelveMonths,
        FinancialStatements_BalanceSheet_HeldToMaturitySecurities_ThreeMonths,
        FinancialStatements_BalanceSheet_HeldToMaturitySecurities_SixMonths,
        FinancialStatements_BalanceSheet_HeldToMaturitySecurities_NineMonths,
        FinancialStatements_BalanceSheet_HeldToMaturitySecurities_TwelveMonths,
        FinancialStatements_BalanceSheet_IncomeTaxPayable_OneMonth,
        FinancialStatements_BalanceSheet_IncomeTaxPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_IncomeTaxPayable_SixMonths,
        FinancialStatements_BalanceSheet_IncomeTaxPayable_NineMonths,
        FinancialStatements_BalanceSheet_IncomeTaxPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_InterestPayable_OneMonth,
        FinancialStatements_BalanceSheet_InterestPayable_TwoMonths,
        FinancialStatements_BalanceSheet_InterestPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_InterestPayable_SixMonths,
        FinancialStatements_BalanceSheet_InterestPayable_NineMonths,
        FinancialStatements_BalanceSheet_InterestPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsAssets_SixMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsAssets_NineMonths,
        FinancialStatements_BalanceSheet_InterestBearingDepositsAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_Inventory_OneMonth,
        FinancialStatements_BalanceSheet_Inventory_TwoMonths,
        FinancialStatements_BalanceSheet_Inventory_ThreeMonths,
        FinancialStatements_BalanceSheet_Inventory_SixMonths,
        FinancialStatements_BalanceSheet_Inventory_NineMonths,
        FinancialStatements_BalanceSheet_Inventory_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentsAndAdvances_OneMonth,
        FinancialStatements_BalanceSheet_InvestmentsAndAdvances_TwoMonths,
        FinancialStatements_BalanceSheet_InvestmentsAndAdvances_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentsAndAdvances_SixMonths,
        FinancialStatements_BalanceSheet_InvestmentsAndAdvances_NineMonths,
        FinancialStatements_BalanceSheet_InvestmentsAndAdvances_TwelveMonths,
        FinancialStatements_BalanceSheet_LimitedPartnershipCapital_ThreeMonths,
        FinancialStatements_BalanceSheet_LimitedPartnershipCapital_SixMonths,
        FinancialStatements_BalanceSheet_LimitedPartnershipCapital_TwelveMonths,
        FinancialStatements_BalanceSheet_LongTermDebt_OneMonth,
        FinancialStatements_BalanceSheet_LongTermDebt_TwoMonths,
        FinancialStatements_BalanceSheet_LongTermDebt_ThreeMonths,
        FinancialStatements_BalanceSheet_LongTermDebt_SixMonths,
        FinancialStatements_BalanceSheet_LongTermDebt_NineMonths,
        FinancialStatements_BalanceSheet_LongTermDebt_TwelveMonths,
        FinancialStatements_BalanceSheet_LongTermDebtAndCapitalLeaseObligation_OneMonth,
        FinancialStatements_BalanceSheet_LongTermDebtAndCapitalLeaseObligation_TwoMonths,
        FinancialStatements_BalanceSheet_LongTermDebtAndCapitalLeaseObligation_ThreeMonths,
        FinancialStatements_BalanceSheet_LongTermDebtAndCapitalLeaseObligation_SixMonths,
        FinancialStatements_BalanceSheet_LongTermDebtAndCapitalLeaseObligation_NineMonths,
        FinancialStatements_BalanceSheet_LongTermDebtAndCapitalLeaseObligation_TwelveMonths,
        FinancialStatements_BalanceSheet_LongTermInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_LongTermInvestments_SixMonths,
        FinancialStatements_BalanceSheet_LongTermInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_LongTermCapitalLeaseObligation_OneMonth,
        FinancialStatements_BalanceSheet_LongTermCapitalLeaseObligation_TwoMonths,
        FinancialStatements_BalanceSheet_LongTermCapitalLeaseObligation_ThreeMonths,
        FinancialStatements_BalanceSheet_LongTermCapitalLeaseObligation_SixMonths,
        FinancialStatements_BalanceSheet_LongTermCapitalLeaseObligation_NineMonths,
        FinancialStatements_BalanceSheet_LongTermCapitalLeaseObligation_TwelveMonths,
        FinancialStatements_BalanceSheet_MinorityInterest_OneMonth,
        FinancialStatements_BalanceSheet_MinorityInterest_TwoMonths,
        FinancialStatements_BalanceSheet_MinorityInterest_ThreeMonths,
        FinancialStatements_BalanceSheet_MinorityInterest_SixMonths,
        FinancialStatements_BalanceSheet_MinorityInterest_NineMonths,
        FinancialStatements_BalanceSheet_MinorityInterest_TwelveMonths,
        FinancialStatements_BalanceSheet_MoneyMarketInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_MoneyMarketInvestments_SixMonths,
        FinancialStatements_BalanceSheet_MoneyMarketInvestments_NineMonths,
        FinancialStatements_BalanceSheet_MoneyMarketInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_NetLoan_ThreeMonths,
        FinancialStatements_BalanceSheet_NetLoan_SixMonths,
        FinancialStatements_BalanceSheet_NetLoan_NineMonths,
        FinancialStatements_BalanceSheet_NetLoan_TwelveMonths,
        FinancialStatements_BalanceSheet_NetPPE_OneMonth,
        FinancialStatements_BalanceSheet_NetPPE_TwoMonths,
        FinancialStatements_BalanceSheet_NetPPE_ThreeMonths,
        FinancialStatements_BalanceSheet_NetPPE_SixMonths,
        FinancialStatements_BalanceSheet_NetPPE_NineMonths,
        FinancialStatements_BalanceSheet_NetPPE_TwelveMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingDeposits_ThreeMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingDeposits_SixMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingDeposits_NineMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingDeposits_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentNotesPayable_OneMonth,
        FinancialStatements_BalanceSheet_CurrentNotesPayable_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentNotesPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentNotesPayable_SixMonths,
        FinancialStatements_BalanceSheet_CurrentNotesPayable_NineMonths,
        FinancialStatements_BalanceSheet_CurrentNotesPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_NotesReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_NotesReceivable_SixMonths,
        FinancialStatements_BalanceSheet_NotesReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentNoteReceivables_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentNoteReceivables_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentNoteReceivables_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentNoteReceivables_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherCurrentLiabilities_OneMonth,
        FinancialStatements_BalanceSheet_OtherCurrentLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_OtherCurrentLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherCurrentLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_OtherCurrentLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_OtherCurrentLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherIntangibleAssets_OneMonth,
        FinancialStatements_BalanceSheet_OtherIntangibleAssets_TwoMonths,
        FinancialStatements_BalanceSheet_OtherIntangibleAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherIntangibleAssets_SixMonths,
        FinancialStatements_BalanceSheet_OtherIntangibleAssets_NineMonths,
        FinancialStatements_BalanceSheet_OtherIntangibleAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherShortTermInvestments_OneMonth,
        FinancialStatements_BalanceSheet_OtherShortTermInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherShortTermInvestments_SixMonths,
        FinancialStatements_BalanceSheet_OtherShortTermInvestments_NineMonths,
        FinancialStatements_BalanceSheet_OtherShortTermInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_Payables_OneMonth,
        FinancialStatements_BalanceSheet_Payables_TwoMonths,
        FinancialStatements_BalanceSheet_Payables_ThreeMonths,
        FinancialStatements_BalanceSheet_Payables_SixMonths,
        FinancialStatements_BalanceSheet_Payables_NineMonths,
        FinancialStatements_BalanceSheet_Payables_TwelveMonths,
        FinancialStatements_BalanceSheet_PayablesAndAccruedExpenses_OneMonth,
        FinancialStatements_BalanceSheet_PayablesAndAccruedExpenses_TwoMonths,
        FinancialStatements_BalanceSheet_PayablesAndAccruedExpenses_ThreeMonths,
        FinancialStatements_BalanceSheet_PayablesAndAccruedExpenses_SixMonths,
        FinancialStatements_BalanceSheet_PayablesAndAccruedExpenses_NineMonths,
        FinancialStatements_BalanceSheet_PayablesAndAccruedExpenses_TwelveMonths,
        FinancialStatements_BalanceSheet_PolicyReservesBenefits_ThreeMonths,
        FinancialStatements_BalanceSheet_PolicyReservesBenefits_SixMonths,
        FinancialStatements_BalanceSheet_PolicyReservesBenefits_NineMonths,
        FinancialStatements_BalanceSheet_PolicyReservesBenefits_TwelveMonths,
        FinancialStatements_BalanceSheet_PolicyholderFunds_ThreeMonths,
        FinancialStatements_BalanceSheet_PolicyholderFunds_TwelveMonths,
        FinancialStatements_BalanceSheet_PreferredSecuritiesOutsideStockEquity_OneMonth,
        FinancialStatements_BalanceSheet_PreferredSecuritiesOutsideStockEquity_ThreeMonths,
        FinancialStatements_BalanceSheet_PreferredSecuritiesOutsideStockEquity_SixMonths,
        FinancialStatements_BalanceSheet_PreferredSecuritiesOutsideStockEquity_NineMonths,
        FinancialStatements_BalanceSheet_PreferredSecuritiesOutsideStockEquity_TwelveMonths,
        FinancialStatements_BalanceSheet_PreferredStock_OneMonth,
        FinancialStatements_BalanceSheet_PreferredStock_TwoMonths,
        FinancialStatements_BalanceSheet_PreferredStock_ThreeMonths,
        FinancialStatements_BalanceSheet_PreferredStock_SixMonths,
        FinancialStatements_BalanceSheet_PreferredStock_NineMonths,
        FinancialStatements_BalanceSheet_PreferredStock_TwelveMonths,
        FinancialStatements_BalanceSheet_PrepaidAssets_OneMonth,
        FinancialStatements_BalanceSheet_PrepaidAssets_TwoMonths,
        FinancialStatements_BalanceSheet_PrepaidAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_PrepaidAssets_SixMonths,
        FinancialStatements_BalanceSheet_PrepaidAssets_NineMonths,
        FinancialStatements_BalanceSheet_PrepaidAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentPrepaidAssets_OneMonth,
        FinancialStatements_BalanceSheet_NonCurrentPrepaidAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentPrepaidAssets_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentPrepaidAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_Receivables_OneMonth,
        FinancialStatements_BalanceSheet_Receivables_TwoMonths,
        FinancialStatements_BalanceSheet_Receivables_ThreeMonths,
        FinancialStatements_BalanceSheet_Receivables_SixMonths,
        FinancialStatements_BalanceSheet_Receivables_NineMonths,
        FinancialStatements_BalanceSheet_Receivables_TwelveMonths,
        FinancialStatements_BalanceSheet_ReinsuranceRecoverable_ThreeMonths,
        FinancialStatements_BalanceSheet_ReinsuranceRecoverable_TwelveMonths,
        FinancialStatements_BalanceSheet_RetainedEarnings_OneMonth,
        FinancialStatements_BalanceSheet_RetainedEarnings_TwoMonths,
        FinancialStatements_BalanceSheet_RetainedEarnings_ThreeMonths,
        FinancialStatements_BalanceSheet_RetainedEarnings_SixMonths,
        FinancialStatements_BalanceSheet_RetainedEarnings_NineMonths,
        FinancialStatements_BalanceSheet_RetainedEarnings_TwelveMonths,
        FinancialStatements_BalanceSheet_SecuritiesLendingCollateral_ThreeMonths,
        FinancialStatements_BalanceSheet_SecuritiesLendingCollateral_TwelveMonths,
        FinancialStatements_BalanceSheet_SecurityAgreeToBeResell_ThreeMonths,
        FinancialStatements_BalanceSheet_SecurityAgreeToBeResell_TwelveMonths,
        FinancialStatements_BalanceSheet_SecuritySoldNotYetRepurchased_ThreeMonths,
        FinancialStatements_BalanceSheet_SecuritySoldNotYetRepurchased_TwelveMonths,
        FinancialStatements_BalanceSheet_SeparateAccountAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_SeparateAccountAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_SeparateAccountBusiness_ThreeMonths,
        FinancialStatements_BalanceSheet_SeparateAccountBusiness_TwelveMonths,
        FinancialStatements_BalanceSheet_ShortTermInvestmentsAvailableForSale_ThreeMonths,
        FinancialStatements_BalanceSheet_ShortTermInvestmentsAvailableForSale_TwelveMonths,
        FinancialStatements_BalanceSheet_ShortTermInvestmentsHeldToMaturity_ThreeMonths,
        FinancialStatements_BalanceSheet_ShortTermInvestmentsHeldToMaturity_TwelveMonths,
        FinancialStatements_BalanceSheet_ShortTermInvestmentsTrading_ThreeMonths,
        FinancialStatements_BalanceSheet_ShortTermInvestmentsTrading_TwelveMonths,
        FinancialStatements_BalanceSheet_StockholdersEquity_OneMonth,
        FinancialStatements_BalanceSheet_StockholdersEquity_TwoMonths,
        FinancialStatements_BalanceSheet_StockholdersEquity_ThreeMonths,
        FinancialStatements_BalanceSheet_StockholdersEquity_SixMonths,
        FinancialStatements_BalanceSheet_StockholdersEquity_NineMonths,
        FinancialStatements_BalanceSheet_StockholdersEquity_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalTaxPayable_OneMonth,
        FinancialStatements_BalanceSheet_TotalTaxPayable_TwoMonths,
        FinancialStatements_BalanceSheet_TotalTaxPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalTaxPayable_SixMonths,
        FinancialStatements_BalanceSheet_TotalTaxPayable_NineMonths,
        FinancialStatements_BalanceSheet_TotalTaxPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalAssets_OneMonth,
        FinancialStatements_BalanceSheet_TotalAssets_TwoMonths,
        FinancialStatements_BalanceSheet_TotalAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalAssets_SixMonths,
        FinancialStatements_BalanceSheet_TotalAssets_NineMonths,
        FinancialStatements_BalanceSheet_TotalAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalDeposits_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalDeposits_SixMonths,
        FinancialStatements_BalanceSheet_TotalDeposits_NineMonths,
        FinancialStatements_BalanceSheet_TotalDeposits_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalInvestments_SixMonths,
        FinancialStatements_BalanceSheet_TotalInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentAssets_OneMonth,
        FinancialStatements_BalanceSheet_TotalNonCurrentAssets_TwoMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentAssets_SixMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentAssets_NineMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalPartnershipCapital_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalPartnershipCapital_SixMonths,
        FinancialStatements_BalanceSheet_TotalPartnershipCapital_TwelveMonths,
        FinancialStatements_BalanceSheet_TradingAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_TradingAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_TradingLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_TradingLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_TradingSecurities_ThreeMonths,
        FinancialStatements_BalanceSheet_TradingSecurities_SixMonths,
        FinancialStatements_BalanceSheet_TradingSecurities_TwelveMonths,
        FinancialStatements_BalanceSheet_TreasuryStock_OneMonth,
        FinancialStatements_BalanceSheet_TreasuryStock_TwoMonths,
        FinancialStatements_BalanceSheet_TreasuryStock_ThreeMonths,
        FinancialStatements_BalanceSheet_TreasuryStock_SixMonths,
        FinancialStatements_BalanceSheet_TreasuryStock_NineMonths,
        FinancialStatements_BalanceSheet_TreasuryStock_TwelveMonths,
        FinancialStatements_BalanceSheet_UnearnedIncome_ThreeMonths,
        FinancialStatements_BalanceSheet_UnearnedIncome_SixMonths,
        FinancialStatements_BalanceSheet_UnearnedIncome_NineMonths,
        FinancialStatements_BalanceSheet_UnearnedIncome_TwelveMonths,
        FinancialStatements_BalanceSheet_UnearnedPremiums_ThreeMonths,
        FinancialStatements_BalanceSheet_UnearnedPremiums_SixMonths,
        FinancialStatements_BalanceSheet_UnearnedPremiums_NineMonths,
        FinancialStatements_BalanceSheet_UnearnedPremiums_TwelveMonths,
        FinancialStatements_BalanceSheet_UnpaidLossAndLossReserve_ThreeMonths,
        FinancialStatements_BalanceSheet_UnpaidLossAndLossReserve_SixMonths,
        FinancialStatements_BalanceSheet_UnpaidLossAndLossReserve_NineMonths,
        FinancialStatements_BalanceSheet_UnpaidLossAndLossReserve_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestedCapital_OneMonth,
        FinancialStatements_BalanceSheet_InvestedCapital_TwoMonths,
        FinancialStatements_BalanceSheet_InvestedCapital_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestedCapital_SixMonths,
        FinancialStatements_BalanceSheet_InvestedCapital_NineMonths,
        FinancialStatements_BalanceSheet_InvestedCapital_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredAssets_OneMonth,
        FinancialStatements_BalanceSheet_CurrentDeferredAssets_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredAssets_SixMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredAssets_NineMonths,
        FinancialStatements_BalanceSheet_CurrentDeferredAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredAssets_OneMonth,
        FinancialStatements_BalanceSheet_NonCurrentDeferredAssets_TwoMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredAssets_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredAssets_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentDeferredAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_SecuritiesAndInvestments_TwoMonths,
        FinancialStatements_BalanceSheet_SecuritiesAndInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_SecuritiesAndInvestments_SixMonths,
        FinancialStatements_BalanceSheet_SecuritiesAndInvestments_NineMonths,
        FinancialStatements_BalanceSheet_SecuritiesAndInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalLiabilitiesNetMinorityInterest_OneMonth,
        FinancialStatements_BalanceSheet_TotalLiabilitiesNetMinorityInterest_TwoMonths,
        FinancialStatements_BalanceSheet_TotalLiabilitiesNetMinorityInterest_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalLiabilitiesNetMinorityInterest_SixMonths,
        FinancialStatements_BalanceSheet_TotalLiabilitiesNetMinorityInterest_NineMonths,
        FinancialStatements_BalanceSheet_TotalLiabilitiesNetMinorityInterest_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentLiabilitiesNetMinorityInterest_OneMonth,
        FinancialStatements_BalanceSheet_TotalNonCurrentLiabilitiesNetMinorityInterest_TwoMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentLiabilitiesNetMinorityInterest_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentLiabilitiesNetMinorityInterest_SixMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentLiabilitiesNetMinorityInterest_NineMonths,
        FinancialStatements_BalanceSheet_TotalNonCurrentLiabilitiesNetMinorityInterest_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalEquityGrossMinorityInterest_OneMonth,
        FinancialStatements_BalanceSheet_TotalEquityGrossMinorityInterest_TwoMonths,
        FinancialStatements_BalanceSheet_TotalEquityGrossMinorityInterest_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalEquityGrossMinorityInterest_SixMonths,
        FinancialStatements_BalanceSheet_TotalEquityGrossMinorityInterest_NineMonths,
        FinancialStatements_BalanceSheet_TotalEquityGrossMinorityInterest_TwelveMonths,
        FinancialStatements_BalanceSheet_GrossAccountsReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_GrossAccountsReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccountsReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccountsReceivable_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccountsReceivable_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentAccountsReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_AccruedInterestReceivable_TwoMonths,
        FinancialStatements_BalanceSheet_AccruedInterestReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_AccruedInterestReceivable_SixMonths,
        FinancialStatements_BalanceSheet_AccruedInterestReceivable_NineMonths,
        FinancialStatements_BalanceSheet_AccruedInterestReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_AdvanceFromFederalHomeLoanBanks_ThreeMonths,
        FinancialStatements_BalanceSheet_AdvanceFromFederalHomeLoanBanks_SixMonths,
        FinancialStatements_BalanceSheet_AdvanceFromFederalHomeLoanBanks_NineMonths,
        FinancialStatements_BalanceSheet_AdvanceFromFederalHomeLoanBanks_TwelveMonths,
        FinancialStatements_BalanceSheet_AllowanceForDoubtfulAccountsReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_AllowanceForDoubtfulAccountsReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_AllowanceForNotesReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_AllowanceForNotesReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_AssetsHeldForSale_ThreeMonths,
        FinancialStatements_BalanceSheet_AssetsHeldForSale_TwelveMonths,
        FinancialStatements_BalanceSheet_AssetsOfDiscontinuedOperations_ThreeMonths,
        FinancialStatements_BalanceSheet_AssetsOfDiscontinuedOperations_TwelveMonths,
        FinancialStatements_BalanceSheet_BankIndebtedness_ThreeMonths,
        FinancialStatements_BalanceSheet_BankIndebtedness_TwelveMonths,
        FinancialStatements_BalanceSheet_BankOwnedLifeInsurance_ThreeMonths,
        FinancialStatements_BalanceSheet_BankOwnedLifeInsurance_SixMonths,
        FinancialStatements_BalanceSheet_BankOwnedLifeInsurance_NineMonths,
        FinancialStatements_BalanceSheet_BankOwnedLifeInsurance_TwelveMonths,
        FinancialStatements_BalanceSheet_SecurityBorrowed_ThreeMonths,
        FinancialStatements_BalanceSheet_SecurityBorrowed_TwelveMonths,
        FinancialStatements_BalanceSheet_BuildingsAndImprovements_OneMonth,
        FinancialStatements_BalanceSheet_BuildingsAndImprovements_TwoMonths,
        FinancialStatements_BalanceSheet_BuildingsAndImprovements_ThreeMonths,
        FinancialStatements_BalanceSheet_BuildingsAndImprovements_SixMonths,
        FinancialStatements_BalanceSheet_BuildingsAndImprovements_NineMonths,
        FinancialStatements_BalanceSheet_BuildingsAndImprovements_TwelveMonths,
        FinancialStatements_BalanceSheet_CommercialLoan_ThreeMonths,
        FinancialStatements_BalanceSheet_CommercialLoan_SixMonths,
        FinancialStatements_BalanceSheet_CommercialLoan_NineMonths,
        FinancialStatements_BalanceSheet_CommercialLoan_TwelveMonths,
        FinancialStatements_BalanceSheet_CommercialPaper_ThreeMonths,
        FinancialStatements_BalanceSheet_CommercialPaper_TwelveMonths,
        FinancialStatements_BalanceSheet_CommonStockEquity_OneMonth,
        FinancialStatements_BalanceSheet_CommonStockEquity_TwoMonths,
        FinancialStatements_BalanceSheet_CommonStockEquity_ThreeMonths,
        FinancialStatements_BalanceSheet_CommonStockEquity_SixMonths,
        FinancialStatements_BalanceSheet_CommonStockEquity_NineMonths,
        FinancialStatements_BalanceSheet_CommonStockEquity_TwelveMonths,
        FinancialStatements_BalanceSheet_ConstructionInProgress_OneMonth,
        FinancialStatements_BalanceSheet_ConstructionInProgress_TwoMonths,
        FinancialStatements_BalanceSheet_ConstructionInProgress_ThreeMonths,
        FinancialStatements_BalanceSheet_ConstructionInProgress_SixMonths,
        FinancialStatements_BalanceSheet_ConstructionInProgress_NineMonths,
        FinancialStatements_BalanceSheet_ConstructionInProgress_TwelveMonths,
        FinancialStatements_BalanceSheet_ConsumerLoan_ThreeMonths,
        FinancialStatements_BalanceSheet_ConsumerLoan_SixMonths,
        FinancialStatements_BalanceSheet_ConsumerLoan_NineMonths,
        FinancialStatements_BalanceSheet_ConsumerLoan_TwelveMonths,
        FinancialStatements_BalanceSheet_MinimumPensionLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_MinimumPensionLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_CustomerAcceptances_ThreeMonths,
        FinancialStatements_BalanceSheet_CustomerAcceptances_TwelveMonths,
        FinancialStatements_BalanceSheet_DefinedPensionBenefit_ThreeMonths,
        FinancialStatements_BalanceSheet_DefinedPensionBenefit_SixMonths,
        FinancialStatements_BalanceSheet_DefinedPensionBenefit_TwelveMonths,
        FinancialStatements_BalanceSheet_DerivativeProductLiabilities_OneMonth,
        FinancialStatements_BalanceSheet_DerivativeProductLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_DerivativeProductLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_DerivativeProductLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_DerivativeProductLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_DerivativeProductLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_DerivativeAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_DerivativeAssets_SixMonths,
        FinancialStatements_BalanceSheet_DerivativeAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_DividendsPayable_OneMonth,
        FinancialStatements_BalanceSheet_DividendsPayable_TwoMonths,
        FinancialStatements_BalanceSheet_DividendsPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_DividendsPayable_NineMonths,
        FinancialStatements_BalanceSheet_DividendsPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_EmployeeBenefits_TwoMonths,
        FinancialStatements_BalanceSheet_EmployeeBenefits_ThreeMonths,
        FinancialStatements_BalanceSheet_EmployeeBenefits_SixMonths,
        FinancialStatements_BalanceSheet_EmployeeBenefits_NineMonths,
        FinancialStatements_BalanceSheet_EmployeeBenefits_TwelveMonths,
        FinancialStatements_BalanceSheet_FederalFundsPurchased_ThreeMonths,
        FinancialStatements_BalanceSheet_FederalFundsPurchased_TwelveMonths,
        FinancialStatements_BalanceSheet_FederalFundsSold_ThreeMonths,
        FinancialStatements_BalanceSheet_FederalFundsSold_SixMonths,
        FinancialStatements_BalanceSheet_FederalFundsSold_TwelveMonths,
        FinancialStatements_BalanceSheet_FederalHomeLoanBankStock_ThreeMonths,
        FinancialStatements_BalanceSheet_FederalHomeLoanBankStock_SixMonths,
        FinancialStatements_BalanceSheet_FederalHomeLoanBankStock_NineMonths,
        FinancialStatements_BalanceSheet_FederalHomeLoanBankStock_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialAssets_NineMonths,
        FinancialStatements_BalanceSheet_FinancialAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialInstrumentsSoldUnderAgreementsToRepurchase_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialInstrumentsSoldUnderAgreementsToRepurchase_SixMonths,
        FinancialStatements_BalanceSheet_FinancialInstrumentsSoldUnderAgreementsToRepurchase_TwelveMonths,
        FinancialStatements_BalanceSheet_FinishedGoods_OneMonth,
        FinancialStatements_BalanceSheet_FinishedGoods_TwoMonths,
        FinancialStatements_BalanceSheet_FinishedGoods_ThreeMonths,
        FinancialStatements_BalanceSheet_FinishedGoods_SixMonths,
        FinancialStatements_BalanceSheet_FinishedGoods_NineMonths,
        FinancialStatements_BalanceSheet_FinishedGoods_TwelveMonths,
        FinancialStatements_BalanceSheet_FlightFleetVehicleAndRelatedEquipments_ThreeMonths,
        FinancialStatements_BalanceSheet_FlightFleetVehicleAndRelatedEquipments_SixMonths,
        FinancialStatements_BalanceSheet_FlightFleetVehicleAndRelatedEquipments_TwelveMonths,
        FinancialStatements_BalanceSheet_ForeclosedAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_ForeclosedAssets_NineMonths,
        FinancialStatements_BalanceSheet_ForeclosedAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_ForeignCurrencyTranslationAdjustments_TwoMonths,
        FinancialStatements_BalanceSheet_ForeignCurrencyTranslationAdjustments_ThreeMonths,
        FinancialStatements_BalanceSheet_ForeignCurrencyTranslationAdjustments_SixMonths,
        FinancialStatements_BalanceSheet_ForeignCurrencyTranslationAdjustments_NineMonths,
        FinancialStatements_BalanceSheet_ForeignCurrencyTranslationAdjustments_TwelveMonths,
        FinancialStatements_BalanceSheet_InventoriesAdjustmentsAllowances_ThreeMonths,
        FinancialStatements_BalanceSheet_InventoriesAdjustmentsAllowances_SixMonths,
        FinancialStatements_BalanceSheet_InventoriesAdjustmentsAllowances_NineMonths,
        FinancialStatements_BalanceSheet_InventoriesAdjustmentsAllowances_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentsInOtherVenturesUnderEquityMethod_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentsInOtherVenturesUnderEquityMethod_TwelveMonths,
        FinancialStatements_BalanceSheet_LandAndImprovements_OneMonth,
        FinancialStatements_BalanceSheet_LandAndImprovements_TwoMonths,
        FinancialStatements_BalanceSheet_LandAndImprovements_ThreeMonths,
        FinancialStatements_BalanceSheet_LandAndImprovements_SixMonths,
        FinancialStatements_BalanceSheet_LandAndImprovements_NineMonths,
        FinancialStatements_BalanceSheet_LandAndImprovements_TwelveMonths,
        FinancialStatements_BalanceSheet_Leases_OneMonth,
        FinancialStatements_BalanceSheet_Leases_TwoMonths,
        FinancialStatements_BalanceSheet_Leases_ThreeMonths,
        FinancialStatements_BalanceSheet_Leases_SixMonths,
        FinancialStatements_BalanceSheet_Leases_NineMonths,
        FinancialStatements_BalanceSheet_Leases_TwelveMonths,
        FinancialStatements_BalanceSheet_LiabilitiesOfDiscontinuedOperations_ThreeMonths,
        FinancialStatements_BalanceSheet_LiabilitiesOfDiscontinuedOperations_TwelveMonths,
        FinancialStatements_BalanceSheet_LineOfCredit_OneMonth,
        FinancialStatements_BalanceSheet_LineOfCredit_ThreeMonths,
        FinancialStatements_BalanceSheet_LineOfCredit_NineMonths,
        FinancialStatements_BalanceSheet_LineOfCredit_TwelveMonths,
        FinancialStatements_BalanceSheet_LoansHeldForSale_ThreeMonths,
        FinancialStatements_BalanceSheet_LoansHeldForSale_SixMonths,
        FinancialStatements_BalanceSheet_LoansHeldForSale_NineMonths,
        FinancialStatements_BalanceSheet_LoansHeldForSale_TwelveMonths,
        FinancialStatements_BalanceSheet_LoansReceivable_TwoMonths,
        FinancialStatements_BalanceSheet_LoansReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_LoansReceivable_SixMonths,
        FinancialStatements_BalanceSheet_LoansReceivable_NineMonths,
        FinancialStatements_BalanceSheet_LoansReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_MachineryFurnitureEquipment_OneMonth,
        FinancialStatements_BalanceSheet_MachineryFurnitureEquipment_TwoMonths,
        FinancialStatements_BalanceSheet_MachineryFurnitureEquipment_ThreeMonths,
        FinancialStatements_BalanceSheet_MachineryFurnitureEquipment_SixMonths,
        FinancialStatements_BalanceSheet_MachineryFurnitureEquipment_NineMonths,
        FinancialStatements_BalanceSheet_MachineryFurnitureEquipment_TwelveMonths,
        FinancialStatements_BalanceSheet_MaterialsAndSupplies_ThreeMonths,
        FinancialStatements_BalanceSheet_MaterialsAndSupplies_TwelveMonths,
        FinancialStatements_BalanceSheet_MineralProperties_ThreeMonths,
        FinancialStatements_BalanceSheet_MineralProperties_SixMonths,
        FinancialStatements_BalanceSheet_MineralProperties_NineMonths,
        FinancialStatements_BalanceSheet_MineralProperties_TwelveMonths,
        FinancialStatements_BalanceSheet_MortgageLoan_ThreeMonths,
        FinancialStatements_BalanceSheet_MortgageLoan_SixMonths,
        FinancialStatements_BalanceSheet_MortgageLoan_NineMonths,
        FinancialStatements_BalanceSheet_MortgageLoan_TwelveMonths,
        FinancialStatements_BalanceSheet_MortgageAndConsumerloans_ThreeMonths,
        FinancialStatements_BalanceSheet_MortgageAndConsumerloans_TwelveMonths,
        FinancialStatements_BalanceSheet_GrossNotesReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_GrossNotesReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherAssets_TwoMonths,
        FinancialStatements_BalanceSheet_OtherAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherAssets_SixMonths,
        FinancialStatements_BalanceSheet_OtherAssets_NineMonths,
        FinancialStatements_BalanceSheet_OtherAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherCapitalStock_OneMonth,
        FinancialStatements_BalanceSheet_OtherCapitalStock_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherCapitalStock_NineMonths,
        FinancialStatements_BalanceSheet_OtherCapitalStock_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherCurrentAssets_OneMonth,
        FinancialStatements_BalanceSheet_OtherCurrentAssets_TwoMonths,
        FinancialStatements_BalanceSheet_OtherCurrentAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherCurrentAssets_SixMonths,
        FinancialStatements_BalanceSheet_OtherCurrentAssets_NineMonths,
        FinancialStatements_BalanceSheet_OtherCurrentAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherCurrentBorrowings_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherCurrentBorrowings_SixMonths,
        FinancialStatements_BalanceSheet_OtherCurrentBorrowings_NineMonths,
        FinancialStatements_BalanceSheet_OtherCurrentBorrowings_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherEquityAdjustments_TwoMonths,
        FinancialStatements_BalanceSheet_OtherEquityAdjustments_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherEquityAdjustments_SixMonths,
        FinancialStatements_BalanceSheet_OtherEquityAdjustments_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherInventories_OneMonth,
        FinancialStatements_BalanceSheet_OtherInventories_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherInventories_SixMonths,
        FinancialStatements_BalanceSheet_OtherInventories_NineMonths,
        FinancialStatements_BalanceSheet_OtherInventories_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherInvestedAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherInvestedAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentAssets_OneMonth,
        FinancialStatements_BalanceSheet_OtherNonCurrentAssets_TwoMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentAssets_SixMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentAssets_NineMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherProperties_OneMonth,
        FinancialStatements_BalanceSheet_OtherProperties_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherProperties_SixMonths,
        FinancialStatements_BalanceSheet_OtherProperties_NineMonths,
        FinancialStatements_BalanceSheet_OtherProperties_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherRealEstateOwned_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherRealEstateOwned_SixMonths,
        FinancialStatements_BalanceSheet_OtherRealEstateOwned_NineMonths,
        FinancialStatements_BalanceSheet_OtherRealEstateOwned_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherReceivables_TwoMonths,
        FinancialStatements_BalanceSheet_OtherReceivables_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherReceivables_SixMonths,
        FinancialStatements_BalanceSheet_OtherReceivables_NineMonths,
        FinancialStatements_BalanceSheet_OtherReceivables_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentPensionAndOtherPostretirementBenefitPlans_TwoMonths,
        FinancialStatements_BalanceSheet_NonCurrentPensionAndOtherPostretirementBenefitPlans_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentPensionAndOtherPostretirementBenefitPlans_SixMonths,
        FinancialStatements_BalanceSheet_NonCurrentPensionAndOtherPostretirementBenefitPlans_NineMonths,
        FinancialStatements_BalanceSheet_NonCurrentPensionAndOtherPostretirementBenefitPlans_TwelveMonths,
        FinancialStatements_BalanceSheet_PolicyLoans_ThreeMonths,
        FinancialStatements_BalanceSheet_PolicyLoans_TwelveMonths,
        FinancialStatements_BalanceSheet_PreferredStockEquity_OneMonth,
        FinancialStatements_BalanceSheet_PreferredStockEquity_TwoMonths,
        FinancialStatements_BalanceSheet_PreferredStockEquity_ThreeMonths,
        FinancialStatements_BalanceSheet_PreferredStockEquity_SixMonths,
        FinancialStatements_BalanceSheet_PreferredStockEquity_NineMonths,
        FinancialStatements_BalanceSheet_PreferredStockEquity_TwelveMonths,
        FinancialStatements_BalanceSheet_Properties_ThreeMonths,
        FinancialStatements_BalanceSheet_Properties_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentProvisions_TwoMonths,
        FinancialStatements_BalanceSheet_CurrentProvisions_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentProvisions_SixMonths,
        FinancialStatements_BalanceSheet_CurrentProvisions_TwelveMonths,
        FinancialStatements_BalanceSheet_LongTermProvisions_ThreeMonths,
        FinancialStatements_BalanceSheet_LongTermProvisions_SixMonths,
        FinancialStatements_BalanceSheet_LongTermProvisions_NineMonths,
        FinancialStatements_BalanceSheet_LongTermProvisions_TwelveMonths,
        FinancialStatements_BalanceSheet_RawMaterials_TwoMonths,
        FinancialStatements_BalanceSheet_RawMaterials_ThreeMonths,
        FinancialStatements_BalanceSheet_RawMaterials_SixMonths,
        FinancialStatements_BalanceSheet_RawMaterials_NineMonths,
        FinancialStatements_BalanceSheet_RawMaterials_TwelveMonths,
        FinancialStatements_BalanceSheet_ReceivablesAdjustmentsAllowances_ThreeMonths,
        FinancialStatements_BalanceSheet_ReceivablesAdjustmentsAllowances_NineMonths,
        FinancialStatements_BalanceSheet_ReceivablesAdjustmentsAllowances_TwelveMonths,
        FinancialStatements_BalanceSheet_RegulatoryAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_RegulatoryAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_RegulatoryLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_RegulatoryLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_ReinsuranceBalancesPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_ReinsuranceBalancesPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_RestrictedCash_OneMonth,
        FinancialStatements_BalanceSheet_RestrictedCash_TwoMonths,
        FinancialStatements_BalanceSheet_RestrictedCash_ThreeMonths,
        FinancialStatements_BalanceSheet_RestrictedCash_SixMonths,
        FinancialStatements_BalanceSheet_RestrictedCash_NineMonths,
        FinancialStatements_BalanceSheet_RestrictedCash_TwelveMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndCashEquivalents_ThreeMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndCashEquivalents_SixMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndCashEquivalents_NineMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndCashEquivalents_TwelveMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndInvestments_SixMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndInvestments_NineMonths,
        FinancialStatements_BalanceSheet_RestrictedCashAndInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_RestrictedCommonStock_ThreeMonths,
        FinancialStatements_BalanceSheet_RestrictedCommonStock_NineMonths,
        FinancialStatements_BalanceSheet_RestrictedCommonStock_TwelveMonths,
        FinancialStatements_BalanceSheet_RestrictedInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_RestrictedInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_TaxesReceivable_TwoMonths,
        FinancialStatements_BalanceSheet_TaxesReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_TaxesReceivable_SixMonths,
        FinancialStatements_BalanceSheet_TaxesReceivable_NineMonths,
        FinancialStatements_BalanceSheet_TaxesReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalCapitalization_OneMonth,
        FinancialStatements_BalanceSheet_TotalCapitalization_TwoMonths,
        FinancialStatements_BalanceSheet_TotalCapitalization_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalCapitalization_SixMonths,
        FinancialStatements_BalanceSheet_TotalCapitalization_NineMonths,
        FinancialStatements_BalanceSheet_TotalCapitalization_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalDeferredCreditsAndOtherNonCurrentLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalDeferredCreditsAndOtherNonCurrentLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_TotalDeferredCreditsAndOtherNonCurrentLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_TotalDeferredCreditsAndOtherNonCurrentLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_UnbilledReceivables_ThreeMonths,
        FinancialStatements_BalanceSheet_UnbilledReceivables_TwelveMonths,
        FinancialStatements_BalanceSheet_UnrealizedGainLoss_ThreeMonths,
        FinancialStatements_BalanceSheet_UnrealizedGainLoss_SixMonths,
        FinancialStatements_BalanceSheet_UnrealizedGainLoss_TwelveMonths,
        FinancialStatements_BalanceSheet_WorkInProcess_OneMonth,
        FinancialStatements_BalanceSheet_WorkInProcess_TwoMonths,
        FinancialStatements_BalanceSheet_WorkInProcess_ThreeMonths,
        FinancialStatements_BalanceSheet_WorkInProcess_SixMonths,
        FinancialStatements_BalanceSheet_WorkInProcess_NineMonths,
        FinancialStatements_BalanceSheet_WorkInProcess_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentLiabilities_OneMonth,
        FinancialStatements_BalanceSheet_OtherNonCurrentLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_OtherNonCurrentLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_CapitalLeaseObligations_OneMonth,
        FinancialStatements_BalanceSheet_CapitalLeaseObligations_TwoMonths,
        FinancialStatements_BalanceSheet_CapitalLeaseObligations_ThreeMonths,
        FinancialStatements_BalanceSheet_CapitalLeaseObligations_SixMonths,
        FinancialStatements_BalanceSheet_CapitalLeaseObligations_NineMonths,
        FinancialStatements_BalanceSheet_CapitalLeaseObligations_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherLiabilities_TwoMonths,
        FinancialStatements_BalanceSheet_OtherLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherLiabilities_SixMonths,
        FinancialStatements_BalanceSheet_OtherLiabilities_NineMonths,
        FinancialStatements_BalanceSheet_OtherLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherPayable_OneMonth,
        FinancialStatements_BalanceSheet_OtherPayable_TwoMonths,
        FinancialStatements_BalanceSheet_OtherPayable_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherPayable_SixMonths,
        FinancialStatements_BalanceSheet_OtherPayable_NineMonths,
        FinancialStatements_BalanceSheet_OtherPayable_TwelveMonths,
        FinancialStatements_BalanceSheet_TangibleBookValue_OneMonth,
        FinancialStatements_BalanceSheet_TangibleBookValue_TwoMonths,
        FinancialStatements_BalanceSheet_TangibleBookValue_ThreeMonths,
        FinancialStatements_BalanceSheet_TangibleBookValue_SixMonths,
        FinancialStatements_BalanceSheet_TangibleBookValue_NineMonths,
        FinancialStatements_BalanceSheet_TangibleBookValue_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalEquity_OneMonth,
        FinancialStatements_BalanceSheet_TotalEquity_TwoMonths,
        FinancialStatements_BalanceSheet_TotalEquity_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalEquity_SixMonths,
        FinancialStatements_BalanceSheet_TotalEquity_NineMonths,
        FinancialStatements_BalanceSheet_TotalEquity_TwelveMonths,
        FinancialStatements_BalanceSheet_WorkingCapital_OneMonth,
        FinancialStatements_BalanceSheet_WorkingCapital_TwoMonths,
        FinancialStatements_BalanceSheet_WorkingCapital_ThreeMonths,
        FinancialStatements_BalanceSheet_WorkingCapital_SixMonths,
        FinancialStatements_BalanceSheet_WorkingCapital_NineMonths,
        FinancialStatements_BalanceSheet_WorkingCapital_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalDebt_OneMonth,
        FinancialStatements_BalanceSheet_TotalDebt_TwoMonths,
        FinancialStatements_BalanceSheet_TotalDebt_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalDebt_SixMonths,
        FinancialStatements_BalanceSheet_TotalDebt_NineMonths,
        FinancialStatements_BalanceSheet_TotalDebt_TwelveMonths,
        FinancialStatements_BalanceSheet_CommonUtilityPlant_ThreeMonths,
        FinancialStatements_BalanceSheet_CommonUtilityPlant_NineMonths,
        FinancialStatements_BalanceSheet_CommonUtilityPlant_TwelveMonths,
        FinancialStatements_BalanceSheet_ElectricUtilityPlant_ThreeMonths,
        FinancialStatements_BalanceSheet_ElectricUtilityPlant_TwelveMonths,
        FinancialStatements_BalanceSheet_NaturalGasFuelAndOther_ThreeMonths,
        FinancialStatements_BalanceSheet_NaturalGasFuelAndOther_TwelveMonths,
        FinancialStatements_BalanceSheet_NetUtilityPlant_ThreeMonths,
        FinancialStatements_BalanceSheet_NetUtilityPlant_NineMonths,
        FinancialStatements_BalanceSheet_NetUtilityPlant_TwelveMonths,
        FinancialStatements_BalanceSheet_WaterProduction_ThreeMonths,
        FinancialStatements_BalanceSheet_WaterProduction_TwelveMonths,
        FinancialStatements_BalanceSheet_OrdinarySharesNumber_ThreeMonths,
        FinancialStatements_BalanceSheet_OrdinarySharesNumber_TwelveMonths,
        FinancialStatements_BalanceSheet_PreferredSharesNumber_ThreeMonths,
        FinancialStatements_BalanceSheet_PreferredSharesNumber_TwelveMonths,
        FinancialStatements_BalanceSheet_TreasurySharesNumber_ThreeMonths,
        FinancialStatements_BalanceSheet_TreasurySharesNumber_TwelveMonths,
        FinancialStatements_BalanceSheet_TradingAndOtherReceivable_ThreeMonths,
        FinancialStatements_BalanceSheet_TradingAndOtherReceivable_TwelveMonths,
        FinancialStatements_BalanceSheet_EquityAttributableToOwnersOfParent_TwoMonths,
        FinancialStatements_BalanceSheet_EquityAttributableToOwnersOfParent_ThreeMonths,
        FinancialStatements_BalanceSheet_EquityAttributableToOwnersOfParent_TwelveMonths,
        FinancialStatements_BalanceSheet_SecuritiesLoaned_ThreeMonths,
        FinancialStatements_BalanceSheet_SecuritiesLoaned_TwelveMonths,
        FinancialStatements_BalanceSheet_NetTangibleAssets_OneMonth,
        FinancialStatements_BalanceSheet_NetTangibleAssets_TwoMonths,
        FinancialStatements_BalanceSheet_NetTangibleAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_NetTangibleAssets_SixMonths,
        FinancialStatements_BalanceSheet_NetTangibleAssets_NineMonths,
        FinancialStatements_BalanceSheet_NetTangibleAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_DuefromRelatedPartiesCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_DuefromRelatedPartiesCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_DuefromRelatedPartiesNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_DuefromRelatedPartiesNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_DuetoRelatedParties_ThreeMonths,
        FinancialStatements_BalanceSheet_DuetoRelatedParties_TwelveMonths,
        FinancialStatements_BalanceSheet_DuetoRelatedPartiesCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_DuetoRelatedPartiesCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_DuetoRelatedPartiesNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_DuetoRelatedPartiesNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentProperties_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentProperties_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentsinSubsidiariesatCost_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentsinSubsidiariesatCost_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentsinAssociatesatCost_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentsinAssociatesatCost_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentsinJointVenturesatCost_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentsinJointVenturesatCost_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentinFinancialAssets_TwoMonths,
        FinancialStatements_BalanceSheet_InvestmentinFinancialAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentinFinancialAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_FinanceLeaseReceivables_ThreeMonths,
        FinancialStatements_BalanceSheet_FinanceLeaseReceivables_TwelveMonths,
        FinancialStatements_BalanceSheet_ConvertibleLoansCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_BankLoansCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_BankLoansCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherLoansCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherLoansCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_AccruedandDeferredIncome_ThreeMonths,
        FinancialStatements_BalanceSheet_AccruedandDeferredIncome_TwelveMonths,
        FinancialStatements_BalanceSheet_BankLoansNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_BankLoansNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherLoansNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherLoansNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherReserves_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherReserves_TwelveMonths,
        FinancialStatements_BalanceSheet_LoansandAdvancestoBank_ThreeMonths,
        FinancialStatements_BalanceSheet_LoansandAdvancestoBank_TwelveMonths,
        FinancialStatements_BalanceSheet_LoansandAdvancestoCustomer_ThreeMonths,
        FinancialStatements_BalanceSheet_LoansandAdvancestoCustomer_TwelveMonths,
        FinancialStatements_BalanceSheet_TreasuryBillsandOtherEligibleBills_ThreeMonths,
        FinancialStatements_BalanceSheet_TreasuryBillsandOtherEligibleBills_TwelveMonths,
        FinancialStatements_BalanceSheet_EquitySharesInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_EquitySharesInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_DepositsbyBank_ThreeMonths,
        FinancialStatements_BalanceSheet_DepositsbyBank_TwelveMonths,
        FinancialStatements_BalanceSheet_CustomerAccounts_ThreeMonths,
        FinancialStatements_BalanceSheet_CustomerAccounts_TwelveMonths,
        FinancialStatements_BalanceSheet_ItemsinTheCourseofTransmissiontoOtherBanks_ThreeMonths,
        FinancialStatements_BalanceSheet_ItemsinTheCourseofTransmissiontoOtherBanks_TwelveMonths,
        FinancialStatements_BalanceSheet_TradingandFinancialLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_TradingandFinancialLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_DebtSecuritiesinIssue_ThreeMonths,
        FinancialStatements_BalanceSheet_DebtSecuritiesinIssue_TwelveMonths,
        FinancialStatements_BalanceSheet_SubordinatedLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_SubordinatedLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_ProvisionsTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_ProvisionsTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_OperatingLeaseAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_OperatingLeaseAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_ClaimsOutstanding_ThreeMonths,
        FinancialStatements_BalanceSheet_ClaimsOutstanding_TwelveMonths,
        FinancialStatements_BalanceSheet_LiabilitiesHeldforSaleCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_LiabilitiesHeldforSaleCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_LiabilitiesHeldforSaleNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_LiabilitiesHeldforSaleNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_DebtSecurities_ThreeMonths,
        FinancialStatements_BalanceSheet_DebtSecurities_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalFinancialLeaseObligations_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalFinancialLeaseObligations_TwelveMonths,
        FinancialStatements_BalanceSheet_AccruedandDeferredIncomeCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_AccruedandDeferredIncomeCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_AccruedandDeferredIncomeNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_AccruedandDeferredIncomeNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_FinanceLeaseReceivablesCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_FinanceLeaseReceivablesCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_FinanceLeaseReceivablesNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_FinanceLeaseReceivablesNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialAssetsDesignatedasFairValueThroughProfitorLossTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialAssetsDesignatedasFairValueThroughProfitorLossTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_TaxesAssetsCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_TaxesAssetsCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherEquityInterest_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherEquityInterest_TwelveMonths,
        FinancialStatements_BalanceSheet_InterestBearingBorrowingsNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_InterestBearingBorrowingsNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingBorrowingsNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingBorrowingsNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_TradeandOtherPayablesNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_TradeandOtherPayablesNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingBorrowingsCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingBorrowingsCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_PensionandOtherPostRetirementBenefitPlansCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_PensionandOtherPostRetirementBenefitPlansCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherLoanAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherLoanAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_AssetsPledgedasCollateralSubjecttoSaleorRepledgingTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_AssetsPledgedasCollateralSubjecttoSaleorRepledgingTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_TaxAssetsTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_TaxAssetsTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_AdvancesfromCentralBanks_ThreeMonths,
        FinancialStatements_BalanceSheet_AdvancesfromCentralBanks_TwelveMonths,
        FinancialStatements_BalanceSheet_DepositCertificates_ThreeMonths,
        FinancialStatements_BalanceSheet_DepositCertificates_TwelveMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingBorrowingsTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_NonInterestBearingBorrowingsTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherBorrowedFunds_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherBorrowedFunds_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesDesignatedasFairValueThroughProfitorLossTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesDesignatedasFairValueThroughProfitorLossTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesMeasuredatAmortizedCostTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialLiabilitiesMeasuredatAmortizedCostTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_AccruedLiabilitiesTotal_TwoMonths,
        FinancialStatements_BalanceSheet_AccruedLiabilitiesTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_AccruedLiabilitiesTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_DeferredIncomeTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_DeferredIncomeTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_DeferredTaxLiabilitiesTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_DeferredTaxLiabilitiesTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_ReinsuranceAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_ReinsuranceAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_DepositsMadeunderAssumedReinsuranceContract_ThreeMonths,
        FinancialStatements_BalanceSheet_DepositsMadeunderAssumedReinsuranceContract_TwelveMonths,
        FinancialStatements_BalanceSheet_InsuranceContractAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_InsuranceContractAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_InsuranceContractLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_InsuranceContractLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_DepositsReceivedunderCededInsuranceContract_ThreeMonths,
        FinancialStatements_BalanceSheet_DepositsReceivedunderCededInsuranceContract_TwelveMonths,
        FinancialStatements_BalanceSheet_InvestmentContractLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_InvestmentContractLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_PensionAndOtherPostretirementBenefitPlansTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_PensionAndOtherPostretirementBenefitPlansTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_LiabilitiesHeldforSaleTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_LiabilitiesHeldforSaleTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_HedgingAssetsCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_HedgingAssetsCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_ConvertibleLoansTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_ConvertibleLoansTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_BankLoansTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_BankLoansTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherLoansTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherLoansTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_InsuranceFundsNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_InsuranceFundsNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_DebtTotal_ThreeMonths,
        FinancialStatements_BalanceSheet_DebtTotal_TwelveMonths,
        FinancialStatements_BalanceSheet_ComTreShaNum_ThreeMonths,
        FinancialStatements_BalanceSheet_ComTreShaNum_TwelveMonths,
        FinancialStatements_BalanceSheet_PreTreShaNum_ThreeMonths,
        FinancialStatements_BalanceSheet_PreTreShaNum_TwelveMonths,
        FinancialStatements_BalanceSheet_NetDebt_OneMonth,
        FinancialStatements_BalanceSheet_NetDebt_TwoMonths,
        FinancialStatements_BalanceSheet_NetDebt_ThreeMonths,
        FinancialStatements_BalanceSheet_NetDebt_SixMonths,
        FinancialStatements_BalanceSheet_NetDebt_NineMonths,
        FinancialStatements_BalanceSheet_NetDebt_TwelveMonths,
        FinancialStatements_BalanceSheet_ShareIssued_ThreeMonths,
        FinancialStatements_BalanceSheet_ShareIssued_TwelveMonths,
        FinancialStatements_BalanceSheet_AssetsHeldForSaleCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_AssetsHeldForSaleCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_AssetsHeldForSaleNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_AssetsHeldForSaleNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_BiologicalAssets_ThreeMonths,
        FinancialStatements_BalanceSheet_BiologicalAssets_TwelveMonths,
        FinancialStatements_BalanceSheet_CashRestrictedOrPledged_ThreeMonths,
        FinancialStatements_BalanceSheet_CashRestrictedOrPledged_TwelveMonths,
        FinancialStatements_BalanceSheet_ConvertibleLoansNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_ConvertibleLoansNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_FinancialOrDerivativeInvestmentCurrentLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_FinancialOrDerivativeInvestmentCurrentLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherInvestments_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherInvestments_TwelveMonths,
        FinancialStatements_BalanceSheet_TradeAndOtherReceivablesNonCurrent_ThreeMonths,
        FinancialStatements_BalanceSheet_TradeAndOtherReceivablesNonCurrent_TwelveMonths,
        FinancialStatements_BalanceSheet_DueFromRelatedParties_ThreeMonths,
        FinancialStatements_BalanceSheet_DueFromRelatedParties_TwelveMonths,
        FinancialStatements_BalanceSheet_UnallocatedSurplus_ThreeMonths,
        FinancialStatements_BalanceSheet_UnallocatedSurplus_TwelveMonths,
        FinancialStatements_BalanceSheet_DebtDueInYear1_ThreeMonths,
        FinancialStatements_BalanceSheet_DebtDueInYear1_TwelveMonths,
        FinancialStatements_BalanceSheet_DebtDueInYear2_ThreeMonths,
        FinancialStatements_BalanceSheet_DebtDueInYear2_TwelveMonths,
        FinancialStatements_BalanceSheet_DebtDueInYear5_ThreeMonths,
        FinancialStatements_BalanceSheet_DebtDueInYear5_TwelveMonths,
        FinancialStatements_BalanceSheet_DebtDueBeyond_ThreeMonths,
        FinancialStatements_BalanceSheet_DebtDueBeyond_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalDebtInMaturitySchedule_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalDebtInMaturitySchedule_TwelveMonths,
        FinancialStatements_BalanceSheet_FixedAssetsRevaluationReserve_ThreeMonths,
        FinancialStatements_BalanceSheet_FixedAssetsRevaluationReserve_TwelveMonths,
        FinancialStatements_BalanceSheet_CurrentOtherFinancialLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_CurrentOtherFinancialLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_NonCurrentOtherFinancialLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_NonCurrentOtherFinancialLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_OtherFinancialLiabilities_ThreeMonths,
        FinancialStatements_BalanceSheet_OtherFinancialLiabilities_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalLiabilitiesAsReported_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalLiabilitiesAsReported_TwelveMonths,
        FinancialStatements_BalanceSheet_TotalEquityAsReported_ThreeMonths,
        FinancialStatements_BalanceSheet_TotalEquityAsReported_TwelveMonths,
        FinancialStatements_CashFlowStatement_CFFileDate_OneMonth,
        FinancialStatements_CashFlowStatement_CFFileDate_TwoMonths,
        FinancialStatements_CashFlowStatement_CFFileDate_ThreeMonths,
        FinancialStatements_CashFlowStatement_CFFileDate_SixMonths,
        FinancialStatements_CashFlowStatement_CFFileDate_NineMonths,
        FinancialStatements_CashFlowStatement_CFFileDate_TwelveMonths,
        FinancialStatements_CashFlowStatement_Amortization_OneMonth,
        FinancialStatements_CashFlowStatement_Amortization_TwoMonths,
        FinancialStatements_CashFlowStatement_Amortization_ThreeMonths,
        FinancialStatements_CashFlowStatement_Amortization_SixMonths,
        FinancialStatements_CashFlowStatement_Amortization_NineMonths,
        FinancialStatements_CashFlowStatement_Amortization_TwelveMonths,
        FinancialStatements_CashFlowStatement_CapitalExpenditure_OneMonth,
        FinancialStatements_CashFlowStatement_CapitalExpenditure_TwoMonths,
        FinancialStatements_CashFlowStatement_CapitalExpenditure_ThreeMonths,
        FinancialStatements_CashFlowStatement_CapitalExpenditure_SixMonths,
        FinancialStatements_CashFlowStatement_CapitalExpenditure_NineMonths,
        FinancialStatements_CashFlowStatement_CapitalExpenditure_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashDividendsPaid_OneMonth,
        FinancialStatements_CashFlowStatement_CashDividendsPaid_TwoMonths,
        FinancialStatements_CashFlowStatement_CashDividendsPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashDividendsPaid_SixMonths,
        FinancialStatements_CashFlowStatement_CashDividendsPaid_NineMonths,
        FinancialStatements_CashFlowStatement_CashDividendsPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingFinancingActivities_TwoMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingFinancingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingFinancingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingFinancingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingFinancingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingInvestingActivities_TwoMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingInvestingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingInvestingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingInvestingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingInvestingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingOperatingActivities_TwoMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingOperatingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingOperatingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingOperatingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromContinuingOperatingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromDiscontinuedOperation_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromDiscontinuedOperation_SixMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromDiscontinuedOperation_NineMonths,
        FinancialStatements_CashFlowStatement_CashFlowFromDiscontinuedOperation_TwelveMonths,
        FinancialStatements_CashFlowStatement_FinancingCashFlow_OneMonth,
        FinancialStatements_CashFlowStatement_FinancingCashFlow_TwoMonths,
        FinancialStatements_CashFlowStatement_FinancingCashFlow_ThreeMonths,
        FinancialStatements_CashFlowStatement_FinancingCashFlow_SixMonths,
        FinancialStatements_CashFlowStatement_FinancingCashFlow_NineMonths,
        FinancialStatements_CashFlowStatement_FinancingCashFlow_TwelveMonths,
        FinancialStatements_CashFlowStatement_InvestingCashFlow_OneMonth,
        FinancialStatements_CashFlowStatement_InvestingCashFlow_TwoMonths,
        FinancialStatements_CashFlowStatement_InvestingCashFlow_ThreeMonths,
        FinancialStatements_CashFlowStatement_InvestingCashFlow_SixMonths,
        FinancialStatements_CashFlowStatement_InvestingCashFlow_NineMonths,
        FinancialStatements_CashFlowStatement_InvestingCashFlow_TwelveMonths,
        FinancialStatements_CashFlowStatement_OperatingCashFlow_OneMonth,
        FinancialStatements_CashFlowStatement_OperatingCashFlow_TwoMonths,
        FinancialStatements_CashFlowStatement_OperatingCashFlow_ThreeMonths,
        FinancialStatements_CashFlowStatement_OperatingCashFlow_SixMonths,
        FinancialStatements_CashFlowStatement_OperatingCashFlow_NineMonths,
        FinancialStatements_CashFlowStatement_OperatingCashFlow_TwelveMonths,
        FinancialStatements_CashFlowStatement_BeginningCashPosition_OneMonth,
        FinancialStatements_CashFlowStatement_BeginningCashPosition_TwoMonths,
        FinancialStatements_CashFlowStatement_BeginningCashPosition_ThreeMonths,
        FinancialStatements_CashFlowStatement_BeginningCashPosition_SixMonths,
        FinancialStatements_CashFlowStatement_BeginningCashPosition_NineMonths,
        FinancialStatements_CashFlowStatement_BeginningCashPosition_TwelveMonths,
        FinancialStatements_CashFlowStatement_EndCashPosition_OneMonth,
        FinancialStatements_CashFlowStatement_EndCashPosition_TwoMonths,
        FinancialStatements_CashFlowStatement_EndCashPosition_ThreeMonths,
        FinancialStatements_CashFlowStatement_EndCashPosition_SixMonths,
        FinancialStatements_CashFlowStatement_EndCashPosition_NineMonths,
        FinancialStatements_CashFlowStatement_EndCashPosition_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedFinancingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedFinancingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedFinancingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedFinancingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedInvestingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedInvestingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedInvestingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedInvestingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccountPayable_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInAccountPayable_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccountPayable_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccountPayable_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccountPayable_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccountPayable_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInTaxPayable_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInTaxPayable_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInTaxPayable_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInTaxPayable_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInTaxPayable_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInTaxPayable_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedExpense_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInAccruedExpense_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedExpense_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedExpense_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedExpense_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedExpense_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedInvestmentIncome_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedInvestmentIncome_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedInvestmentIncome_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInAccruedInvestmentIncome_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangesInCash_OneMonth,
        FinancialStatements_CashFlowStatement_ChangesInCash_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangesInCash_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangesInCash_SixMonths,
        FinancialStatements_CashFlowStatement_ChangesInCash_NineMonths,
        FinancialStatements_CashFlowStatement_ChangesInCash_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredAcquisitionCosts_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredAcquisitionCosts_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredAcquisitionCosts_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredAcquisitionCosts_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInFederalFundsAndSecuritiesSoldForRepurchase_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInFederalFundsAndSecuritiesSoldForRepurchase_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInFederalFundsAndSecuritiesSoldForRepurchase_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInFederalFundsAndSecuritiesSoldForRepurchase_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInFundsWithheld_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInFundsWithheld_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInFundsWithheld_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInFundsWithheld_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInIncomeTaxPayable_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInIncomeTaxPayable_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInIncomeTaxPayable_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInIncomeTaxPayable_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInIncomeTaxPayable_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInIncomeTaxPayable_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInInterestPayable_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInInterestPayable_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInInterestPayable_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInInterestPayable_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInInterestPayable_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInInterestPayable_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInInventory_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInInventory_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInInventory_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInInventory_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInInventory_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInInventory_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInLoans_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInLoans_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInLoans_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInLoans_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInLossAndLossAdjustmentExpenseReserves_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInLossAndLossAdjustmentExpenseReserves_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInLossAndLossAdjustmentExpenseReserves_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInLossAndLossAdjustmentExpenseReserves_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayable_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInPayable_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayable_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayable_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayable_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayable_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayablesAndAccruedExpense_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInPayablesAndAccruedExpense_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayablesAndAccruedExpense_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayablesAndAccruedExpense_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayablesAndAccruedExpense_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInPayablesAndAccruedExpense_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInPrepaidAssets_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInPrepaidAssets_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInPrepaidAssets_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInPrepaidAssets_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInPrepaidAssets_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInPrepaidAssets_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInReceivables_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInReceivables_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInReceivables_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInReceivables_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInReceivables_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInReceivables_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInRestrictedCash_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInRestrictedCash_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInTradingAccountSecurities_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInTradingAccountSecurities_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInTradingAccountSecurities_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInTradingAccountSecurities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInWorkingCapital_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInWorkingCapital_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInWorkingCapital_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInWorkingCapital_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInWorkingCapital_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInWorkingCapital_TwelveMonths,
        FinancialStatements_CashFlowStatement_DeferredIncomeTax_OneMonth,
        FinancialStatements_CashFlowStatement_DeferredIncomeTax_TwoMonths,
        FinancialStatements_CashFlowStatement_DeferredIncomeTax_ThreeMonths,
        FinancialStatements_CashFlowStatement_DeferredIncomeTax_SixMonths,
        FinancialStatements_CashFlowStatement_DeferredIncomeTax_NineMonths,
        FinancialStatements_CashFlowStatement_DeferredIncomeTax_TwelveMonths,
        FinancialStatements_CashFlowStatement_DeferredTax_OneMonth,
        FinancialStatements_CashFlowStatement_DeferredTax_TwoMonths,
        FinancialStatements_CashFlowStatement_DeferredTax_ThreeMonths,
        FinancialStatements_CashFlowStatement_DeferredTax_SixMonths,
        FinancialStatements_CashFlowStatement_DeferredTax_NineMonths,
        FinancialStatements_CashFlowStatement_DeferredTax_TwelveMonths,
        FinancialStatements_CashFlowStatement_Depletion_ThreeMonths,
        FinancialStatements_CashFlowStatement_Depletion_SixMonths,
        FinancialStatements_CashFlowStatement_Depletion_NineMonths,
        FinancialStatements_CashFlowStatement_Depletion_TwelveMonths,
        FinancialStatements_CashFlowStatement_Depreciation_OneMonth,
        FinancialStatements_CashFlowStatement_Depreciation_TwoMonths,
        FinancialStatements_CashFlowStatement_Depreciation_ThreeMonths,
        FinancialStatements_CashFlowStatement_Depreciation_SixMonths,
        FinancialStatements_CashFlowStatement_Depreciation_NineMonths,
        FinancialStatements_CashFlowStatement_Depreciation_TwelveMonths,
        FinancialStatements_CashFlowStatement_DepreciationAndAmortization_OneMonth,
        FinancialStatements_CashFlowStatement_DepreciationAndAmortization_TwoMonths,
        FinancialStatements_CashFlowStatement_DepreciationAndAmortization_ThreeMonths,
        FinancialStatements_CashFlowStatement_DepreciationAndAmortization_SixMonths,
        FinancialStatements_CashFlowStatement_DepreciationAndAmortization_NineMonths,
        FinancialStatements_CashFlowStatement_DepreciationAndAmortization_TwelveMonths,
        FinancialStatements_CashFlowStatement_DepreciationAmortizationDepletion_OneMonth,
        FinancialStatements_CashFlowStatement_DepreciationAmortizationDepletion_TwoMonths,
        FinancialStatements_CashFlowStatement_DepreciationAmortizationDepletion_ThreeMonths,
        FinancialStatements_CashFlowStatement_DepreciationAmortizationDepletion_SixMonths,
        FinancialStatements_CashFlowStatement_DepreciationAmortizationDepletion_NineMonths,
        FinancialStatements_CashFlowStatement_DepreciationAmortizationDepletion_TwelveMonths,
        FinancialStatements_CashFlowStatement_EffectOfExchangeRateChanges_OneMonth,
        FinancialStatements_CashFlowStatement_EffectOfExchangeRateChanges_TwoMonths,
        FinancialStatements_CashFlowStatement_EffectOfExchangeRateChanges_ThreeMonths,
        FinancialStatements_CashFlowStatement_EffectOfExchangeRateChanges_SixMonths,
        FinancialStatements_CashFlowStatement_EffectOfExchangeRateChanges_NineMonths,
        FinancialStatements_CashFlowStatement_EffectOfExchangeRateChanges_TwelveMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInDeposit_ThreeMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInDeposit_SixMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInDeposit_NineMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInDeposit_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetCommonStockIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_NetCommonStockIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_NetCommonStockIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetCommonStockIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_NetCommonStockIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_NetCommonStockIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetIssuancePaymentsOfDebt_OneMonth,
        FinancialStatements_CashFlowStatement_NetIssuancePaymentsOfDebt_TwoMonths,
        FinancialStatements_CashFlowStatement_NetIssuancePaymentsOfDebt_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetIssuancePaymentsOfDebt_SixMonths,
        FinancialStatements_CashFlowStatement_NetIssuancePaymentsOfDebt_NineMonths,
        FinancialStatements_CashFlowStatement_NetIssuancePaymentsOfDebt_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetLongTermDebtIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_NetLongTermDebtIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_NetLongTermDebtIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetLongTermDebtIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_NetLongTermDebtIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_NetLongTermDebtIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetPreferredStockIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_NetPreferredStockIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_NetPreferredStockIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetPreferredStockIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_NetPreferredStockIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_NetPreferredStockIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetShortTermDebtIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_NetShortTermDebtIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_NetShortTermDebtIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetShortTermDebtIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_NetShortTermDebtIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_NetShortTermDebtIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetCashFromDiscontinuedOperations_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetCashFromDiscontinuedOperations_SixMonths,
        FinancialStatements_CashFlowStatement_NetCashFromDiscontinuedOperations_NineMonths,
        FinancialStatements_CashFlowStatement_NetCashFromDiscontinuedOperations_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetForeignCurrencyExchangeGainLoss_OneMonth,
        FinancialStatements_CashFlowStatement_NetForeignCurrencyExchangeGainLoss_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetForeignCurrencyExchangeGainLoss_SixMonths,
        FinancialStatements_CashFlowStatement_NetForeignCurrencyExchangeGainLoss_NineMonths,
        FinancialStatements_CashFlowStatement_NetForeignCurrencyExchangeGainLoss_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetIncomeFromContinuingOperations_OneMonth,
        FinancialStatements_CashFlowStatement_NetIncomeFromContinuingOperations_TwoMonths,
        FinancialStatements_CashFlowStatement_NetIncomeFromContinuingOperations_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetIncomeFromContinuingOperations_SixMonths,
        FinancialStatements_CashFlowStatement_NetIncomeFromContinuingOperations_NineMonths,
        FinancialStatements_CashFlowStatement_NetIncomeFromContinuingOperations_TwelveMonths,
        FinancialStatements_CashFlowStatement_PaymentForLoans_ThreeMonths,
        FinancialStatements_CashFlowStatement_PaymentForLoans_SixMonths,
        FinancialStatements_CashFlowStatement_PaymentForLoans_NineMonths,
        FinancialStatements_CashFlowStatement_PaymentForLoans_TwelveMonths,
        FinancialStatements_CashFlowStatement_CommonStockPayments_OneMonth,
        FinancialStatements_CashFlowStatement_CommonStockPayments_TwoMonths,
        FinancialStatements_CashFlowStatement_CommonStockPayments_ThreeMonths,
        FinancialStatements_CashFlowStatement_CommonStockPayments_SixMonths,
        FinancialStatements_CashFlowStatement_CommonStockPayments_NineMonths,
        FinancialStatements_CashFlowStatement_CommonStockPayments_TwelveMonths,
        FinancialStatements_CashFlowStatement_PreferredStockPayments_OneMonth,
        FinancialStatements_CashFlowStatement_PreferredStockPayments_ThreeMonths,
        FinancialStatements_CashFlowStatement_PreferredStockPayments_SixMonths,
        FinancialStatements_CashFlowStatement_PreferredStockPayments_NineMonths,
        FinancialStatements_CashFlowStatement_PreferredStockPayments_TwelveMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtPayments_OneMonth,
        FinancialStatements_CashFlowStatement_LongTermDebtPayments_TwoMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtPayments_ThreeMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtPayments_SixMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtPayments_NineMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtPayments_TwelveMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtPayments_OneMonth,
        FinancialStatements_CashFlowStatement_ShortTermDebtPayments_TwoMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtPayments_ThreeMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtPayments_SixMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtPayments_NineMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtPayments_TwelveMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromLoans_ThreeMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromLoans_SixMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromLoans_NineMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromLoans_TwelveMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromStockOptionExercised_OneMonth,
        FinancialStatements_CashFlowStatement_ProceedsFromStockOptionExercised_TwoMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromStockOptionExercised_ThreeMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromStockOptionExercised_SixMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromStockOptionExercised_NineMonths,
        FinancialStatements_CashFlowStatement_ProceedsFromStockOptionExercised_TwelveMonths,
        FinancialStatements_CashFlowStatement_CommonStockIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_CommonStockIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_CommonStockIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_CommonStockIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_CommonStockIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_CommonStockIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_LongTermDebtIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_LongTermDebtIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_PreferredStockIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_PreferredStockIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_PreferredStockIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_PreferredStockIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_PreferredStockIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_PreferredStockIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtIssuance_OneMonth,
        FinancialStatements_CashFlowStatement_ShortTermDebtIssuance_TwoMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtIssuance_ThreeMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtIssuance_SixMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtIssuance_NineMonths,
        FinancialStatements_CashFlowStatement_ShortTermDebtIssuance_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetProceedsPaymentForLoan_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetProceedsPaymentForLoan_SixMonths,
        FinancialStatements_CashFlowStatement_NetProceedsPaymentForLoan_NineMonths,
        FinancialStatements_CashFlowStatement_NetProceedsPaymentForLoan_TwelveMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentInInterestBearingDepositsInBank_ThreeMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentInInterestBearingDepositsInBank_SixMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentInInterestBearingDepositsInBank_NineMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentInInterestBearingDepositsInBank_TwelveMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfIntangibles_OneMonth,
        FinancialStatements_CashFlowStatement_PurchaseOfIntangibles_TwoMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfIntangibles_ThreeMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfIntangibles_SixMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfIntangibles_NineMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfIntangibles_TwelveMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestment_OneMonth,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestment_TwoMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestment_ThreeMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestment_SixMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestment_NineMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestment_TwelveMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfPPE_OneMonth,
        FinancialStatements_CashFlowStatement_PurchaseOfPPE_TwoMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfPPE_ThreeMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfPPE_SixMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfPPE_NineMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfPPE_TwelveMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfBusiness_OneMonth,
        FinancialStatements_CashFlowStatement_PurchaseOfBusiness_TwoMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfBusiness_ThreeMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfBusiness_SixMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfBusiness_NineMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfBusiness_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetBusinessPurchaseAndSale_OneMonth,
        FinancialStatements_CashFlowStatement_NetBusinessPurchaseAndSale_TwoMonths,
        FinancialStatements_CashFlowStatement_NetBusinessPurchaseAndSale_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetBusinessPurchaseAndSale_SixMonths,
        FinancialStatements_CashFlowStatement_NetBusinessPurchaseAndSale_NineMonths,
        FinancialStatements_CashFlowStatement_NetBusinessPurchaseAndSale_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetIntangiblesPurchaseAndSale_OneMonth,
        FinancialStatements_CashFlowStatement_NetIntangiblesPurchaseAndSale_TwoMonths,
        FinancialStatements_CashFlowStatement_NetIntangiblesPurchaseAndSale_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetIntangiblesPurchaseAndSale_SixMonths,
        FinancialStatements_CashFlowStatement_NetIntangiblesPurchaseAndSale_NineMonths,
        FinancialStatements_CashFlowStatement_NetIntangiblesPurchaseAndSale_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPurchaseAndSale_OneMonth,
        FinancialStatements_CashFlowStatement_NetInvestmentPurchaseAndSale_TwoMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPurchaseAndSale_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPurchaseAndSale_SixMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPurchaseAndSale_NineMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPurchaseAndSale_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetPPEPurchaseAndSale_OneMonth,
        FinancialStatements_CashFlowStatement_NetPPEPurchaseAndSale_TwoMonths,
        FinancialStatements_CashFlowStatement_NetPPEPurchaseAndSale_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetPPEPurchaseAndSale_SixMonths,
        FinancialStatements_CashFlowStatement_NetPPEPurchaseAndSale_NineMonths,
        FinancialStatements_CashFlowStatement_NetPPEPurchaseAndSale_TwelveMonths,
        FinancialStatements_CashFlowStatement_SaleOfBusiness_OneMonth,
        FinancialStatements_CashFlowStatement_SaleOfBusiness_TwoMonths,
        FinancialStatements_CashFlowStatement_SaleOfBusiness_ThreeMonths,
        FinancialStatements_CashFlowStatement_SaleOfBusiness_SixMonths,
        FinancialStatements_CashFlowStatement_SaleOfBusiness_NineMonths,
        FinancialStatements_CashFlowStatement_SaleOfBusiness_TwelveMonths,
        FinancialStatements_CashFlowStatement_SaleOfIntangibles_OneMonth,
        FinancialStatements_CashFlowStatement_SaleOfIntangibles_ThreeMonths,
        FinancialStatements_CashFlowStatement_SaleOfIntangibles_SixMonths,
        FinancialStatements_CashFlowStatement_SaleOfIntangibles_NineMonths,
        FinancialStatements_CashFlowStatement_SaleOfIntangibles_TwelveMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestment_OneMonth,
        FinancialStatements_CashFlowStatement_SaleOfInvestment_TwoMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestment_ThreeMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestment_SixMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestment_NineMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestment_TwelveMonths,
        FinancialStatements_CashFlowStatement_SaleOfPPE_OneMonth,
        FinancialStatements_CashFlowStatement_SaleOfPPE_TwoMonths,
        FinancialStatements_CashFlowStatement_SaleOfPPE_ThreeMonths,
        FinancialStatements_CashFlowStatement_SaleOfPPE_SixMonths,
        FinancialStatements_CashFlowStatement_SaleOfPPE_NineMonths,
        FinancialStatements_CashFlowStatement_SaleOfPPE_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangesInAccountReceivables_OneMonth,
        FinancialStatements_CashFlowStatement_ChangesInAccountReceivables_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangesInAccountReceivables_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangesInAccountReceivables_SixMonths,
        FinancialStatements_CashFlowStatement_ChangesInAccountReceivables_NineMonths,
        FinancialStatements_CashFlowStatement_ChangesInAccountReceivables_TwelveMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfFinancingCostsAndDiscounts_OneMonth,
        FinancialStatements_CashFlowStatement_AmortizationOfFinancingCostsAndDiscounts_TwoMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfFinancingCostsAndDiscounts_ThreeMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfFinancingCostsAndDiscounts_SixMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfFinancingCostsAndDiscounts_NineMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfFinancingCostsAndDiscounts_TwelveMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfSecurities_OneMonth,
        FinancialStatements_CashFlowStatement_AmortizationOfSecurities_TwoMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfSecurities_ThreeMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfSecurities_SixMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfSecurities_NineMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfSecurities_TwelveMonths,
        FinancialStatements_CashFlowStatement_AssetImpairmentCharge_OneMonth,
        FinancialStatements_CashFlowStatement_AssetImpairmentCharge_TwoMonths,
        FinancialStatements_CashFlowStatement_AssetImpairmentCharge_ThreeMonths,
        FinancialStatements_CashFlowStatement_AssetImpairmentCharge_SixMonths,
        FinancialStatements_CashFlowStatement_AssetImpairmentCharge_NineMonths,
        FinancialStatements_CashFlowStatement_AssetImpairmentCharge_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInDividendPayable_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInDividendPayable_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInDividendPayable_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInDividendPayable_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredCharges_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredCharges_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredCharges_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInDeferredCharges_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentAssets_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentAssets_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentAssets_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentAssets_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentAssets_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentAssets_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentLiabilities_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentLiabilities_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentLiabilities_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentLiabilities_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentLiabilities_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherCurrentLiabilities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherWorkingCapital_OneMonth,
        FinancialStatements_CashFlowStatement_ChangeInOtherWorkingCapital_TwoMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherWorkingCapital_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherWorkingCapital_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherWorkingCapital_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInOtherWorkingCapital_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeInUnearnedPremiums_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeInUnearnedPremiums_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeInUnearnedPremiums_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeInUnearnedPremiums_TwelveMonths,
        FinancialStatements_CashFlowStatement_CommonStockDividendPaid_OneMonth,
        FinancialStatements_CashFlowStatement_CommonStockDividendPaid_TwoMonths,
        FinancialStatements_CashFlowStatement_CommonStockDividendPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_CommonStockDividendPaid_SixMonths,
        FinancialStatements_CashFlowStatement_CommonStockDividendPaid_NineMonths,
        FinancialStatements_CashFlowStatement_CommonStockDividendPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_EarningsLossesFromEquityInvestments_OneMonth,
        FinancialStatements_CashFlowStatement_EarningsLossesFromEquityInvestments_TwoMonths,
        FinancialStatements_CashFlowStatement_EarningsLossesFromEquityInvestments_ThreeMonths,
        FinancialStatements_CashFlowStatement_EarningsLossesFromEquityInvestments_SixMonths,
        FinancialStatements_CashFlowStatement_EarningsLossesFromEquityInvestments_NineMonths,
        FinancialStatements_CashFlowStatement_EarningsLossesFromEquityInvestments_TwelveMonths,
        FinancialStatements_CashFlowStatement_ExcessTaxBenefitFromStockBasedCompensation_TwoMonths,
        FinancialStatements_CashFlowStatement_ExcessTaxBenefitFromStockBasedCompensation_ThreeMonths,
        FinancialStatements_CashFlowStatement_ExcessTaxBenefitFromStockBasedCompensation_SixMonths,
        FinancialStatements_CashFlowStatement_ExcessTaxBenefitFromStockBasedCompensation_NineMonths,
        FinancialStatements_CashFlowStatement_ExcessTaxBenefitFromStockBasedCompensation_TwelveMonths,
        FinancialStatements_CashFlowStatement_GainLossOnInvestmentSecurities_OneMonth,
        FinancialStatements_CashFlowStatement_GainLossOnInvestmentSecurities_TwoMonths,
        FinancialStatements_CashFlowStatement_GainLossOnInvestmentSecurities_ThreeMonths,
        FinancialStatements_CashFlowStatement_GainLossOnInvestmentSecurities_SixMonths,
        FinancialStatements_CashFlowStatement_GainLossOnInvestmentSecurities_NineMonths,
        FinancialStatements_CashFlowStatement_GainLossOnInvestmentSecurities_TwelveMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfBusiness_OneMonth,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfBusiness_TwoMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfBusiness_ThreeMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfBusiness_SixMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfBusiness_NineMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfBusiness_TwelveMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfPPE_OneMonth,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfPPE_TwoMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfPPE_ThreeMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfPPE_SixMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfPPE_NineMonths,
        FinancialStatements_CashFlowStatement_GainLossOnSaleOfPPE_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestCreditedOnPolicyholderDeposits_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestCreditedOnPolicyholderDeposits_SixMonths,
        FinancialStatements_CashFlowStatement_InterestCreditedOnPolicyholderDeposits_NineMonths,
        FinancialStatements_CashFlowStatement_InterestCreditedOnPolicyholderDeposits_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedOperatingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedOperatingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedOperatingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashFromDiscontinuedOperatingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_OperatingGainsLosses_OneMonth,
        FinancialStatements_CashFlowStatement_OperatingGainsLosses_TwoMonths,
        FinancialStatements_CashFlowStatement_OperatingGainsLosses_ThreeMonths,
        FinancialStatements_CashFlowStatement_OperatingGainsLosses_SixMonths,
        FinancialStatements_CashFlowStatement_OperatingGainsLosses_NineMonths,
        FinancialStatements_CashFlowStatement_OperatingGainsLosses_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetOtherFinancingCharges_OneMonth,
        FinancialStatements_CashFlowStatement_NetOtherFinancingCharges_TwoMonths,
        FinancialStatements_CashFlowStatement_NetOtherFinancingCharges_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetOtherFinancingCharges_SixMonths,
        FinancialStatements_CashFlowStatement_NetOtherFinancingCharges_NineMonths,
        FinancialStatements_CashFlowStatement_NetOtherFinancingCharges_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetOtherInvestingChanges_OneMonth,
        FinancialStatements_CashFlowStatement_NetOtherInvestingChanges_TwoMonths,
        FinancialStatements_CashFlowStatement_NetOtherInvestingChanges_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetOtherInvestingChanges_SixMonths,
        FinancialStatements_CashFlowStatement_NetOtherInvestingChanges_NineMonths,
        FinancialStatements_CashFlowStatement_NetOtherInvestingChanges_TwelveMonths,
        FinancialStatements_CashFlowStatement_OtherNonCashItems_OneMonth,
        FinancialStatements_CashFlowStatement_OtherNonCashItems_TwoMonths,
        FinancialStatements_CashFlowStatement_OtherNonCashItems_ThreeMonths,
        FinancialStatements_CashFlowStatement_OtherNonCashItems_SixMonths,
        FinancialStatements_CashFlowStatement_OtherNonCashItems_NineMonths,
        FinancialStatements_CashFlowStatement_OtherNonCashItems_TwelveMonths,
        FinancialStatements_CashFlowStatement_PensionAndEmployeeBenefitExpense_OneMonth,
        FinancialStatements_CashFlowStatement_PensionAndEmployeeBenefitExpense_TwoMonths,
        FinancialStatements_CashFlowStatement_PensionAndEmployeeBenefitExpense_ThreeMonths,
        FinancialStatements_CashFlowStatement_PensionAndEmployeeBenefitExpense_SixMonths,
        FinancialStatements_CashFlowStatement_PensionAndEmployeeBenefitExpense_NineMonths,
        FinancialStatements_CashFlowStatement_PensionAndEmployeeBenefitExpense_TwelveMonths,
        FinancialStatements_CashFlowStatement_PreferredStockDividendPaid_OneMonth,
        FinancialStatements_CashFlowStatement_PreferredStockDividendPaid_TwoMonths,
        FinancialStatements_CashFlowStatement_PreferredStockDividendPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_PreferredStockDividendPaid_SixMonths,
        FinancialStatements_CashFlowStatement_PreferredStockDividendPaid_NineMonths,
        FinancialStatements_CashFlowStatement_PreferredStockDividendPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell_ThreeMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell_SixMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell_NineMonths,
        FinancialStatements_CashFlowStatement_ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell_TwelveMonths,
        FinancialStatements_CashFlowStatement_ProvisionForLoanLeaseAndOtherLosses_ThreeMonths,
        FinancialStatements_CashFlowStatement_ProvisionForLoanLeaseAndOtherLosses_SixMonths,
        FinancialStatements_CashFlowStatement_ProvisionForLoanLeaseAndOtherLosses_NineMonths,
        FinancialStatements_CashFlowStatement_ProvisionForLoanLeaseAndOtherLosses_TwelveMonths,
        FinancialStatements_CashFlowStatement_RealizedGainLossOnSaleOfLoansAndLease_OneMonth,
        FinancialStatements_CashFlowStatement_RealizedGainLossOnSaleOfLoansAndLease_ThreeMonths,
        FinancialStatements_CashFlowStatement_RealizedGainLossOnSaleOfLoansAndLease_SixMonths,
        FinancialStatements_CashFlowStatement_RealizedGainLossOnSaleOfLoansAndLease_NineMonths,
        FinancialStatements_CashFlowStatement_RealizedGainLossOnSaleOfLoansAndLease_TwelveMonths,
        FinancialStatements_CashFlowStatement_StockBasedCompensation_OneMonth,
        FinancialStatements_CashFlowStatement_StockBasedCompensation_TwoMonths,
        FinancialStatements_CashFlowStatement_StockBasedCompensation_ThreeMonths,
        FinancialStatements_CashFlowStatement_StockBasedCompensation_SixMonths,
        FinancialStatements_CashFlowStatement_StockBasedCompensation_NineMonths,
        FinancialStatements_CashFlowStatement_StockBasedCompensation_TwelveMonths,
        FinancialStatements_CashFlowStatement_UnrealizedGainLossOnInvestmentSecurities_OneMonth,
        FinancialStatements_CashFlowStatement_UnrealizedGainLossOnInvestmentSecurities_TwoMonths,
        FinancialStatements_CashFlowStatement_UnrealizedGainLossOnInvestmentSecurities_ThreeMonths,
        FinancialStatements_CashFlowStatement_UnrealizedGainLossOnInvestmentSecurities_SixMonths,
        FinancialStatements_CashFlowStatement_UnrealizedGainLossOnInvestmentSecurities_NineMonths,
        FinancialStatements_CashFlowStatement_UnrealizedGainLossOnInvestmentSecurities_TwelveMonths,
        FinancialStatements_CashFlowStatement_UnrealizedGainsLossesOnDerivatives_ThreeMonths,
        FinancialStatements_CashFlowStatement_UnrealizedGainsLossesOnDerivatives_TwelveMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfIntangibles_OneMonth,
        FinancialStatements_CashFlowStatement_AmortizationOfIntangibles_TwoMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfIntangibles_ThreeMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfIntangibles_SixMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfIntangibles_NineMonths,
        FinancialStatements_CashFlowStatement_AmortizationOfIntangibles_TwelveMonths,
        FinancialStatements_CashFlowStatement_IncomeTaxPaidSupplementalData_OneMonth,
        FinancialStatements_CashFlowStatement_IncomeTaxPaidSupplementalData_TwoMonths,
        FinancialStatements_CashFlowStatement_IncomeTaxPaidSupplementalData_ThreeMonths,
        FinancialStatements_CashFlowStatement_IncomeTaxPaidSupplementalData_SixMonths,
        FinancialStatements_CashFlowStatement_IncomeTaxPaidSupplementalData_NineMonths,
        FinancialStatements_CashFlowStatement_IncomeTaxPaidSupplementalData_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestPaidSupplementalData_OneMonth,
        FinancialStatements_CashFlowStatement_InterestPaidSupplementalData_TwoMonths,
        FinancialStatements_CashFlowStatement_InterestPaidSupplementalData_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestPaidSupplementalData_SixMonths,
        FinancialStatements_CashFlowStatement_InterestPaidSupplementalData_NineMonths,
        FinancialStatements_CashFlowStatement_InterestPaidSupplementalData_TwelveMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfCapitalStock_OneMonth,
        FinancialStatements_CashFlowStatement_IssuanceOfCapitalStock_TwoMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfCapitalStock_ThreeMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfCapitalStock_SixMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfCapitalStock_NineMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfCapitalStock_TwelveMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfDebt_OneMonth,
        FinancialStatements_CashFlowStatement_IssuanceOfDebt_TwoMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfDebt_ThreeMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfDebt_SixMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfDebt_NineMonths,
        FinancialStatements_CashFlowStatement_IssuanceOfDebt_TwelveMonths,
        FinancialStatements_CashFlowStatement_RepaymentOfDebt_OneMonth,
        FinancialStatements_CashFlowStatement_RepaymentOfDebt_TwoMonths,
        FinancialStatements_CashFlowStatement_RepaymentOfDebt_ThreeMonths,
        FinancialStatements_CashFlowStatement_RepaymentOfDebt_SixMonths,
        FinancialStatements_CashFlowStatement_RepaymentOfDebt_NineMonths,
        FinancialStatements_CashFlowStatement_RepaymentOfDebt_TwelveMonths,
        FinancialStatements_CashFlowStatement_RepurchaseOfCapitalStock_OneMonth,
        FinancialStatements_CashFlowStatement_RepurchaseOfCapitalStock_TwoMonths,
        FinancialStatements_CashFlowStatement_RepurchaseOfCapitalStock_ThreeMonths,
        FinancialStatements_CashFlowStatement_RepurchaseOfCapitalStock_SixMonths,
        FinancialStatements_CashFlowStatement_RepurchaseOfCapitalStock_NineMonths,
        FinancialStatements_CashFlowStatement_RepurchaseOfCapitalStock_TwelveMonths,
        FinancialStatements_CashFlowStatement_FreeCashFlow_OneMonth,
        FinancialStatements_CashFlowStatement_FreeCashFlow_TwoMonths,
        FinancialStatements_CashFlowStatement_FreeCashFlow_ThreeMonths,
        FinancialStatements_CashFlowStatement_FreeCashFlow_SixMonths,
        FinancialStatements_CashFlowStatement_FreeCashFlow_NineMonths,
        FinancialStatements_CashFlowStatement_FreeCashFlow_TwelveMonths,
        FinancialStatements_CashFlowStatement_DecreaseInInterestBearingDepositsInBank_ThreeMonths,
        FinancialStatements_CashFlowStatement_DecreaseInInterestBearingDepositsInBank_SixMonths,
        FinancialStatements_CashFlowStatement_DecreaseInInterestBearingDepositsInBank_NineMonths,
        FinancialStatements_CashFlowStatement_DecreaseInInterestBearingDepositsInBank_TwelveMonths,
        FinancialStatements_CashFlowStatement_IncreaseInInterestBearingDepositsInBank_ThreeMonths,
        FinancialStatements_CashFlowStatement_IncreaseInInterestBearingDepositsInBank_SixMonths,
        FinancialStatements_CashFlowStatement_IncreaseInInterestBearingDepositsInBank_NineMonths,
        FinancialStatements_CashFlowStatement_IncreaseInInterestBearingDepositsInBank_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFO_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFO_SixMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFO_NineMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFO_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFO_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFO_SixMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFO_NineMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFO_TwelveMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfSubsidiaries_ThreeMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfSubsidiaries_SixMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfSubsidiaries_NineMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfSubsidiaries_TwelveMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfJointVentureAssociate_ThreeMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfJointVentureAssociate_SixMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfJointVentureAssociate_NineMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfJointVentureAssociate_TwelveMonths,
        FinancialStatements_CashFlowStatement_SaleOfSubsidiaries_SixMonths,
        FinancialStatements_CashFlowStatement_SaleOfSubsidiaries_TwelveMonths,
        FinancialStatements_CashFlowStatement_SaleOfJointVentureAssociate_ThreeMonths,
        FinancialStatements_CashFlowStatement_SaleOfJointVentureAssociate_SixMonths,
        FinancialStatements_CashFlowStatement_SaleOfJointVentureAssociate_NineMonths,
        FinancialStatements_CashFlowStatement_SaleOfJointVentureAssociate_TwelveMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInLeaseFinancing_ThreeMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInLeaseFinancing_SixMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInLeaseFinancing_NineMonths,
        FinancialStatements_CashFlowStatement_IncreaseDecreaseInLeaseFinancing_TwelveMonths,
        FinancialStatements_CashFlowStatement_IncreaseInLeaseFinancing_SixMonths,
        FinancialStatements_CashFlowStatement_IncreaseInLeaseFinancing_TwelveMonths,
        FinancialStatements_CashFlowStatement_RepaymentInLeaseFinancing_ThreeMonths,
        FinancialStatements_CashFlowStatement_RepaymentInLeaseFinancing_SixMonths,
        FinancialStatements_CashFlowStatement_RepaymentInLeaseFinancing_NineMonths,
        FinancialStatements_CashFlowStatement_RepaymentInLeaseFinancing_TwelveMonths,
        FinancialStatements_CashFlowStatement_ShareOfAssociates_ThreeMonths,
        FinancialStatements_CashFlowStatement_ShareOfAssociates_SixMonths,
        FinancialStatements_CashFlowStatement_ShareOfAssociates_NineMonths,
        FinancialStatements_CashFlowStatement_ShareOfAssociates_TwelveMonths,
        FinancialStatements_CashFlowStatement_ProfitOnDisposals_ThreeMonths,
        FinancialStatements_CashFlowStatement_ProfitOnDisposals_SixMonths,
        FinancialStatements_CashFlowStatement_ProfitOnDisposals_NineMonths,
        FinancialStatements_CashFlowStatement_ProfitOnDisposals_TwelveMonths,
        FinancialStatements_CashFlowStatement_ReorganizationOtherCosts_ThreeMonths,
        FinancialStatements_CashFlowStatement_ReorganizationOtherCosts_SixMonths,
        FinancialStatements_CashFlowStatement_ReorganizationOtherCosts_NineMonths,
        FinancialStatements_CashFlowStatement_ReorganizationOtherCosts_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetOutwardLoans_TwelveMonths,
        FinancialStatements_CashFlowStatement_IssueExpenses_TwoMonths,
        FinancialStatements_CashFlowStatement_IssueExpenses_ThreeMonths,
        FinancialStatements_CashFlowStatement_IssueExpenses_SixMonths,
        FinancialStatements_CashFlowStatement_IssueExpenses_NineMonths,
        FinancialStatements_CashFlowStatement_IssueExpenses_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinDepositsbyBanksandCustomers_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashFlowsfromusedinOperatingActivitiesDirect_OneMonth,
        FinancialStatements_CashFlowStatement_CashFlowsfromusedinOperatingActivitiesDirect_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashFlowsfromusedinOperatingActivitiesDirect_SixMonths,
        FinancialStatements_CashFlowStatement_CashFlowsfromusedinOperatingActivitiesDirect_NineMonths,
        FinancialStatements_CashFlowStatement_CashFlowsfromusedinOperatingActivitiesDirect_TwelveMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashReceiptsfromOperatingActivities_OneMonth,
        FinancialStatements_CashFlowStatement_ClassesofCashReceiptsfromOperatingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashReceiptsfromOperatingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashReceiptsfromOperatingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashReceiptsfromOperatingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_OtherCashReceiptsfromOperatingActivities_OneMonth,
        FinancialStatements_CashFlowStatement_OtherCashReceiptsfromOperatingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_OtherCashReceiptsfromOperatingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_OtherCashReceiptsfromOperatingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_OtherCashReceiptsfromOperatingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashPayments_OneMonth,
        FinancialStatements_CashFlowStatement_ClassesofCashPayments_ThreeMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashPayments_SixMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashPayments_NineMonths,
        FinancialStatements_CashFlowStatement_ClassesofCashPayments_TwelveMonths,
        FinancialStatements_CashFlowStatement_PaymentstoSuppliersforGoodsandServices_ThreeMonths,
        FinancialStatements_CashFlowStatement_PaymentstoSuppliersforGoodsandServices_SixMonths,
        FinancialStatements_CashFlowStatement_PaymentstoSuppliersforGoodsandServices_NineMonths,
        FinancialStatements_CashFlowStatement_PaymentstoSuppliersforGoodsandServices_TwelveMonths,
        FinancialStatements_CashFlowStatement_PaymentsonBehalfofEmployees_ThreeMonths,
        FinancialStatements_CashFlowStatement_PaymentsonBehalfofEmployees_SixMonths,
        FinancialStatements_CashFlowStatement_PaymentsonBehalfofEmployees_NineMonths,
        FinancialStatements_CashFlowStatement_PaymentsonBehalfofEmployees_TwelveMonths,
        FinancialStatements_CashFlowStatement_OtherCashPaymentsfromOperatingActivities_OneMonth,
        FinancialStatements_CashFlowStatement_OtherCashPaymentsfromOperatingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_OtherCashPaymentsfromOperatingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_OtherCashPaymentsfromOperatingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_OtherCashPaymentsfromOperatingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_DividendsPaidDirect_TwelveMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedDirect_ThreeMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedDirect_SixMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedDirect_NineMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedDirect_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestPaidDirect_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestPaidDirect_SixMonths,
        FinancialStatements_CashFlowStatement_InterestPaidDirect_NineMonths,
        FinancialStatements_CashFlowStatement_InterestPaidDirect_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedDirect_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedDirect_SixMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedDirect_NineMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedDirect_TwelveMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaidDirect_ThreeMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaidDirect_SixMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaidDirect_NineMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaidDirect_TwelveMonths,
        FinancialStatements_CashFlowStatement_TotalAdjustmentsforNonCashItems_TwoMonths,
        FinancialStatements_CashFlowStatement_TotalAdjustmentsforNonCashItems_ThreeMonths,
        FinancialStatements_CashFlowStatement_TotalAdjustmentsforNonCashItems_SixMonths,
        FinancialStatements_CashFlowStatement_TotalAdjustmentsforNonCashItems_NineMonths,
        FinancialStatements_CashFlowStatement_TotalAdjustmentsforNonCashItems_TwelveMonths,
        FinancialStatements_CashFlowStatement_ImpairmentLossReversalRecognizedinProfitorLoss_ThreeMonths,
        FinancialStatements_CashFlowStatement_ImpairmentLossReversalRecognizedinProfitorLoss_SixMonths,
        FinancialStatements_CashFlowStatement_ImpairmentLossReversalRecognizedinProfitorLoss_NineMonths,
        FinancialStatements_CashFlowStatement_ImpairmentLossReversalRecognizedinProfitorLoss_TwelveMonths,
        FinancialStatements_CashFlowStatement_DividendPaidCFO_TwelveMonths,
        FinancialStatements_CashFlowStatement_DividendReceivedCFO_SixMonths,
        FinancialStatements_CashFlowStatement_DividendReceivedCFO_TwelveMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaid_SixMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaid_NineMonths,
        FinancialStatements_CashFlowStatement_TaxesRefundPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_OtherOperatingInflowsOutflowsofCash_ThreeMonths,
        FinancialStatements_CashFlowStatement_OtherOperatingInflowsOutflowsofCash_SixMonths,
        FinancialStatements_CashFlowStatement_OtherOperatingInflowsOutflowsofCash_NineMonths,
        FinancialStatements_CashFlowStatement_OtherOperatingInflowsOutflowsofCash_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashAdvancesandLoansMadetoOtherParties_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherParties_SixMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherParties_TwelveMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedCFI_ThreeMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedCFI_SixMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedCFI_NineMonths,
        FinancialStatements_CashFlowStatement_DividendsReceivedCFI_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFI_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFI_SixMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFI_NineMonths,
        FinancialStatements_CashFlowStatement_InterestReceivedCFI_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFF_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFF_SixMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFF_NineMonths,
        FinancialStatements_CashFlowStatement_InterestPaidCFF_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinAccruedIncome_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinAccruedIncome_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinAccruedIncome_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinAccruedIncome_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinFinancialAssets_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinAdvancesfromCentralBanks_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinAdvancesfromCentralBanks_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinAdvancesfromCentralBanks_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinAdvancesfromCentralBanks_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinFinancialLiabilities_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinFinancialLiabilities_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinFinancialLiabilities_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinFinancialLiabilities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractAssets_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractAssets_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractAssets_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractAssets_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinReinsuranceReceivables_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinReinsuranceReceivables_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinReinsuranceReceivables_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinReinsuranceReceivables_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinDeferredAcquisitionCostsNet_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinDeferredAcquisitionCostsNet_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinDeferredAcquisitionCostsNet_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinDeferredAcquisitionCostsNet_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceFunds_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceFunds_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceFunds_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceFunds_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinInvestmentContractLiabilities_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinInvestmentContractLiabilities_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinInvestmentContractLiabilities_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinInvestmentContractLiabilities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractLiabilities_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractLiabilities_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractLiabilities_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinInsuranceContractLiabilities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ProvisionandWriteOffofAssets_ThreeMonths,
        FinancialStatements_CashFlowStatement_ProvisionandWriteOffofAssets_SixMonths,
        FinancialStatements_CashFlowStatement_ProvisionandWriteOffofAssets_NineMonths,
        FinancialStatements_CashFlowStatement_ProvisionandWriteOffofAssets_TwelveMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromCustomers_ThreeMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromCustomers_SixMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromCustomers_NineMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromCustomers_TwelveMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromGovernmentGrants_ThreeMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromGovernmentGrants_SixMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromGovernmentGrants_NineMonths,
        FinancialStatements_CashFlowStatement_ReceiptsfromGovernmentGrants_TwelveMonths,
        FinancialStatements_CashFlowStatement_MinorityInterest_TwelveMonths,
        FinancialStatements_CashFlowStatement_CapExReported_OneMonth,
        FinancialStatements_CashFlowStatement_CapExReported_TwoMonths,
        FinancialStatements_CashFlowStatement_CapExReported_ThreeMonths,
        FinancialStatements_CashFlowStatement_CapExReported_SixMonths,
        FinancialStatements_CashFlowStatement_CapExReported_NineMonths,
        FinancialStatements_CashFlowStatement_CapExReported_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromTaxRefunds_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromTaxRefunds_SixMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromTaxRefunds_NineMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromTaxRefunds_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromDepositsbyBanksandCustomers_OneMonth,
        FinancialStatements_CashFlowStatement_CashReceiptsfromDepositsbyBanksandCustomers_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromDepositsbyBanksandCustomers_SixMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromDepositsbyBanksandCustomers_NineMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromDepositsbyBanksandCustomers_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromLoans_OneMonth,
        FinancialStatements_CashFlowStatement_CashReceiptsfromLoans_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromLoans_SixMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromLoans_NineMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromLoans_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromSecuritiesRelatedActivities_OneMonth,
        FinancialStatements_CashFlowStatement_CashReceiptsfromSecuritiesRelatedActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromSecuritiesRelatedActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromSecuritiesRelatedActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromSecuritiesRelatedActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromFeesandCommissions_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromFeesandCommissions_SixMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromFeesandCommissions_NineMonths,
        FinancialStatements_CashFlowStatement_CashReceiptsfromFeesandCommissions_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforDepositsbyBanksandCustomers_OneMonth,
        FinancialStatements_CashFlowStatement_CashPaymentsforDepositsbyBanksandCustomers_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforDepositsbyBanksandCustomers_SixMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforDepositsbyBanksandCustomers_NineMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforDepositsbyBanksandCustomers_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforLoans_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforLoans_SixMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforLoans_NineMonths,
        FinancialStatements_CashFlowStatement_CashPaymentsforLoans_TwelveMonths,
        FinancialStatements_CashFlowStatement_InterestandCommissionPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_InterestandCommissionPaid_SixMonths,
        FinancialStatements_CashFlowStatement_InterestandCommissionPaid_NineMonths,
        FinancialStatements_CashFlowStatement_InterestandCommissionPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_AllTaxesPaid_OneMonth,
        FinancialStatements_CashFlowStatement_AllTaxesPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_AllTaxesPaid_SixMonths,
        FinancialStatements_CashFlowStatement_AllTaxesPaid_NineMonths,
        FinancialStatements_CashFlowStatement_AllTaxesPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashReceivedfromInsuranceActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashReceivedfromInsuranceActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashReceivedfromInsuranceActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashReceivedfromInsuranceActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_PremiumReceived_ThreeMonths,
        FinancialStatements_CashFlowStatement_PremiumReceived_SixMonths,
        FinancialStatements_CashFlowStatement_PremiumReceived_NineMonths,
        FinancialStatements_CashFlowStatement_PremiumReceived_TwelveMonths,
        FinancialStatements_CashFlowStatement_ReinsuranceandOtherRecoveriesReceived_ThreeMonths,
        FinancialStatements_CashFlowStatement_ReinsuranceandOtherRecoveriesReceived_SixMonths,
        FinancialStatements_CashFlowStatement_ReinsuranceandOtherRecoveriesReceived_NineMonths,
        FinancialStatements_CashFlowStatement_ReinsuranceandOtherRecoveriesReceived_TwelveMonths,
        FinancialStatements_CashFlowStatement_PolicyholderDepositInvestmentReceived_ThreeMonths,
        FinancialStatements_CashFlowStatement_PolicyholderDepositInvestmentReceived_SixMonths,
        FinancialStatements_CashFlowStatement_PolicyholderDepositInvestmentReceived_NineMonths,
        FinancialStatements_CashFlowStatement_PolicyholderDepositInvestmentReceived_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashPaidforInsuranceActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashPaidforInsuranceActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashPaidforInsuranceActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashPaidforInsuranceActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_ClaimsPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_ClaimsPaid_SixMonths,
        FinancialStatements_CashFlowStatement_ClaimsPaid_NineMonths,
        FinancialStatements_CashFlowStatement_ClaimsPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_CommissionPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_CommissionPaid_SixMonths,
        FinancialStatements_CashFlowStatement_CommissionPaid_NineMonths,
        FinancialStatements_CashFlowStatement_CommissionPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashPaidtoReinsurers_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashPaidtoReinsurers_SixMonths,
        FinancialStatements_CashFlowStatement_CashPaidtoReinsurers_NineMonths,
        FinancialStatements_CashFlowStatement_CashPaidtoReinsurers_TwelveMonths,
        FinancialStatements_CashFlowStatement_OtherUnderwritingExpensesPaid_ThreeMonths,
        FinancialStatements_CashFlowStatement_OtherUnderwritingExpensesPaid_SixMonths,
        FinancialStatements_CashFlowStatement_OtherUnderwritingExpensesPaid_NineMonths,
        FinancialStatements_CashFlowStatement_OtherUnderwritingExpensesPaid_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashDividendsForMinorities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashDividendsForMinorities_SixMonths,
        FinancialStatements_CashFlowStatement_CashDividendsForMinorities_NineMonths,
        FinancialStatements_CashFlowStatement_CashDividendsForMinorities_TwelveMonths,
        FinancialStatements_CashFlowStatement_CashGeneratedfromOperatingActivities_ThreeMonths,
        FinancialStatements_CashFlowStatement_CashGeneratedfromOperatingActivities_SixMonths,
        FinancialStatements_CashFlowStatement_CashGeneratedfromOperatingActivities_NineMonths,
        FinancialStatements_CashFlowStatement_CashGeneratedfromOperatingActivities_TwelveMonths,
        FinancialStatements_CashFlowStatement_FundFromOperation_ThreeMonths,
        FinancialStatements_CashFlowStatement_FundFromOperation_SixMonths,
        FinancialStatements_CashFlowStatement_FundFromOperation_NineMonths,
        FinancialStatements_CashFlowStatement_FundFromOperation_TwelveMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPropertiesPurchaseAndSale_ThreeMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPropertiesPurchaseAndSale_SixMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPropertiesPurchaseAndSale_NineMonths,
        FinancialStatements_CashFlowStatement_NetInvestmentPropertiesPurchaseAndSale_TwelveMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestmentProperties_ThreeMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestmentProperties_SixMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestmentProperties_NineMonths,
        FinancialStatements_CashFlowStatement_PurchaseOfInvestmentProperties_TwelveMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestmentProperties_ThreeMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestmentProperties_SixMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestmentProperties_NineMonths,
        FinancialStatements_CashFlowStatement_SaleOfInvestmentProperties_TwelveMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustIncludedIntoChangeinCash_ThreeMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustIncludedIntoChangeinCash_SixMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustIncludedIntoChangeinCash_NineMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustIncludedIntoChangeinCash_TwelveMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustExcludeFromChangeinCash_ThreeMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustExcludeFromChangeinCash_SixMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustExcludeFromChangeinCash_NineMonths,
        FinancialStatements_CashFlowStatement_OtherCashAdjustExcludeFromChangeinCash_TwelveMonths,
        FinancialStatements_CashFlowStatement_ChangeinCashSupplementalAsReported_ThreeMonths,
        FinancialStatements_CashFlowStatement_ChangeinCashSupplementalAsReported_SixMonths,
        FinancialStatements_CashFlowStatement_ChangeinCashSupplementalAsReported_NineMonths,
        FinancialStatements_CashFlowStatement_ChangeinCashSupplementalAsReported_TwelveMonths,
        EarningReports_PeriodEndingDate_OneMonth,
        EarningReports_PeriodEndingDate_TwoMonths,
        EarningReports_PeriodEndingDate_ThreeMonths,
        EarningReports_PeriodEndingDate_SixMonths,
        EarningReports_PeriodEndingDate_NineMonths,
        EarningReports_PeriodEndingDate_TwelveMonths,
        EarningReports_FileDate_OneMonth,
        EarningReports_FileDate_TwoMonths,
        EarningReports_FileDate_ThreeMonths,
        EarningReports_FileDate_SixMonths,
        EarningReports_FileDate_NineMonths,
        EarningReports_FileDate_TwelveMonths,
        EarningReports_AccessionNumber_OneMonth,
        EarningReports_AccessionNumber_TwoMonths,
        EarningReports_AccessionNumber_ThreeMonths,
        EarningReports_AccessionNumber_SixMonths,
        EarningReports_AccessionNumber_NineMonths,
        EarningReports_FormType_OneMonth,
        EarningReports_FormType_TwoMonths,
        EarningReports_FormType_ThreeMonths,
        EarningReports_FormType_SixMonths,
        EarningReports_FormType_NineMonths,
        EarningReports_FormType_TwelveMonths,
        EarningReports_PeriodType_OneMonth,
        EarningReports_PeriodType_TwoMonths,
        EarningReports_PeriodType_ThreeMonths,
        EarningReports_PeriodType_SixMonths,
        EarningReports_PeriodType_NineMonths,
        EarningReports_PeriodType_TwelveMonths,
        EarningReports_BasicContinuousOperations_OneMonth,
        EarningReports_BasicContinuousOperations_TwoMonths,
        EarningReports_BasicContinuousOperations_ThreeMonths,
        EarningReports_BasicContinuousOperations_SixMonths,
        EarningReports_BasicContinuousOperations_NineMonths,
        EarningReports_BasicContinuousOperations_TwelveMonths,
        EarningReports_BasicDiscontinuousOperations_OneMonth,
        EarningReports_BasicDiscontinuousOperations_TwoMonths,
        EarningReports_BasicDiscontinuousOperations_ThreeMonths,
        EarningReports_BasicDiscontinuousOperations_SixMonths,
        EarningReports_BasicDiscontinuousOperations_NineMonths,
        EarningReports_BasicDiscontinuousOperations_TwelveMonths,
        EarningReports_BasicExtraordinary_OneMonth,
        EarningReports_BasicExtraordinary_TwoMonths,
        EarningReports_BasicExtraordinary_ThreeMonths,
        EarningReports_BasicExtraordinary_SixMonths,
        EarningReports_BasicExtraordinary_NineMonths,
        EarningReports_BasicExtraordinary_TwelveMonths,
        EarningReports_BasicAccountingChange_ThreeMonths,
        EarningReports_BasicAccountingChange_SixMonths,
        EarningReports_BasicAccountingChange_NineMonths,
        EarningReports_BasicAccountingChange_TwelveMonths,
        EarningReports_BasicEPS_OneMonth,
        EarningReports_BasicEPS_TwoMonths,
        EarningReports_BasicEPS_ThreeMonths,
        EarningReports_BasicEPS_SixMonths,
        EarningReports_BasicEPS_NineMonths,
        EarningReports_BasicEPS_TwelveMonths,
        EarningReports_DilutedContinuousOperations_OneMonth,
        EarningReports_DilutedContinuousOperations_TwoMonths,
        EarningReports_DilutedContinuousOperations_ThreeMonths,
        EarningReports_DilutedContinuousOperations_SixMonths,
        EarningReports_DilutedContinuousOperations_NineMonths,
        EarningReports_DilutedContinuousOperations_TwelveMonths,
        EarningReports_DilutedDiscontinuousOperations_OneMonth,
        EarningReports_DilutedDiscontinuousOperations_TwoMonths,
        EarningReports_DilutedDiscontinuousOperations_ThreeMonths,
        EarningReports_DilutedDiscontinuousOperations_SixMonths,
        EarningReports_DilutedDiscontinuousOperations_NineMonths,
        EarningReports_DilutedDiscontinuousOperations_TwelveMonths,
        EarningReports_DilutedExtraordinary_OneMonth,
        EarningReports_DilutedExtraordinary_TwoMonths,
        EarningReports_DilutedExtraordinary_ThreeMonths,
        EarningReports_DilutedExtraordinary_SixMonths,
        EarningReports_DilutedExtraordinary_NineMonths,
        EarningReports_DilutedExtraordinary_TwelveMonths,
        EarningReports_DilutedAccountingChange_ThreeMonths,
        EarningReports_DilutedAccountingChange_SixMonths,
        EarningReports_DilutedAccountingChange_NineMonths,
        EarningReports_DilutedAccountingChange_TwelveMonths,
        EarningReports_DilutedEPS_OneMonth,
        EarningReports_DilutedEPS_TwoMonths,
        EarningReports_DilutedEPS_ThreeMonths,
        EarningReports_DilutedEPS_SixMonths,
        EarningReports_DilutedEPS_NineMonths,
        EarningReports_DilutedEPS_TwelveMonths,
        EarningReports_BasicAverageShares_OneMonth,
        EarningReports_BasicAverageShares_TwoMonths,
        EarningReports_BasicAverageShares_ThreeMonths,
        EarningReports_BasicAverageShares_SixMonths,
        EarningReports_BasicAverageShares_NineMonths,
        EarningReports_BasicAverageShares_TwelveMonths,
        EarningReports_DilutedAverageShares_OneMonth,
        EarningReports_DilutedAverageShares_TwoMonths,
        EarningReports_DilutedAverageShares_ThreeMonths,
        EarningReports_DilutedAverageShares_SixMonths,
        EarningReports_DilutedAverageShares_NineMonths,
        EarningReports_DilutedAverageShares_TwelveMonths,
        EarningReports_DividendPerShare_OneMonth,
        EarningReports_DividendPerShare_TwoMonths,
        EarningReports_DividendPerShare_ThreeMonths,
        EarningReports_DividendPerShare_SixMonths,
        EarningReports_DividendPerShare_NineMonths,
        EarningReports_DividendPerShare_TwelveMonths,
        EarningReports_BasicEPSOtherGainsLosses_ThreeMonths,
        EarningReports_BasicEPSOtherGainsLosses_SixMonths,
        EarningReports_BasicEPSOtherGainsLosses_NineMonths,
        EarningReports_BasicEPSOtherGainsLosses_TwelveMonths,
        EarningReports_ContinuingAndDiscontinuedBasicEPS_OneMonth,
        EarningReports_ContinuingAndDiscontinuedBasicEPS_TwoMonths,
        EarningReports_ContinuingAndDiscontinuedBasicEPS_ThreeMonths,
        EarningReports_ContinuingAndDiscontinuedBasicEPS_SixMonths,
        EarningReports_ContinuingAndDiscontinuedBasicEPS_NineMonths,
        EarningReports_ContinuingAndDiscontinuedBasicEPS_TwelveMonths,
        EarningReports_TaxLossCarryforwardBasicEPS_ThreeMonths,
        EarningReports_TaxLossCarryforwardBasicEPS_SixMonths,
        EarningReports_TaxLossCarryforwardBasicEPS_NineMonths,
        EarningReports_TaxLossCarryforwardBasicEPS_TwelveMonths,
        EarningReports_DilutedEPSOtherGainsLosses_ThreeMonths,
        EarningReports_DilutedEPSOtherGainsLosses_SixMonths,
        EarningReports_DilutedEPSOtherGainsLosses_NineMonths,
        EarningReports_DilutedEPSOtherGainsLosses_TwelveMonths,
        EarningReports_ContinuingAndDiscontinuedDilutedEPS_OneMonth,
        EarningReports_ContinuingAndDiscontinuedDilutedEPS_TwoMonths,
        EarningReports_ContinuingAndDiscontinuedDilutedEPS_ThreeMonths,
        EarningReports_ContinuingAndDiscontinuedDilutedEPS_SixMonths,
        EarningReports_ContinuingAndDiscontinuedDilutedEPS_NineMonths,
        EarningReports_ContinuingAndDiscontinuedDilutedEPS_TwelveMonths,
        EarningReports_TaxLossCarryforwardDilutedEPS_ThreeMonths,
        EarningReports_TaxLossCarryforwardDilutedEPS_SixMonths,
        EarningReports_TaxLossCarryforwardDilutedEPS_NineMonths,
        EarningReports_TaxLossCarryforwardDilutedEPS_TwelveMonths,
        EarningReports_NormalizedBasicEPS_OneMonth,
        EarningReports_NormalizedBasicEPS_TwoMonths,
        EarningReports_NormalizedBasicEPS_ThreeMonths,
        EarningReports_NormalizedBasicEPS_SixMonths,
        EarningReports_NormalizedBasicEPS_NineMonths,
        EarningReports_NormalizedBasicEPS_TwelveMonths,
        EarningReports_NormalizedDilutedEPS_OneMonth,
        EarningReports_NormalizedDilutedEPS_TwoMonths,
        EarningReports_NormalizedDilutedEPS_ThreeMonths,
        EarningReports_NormalizedDilutedEPS_SixMonths,
        EarningReports_NormalizedDilutedEPS_NineMonths,
        EarningReports_NormalizedDilutedEPS_TwelveMonths,
        EarningReports_TotalDividendPerShare_OneMonth,
        EarningReports_TotalDividendPerShare_TwoMonths,
        EarningReports_TotalDividendPerShare_ThreeMonths,
        EarningReports_TotalDividendPerShare_SixMonths,
        EarningReports_TotalDividendPerShare_NineMonths,
        EarningReports_TotalDividendPerShare_TwelveMonths,
        EarningReports_ReportedNormalizedBasicEPS_ThreeMonths,
        EarningReports_ReportedNormalizedBasicEPS_SixMonths,
        EarningReports_ReportedNormalizedBasicEPS_NineMonths,
        EarningReports_ReportedNormalizedBasicEPS_TwelveMonths,
        EarningReports_ReportedNormalizedDilutedEPS_ThreeMonths,
        EarningReports_ReportedNormalizedDilutedEPS_SixMonths,
        EarningReports_ReportedNormalizedDilutedEPS_NineMonths,
        EarningReports_ReportedNormalizedDilutedEPS_TwelveMonths,
        EarningReports_DividendCoverageRatio_ThreeMonths,
        EarningReports_DividendCoverageRatio_SixMonths,
        EarningReports_DividendCoverageRatio_NineMonths,
        EarningReports_DividendCoverageRatio_TwelveMonths,
        OperationRatios_RevenueGrowth_OneYear,
        OperationRatios_RevenueGrowth_ThreeYears,
        OperationRatios_RevenueGrowth_ThreeMonths,
        OperationRatios_RevenueGrowth_FiveYears,
        OperationRatios_OperationIncomeGrowth_OneYear,
        OperationRatios_OperationIncomeGrowth_ThreeYears,
        OperationRatios_OperationIncomeGrowth_ThreeMonths,
        OperationRatios_OperationIncomeGrowth_FiveYears,
        OperationRatios_NetIncomeGrowth_OneYear,
        OperationRatios_NetIncomeGrowth_ThreeYears,
        OperationRatios_NetIncomeGrowth_ThreeMonths,
        OperationRatios_NetIncomeGrowth_FiveYears,
        OperationRatios_NetIncomeContOpsGrowth_OneYear,
        OperationRatios_NetIncomeContOpsGrowth_ThreeYears,
        OperationRatios_NetIncomeContOpsGrowth_ThreeMonths,
        OperationRatios_NetIncomeContOpsGrowth_FiveYears,
        OperationRatios_CFOGrowth_OneYear,
        OperationRatios_CFOGrowth_ThreeYears,
        OperationRatios_CFOGrowth_FiveYears,
        OperationRatios_FCFGrowth_OneYear,
        OperationRatios_FCFGrowth_ThreeYears,
        OperationRatios_FCFGrowth_FiveYears,
        OperationRatios_OperationRevenueGrowth3MonthAvg_OneYear,
        OperationRatios_OperationRevenueGrowth3MonthAvg_ThreeYears,
        OperationRatios_OperationRevenueGrowth3MonthAvg_ThreeMonths,
        OperationRatios_OperationRevenueGrowth3MonthAvg_FiveYears,
        OperationRatios_GrossMargin_OneYear,
        OperationRatios_GrossMargin_OneMonth,
        OperationRatios_GrossMargin_TwoMonths,
        OperationRatios_GrossMargin_ThreeMonths,
        OperationRatios_GrossMargin_SixMonths,
        OperationRatios_GrossMargin_NineMonths,
        OperationRatios_OperationMargin_OneYear,
        OperationRatios_OperationMargin_OneMonth,
        OperationRatios_OperationMargin_TwoMonths,
        OperationRatios_OperationMargin_ThreeMonths,
        OperationRatios_OperationMargin_SixMonths,
        OperationRatios_OperationMargin_NineMonths,
        OperationRatios_PretaxMargin_OneYear,
        OperationRatios_PretaxMargin_OneMonth,
        OperationRatios_PretaxMargin_TwoMonths,
        OperationRatios_PretaxMargin_ThreeMonths,
        OperationRatios_PretaxMargin_SixMonths,
        OperationRatios_PretaxMargin_NineMonths,
        OperationRatios_NetMargin_OneYear,
        OperationRatios_NetMargin_OneMonth,
        OperationRatios_NetMargin_TwoMonths,
        OperationRatios_NetMargin_ThreeMonths,
        OperationRatios_NetMargin_SixMonths,
        OperationRatios_NetMargin_NineMonths,
        OperationRatios_TaxRate_OneYear,
        OperationRatios_TaxRate_OneMonth,
        OperationRatios_TaxRate_TwoMonths,
        OperationRatios_TaxRate_ThreeMonths,
        OperationRatios_TaxRate_SixMonths,
        OperationRatios_TaxRate_NineMonths,
        OperationRatios_EBITMargin_OneYear,
        OperationRatios_EBITMargin_OneMonth,
        OperationRatios_EBITMargin_TwoMonths,
        OperationRatios_EBITMargin_ThreeMonths,
        OperationRatios_EBITMargin_SixMonths,
        OperationRatios_EBITMargin_NineMonths,
        OperationRatios_EBITDAMargin_OneYear,
        OperationRatios_EBITDAMargin_OneMonth,
        OperationRatios_EBITDAMargin_TwoMonths,
        OperationRatios_EBITDAMargin_ThreeMonths,
        OperationRatios_EBITDAMargin_SixMonths,
        OperationRatios_EBITDAMargin_NineMonths,
        OperationRatios_SalesPerEmployee_OneYear,
        OperationRatios_SalesPerEmployee_OneMonth,
        OperationRatios_SalesPerEmployee_TwoMonths,
        OperationRatios_SalesPerEmployee_ThreeMonths,
        OperationRatios_SalesPerEmployee_SixMonths,
        OperationRatios_SalesPerEmployee_NineMonths,
        OperationRatios_CurrentRatio_OneYear,
        OperationRatios_CurrentRatio_OneMonth,
        OperationRatios_CurrentRatio_TwoMonths,
        OperationRatios_CurrentRatio_ThreeMonths,
        OperationRatios_CurrentRatio_SixMonths,
        OperationRatios_CurrentRatio_NineMonths,
        OperationRatios_QuickRatio_OneYear,
        OperationRatios_QuickRatio_OneMonth,
        OperationRatios_QuickRatio_TwoMonths,
        OperationRatios_QuickRatio_ThreeMonths,
        OperationRatios_QuickRatio_SixMonths,
        OperationRatios_QuickRatio_NineMonths,
        OperationRatios_LongTermDebtTotalCapitalRatio_OneYear,
        OperationRatios_LongTermDebtTotalCapitalRatio_OneMonth,
        OperationRatios_LongTermDebtTotalCapitalRatio_TwoMonths,
        OperationRatios_LongTermDebtTotalCapitalRatio_ThreeMonths,
        OperationRatios_LongTermDebtTotalCapitalRatio_SixMonths,
        OperationRatios_LongTermDebtTotalCapitalRatio_NineMonths,
        OperationRatios_InterestCoverage_OneYear,
        OperationRatios_InterestCoverage_OneMonth,
        OperationRatios_InterestCoverage_TwoMonths,
        OperationRatios_InterestCoverage_ThreeMonths,
        OperationRatios_InterestCoverage_SixMonths,
        OperationRatios_InterestCoverage_NineMonths,
        OperationRatios_LongTermDebtEquityRatio_OneYear,
        OperationRatios_LongTermDebtEquityRatio_OneMonth,
        OperationRatios_LongTermDebtEquityRatio_TwoMonths,
        OperationRatios_LongTermDebtEquityRatio_ThreeMonths,
        OperationRatios_LongTermDebtEquityRatio_SixMonths,
        OperationRatios_LongTermDebtEquityRatio_NineMonths,
        OperationRatios_FinancialLeverage_OneYear,
        OperationRatios_FinancialLeverage_OneMonth,
        OperationRatios_FinancialLeverage_TwoMonths,
        OperationRatios_FinancialLeverage_ThreeMonths,
        OperationRatios_FinancialLeverage_SixMonths,
        OperationRatios_FinancialLeverage_NineMonths,
        OperationRatios_TotalDebtEquityRatio_OneYear,
        OperationRatios_TotalDebtEquityRatio_OneMonth,
        OperationRatios_TotalDebtEquityRatio_TwoMonths,
        OperationRatios_TotalDebtEquityRatio_ThreeMonths,
        OperationRatios_TotalDebtEquityRatio_SixMonths,
        OperationRatios_TotalDebtEquityRatio_NineMonths,
        OperationRatios_NormalizedNetProfitMargin_OneYear,
        OperationRatios_NormalizedNetProfitMargin_OneMonth,
        OperationRatios_NormalizedNetProfitMargin_TwoMonths,
        OperationRatios_NormalizedNetProfitMargin_ThreeMonths,
        OperationRatios_NormalizedNetProfitMargin_SixMonths,
        OperationRatios_NormalizedNetProfitMargin_NineMonths,
        OperationRatios_DaysInSales_OneYear,
        OperationRatios_DaysInSales_ThreeMonths,
        OperationRatios_DaysInSales_SixMonths,
        OperationRatios_DaysInInventory_OneYear,
        OperationRatios_DaysInInventory_ThreeMonths,
        OperationRatios_DaysInInventory_SixMonths,
        OperationRatios_DaysInPayment_OneYear,
        OperationRatios_DaysInPayment_ThreeMonths,
        OperationRatios_DaysInPayment_SixMonths,
        OperationRatios_CashConversionCycle_OneYear,
        OperationRatios_CashConversionCycle_ThreeMonths,
        OperationRatios_CashConversionCycle_SixMonths,
        OperationRatios_ReceivableTurnover_OneYear,
        OperationRatios_ReceivableTurnover_ThreeMonths,
        OperationRatios_ReceivableTurnover_SixMonths,
        OperationRatios_InventoryTurnover_OneYear,
        OperationRatios_InventoryTurnover_ThreeMonths,
        OperationRatios_InventoryTurnover_SixMonths,
        OperationRatios_PaymentTurnover_OneYear,
        OperationRatios_PaymentTurnover_ThreeMonths,
        OperationRatios_PaymentTurnover_SixMonths,
        OperationRatios_FixAssetsTuronver_OneYear,
        OperationRatios_FixAssetsTuronver_ThreeMonths,
        OperationRatios_FixAssetsTuronver_SixMonths,
        OperationRatios_AssetsTurnover_OneYear,
        OperationRatios_AssetsTurnover_ThreeMonths,
        OperationRatios_AssetsTurnover_SixMonths,
        OperationRatios_ROE_OneYear,
        OperationRatios_ROE_ThreeMonths,
        OperationRatios_ROE_SixMonths,
        OperationRatios_ROA_OneYear,
        OperationRatios_ROA_ThreeMonths,
        OperationRatios_ROA_SixMonths,
        OperationRatios_ROIC_OneYear,
        OperationRatios_ROIC_ThreeMonths,
        OperationRatios_ROIC_SixMonths,
        OperationRatios_FCFSalesRatio_OneYear,
        OperationRatios_FCFNetIncomeRatio_OneYear,
        OperationRatios_CapExSalesRatio_OneYear,
        OperationRatios_DebtToAssets_OneYear,
        OperationRatios_DebtToAssets_OneMonth,
        OperationRatios_DebtToAssets_TwoMonths,
        OperationRatios_DebtToAssets_ThreeMonths,
        OperationRatios_DebtToAssets_SixMonths,
        OperationRatios_DebtToAssets_NineMonths,
        OperationRatios_CommonEquityToAssets_OneYear,
        OperationRatios_CommonEquityToAssets_OneMonth,
        OperationRatios_CommonEquityToAssets_TwoMonths,
        OperationRatios_CommonEquityToAssets_ThreeMonths,
        OperationRatios_CommonEquityToAssets_SixMonths,
        OperationRatios_CommonEquityToAssets_NineMonths,
        OperationRatios_CapitalExpenditureAnnual5YrGrowth_OneYear,
        OperationRatios_CapitalExpenditureAnnual5YrGrowth_ThreeYears,
        OperationRatios_CapitalExpenditureAnnual5YrGrowth_FiveYears,
        OperationRatios_GrossProfitAnnual5YrGrowth_OneYear,
        OperationRatios_GrossProfitAnnual5YrGrowth_ThreeYears,
        OperationRatios_GrossProfitAnnual5YrGrowth_FiveYears,
        OperationRatios_GrossMargin5YrAvg_FiveYears,
        OperationRatios_PostTaxMargin5YrAvg_FiveYears,
        OperationRatios_PreTaxMargin5YrAvg_FiveYears,
        OperationRatios_ProfitMargin5YrAvg_FiveYears,
        OperationRatios_ROE5YrAvg_FiveYears,
        OperationRatios_ROA5YrAvg_FiveYears,
        OperationRatios_AVG5YrsROIC_FiveYears,
        OperationRatios_NormalizedROIC_OneYear,
        OperationRatios_NormalizedROIC_ThreeMonths,
        OperationRatios_NormalizedROIC_SixMonths,
        OperationRatios_RegressionGrowthOperatingRevenue5Years_FiveYears,
        OperationRatios_CashRatio_OneYear,
        OperationRatios_CashRatio_ThreeMonths,
        OperationRatios_CashtoTotalAssets_OneYear,
        OperationRatios_CashtoTotalAssets_ThreeMonths,
        OperationRatios_CapitalExpendituretoEBITDA_OneYear,
        OperationRatios_FCFtoCFO_OneYear,
        OperationRatios_StockholdersEquityGrowth_OneYear,
        OperationRatios_StockholdersEquityGrowth_ThreeYears,
        OperationRatios_StockholdersEquityGrowth_FiveYears,
        OperationRatios_TotalAssetsGrowth_OneYear,
        OperationRatios_TotalAssetsGrowth_ThreeYears,
        OperationRatios_TotalAssetsGrowth_FiveYears,
        OperationRatios_TotalLiabilitiesGrowth_OneYear,
        OperationRatios_TotalLiabilitiesGrowth_ThreeYears,
        OperationRatios_TotalLiabilitiesGrowth_FiveYears,
        OperationRatios_TotalDebtEquityRatioGrowth_OneYear,
        OperationRatios_TotalDebtEquityRatioGrowth_ThreeYears,
        OperationRatios_TotalDebtEquityRatioGrowth_FiveYears,
        OperationRatios_CashRatioGrowth_OneYear,
        OperationRatios_CashRatioGrowth_ThreeYears,
        OperationRatios_CashRatioGrowth_FiveYears,
        OperationRatios_EBITDAGrowth_OneYear,
        OperationRatios_EBITDAGrowth_ThreeYears,
        OperationRatios_EBITDAGrowth_FiveYears,
        OperationRatios_CashFlowFromFinancingGrowth_OneYear,
        OperationRatios_CashFlowFromFinancingGrowth_ThreeYears,
        OperationRatios_CashFlowFromFinancingGrowth_FiveYears,
        OperationRatios_CashFlowFromInvestingGrowth_OneYear,
        OperationRatios_CashFlowFromInvestingGrowth_ThreeYears,
        OperationRatios_CashFlowFromInvestingGrowth_FiveYears,
        OperationRatios_CapExGrowth_OneYear,
        OperationRatios_CapExGrowth_ThreeYears,
        OperationRatios_CapExGrowth_FiveYears,
        OperationRatios_CurrentRatioGrowth_OneYear,
        OperationRatios_CurrentRatioGrowth_ThreeYears,
        OperationRatios_CurrentRatioGrowth_FiveYears,
        OperationRatios_WorkingCapitalTurnoverRatio_OneYear,
        OperationRatios_WorkingCapitalTurnoverRatio_ThreeMonths,
        OperationRatios_NetIncomePerEmployee_OneYear,
        OperationRatios_NetIncomePerEmployee_ThreeMonths,
        OperationRatios_SolvencyRatio_OneYear,
        OperationRatios_SolvencyRatio_ThreeMonths,
        OperationRatios_ExpenseRatio_OneYear,
        OperationRatios_ExpenseRatio_ThreeMonths,
        OperationRatios_LossRatio_OneYear,
        OperationRatios_LossRatio_ThreeMonths,
        EarningRatios_DilutedEPSGrowth_OneYear,
        EarningRatios_DilutedEPSGrowth_ThreeYears,
        EarningRatios_DilutedEPSGrowth_ThreeMonths,
        EarningRatios_DilutedEPSGrowth_FiveYears,
        EarningRatios_DilutedContEPSGrowth_OneYear,
        EarningRatios_DilutedContEPSGrowth_ThreeYears,
        EarningRatios_DilutedContEPSGrowth_ThreeMonths,
        EarningRatios_DilutedContEPSGrowth_FiveYears,
        EarningRatios_DPSGrowth_OneYear,
        EarningRatios_DPSGrowth_ThreeMonths,
        EarningRatios_DPSGrowth_ThreeYears,
        EarningRatios_DPSGrowth_FiveYears,
        EarningRatios_EquityPerShareGrowth_OneYear,
        EarningRatios_EquityPerShareGrowth_ThreeMonths,
        EarningRatios_EquityPerShareGrowth_ThreeYears,
        EarningRatios_EquityPerShareGrowth_FiveYears,
        EarningRatios_RegressionGrowthofDividends5Years_FiveYears,
        EarningRatios_FCFPerShareGrowth_OneYear,
        EarningRatios_FCFPerShareGrowth_ThreeYears,
        EarningRatios_FCFPerShareGrowth_FiveYears,
        EarningRatios_BookValuePerShareGrowth_OneYear,
        EarningRatios_BookValuePerShareGrowth_ThreeMonths,
        EarningRatios_BookValuePerShareGrowth_ThreeYears,
        EarningRatios_BookValuePerShareGrowth_FiveYears,
        EarningRatios_NormalizedDilutedEPSGrowth_OneYear,
        EarningRatios_NormalizedDilutedEPSGrowth_ThreeMonths,
        EarningRatios_NormalizedDilutedEPSGrowth_ThreeYears,
        EarningRatios_NormalizedDilutedEPSGrowth_FiveYears,
        EarningRatios_NormalizedBasicEPSGrowth_OneYear,
        EarningRatios_NormalizedBasicEPSGrowth_ThreeMonths,
        EarningRatios_NormalizedBasicEPSGrowth_ThreeYears,
        EarningRatios_NormalizedBasicEPSGrowth_FiveYears,
        ValuationRatios_PayoutRatio,
        ValuationRatios_SustainableGrowthRate,
        ValuationRatios_CashReturn,
        ValuationRatios_SalesPerShare,
        ValuationRatios_BookValuePerShare,
        ValuationRatios_CFOPerShare,
        ValuationRatios_FCFPerShare,
        ValuationRatios_EarningYield,
        ValuationRatios_PERatio,
        ValuationRatios_SalesYield,
        ValuationRatios_PSRatio,
        ValuationRatios_BookValueYield,
        ValuationRatios_PBRatio,
        ValuationRatios_CFYield,
        ValuationRatios_PCFRatio,
        ValuationRatios_FCFYield,
        ValuationRatios_FCFRatio,
        ValuationRatios_TrailingDividendYield,
        ValuationRatios_ForwardDividendYield,
        ValuationRatios_ForwardEarningYield,
        ValuationRatios_ForwardPERatio,
        ValuationRatios_PEGRatio,
        ValuationRatios_PEGPayback,
        ValuationRatios_TangibleBookValuePerShare,
        ValuationRatios_TangibleBVPerShare3YrAvg,
        ValuationRatios_TangibleBVPerShare5YrAvg,
        ValuationRatios_ForwardDividend,
        ValuationRatios_WorkingCapitalPerShare,
        ValuationRatios_WorkingCapitalPerShare3YrAvg,
        ValuationRatios_WorkingCapitalPerShare5YrAvg,
        ValuationRatios_EVToEBITDA,
        ValuationRatios_BuyBackYield,
        ValuationRatios_TotalYield,
        ValuationRatios_RatioPE5YearAverage,
        ValuationRatios_PriceChange1M,
        ValuationRatios_NormalizedPERatio,
        ValuationRatios_PriceToEBITDA,
        ValuationRatios_DivYield5Year,
        ValuationRatios_ForwardROE,
        ValuationRatios_ForwardROA,
        ValuationRatios_TwoYearsForwardEarningYield,
        ValuationRatios_TwoYearsForwardPERatio,
        ValuationRatios_ForwardCalculationStyle,
        ValuationRatios_ActualForwardDividend,
        ValuationRatios_TrailingCalculationStyle,
        ValuationRatios_ActualTrailingDividend,
        ValuationRatios_TotalAssetPerShare,
        ValuationRatios_ExpectedDividendGrowthRate,
        ValuationRatios_EVToRevenue,
        ValuationRatios_EVToPreTaxIncome,
        ValuationRatios_EVToTotalAssets,
        ValuationRatios_EVToFCF,
        ValuationRatios_EVToEBIT,
        ValuationRatios_FFOPerShare,
        ValuationRatios_PriceToCashRatio,
        ValuationRatios_EVToForwardEBITDA,
        ValuationRatios_EVToForwardRevenue,
        ValuationRatios_EVToForwardEBIT,
        ValuationRatios_EVToEBITDA1YearGrowth,
        ValuationRatios_EVToFCF1YearGrowth,
        ValuationRatios_EVToRevenue1YearGrowth,
        ValuationRatios_EVToTotalAssets1YearGrowth,
        ValuationRatios_PFCFRatio1YearGrowth,
        ValuationRatios_PBRatio1YearGrowth,
        ValuationRatios_PERatio1YearGrowth,
        ValuationRatios_PSRatio1YearGrowth,
        ValuationRatios_EVToEBIT3YrAvg,
        ValuationRatios_EVToEBITDA3YrAvg,
        ValuationRatios_EVToFCF3YrAvg,
        ValuationRatios_EVToRevenue3YrAvg,
        ValuationRatios_EVToTotalAssets3YrAvg,
        ValuationRatios_EVToEBIT3YrAvgChange,
        ValuationRatios_EVToEBITDA3YrAvgChange,
        ValuationRatios_EVToFCF3YrAvgChange,
        ValuationRatios_EVToRevenue3YrAvgChange,
        ValuationRatios_EVToTotalAssets3YrAvgChange,
        ValuationRatios_PFCFRatio3YrAvg,
        ValuationRatios_PBRatio3YrAvg,
        ValuationRatios_PSRatio3YrAvg,
        ValuationRatios_PCashRatio3YrAvg,
        ValuationRatios_PERatio3YrAvg,
        ValuationRatios_PFCFRatio3YrAvgChange,
        ValuationRatios_PBRatio3YrAvgChange,
        ValuationRatios_PSRatio3YrAvgChange,
        ValuationRatios_PERatio3YrAvgChange,
        ValuationRatios_PERatio1YearHigh,
        ValuationRatios_PERatio1YearLow,
        ValuationRatios_PERatio1YearAverage,
        ValuationRatios_PERatio5YearHigh,
        ValuationRatios_PERatio5YearLow,
        ValuationRatios_PERatio5YearAverage,
        ValuationRatios_PERatio10YearHigh,
        ValuationRatios_PERatio10YearLow,
        ValuationRatios_PERatio10YearAverage,
        ValuationRatios_CAPERatio,
        ValuationRatios_EVToEBITDA3YearGrowth,
        ValuationRatios_EVToFCF3YearGrowth,
        ValuationRatios_EVToRevenue3YearGrowth,
        ValuationRatios_EVToTotalAssets3YearGrowth,
        ValuationRatios_PFCFRatio3YearGrowth,
        ValuationRatios_PBRatio3YearGrowth,
        ValuationRatios_PERatio3YearGrowth,
        ValuationRatios_PSRatio3YearGrowth,
        ValuationRatios_EVToEBITDA5YearGrowth,
        ValuationRatios_EVToFCF5YearGrowth,
        ValuationRatios_EVToRevenue5YearGrowth,
        ValuationRatios_EVToTotalAssets5YearGrowth,
        ValuationRatios_PFCFRatio5YearGrowth,
        ValuationRatios_PBRatio5YearGrowth,
        ValuationRatios_PERatio5YearGrowth,
        ValuationRatios_PSRatio5YearGrowth,
        ValuationRatios_EVToEBITDA10YearGrowth,
        ValuationRatios_EVToFCF10YearGrowth,
        ValuationRatios_EVToRevenue10YearGrowth,
        ValuationRatios_EVToTotalAssets10YearGrowth,
        ValuationRatios_PFCFRatio10YearGrowth,
        ValuationRatios_PBRatio10YearGrowth,
        ValuationRatios_PERatio10YearGrowth,
        ValuationRatios_PSRatio10YearGrowth,
        ValuationRatios_TwoYrsEVToForwardEBIT,
        ValuationRatios_TwoYrsEVToForwardEBITDA,
        ValuationRatios_FirstYearEstimatedEPSGrowth,
        ValuationRatios_SecondYearEstimatedEPSGrowth,
        ValuationRatios_NormalizedPEGRatio,
        CompanyProfile_HeadquarterAddressLine1,
        CompanyProfile_HeadquarterAddressLine2,
        CompanyProfile_HeadquarterAddressLine3,
        CompanyProfile_HeadquarterAddressLine4,
        CompanyProfile_HeadquarterAddressLine5,
        CompanyProfile_HeadquarterCity,
        CompanyProfile_HeadquarterProvince,
        CompanyProfile_HeadquarterCountry,
        CompanyProfile_HeadquarterPostalCode,
        CompanyProfile_HeadquarterPhone,
        CompanyProfile_HeadquarterFax,
        CompanyProfile_HeadquarterHomepage,
        CompanyProfile_TotalEmployeeNumber,
        CompanyProfile_ContactEmail,
        CompanyProfile_AverageEmployeeNumber,
        CompanyProfile_RegisteredAddressLine1,
        CompanyProfile_RegisteredAddressLine2,
        CompanyProfile_RegisteredAddressLine3,
        CompanyProfile_RegisteredAddressLine4,
        CompanyProfile_RegisteredCity,
        CompanyProfile_RegisteredProvince,
        CompanyProfile_RegisteredCountry,
        CompanyProfile_RegisteredPostalCode,
        CompanyProfile_RegisteredPhone,
        CompanyProfile_RegisteredFax,
        CompanyProfile_IsHeadOfficeSameWithRegisteredOfficeFlag,
        CompanyProfile_SharesOutstanding,
        CompanyProfile_MarketCap,
        CompanyProfile_EnterpriseValue,
        CompanyProfile_ShareClassLevelSharesOutstanding,
        CompanyProfile_SharesOutstandingWithBalanceSheetEndingDate,
        CompanyProfile_ReasonofSharesChange,
        AssetClassification_StockType,
        AssetClassification_StyleBox,
        AssetClassification_GrowthGrade,
        AssetClassification_FinancialHealthGrade,
        AssetClassification_ProfitabilityGrade,
        AssetClassification_MorningstarIndustryCode,
        AssetClassification_MorningstarIndustryGroupCode,
        AssetClassification_MorningstarSectorCode,
        AssetClassification_MorningstarEconomySphereCode,
        AssetClassification_SIC,
        AssetClassification_NAICS,
        AssetClassification_StyleScore,
        AssetClassification_SizeScore,
        AssetClassification_GrowthScore,
        AssetClassification_ValueScore,
        AssetClassification_NACE,
        AssetClassification_CANNAICS,
#pragma warning restore CS1591, CA1707
    }
}
