## Licenses

The MRIcroGL source code uses the [BSD license](https://opensource.org/licenses/BSD-2-Clause). However, it is distributed with sample images that from various sources and with various open source licenses.

MRIcroGL is distributed with low-resolution images to reduce file size and ensure compatibility with old computers. Larger but higher quality images are available by downloading the [Extra Sample Images](https://www.nitrc.org/projects/mricrogl). Further examples are available in the [VolumeRenderingData](https://github.com/neurolabusc/VolumeRenderingData) repository.

 - `chris_MRA`, `chris_PD`, `chris_t1`, `chris_t2`, `pcasl` and `spmMotor` show proton density, T1-weighted, T2-weighted and fMRI statistical map images. They were acquired by Chirs Rorden at the [McCausland Center for Brain Imaging](https://www.mccauslandcenter.sc.edu) and are distributed under the [CC BY-NC 4.0 license](https://creativecommons.org/licenses/by-nc/4.0/).
 - `CT_Abdo` was provided by Steve Pieper and is from a Slicer3D [example dataset](https://www.slicer.org/wiki/File:CTA-cardio.nrrd).
 - `CT_AVM` is [from Github](https://github.com/IbisNeuronav/PRISMDatabase) as an example for [IBIS](https://pubmed.ncbi.nlm.nih.gov/27581336/).
 - `CT_Electrodes` is from the [Seg3DData ](https://github.com/CIBC-Internal/Seg3DData) repository. It is distributed using the [MIT license](https://opensource.org/licenses/MIT) from the Scientific Computing and Imaging Institute, University of Utah (2015).
 - `CT_Philips` is courtesy of Philips Medical and described [here](https://www.nitrc.org/plugins/mwiki/index.php/dcm2nii:MainPage#Computed_Tomography_.28CT.2C_CAT.29).
 - `Iguana` is a desert [desert iguana](http://digimorph.org/specimens/Dipsosaurus_dorsalis/) from Dr. Jessie Maisano. University of Texas High-Resolution X-ray CT Facility Archive 0787. [CC BY-NC 4.0 license](https://creativecommons.org/licenses/by-nc/4.0/).
 - `spm152` and `mni153` are derived from the [ICBM 152 Nonlinear atlases version 2009](https://www.bic.mni.mcgill.ca/ServicesAtlases/ICBM152NLin2009). The spm152 is average brain size, while the mni152 matches the size of the [MNI ICBM template](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6050588/).
 - `visiblehuman` is from the [visible human project](https://www.nlm.nih.gov/research/visible/visible_human.html)