/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.reflection.JarEntry;
import com.alee.utils.reflection.JarEntryComparator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;

public class JarStructure {
    public static final JarEntryComparator COMPARATOR = new JarEntryComparator();
    private String jarLocation;
    private JarEntry root;

    public JarStructure(JarEntry root) {
        this.setRoot(root);
    }

    public String getJarLocation() {
        return this.jarLocation;
    }

    public void setJarLocation(String jarLocation) {
        this.jarLocation = jarLocation;
    }

    public JarEntry getRoot() {
        return this.root;
    }

    public void setRoot(JarEntry root) {
        this.root = root;
    }

    public List<JarEntry> getChildEntries(JarEntry entry) {
        List<JarEntry> childs = entry != null ? entry.getChilds() : this.getRoot().getChilds();
        Collections.sort(childs, COMPARATOR);
        return childs;
    }

    public JarEntry findEntryByName(String name) {
        return this.findEntryByName(name, this.getRoot());
    }

    private JarEntry findEntryByName(String name, JarEntry entry) {
        for (JarEntry child : entry.getChilds()) {
            if (FileUtils.getFileNamePart(child.getName()).equals(name)) {
                return child;
            }
            JarEntry found = this.findEntryByName(name, child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public List<JarEntry> findSimilarEntries(String name) {
        return this.findSimilarEntries(name.toLowerCase(), null);
    }

    public List<JarEntry> findSimilarEntries(String name, Filter<JarEntry> filter) {
        return this.findSimilarEntries(name.toLowerCase(), this.getRoot(), filter, new ArrayList<JarEntry>());
    }

    private List<JarEntry> findSimilarEntries(String name, JarEntry entry, Filter<JarEntry> filter, List<JarEntry> entries) {
        if (entry.getName().toLowerCase().contains(name) && (filter == null || filter.accept(entry))) {
            entries.add(entry);
        }
        for (JarEntry child : entry.getChilds()) {
            this.findSimilarEntries(name, child, filter, entries);
        }
        return entries;
    }

    public JarEntry getClassEntry(Class forClass) {
        String[] packages = ReflectUtils.getClassPackages(forClass);
        String classFileName = ReflectUtils.getJavaClassName(forClass);
        int currentPackage = 0;
        JarEntry currentLevel = this.getRoot();
        while (currentLevel != null) {
            if (currentPackage >= packages.length) {
                currentLevel = currentLevel.getChildByName(classFileName);
                break;
            }
            currentLevel = currentLevel.getChildByName(packages[currentPackage]);
            ++currentPackage;
        }
        return currentLevel;
    }

    public void setPackageIcon(Package packageType, ImageIcon icon) {
        this.setPackageIcon(packageType.getName(), icon);
    }

    public void setPackageIcon(String packageName, ImageIcon icon) {
        String[] packages = ReflectUtils.getPackages(packageName);
        JarEntry currentLevel = this.getRoot();
        for (String currentPackage : packages) {
            if (currentLevel == null) {
                return;
            }
            currentLevel = currentLevel.getChildByName(currentPackage);
        }
        currentLevel.setIcon(icon);
    }

    public void setClassIcon(Class classType, ImageIcon icon) {
        JarEntry classEntry = this.getClassEntry(classType);
        if (classEntry != null) {
            classEntry.setIcon(icon);
        }
    }

    public InputStream getEntryInputStream(JarEntry entry) throws IOException {
        return new ZipFile(this.getJarLocation()).getInputStream(entry.getZipEntry());
    }
}

