/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.utils.ImageUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.ninepatch.NinePatchIconConverter;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@XStreamConverter(value=NinePatchIconConverter.class)
public class NinePatchIcon
implements Icon {
    protected Component component;
    protected BufferedImage rawImage;
    protected List<NinePatchInterval> horizontalStretch;
    protected List<NinePatchInterval> verticalStretch;
    protected Insets margin;
    protected Integer cachedWidth0;
    protected Integer cachedWidth1;
    protected Integer cachedHeight0;
    protected Integer cachedHeight1;

    public NinePatchIcon(URL url) {
        this(url, null);
    }

    public NinePatchIcon(URL url, Component component) {
        this(ImageUtils.getBufferedImage(url), component);
    }

    public NinePatchIcon(String iconSrc) {
        this(iconSrc, null);
    }

    public NinePatchIcon(String iconSrc, Component component) {
        this(ImageUtils.getBufferedImage(iconSrc), component);
    }

    public NinePatchIcon(ImageIcon imageIcon) {
        this(imageIcon, null);
    }

    public NinePatchIcon(ImageIcon imageIcon, Component component) {
        this(ImageUtils.getBufferedImage(imageIcon), component);
    }

    public NinePatchIcon(Image image) {
        this(image, null);
    }

    public NinePatchIcon(Image image, Component component) {
        this(ImageUtils.getBufferedImage(image), component);
    }

    public NinePatchIcon(BufferedImage bufferedImage) {
        this(bufferedImage, null);
    }

    public NinePatchIcon(BufferedImage bufferedImage, Component component) {
        this(bufferedImage, component, true);
    }

    protected NinePatchIcon(BufferedImage bufferedImage, Component component, boolean parsePatches) {
        if (parsePatches) {
            if (bufferedImage.getWidth() < 3 || bufferedImage.getHeight() < 3) {
                throw new IllegalArgumentException("Buffered image must be atleast 3x3 pixels size");
            }
            this.component = component;
            int w = bufferedImage.getWidth() - 2;
            int h = bufferedImage.getHeight() - 2;
            this.rawImage = ImageUtils.createCompatibleImage(bufferedImage, w, h);
            Graphics2D g2d = this.rawImage.createGraphics();
            g2d.drawImage(bufferedImage, 0, 0, w, h, 1, 1, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1, null);
            g2d.dispose();
            this.horizontalStretch = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.horizontalStretch);
            this.verticalStretch = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.verticalStretch);
            if (this.horizontalStretch.size() <= 1 && (this.horizontalStretch.size() != 1 || this.horizontalStretch.get(0).isPixel()) || this.verticalStretch.size() <= 1 && (this.verticalStretch.size() != 1 || this.verticalStretch.get(0).isPixel())) {
                throw new IllegalArgumentException("There must be stretch constraints specified on image");
            }
            List<NinePatchInterval> vc = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.verticalContent);
            List<NinePatchInterval> hc = NinePatchUtils.parseIntervals(bufferedImage, NinePatchIntervalType.horizontalContent);
            int top = vc.size() == 0 ? 0 : vc.get(0).getStart();
            int bottom = vc.size() == 0 ? 0 : this.rawImage.getHeight() - vc.get(0).getEnd() - 1;
            int left = hc.size() == 0 ? 0 : hc.get(0).getStart();
            int right = hc.size() == 0 ? 0 : this.rawImage.getWidth() - hc.get(0).getEnd() - 1;
            this.margin = new Insets(top, left, bottom, right);
            this.getFixedPixelsWidth(true);
            this.getFixedPixelsWidth(false);
            this.getFixedPixelsHeight(true);
            this.getFixedPixelsHeight(false);
        } else {
            this.component = component;
            this.rawImage = bufferedImage;
            this.horizontalStretch = new ArrayList<NinePatchInterval>();
            this.verticalStretch = new ArrayList<NinePatchInterval>();
        }
    }

    public static NinePatchIcon create(BufferedImage rawImage) {
        return new NinePatchIcon(rawImage, null, false);
    }

    public BufferedImage getRawImage() {
        return this.rawImage;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public List<NinePatchInterval> getHorizontalStretch() {
        return this.horizontalStretch;
    }

    public void setHorizontalStretch(List<NinePatchInterval> horizontalStretch) {
        this.horizontalStretch = horizontalStretch;
        this.updateCachedWidthData();
    }

    public void addHorizontalStretch(NinePatchInterval interval) {
        this.horizontalStretch.add(interval);
        this.updateCachedWidthData();
    }

    public void addHorizontalStretch(int start, int end, boolean pixel) {
        this.addHorizontalStretch(new NinePatchInterval(start, end, pixel));
    }

    public List<NinePatchInterval> getVerticalStretch() {
        return this.verticalStretch;
    }

    public void setVerticalStretch(List<NinePatchInterval> verticalStretch) {
        this.verticalStretch = verticalStretch;
        this.updateCachedHeightData();
    }

    public void addVerticalStretch(NinePatchInterval interval) {
        this.verticalStretch.add(interval);
        this.updateCachedHeightData();
    }

    public void addVerticalStretch(int start, int end, boolean pixel) {
        this.addVerticalStretch(new NinePatchInterval(start, end, pixel));
    }

    public Insets getMargin() {
        return (Insets)this.margin.clone();
    }

    public Insets getStretchMargin() {
        NinePatchInterval top = this.verticalStretch.get(0);
        NinePatchInterval left = this.horizontalStretch.get(0);
        NinePatchInterval bottom = this.verticalStretch.get(this.verticalStretch.size() - 1);
        NinePatchInterval right = this.horizontalStretch.get(this.horizontalStretch.size() - 1);
        return new Insets(top.getLength(), left.getLength(), bottom.getLength(), right.getLength());
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    public void paintIcon(Component c, Graphics g) {
        this.paintIcon((Graphics2D)g, 0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintIcon((Graphics2D)g, 0, 0, c.getWidth(), c.getHeight());
    }

    public void paintIcon(Graphics2D g2d, Rectangle bounds) {
        this.paintIcon(g2d, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void paintIcon(Graphics2D g2d, int x, int y, int width, int height) {
        int availableWidth = Math.max(width, this.getFixedPixelsWidth(true));
        int availableHeight = Math.max(height, this.getFixedPixelsHeight(true));
        int fixedPixelsX = this.getFixedPixelsWidth(false);
        int unfixedX = availableWidth - fixedPixelsX;
        int fixedPixelsY = this.getFixedPixelsHeight(false);
        int unfixedY = availableHeight - fixedPixelsY;
        int currentY = y;
        for (NinePatchInterval intervalY : this.verticalStretch) {
            int finalHeight;
            int intervalHeight = intervalY.getEnd() - intervalY.getStart() + 1;
            if (intervalY.isPixel()) {
                finalHeight = intervalHeight;
            } else {
                float percents = (float)intervalHeight / (float)(this.rawImage.getHeight() - fixedPixelsY);
                finalHeight = Math.round(percents * (float)unfixedY);
            }
            int currentX = x;
            for (NinePatchInterval intervalX : this.horizontalStretch) {
                int finalWidth;
                int intervalWidth = intervalX.getEnd() - intervalX.getStart() + 1;
                if (intervalX.isPixel()) {
                    finalWidth = intervalWidth;
                } else {
                    float percents = (float)intervalWidth / (float)(this.rawImage.getWidth() - fixedPixelsX);
                    finalWidth = Math.round(percents * (float)unfixedX);
                }
                g2d.drawImage(this.rawImage, currentX, currentY, currentX + finalWidth, currentY + finalHeight, intervalX.getStart(), intervalY.getStart(), intervalX.getStart() + intervalWidth, intervalY.getStart() + intervalHeight, null);
                currentX += finalWidth;
            }
            currentY += finalHeight;
        }
    }

    public int getFixedPixelsWidth(boolean addUnfixedSpaces) {
        if (addUnfixedSpaces) {
            if (this.cachedWidth0 == null) {
                this.cachedWidth0 = this.calculateFixedPixelsWidth(addUnfixedSpaces);
            }
            return this.cachedWidth0;
        }
        if (this.cachedWidth1 == null) {
            this.cachedWidth1 = this.calculateFixedPixelsWidth(addUnfixedSpaces);
        }
        return this.cachedWidth1;
    }

    protected int calculateFixedPixelsWidth(boolean addUnfixedSpaces) {
        int fixedPixelsX = this.rawImage.getWidth();
        for (NinePatchInterval interval : this.horizontalStretch) {
            if (interval.isPixel()) continue;
            fixedPixelsX -= interval.getEnd() - interval.getStart() + 1;
            if (!addUnfixedSpaces) continue;
            ++fixedPixelsX;
        }
        return fixedPixelsX;
    }

    protected void updateCachedWidthData() {
        this.cachedWidth0 = null;
        this.cachedWidth1 = null;
        this.getFixedPixelsWidth(true);
        this.getFixedPixelsWidth(false);
    }

    public int getFixedPixelsHeight(boolean addUnfixedSpaces) {
        if (addUnfixedSpaces) {
            if (this.cachedHeight0 == null) {
                this.cachedHeight0 = this.calculateFixedPixelsHeight(addUnfixedSpaces);
            }
            return this.cachedHeight0;
        }
        if (this.cachedHeight1 == null) {
            this.cachedHeight1 = this.calculateFixedPixelsHeight(addUnfixedSpaces);
        }
        return this.cachedHeight1;
    }

    protected int calculateFixedPixelsHeight(boolean addUnfixedSpaces) {
        int fixedPixelsY = this.rawImage.getHeight();
        for (NinePatchInterval interval : this.verticalStretch) {
            if (interval.isPixel()) continue;
            fixedPixelsY -= interval.getEnd() - interval.getStart() + 1;
            if (!addUnfixedSpaces) continue;
            ++fixedPixelsY;
        }
        return fixedPixelsY;
    }

    protected void updateCachedHeightData() {
        this.cachedHeight0 = null;
        this.cachedHeight1 = null;
        this.getFixedPixelsHeight(true);
        this.getFixedPixelsHeight(false);
    }

    @Override
    public int getIconWidth() {
        return Math.max(this.component != null ? this.component.getWidth() : 0, this.getFixedPixelsWidth(true));
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.component != null ? this.component.getHeight() : 0, this.getFixedPixelsHeight(true));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getFixedPixelsWidth(true), this.getFixedPixelsHeight(true));
    }

    public Dimension getRealImageSize() {
        return new Dimension(this.getRawImage().getWidth(), this.getRawImage().getHeight());
    }
}

