/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.global.StyleConstants;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;

public final class WindowUtils {
    private static final Map<Window, WebTimer> windowPackTimers = new HashMap<Window, WebTimer>();

    public static <W extends Window> W setWindowOpaque(W window, boolean opaque) {
        ProprietaryUtils.setWindowOpaque(window, opaque);
        return window;
    }

    public static <W extends Window> boolean isWindowOpaque(W window) {
        return ProprietaryUtils.isWindowOpaque(window);
    }

    public static <W extends Window> W setWindowOpacity(W window, float opacity) {
        ProprietaryUtils.setWindowOpacity(window, opacity);
        return window;
    }

    public static <W extends Window> float getWindowOpacity(W window) {
        return ProprietaryUtils.getWindowOpacity(window);
    }

    public static <W extends Window> W center(W window) {
        window.setLocationRelativeTo(null);
        return window;
    }

    public static <W extends Window> W center(W window, Component relativeTo) {
        window.setLocationRelativeTo(relativeTo);
        return window;
    }

    public static <W extends Window> W center(W window, int width, int height) {
        window.setSize(width, height);
        return WindowUtils.center(window);
    }

    public static <W extends Window> W center(W window, Component relativeTo, int width, int height) {
        window.setSize(width, height);
        return WindowUtils.center(window, relativeTo);
    }

    public static <W extends Window> W packToWidth(W window, int width) {
        window.setSize(width, window.getPreferredSize().height);
        return window;
    }

    public static <W extends Window> W packToHeight(W window, int height) {
        window.setSize(window.getPreferredSize().width, height);
        return window;
    }

    public static <W extends Window> W packAndCenter(W window) {
        return WindowUtils.packAndCenter(window, StyleConstants.animate);
    }

    public static <W extends Window> W packAndCenter(final W window, boolean animate) {
        if (window == null) {
            return window;
        }
        final Rectangle b = window.getBounds();
        Dimension s = window.getPreferredSize();
        Rectangle newBounds = new Rectangle(b.x + b.width / 2 - s.width / 2, b.y + b.height / 2 - s.height / 2, s.width, s.height);
        if (windowPackTimers.containsKey(window) && windowPackTimers.get(window) != null && windowPackTimers.get(window).isRunning()) {
            windowPackTimers.get(window).stop();
        }
        if (window.isShowing() && animate) {
            int time = 100;
            int steps = 10;
            final int xDiff = newBounds.width - b.width;
            final int yDiff = newBounds.height - b.height;
            WebTimer t = new WebTimer(10L, new ActionListener(){
                private int step = 1;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.step <= 10) {
                        int w = b.width + xDiff * this.step / 10;
                        int h = b.height + yDiff * this.step / 10;
                        Rectangle changed = new Rectangle(b.x + b.width / 2 - w / 2, b.y + b.height / 2 - h / 2, w, h);
                        window.setBounds(changed);
                    } else {
                        ((WebTimer)windowPackTimers.get(window)).stop();
                    }
                    ++this.step;
                }
            });
            windowPackTimers.put(window, t);
            t.start();
        } else {
            window.setBounds(newBounds);
        }
        return window;
    }
}

