/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.extended.button.WebSplitButton;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.extended.label.WebMultiLineLabel;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.label.WebVerticalLabel;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.log.Log;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.laf.Styleable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;

public enum SupportedComponent {
    label(true, JLabel.class, "LabelUI", WebLookAndFeel.labelUI),
    verticalLabel(true, WebVerticalLabel.class, "VerticalLabelUI", WebLookAndFeel.verticalLabelUI),
    multiLineLabel(false, WebMultiLineLabel.class, "MultiLineLabelUI", WebLookAndFeel.multiLineLabelUI),
    styledLabel(true, WebStyledLabel.class, "StyledLabelUI", WebLookAndFeel.styledLabelUI),
    toolTip(false, JToolTip.class, "ToolTipUI", WebLookAndFeel.toolTipUI),
    button(false, JButton.class, "ButtonUI", WebLookAndFeel.buttonUI),
    splitButton(false, WebSplitButton.class, "SplitButtonUI", WebLookAndFeel.splitButtonUI),
    toggleButton(false, JToggleButton.class, "ToggleButtonUI", WebLookAndFeel.toggleButtonUI),
    checkBox(false, JCheckBox.class, "CheckBoxUI", WebLookAndFeel.checkBoxUI),
    tristateCheckBox(false, WebTristateCheckBox.class, "TristateCheckBoxUI", WebLookAndFeel.tristateCheckBoxUI),
    radioButton(false, JRadioButton.class, "RadioButtonUI", WebLookAndFeel.radioButtonUI),
    menuBar(false, JMenuBar.class, "MenuBarUI", WebLookAndFeel.menuBarUI),
    menu(false, JMenu.class, "MenuUI", WebLookAndFeel.menuUI),
    popupMenu(true, JPopupMenu.class, "PopupMenuUI", WebLookAndFeel.popupMenuUI),
    menuItem(false, JMenuItem.class, "MenuItemUI", WebLookAndFeel.menuItemUI),
    checkBoxMenuItem(false, JCheckBoxMenuItem.class, "CheckBoxMenuItemUI", WebLookAndFeel.checkBoxMenuItemUI),
    radioButtonMenuItem(false, JRadioButtonMenuItem.class, "RadioButtonMenuItemUI", WebLookAndFeel.radioButtonMenuItemUI),
    popupMenuSeparator(false, JPopupMenu.Separator.class, "PopupMenuSeparatorUI", WebLookAndFeel.popupMenuSeparatorUI),
    separator(false, JSeparator.class, "SeparatorUI", WebLookAndFeel.separatorUI),
    scrollBar(true, JScrollBar.class, "ScrollBarUI", WebLookAndFeel.scrollBarUI),
    scrollPane(false, JScrollPane.class, "ScrollPaneUI", WebLookAndFeel.scrollPaneUI),
    viewport(false, JViewport.class, "ViewportUI", WebLookAndFeel.viewportUI),
    textField(false, JTextField.class, "TextFieldUI", WebLookAndFeel.textFieldUI),
    passwordField(false, JPasswordField.class, "PasswordFieldUI", WebLookAndFeel.passwordFieldUI),
    formattedTextField(false, JFormattedTextField.class, "FormattedTextFieldUI", WebLookAndFeel.formattedTextFieldUI),
    textArea(false, JTextArea.class, "TextAreaUI", WebLookAndFeel.textAreaUI),
    editorPane(false, JEditorPane.class, "EditorPaneUI", WebLookAndFeel.editorPaneUI),
    textPane(false, JTextPane.class, "TextPaneUI", WebLookAndFeel.textPaneUI),
    toolBar(false, JToolBar.class, "ToolBarUI", WebLookAndFeel.toolBarUI),
    toolBarSeparator(false, JToolBar.Separator.class, "ToolBarSeparatorUI", WebLookAndFeel.toolBarSeparatorUI),
    table(false, JTable.class, "TableUI", WebLookAndFeel.tableUI),
    tableHeader(false, JTableHeader.class, "TableHeaderUI", WebLookAndFeel.tableHeaderUI),
    colorChooser(false, JColorChooser.class, "ColorChooserUI", WebLookAndFeel.colorChooserUI),
    fileChooser(false, JFileChooser.class, "FileChooserUI", WebLookAndFeel.fileChooserUI),
    panel(true, JPanel.class, "PanelUI", WebLookAndFeel.panelUI),
    rootPane(false, JRootPane.class, "RootPaneUI", WebLookAndFeel.rootPaneUI),
    tabbedPane(false, JTabbedPane.class, "TabbedPaneUI", WebLookAndFeel.tabbedPaneUI),
    splitPane(false, JSplitPane.class, "SplitPaneUI", WebLookAndFeel.splitPaneUI),
    progressBar(false, JProgressBar.class, "ProgressBarUI", WebLookAndFeel.progressBarUI),
    slider(false, JSlider.class, "SliderUI", WebLookAndFeel.sliderUI),
    spinner(false, JSpinner.class, "SpinnerUI", WebLookAndFeel.spinnerUI),
    tree(false, JTree.class, "TreeUI", WebLookAndFeel.treeUI),
    list(false, JList.class, "ListUI", WebLookAndFeel.listUI),
    comboBox(false, JComboBox.class, "ComboBoxUI", WebLookAndFeel.comboBoxUI),
    desktopPane(false, JDesktopPane.class, "DesktopPaneUI", WebLookAndFeel.desktopPaneUI),
    desktopIcon(false, JInternalFrame.JDesktopIcon.class, "DesktopIconUI", WebLookAndFeel.desktopIconUI),
    internalFrame(false, JInternalFrame.class, "InternalFrameUI", WebLookAndFeel.internalFrameUI),
    optionPane(false, JOptionPane.class, "OptionPaneUI", WebLookAndFeel.optionPaneUI);

    protected final boolean supportsPainters;
    protected final Class<? extends JComponent> componentClass;
    protected final String uiClassID;
    protected final String defaultUIClass;
    private static final Map<SupportedComponent, ImageIcon> componentIcons;
    private static final Map<String, SupportedComponent> componentByUIClassID;

    private SupportedComponent(boolean supportsPainters, Class<? extends JComponent> componentClass, String uiClassID, String defaultUIClass) {
        this.supportsPainters = supportsPainters;
        this.componentClass = componentClass;
        this.uiClassID = uiClassID;
        this.defaultUIClass = defaultUIClass;
    }

    public boolean supportsPainters() {
        return this.supportsPainters;
    }

    public Class<? extends JComponent> getComponentClass() {
        return this.componentClass;
    }

    public String getUIClassID() {
        return this.uiClassID;
    }

    public String getDefaultUIClass() {
        return this.defaultUIClass;
    }

    public String getComponentStyleId(JComponent component) {
        Styleable styleable = LafUtils.getStyleable(component);
        String styleId = styleable != null ? styleable.getStyleId() : "default";
        return styleId != null ? styleId : "default";
    }

    public Class<? extends ComponentUI> getUIClass() {
        Class type = ReflectUtils.getClassSafely(UIManager.getString(this.getUIClassID()));
        Class defaultType = ReflectUtils.getClassSafely(this.getDefaultUIClass());
        return ReflectUtils.isAssignable(defaultType, type) ? type : defaultType;
    }

    public ImageIcon getIcon() {
        ImageIcon icon = componentIcons.get((Object)this);
        if (icon == null) {
            try {
                icon = new ImageIcon(SupportedComponent.class.getResource("icons/component/" + (Object)((Object)this) + ".png"));
                componentIcons.put(this, icon);
            }
            catch (Throwable e) {
                Log.get().error("Unable to find component icon: " + (Object)((Object)this), e);
                componentIcons.put(this, null);
            }
        }
        return icon;
    }

    public static SupportedComponent getComponentTypeByUIClassID(String uiClassID) {
        if (componentByUIClassID.size() == 0) {
            for (SupportedComponent supportedComponent : SupportedComponent.values()) {
                componentByUIClassID.put(supportedComponent.getUIClassID(), supportedComponent);
            }
        }
        return componentByUIClassID.get(uiClassID);
    }

    public static List<SupportedComponent> getPainterSupportedComponents() {
        ArrayList<SupportedComponent> supportedComponents = new ArrayList<SupportedComponent>();
        for (SupportedComponent sc : SupportedComponent.values()) {
            if (!sc.supportsPainters()) continue;
            supportedComponents.add(sc);
        }
        return supportedComponents;
    }

    static {
        componentIcons = new EnumMap<SupportedComponent, ImageIcon>(SupportedComponent.class);
        componentByUIClassID = new HashMap<String, SupportedComponent>(SupportedComponent.values().length);
    }
}

