/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;

public class JScrollBarSettingsProcessor
extends SettingsProcessor<JScrollBar, Integer> {
    private AdjustmentListener adjustmentListener;

    public JScrollBarSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    @Override
    public Integer getDefaultValue() {
        Integer defaultValue = (Integer)super.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = ((JScrollBar)this.getComponent()).getMinimum();
        }
        return defaultValue;
    }

    @Override
    protected void doInit(JScrollBar scrollBar) {
        this.adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBarSettingsProcessor.this.save();
            }
        };
        scrollBar.addAdjustmentListener(this.adjustmentListener);
    }

    @Override
    protected void doDestroy(JScrollBar scrollBar) {
        scrollBar.removeAdjustmentListener(this.adjustmentListener);
        this.adjustmentListener = null;
    }

    @Override
    protected void doLoad(JScrollBar scrollBar) {
        scrollBar.setValue((Integer)this.loadValue());
    }

    @Override
    protected void doSave(JScrollBar scrollBar) {
        SettingsManager.set(this.getGroup(), this.getKey(), scrollBar.getValue());
    }
}

