/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.layout.MultiLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.popup.WebPopup;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;

public class PopupLayer
extends WebPanel {
    public PopupLayer() {
        this(new MultiLayout());
    }

    public PopupLayer(LayoutManager layoutManager) {
        super(layoutManager);
        this.setOpaque(false);
    }

    public MultiLayout getMultiLayout() {
        return (MultiLayout)this.getLayout();
    }

    public void addLayoutManager(LayoutManager layoutManager) {
        this.getMultiLayout().addLayoutManager(layoutManager);
    }

    public void removeLayoutManager(LayoutManager layoutManager) {
        this.getMultiLayout().removeLayoutManager(layoutManager);
    }

    public void hideAllPopups() {
        this.removeAll();
        this.setVisible(false);
    }

    public void showPopup(WebPopup popup) {
        popup.firePopupWillBeOpened();
        this.setBounds(new Rectangle(0, 0, this.getParent().getWidth(), this.getParent().getHeight()));
        this.add((Component)popup, 0);
        this.setVisible(true);
        popup.revalidate();
        popup.repaint();
    }

    public void hidePopup(WebPopup popup) {
        if (!popup.isShowing() || popup.getParent() != this) {
            return;
        }
        popup.firePopupWillBeClosed();
        Rectangle bounds = popup.getBounds();
        this.remove((Component)popup);
        this.revalidate();
        this.repaint(bounds);
    }

    @Override
    public boolean contains(int x, int y) {
        for (Component child : this.getComponents()) {
            Shape shape;
            Point l = child.getLocation();
            if (!(child instanceof ShapeProvider ? (shape = ((ShapeProvider)((Object)child)).provideShape()) != null && shape.contains(x - l.x, y - l.y) : child.getBounds().contains(x, y))) continue;
            return true;
        }
        return false;
    }

    public boolean normalContains(int x, int y) {
        return super.contains(x, y);
    }
}

