/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.WebTreeElement;
import com.alee.laf.tree.WebTreeStyle;
import com.alee.laf.tree.WebTreeUI;
import com.alee.utils.ImageUtils;
import com.alee.utils.TextUtils;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeCellRenderer;

public class WebTreeCellRenderer
extends WebTreeElement
implements TreeCellRenderer {
    public static final String ID_PREFIX = "WTCR";
    protected String id;
    protected ImageIcon rootIcon = WebTreeUI.ROOT_ICON;
    protected ImageIcon openIcon = WebTreeUI.OPEN_ICON;
    protected ImageIcon closedIcon = WebTreeUI.CLOSED_ICON;
    protected ImageIcon leafIcon = WebTreeUI.LEAF_ICON;

    public WebTreeCellRenderer() {
        this.setId();
        this.setName("Tree.cellRenderer");
        this.setForeground(UIManager.getColor("Tree.textForeground"));
    }

    private void setId() {
        this.id = TextUtils.generateId(ID_PREFIX);
    }

    @Override
    public WebTreeElement getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ImageIcon icon;
        boolean enabled = tree.isEnabled();
        this.setFont(tree.getFont());
        this.setEnabled(enabled);
        ImageIcon imageIcon = leaf ? this.leafIcon : (tree.getModel().getRoot() == value ? this.rootIcon : (icon = expanded ? this.openIcon : this.closedIcon));
        if (enabled) {
            this.setIcon(icon);
        } else {
            String type = leaf ? "leaf" : (tree.getModel().getRoot() == value ? "root" : (expanded ? "open" : "closed"));
            this.setIcon(ImageUtils.getDisabledCopy(this.getIconTypeKey(type), icon));
        }
        this.setText(tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus));
        TreeUI tui = tree.getUI();
        int sw = tui instanceof WebTreeUI ? ((WebTreeUI)tui).getSelectionShadeWidth() : WebTreeStyle.selectionShadeWidth;
        this.setMargin(sw + 2, sw + 2, sw + 2, sw + 4);
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    private String getIconTypeKey(String type) {
        return "WebTreeCellRenderer." + this.id + "." + type;
    }

    public Icon getRootIcon() {
        return this.rootIcon;
    }

    public void setRootIcon(Icon rootIcon) {
        this.rootIcon = rootIcon != null ? ImageUtils.getImageIcon(rootIcon) : null;
        ImageUtils.clearDisabledCopyCache(this.getIconTypeKey("root"));
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setOpenIcon(Icon openIcon) {
        this.openIcon = openIcon != null ? ImageUtils.getImageIcon(openIcon) : null;
        ImageUtils.clearDisabledCopyCache(this.getIconTypeKey("open"));
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setClosedIcon(Icon closedIcon) {
        this.closedIcon = closedIcon != null ? ImageUtils.getImageIcon(closedIcon) : null;
        ImageUtils.clearDisabledCopyCache(this.getIconTypeKey("closed"));
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setLeafIcon(Icon leafIcon) {
        this.leafIcon = leafIcon != null ? ImageUtils.getImageIcon(leafIcon) : null;
        ImageUtils.clearDisabledCopyCache(this.getIconTypeKey("leaf"));
    }
}

