/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.global.StyleConstants;
import com.alee.laf.rootpane.WebDialog;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBarStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class WebToolBarUI
extends BasicToolBarUI
implements ShapeProvider,
BorderMethods {
    public static final int gripperSpace = 5;
    private Color topBgColor = WebToolBarStyle.topBgColor;
    private Color bottomBgColor = WebToolBarStyle.bottomBgColor;
    private Color borderColor = WebToolBarStyle.borderColor;
    private Color disabledBorderColor = WebToolBarStyle.disabledBorderColor;
    private boolean undecorated = WebToolBarStyle.undecorated;
    private int round = WebToolBarStyle.round;
    private int shadeWidth = WebToolBarStyle.shadeWidth;
    private Insets margin = WebToolBarStyle.margin;
    private int spacing = WebToolBarStyle.spacing;
    private ToolbarStyle toolbarStyle = WebToolBarStyle.toolbarStyle;
    private Painter painter = WebToolBarStyle.painter;
    private final Color middleColor = new Color(158, 158, 158);
    private final Color[] gradient = new Color[]{StyleConstants.transparent, this.middleColor, this.middleColor, StyleConstants.transparent};
    private final float[] fractions = new float[]{0.0f, 0.33f, 0.66f, 1.0f};
    private AncestorListener ancestorListener;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener componentOrientationListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.toolBar);
        LookAndFeel.installProperty(this.toolBar, "opaque", Boolean.FALSE);
        PainterSupport.installPainter(this.toolBar, this.painter);
        this.updateBorder();
        this.updateLayout(this.toolBar, true);
        this.ancestorListener = new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                WebToolBarUI.this.updateBorder();
                WebToolBarUI.this.updateLayout(WebToolBarUI.this.toolBar, false);
            }
        };
        this.toolBar.addAncestorListener(this.ancestorListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebToolBarUI.this.updateBorder();
                WebToolBarUI.this.updateLayout(WebToolBarUI.this.toolBar, false);
            }
        };
        this.toolBar.addPropertyChangeListener("floatable", this.propertyChangeListener);
        this.toolBar.addPropertyChangeListener("orientation", this.propertyChangeListener);
        this.componentOrientationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebToolBarUI.this.updateBorder();
            }
        };
        this.toolBar.addPropertyChangeListener("componentOrientation", this.componentOrientationListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.toolBar, this.painter);
        c.removeAncestorListener(this.ancestorListener);
        c.removePropertyChangeListener("orientation", this.propertyChangeListener);
        c.removePropertyChangeListener("floatable", this.propertyChangeListener);
        c.removePropertyChangeListener("componentOrientation", this.componentOrientationListener);
        super.uninstallUI(c);
        this.toolBar = null;
    }

    @Override
    public Shape provideShape() {
        if (this.painter != null || this.undecorated) {
            return SwingUtils.size(this.toolBar);
        }
        return LafUtils.getWebBorderShape(this.toolBar, this.getShadeWidth(), this.getRound());
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
        this.updateBorder();
        if (this.painter != null && !undecorated) {
            this.toolBar.setOpaque(false);
        }
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.toolBar, this.painter);
        this.painter = painter;
        PainterSupport.installPainter(this.toolBar, this.painter);
        this.updateBorder();
    }

    public int getRound() {
        if (this.undecorated) {
            return 0;
        }
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color topBgColor) {
        this.topBgColor = topBgColor;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.bottomBgColor = bottomBgColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        this.disabledBorderColor = disabledBorderColor;
    }

    public int getShadeWidth() {
        if (this.undecorated) {
            return 0;
        }
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public ToolbarStyle getToolbarStyle() {
        return this.toolbarStyle;
    }

    public void setToolbarStyle(ToolbarStyle toolbarStyle) {
        this.toolbarStyle = toolbarStyle;
        this.updateBorder();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.updateLayout(this.toolBar, false);
    }

    @Override
    public void updateBorder() {
        if (this.toolBar != null) {
            if (SwingUtils.isPreserveBorders(this.toolBar)) {
                return;
            }
            if (this.painter != null) {
                Insets bi = this.painter.getMargin(this.toolBar);
                this.toolBar.setBorder(LafUtils.createWebBorder(this.margin.top + bi.top, this.margin.left + bi.left, this.margin.bottom + bi.bottom, this.margin.right + bi.right));
            } else if (!this.undecorated) {
                int gripperSpacing = this.toolBar.isFloatable() ? 5 : 0;
                boolean horizontal = this.toolBar.getOrientation() == 0;
                boolean ltr = this.toolBar.getComponentOrientation().isLeftToRight();
                if (this.toolbarStyle.equals((Object)ToolbarStyle.standalone)) {
                    if (this.isFloating()) {
                        this.toolBar.setBorder(LafUtils.createWebBorder(this.margin.top + (!horizontal ? gripperSpacing : 0), this.margin.left + (horizontal && ltr ? gripperSpacing : 0), this.margin.bottom, this.margin.right + (horizontal && !ltr ? gripperSpacing : 0)));
                    } else {
                        this.toolBar.setBorder(LafUtils.createWebBorder(this.margin.top + 1 + this.shadeWidth + (!horizontal ? gripperSpacing : 0), this.margin.left + 1 + this.shadeWidth + (horizontal && ltr ? gripperSpacing : 0), this.margin.bottom + 1 + this.shadeWidth, this.margin.right + 1 + this.shadeWidth + (horizontal && !ltr ? gripperSpacing : 0)));
                    }
                } else if (this.isFloating()) {
                    this.toolBar.setBorder(LafUtils.createWebBorder(this.margin.top + (!horizontal ? gripperSpacing : 0), this.margin.left + (horizontal && ltr ? gripperSpacing : 0), this.margin.bottom, this.margin.right + (horizontal && !ltr ? gripperSpacing : 0)));
                } else {
                    this.toolBar.setBorder(LafUtils.createWebBorder(this.margin.top + (!horizontal ? gripperSpacing : 0), this.margin.left + (horizontal && ltr ? gripperSpacing : 0) + (!horizontal && !ltr ? 1 : 0), this.margin.bottom + (horizontal ? 1 : 0), this.margin.right + (horizontal && !ltr ? gripperSpacing : 0) + (!horizontal && ltr ? 1 : 0)));
                }
            } else {
                this.toolBar.setBorder(LafUtils.createWebBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
            }
        }
    }

    private void updateLayout(JComponent c, boolean install) {
        boolean installed = c.getLayout() instanceof ToolbarLayout;
        if (!install && !installed) {
            return;
        }
        ToolbarLayout layout = new ToolbarLayout(this.spacing, this.toolBar.getOrientation());
        if (installed) {
            ToolbarLayout old = (ToolbarLayout)c.getLayout();
            layout.setConstraints(old.getConstraints());
        }
        c.setLayout(layout);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        } else if (!this.undecorated) {
            Graphics2D g2d = (Graphics2D)g;
            Object aa = GraphicsUtils.setupAntialias(g2d);
            boolean horizontal = this.toolBar.getOrientation() == 0;
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            if (this.isFloating()) {
                if (horizontal) {
                    g2d.setPaint(new GradientPaint(0.0f, c.getHeight() / 2, this.topBgColor, 0.0f, c.getHeight(), this.bottomBgColor));
                } else {
                    g2d.setPaint(new GradientPaint(c.getWidth() / 2, 0.0f, this.topBgColor, c.getWidth(), 0.0f, this.bottomBgColor));
                }
                g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
            } else if (this.toolbarStyle.equals((Object)ToolbarStyle.standalone)) {
                RoundRectangle2D.Double rr = new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, c.getWidth() - this.shadeWidth * 2 - 1, c.getHeight() - this.shadeWidth * 2 - 1, this.round, this.round);
                if (c.isEnabled()) {
                    GraphicsUtils.drawShade(g2d, rr, StyleConstants.shadeColor, this.shadeWidth);
                }
                if (horizontal) {
                    g2d.setPaint(new GradientPaint(0.0f, c.getHeight() / 2, this.topBgColor, 0.0f, c.getHeight(), this.bottomBgColor));
                } else {
                    g2d.setPaint(new GradientPaint(c.getWidth() / 2, 0.0f, this.topBgColor, c.getWidth(), 0.0f, this.bottomBgColor));
                }
                g2d.fill(rr);
                g2d.setPaint(c.isEnabled() ? this.borderColor : this.disabledBorderColor);
                g2d.draw(rr);
            } else {
                if (horizontal) {
                    g2d.setPaint(new GradientPaint(0.0f, c.getHeight() / 2, this.topBgColor, 0.0f, c.getHeight(), this.bottomBgColor));
                } else {
                    g2d.setPaint(new GradientPaint(c.getWidth() / 2, 0.0f, this.topBgColor, c.getWidth(), 0.0f, this.bottomBgColor));
                }
                g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
                g2d.setPaint(c.isEnabled() ? this.borderColor : this.disabledBorderColor);
                if (horizontal) {
                    g2d.drawLine(0, c.getHeight() - 1, c.getWidth() - 1, c.getHeight() - 1);
                } else if (ltr) {
                    g2d.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight() - 1);
                } else {
                    g2d.drawLine(0, 0, 0, c.getHeight() - 1);
                }
            }
            if (this.toolBar.isFloatable()) {
                if (this.toolBar.getOrientation() == 0) {
                    int gradY = this.shadeWidth + 1;
                    int gradEndY = c.getHeight() - this.shadeWidth - 2;
                    if (gradEndY > gradY) {
                        int i;
                        int x;
                        g2d.setPaint(new LinearGradientPaint(0.0f, gradY, 0.0f, gradEndY, this.fractions, this.gradient));
                        int n = this.toolbarStyle.equals((Object)ToolbarStyle.standalone) ? this.shadeWidth + 1 + this.margin.left + (this.isFloating() ? -1 : 1) : (x = this.margin.left + 2 - 1);
                        if (!ltr) {
                            x = c.getWidth() - x - 2;
                        }
                        for (i = c.getHeight() / 2 - 3; i >= gradY; i -= 4) {
                            g2d.fillRect(x, i, 2, 2);
                        }
                        i = c.getHeight() / 2 + 1;
                        while (i + 2 <= gradEndY) {
                            g2d.fillRect(x, i, 2, 2);
                            i += 4;
                        }
                    }
                } else {
                    int gradX = this.shadeWidth + 1;
                    int gradEndX = c.getWidth() - this.shadeWidth - 2;
                    if (gradEndX > gradX) {
                        int i;
                        g2d.setPaint(new LinearGradientPaint(gradX, 0.0f, gradEndX, 0.0f, this.fractions, this.gradient));
                        int y = this.toolbarStyle.equals((Object)ToolbarStyle.standalone) ? this.shadeWidth + 1 + this.margin.top + (this.isFloating() ? -1 : 1) : this.margin.top + 2 - 1;
                        for (i = c.getWidth() / 2 - 3; i >= gradX; i -= 4) {
                            g2d.fillRect(i, y, 2, 2);
                        }
                        i = c.getWidth() / 2 + 1;
                        while (i + 2 <= gradEndX) {
                            g2d.fillRect(i, y, 2, 2);
                            i += 4;
                        }
                    }
                }
            }
            GraphicsUtils.restoreAntialias(g2d, aa);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps;
        Dimension dimension = ps = c.getLayout() != null ? c.getLayout().preferredLayoutSize(c) : null;
        if (this.painter != null) {
            ps = SwingUtils.max(ps, this.painter.getPreferredSize(c));
        }
        return ps;
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtils.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends WebDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog((Frame)null, toolbar.getName(), false));
        dialog.getRootPane().setName("ToolBar.FloatingWindow");
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    @Override
    protected BasicToolBarUI.DragWindow createDragWindow(JToolBar toolbar) {
        BasicToolBarUI.DragWindow dragWindow = super.createDragWindow(toolbar);
        ProprietaryUtils.setWindowOpacity(dragWindow, 0.5f);
        return dragWindow;
    }

    @Override
    protected void installRolloverBorders(JComponent c) {
    }

    @Override
    protected void installNonRolloverBorders(JComponent c) {
    }

    @Override
    protected void installNormalBorders(JComponent c) {
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }
}

