/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.EventUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.WindowUtils;
import com.alee.utils.swing.ComponentEventRunnable;
import com.alee.utils.swing.WindowCloseAdapter;
import com.alee.utils.swing.WindowEventMethods;
import com.alee.utils.swing.WindowEventRunnable;
import com.alee.utils.swing.WindowMethods;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JWindow;

public class WebWindow
extends JWindow
implements WindowEventMethods,
LanguageContainerMethods,
SettingsMethods,
WindowMethods<WebWindow> {
    protected boolean closeOnFocusLoss = false;
    protected DefaultFocusTracker focusTracker;

    public WebWindow() {
        this.initialize();
    }

    public WebWindow(GraphicsConfiguration gc) {
        super(gc);
        this.initialize();
    }

    public WebWindow(Frame owner) {
        super(owner);
        this.initialize();
    }

    public WebWindow(Component owner) {
        super(SwingUtils.getWindowAncestor(owner));
        this.initialize();
    }

    public WebWindow(Window owner) {
        super(owner);
        this.initialize();
    }

    public WebWindow(Window owner, GraphicsConfiguration gc) {
        super(owner, gc);
        this.initialize();
    }

    protected void initialize() {
        this.setFocusable(true);
        SwingUtils.setOrientation(this);
        this.focusTracker = new DefaultFocusTracker(true){

            @Override
            public boolean isTrackingEnabled() {
                return WebWindow.this.isShowing() && WebWindow.this.closeOnFocusLoss;
            }

            @Override
            public void focusChanged(boolean focused) {
                if (WebWindow.this.closeOnFocusLoss && WebWindow.this.isShowing() && !focused) {
                    WebWindow.this.dispose();
                }
            }
        };
        FocusManager.addFocusTracker(this, this.focusTracker);
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public List<Component> getFocusableChilds() {
        return this.focusTracker.getCustomChildren();
    }

    public void addFocusableChild(Component child) {
        this.focusTracker.addCustomChild(child);
    }

    public void removeFocusableChild(Component child) {
        this.focusTracker.removeCustomChild(child);
    }

    @Override
    public WindowAdapter onClosing(WindowEventRunnable runnable) {
        return EventUtils.onClosing(this, runnable);
    }

    @Override
    public WindowCloseAdapter onClose(ComponentEventRunnable runnable) {
        return EventUtils.onClose(this, runnable);
    }

    @Override
    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer(this, key);
    }

    @Override
    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer(this);
    }

    @Override
    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey(this);
    }

    @Override
    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), key);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), key, defaultValueClass);
    }

    @Override
    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), key, defaultValue);
    }

    @Override
    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), group, key);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), group, key, defaultValueClass);
    }

    @Override
    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), group, key, defaultValue);
    }

    @Override
    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), key, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), key, defaultValueClass, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), group, key, defaultValueClass, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), group, key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this.getRootPane(), settingsProcessor);
    }

    @Override
    public void unregisterSettings() {
        SettingsManager.unregisterComponent(this.getRootPane());
    }

    @Override
    public void loadSettings() {
        SettingsManager.loadComponentSettings(this.getRootPane());
    }

    @Override
    public void saveSettings() {
        SettingsManager.saveComponentSettings(this.getRootPane());
    }

    @Override
    public WebWindow setWindowOpaque(boolean opaque) {
        return WindowUtils.setWindowOpaque(this, opaque);
    }

    @Override
    public boolean isWindowOpaque() {
        return WindowUtils.isWindowOpaque(this);
    }

    @Override
    public WebWindow setWindowOpacity(float opacity) {
        return WindowUtils.setWindowOpacity(this, opacity);
    }

    @Override
    public float getWindowOpacity() {
        return WindowUtils.getWindowOpacity(this);
    }

    @Override
    public WebWindow center() {
        return WindowUtils.center(this);
    }

    @Override
    public WebWindow center(Component relativeTo) {
        return WindowUtils.center(this, relativeTo);
    }

    @Override
    public WebWindow center(int width, int height) {
        return WindowUtils.center(this, width, height);
    }

    @Override
    public WebWindow center(Component relativeTo, int width, int height) {
        return WindowUtils.center(this, relativeTo, width, height);
    }

    @Override
    public WebWindow packToWidth(int width) {
        return WindowUtils.packToWidth(this, width);
    }

    @Override
    public WebWindow packToHeight(int height) {
        return WindowUtils.packToHeight(this, height);
    }

    @Override
    public WebWindow packAndCenter() {
        return WindowUtils.packAndCenter(this);
    }

    @Override
    public WebWindow packAndCenter(boolean animate) {
        return WindowUtils.packAndCenter(this, animate);
    }
}

