/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.list.ListRolloverSelectionAdapter;
import com.alee.laf.list.UnselectableListModel;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.WebListModel;
import com.alee.laf.list.WebListUI;
import com.alee.laf.list.editor.DefaultListCellEditor;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.laf.list.editor.ListEditListener;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.log.Log;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.utils.CollectionUtils;
import com.alee.utils.EventUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.EventMethods;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class WebList
extends JList
implements EventMethods,
FontMethods<WebList>,
SizeMethods<WebList> {
    protected List<ListEditListener> editListeners = new ArrayList<ListEditListener>(1);
    protected boolean editable = false;
    protected ListCellEditor listCellEditor = null;
    protected ToolTipProvider<? extends WebList> toolTipProvider = null;
    protected int editedCell = -1;
    protected boolean unselectable = true;

    public WebList() {
    }

    public WebList(List listData) {
        super(listData.toArray());
    }

    public WebList(Vector listData) {
        super(listData);
    }

    public WebList(Object[] listData) {
        super(listData);
    }

    public WebList(ListModel dataModel) {
        super(dataModel);
    }

    public void setMultiplySelectionAllowed(boolean allowed) {
        this.setSelectionMode(allowed ? 2 : 0);
    }

    public WebListCellRenderer getWebListCellRenderer() {
        ListCellRenderer renderer = this.getCellRenderer();
        return renderer instanceof WebListCellRenderer ? (WebListCellRenderer)renderer : null;
    }

    public WebListModel getWebModel() {
        ListModel model = this.getModel();
        return model instanceof WebListModel ? (WebListModel)model : null;
    }

    public void setSelectedValue(Object element) {
        this.setSelectedValue(element, true);
    }

    public void setSelectedValues(Object[] values) {
        this.setSelectedValues(CollectionUtils.toList(values));
    }

    public void setSelectedValues(Collection values) {
        this.setSelectedValues(new ArrayList(values));
    }

    public void setSelectedValues(List values) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ListModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!values.contains(model.getElementAt(i))) continue;
            indices.add(i);
        }
        this.setSelectedIndices(CollectionUtils.toArray(indices));
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (editable && this.listCellEditor == null) {
            this.setCellEditor(this.createDefaultCellEditor());
        }
    }

    public boolean isRolloverSelectionEnabled() {
        return ListRolloverSelectionAdapter.isInstalled(this);
    }

    public void setRolloverSelectionEnabled(boolean enabled) {
        if (enabled) {
            if (!this.isRolloverSelectionEnabled()) {
                this.setHighlightRolloverCell(false);
                ListRolloverSelectionAdapter.install(this);
            }
        } else if (this.isRolloverSelectionEnabled()) {
            ListRolloverSelectionAdapter.uninstall(this);
        }
    }

    public void setCellEditor(ListCellEditor listCellEditor) {
        this.removeCellEditor();
        this.listCellEditor = listCellEditor;
        listCellEditor.install(this);
    }

    protected ListCellEditor createDefaultCellEditor() {
        return new DefaultListCellEditor();
    }

    public ListCellEditor getCellEditor() {
        return this.listCellEditor;
    }

    public void removeCellEditor() {
        if (this.listCellEditor != null) {
            this.listCellEditor.uninstall(this);
            this.listCellEditor = null;
        }
    }

    public void editSelectedCell() {
        this.editCell(this.getSelectedIndex());
    }

    public void editCell(int index) {
        ListCellEditor cellEditor = this.getCellEditor();
        if (index != -1 && cellEditor != null) {
            this.setSelectedIndex(index);
            cellEditor.startEdit(this, index);
        }
    }

    public boolean stopCellEditing() {
        ListCellEditor cellEditor = this.getCellEditor();
        return cellEditor != null && cellEditor.isEditing() && cellEditor.stopEdit(this);
    }

    public boolean isEditing() {
        ListCellEditor cellEditor = this.getCellEditor();
        return cellEditor != null && cellEditor.isEditing();
    }

    public ToolTipProvider<? extends WebList> getToolTipProvider() {
        return this.toolTipProvider;
    }

    public void setToolTipProvider(ToolTipProvider<? extends WebList> provider) {
        this.toolTipProvider = provider;
    }

    public boolean isUnselectable() {
        return this.unselectable;
    }

    public void setUnselectable(boolean unselectable) {
        this.unselectable = unselectable;
        int lead = this.getLeadSelectionIndex();
        int[] selected = this.getSelectedIndices();
        this.setSelectionModel(unselectable ? new DefaultListSelectionModel() : new UnselectableListModel());
        this.setSelectedIndices(selected);
        this.getSelectionModel().setLeadSelectionIndex(lead);
    }

    public int getModelSize() {
        return this.getModel().getSize();
    }

    public <T> T getValueAt(int index) {
        return (T)this.getModel().getElementAt(index);
    }

    public void addListDataListener(ListDataListener listener) {
        this.getModel().addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.getModel().removeListDataListener(listener);
    }

    public void scrollToCell(int index) {
        Rectangle cellBounds;
        if (index != -1 && (cellBounds = this.getCellBounds(index, index)) != null) {
            this.scrollRectToVisible(cellBounds);
        }
    }

    public boolean isDecorateSelection() {
        return this.getWebUI().isDecorateSelection();
    }

    public void setDecorateSelection(boolean decorateSelection) {
        this.getWebUI().setDecorateSelection(decorateSelection);
    }

    public boolean isHighlightRolloverCell() {
        return this.getWebUI().isHighlightRolloverCell();
    }

    public void setHighlightRolloverCell(boolean highlightRolloverCell) {
        this.getWebUI().setHighlightRolloverCell(highlightRolloverCell);
    }

    public int getSelectionRound() {
        return this.getWebUI().getSelectionRound();
    }

    public void setSelectionRound(int selectionRound) {
        this.getWebUI().setSelectionRound(selectionRound);
    }

    public int getSelectionShadeWidth() {
        return this.getWebUI().getSelectionShadeWidth();
    }

    public void setSelectionShadeWidth(int selectionShadeWidth) {
        this.getWebUI().setSelectionShadeWidth(selectionShadeWidth);
    }

    public boolean isWebColoredSelection() {
        return this.getWebUI().isWebColoredSelection();
    }

    public void setWebColoredSelection(boolean webColored) {
        this.getWebUI().setWebColoredSelection(webColored);
    }

    public Color getSelectionBorderColor() {
        return this.getWebUI().getSelectionBorderColor();
    }

    public void setSelectionBorderColor(Color color) {
        this.getWebUI().setSelectionBorderColor(color);
    }

    public Color getSelectionBackgroundColor() {
        return this.getWebUI().getSelectionBackgroundColor();
    }

    public void setSelectionBackgroundColor(Color color) {
        this.getWebUI().setSelectionBackgroundColor(color);
    }

    public boolean isAutoScrollToSelection() {
        return this.getWebUI().isAutoScrollToSelection();
    }

    public void setAutoScrollToSelection(boolean autoScrollToSelection) {
        this.getWebUI().setAutoScrollToSelection(autoScrollToSelection);
    }

    public WebListUI getWebUI() {
        return (WebListUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebListUI)) {
            try {
                this.setUI((WebListUI)ReflectUtils.createInstance(WebLookAndFeel.listUI, new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, e);
                this.setUI(new WebListUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void repaint(Object value) {
        ListModel model = this.getModel();
        if (model instanceof WebListModel) {
            this.repaint(((WebListModel)model).indexOf(value));
        } else {
            for (int i = 0; i < model.getSize(); ++i) {
                if (model.getElementAt(i) != value) continue;
                this.repaint(i);
                break;
            }
        }
    }

    public void repaint(int index) {
        this.repaint(index, index);
    }

    public void repaint(int from, int to) {
        Rectangle cellBounds = this.getCellBounds(from, to);
        if (cellBounds != null) {
            this.repaint(cellBounds);
        }
    }

    public int getEditedCell() {
        return this.editedCell;
    }

    public void addListEditListener(ListEditListener listener) {
        this.editListeners.add(listener);
    }

    public void removeListEditListener(ListEditListener listener) {
        this.editListeners.remove(listener);
    }

    public void fireEditStarted(int index) {
        this.editedCell = index;
        for (ListEditListener listener : CollectionUtils.copy(this.editListeners)) {
            listener.editStarted(index);
        }
    }

    public void fireEditFinished(int index, Object oldValue, Object newValue) {
        this.editedCell = -1;
        for (ListEditListener listener : CollectionUtils.copy(this.editListeners)) {
            listener.editFinished(index, oldValue, newValue);
        }
    }

    public void fireEditCancelled(int index) {
        this.editedCell = -1;
        for (ListEditListener listener : CollectionUtils.copy(this.editListeners)) {
            listener.editCancelled(index);
        }
    }

    @Override
    public MouseAdapter onMousePress(MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseEnter(MouseEventRunnable runnable) {
        return EventUtils.onMouseEnter(this, runnable);
    }

    @Override
    public MouseAdapter onMouseExit(MouseEventRunnable runnable) {
        return EventUtils.onMouseExit(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onDoubleClick(MouseEventRunnable runnable) {
        return EventUtils.onDoubleClick(this, runnable);
    }

    @Override
    public MouseAdapter onMenuTrigger(MouseEventRunnable runnable) {
        return EventUtils.onMenuTrigger(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    public FocusAdapter onFocusGain(FocusEventRunnable runnable) {
        return EventUtils.onFocusGain(this, runnable);
    }

    @Override
    public FocusAdapter onFocusLoss(FocusEventRunnable runnable) {
        return EventUtils.onFocusLoss(this, runnable);
    }

    @Override
    public WebList setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebList setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebList setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebList setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebList setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebList setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebList setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebList setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebList setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebList changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebList setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebList setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebList setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebList setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebList setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebList setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebList setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth(this);
    }

    @Override
    public WebList setMaximumWidth(int maximumWidth) {
        return SizeUtils.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight(this);
    }

    @Override
    public WebList setMaximumHeight(int maximumHeight) {
        return SizeUtils.setMaximumHeight(this, maximumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    public WebList setPreferredSize(int width, int height) {
        return SizeUtils.setPreferredSize(this, width, height);
    }
}

