/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.laf.combobox.ComboBoxElementType;
import com.alee.laf.combobox.WebComboBoxElement;
import com.alee.utils.swing.RendererListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WebComboBoxCellRenderer
implements ListCellRenderer {
    protected List<RendererListener> rendererListeners = new ArrayList<RendererListener>(1);
    protected WebComboBoxElement boxRenderer = new WebComboBoxElement(ComboBoxElementType.box);
    protected WebComboBoxElement elementRenderer = new WebComboBoxElement(ComboBoxElementType.list);

    public WebComboBoxCellRenderer() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebComboBoxCellRenderer.this.fireRevalidate();
            }
        };
        this.boxRenderer.addPropertyChangeListener("painter", listener);
        this.elementRenderer.addPropertyChangeListener("painter", listener);
    }

    public WebComboBoxElement getBoxRenderer() {
        return this.boxRenderer;
    }

    public WebComboBoxElement getElementRenderer() {
        return this.elementRenderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        WebComboBoxElement renderer = index == -1 ? this.boxRenderer : this.elementRenderer;
        renderer.setIndex(index);
        renderer.setTotalElements(list.getModel().getSize());
        renderer.setSelected(isSelected);
        renderer.setEnabled(list.isEnabled());
        renderer.setFont(list.getFont());
        renderer.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        renderer.setComponentOrientation(list.getComponentOrientation());
        if (value instanceof Icon) {
            renderer.setIcon((Icon)value);
            renderer.setText("");
        } else {
            renderer.setIcon(null);
            renderer.setText(value == null || value.toString().equals("") ? " " : value.toString());
        }
        return renderer;
    }

    public void addRendererListener(RendererListener listener) {
        this.rendererListeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.rendererListeners.remove(listener);
    }

    public void fireRepaint() {
        for (RendererListener listener : this.rendererListeners) {
            listener.repaint();
        }
    }

    public void fireRevalidate() {
        for (RendererListener listener : this.rendererListeners) {
            listener.revalidate();
        }
    }
}

