/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.extended.layout.TableLayout;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.colorchooser.PaletteColorChooserPaint;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PaletteColorChooser
extends WebPanel {
    public static final ImageIcon LOOP_ICON = new ImageIcon(PaletteColorChooser.class.getResource("icons/loop.png"));
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private boolean adjusting = false;
    private boolean webOnlyColors = false;
    private Color sideColor = Color.RED;
    private Color color = Color.WHITE;
    private PaletteColorChooserPaint paletteColorChooserPaint = new PaletteColorChooserPaint(0, 0, 256, 256, this.sideColor);
    private BufferedImage image = ImageUtils.createCompatibleImage(256, 256, 3);
    private Point coordinate = new Point(2, 2);
    private JComponent colorChooser;

    public PaletteColorChooser() {
        this.repaintImage();
        this.setLayout(new TableLayout(new double[][]{{-2.0}, {3.0, -2.0, 3.0}}));
        this.colorChooser = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                Shape old = g2d.getClip();
                Area clip = new Area(new Rectangle2D.Double(2.0, 2.0, this.getWidth() - 4, this.getHeight() - 4));
                clip.intersect(new Area(old));
                g2d.setClip(clip);
                g2d.drawImage((Image)PaletteColorChooser.this.image, 2, 2, null);
                g2d.drawImage(LOOP_ICON.getImage(), ((PaletteColorChooser)PaletteColorChooser.this).coordinate.x - LOOP_ICON.getIconWidth() / 2, ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y - LOOP_ICON.getIconHeight() / 2, LOOP_ICON.getImageObserver());
                g2d.setClip(old);
            }
        };
        this.colorChooser.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createLineBorder(Color.WHITE, 1)));
        this.colorChooser.setPreferredSize(new Dimension(260, 260));
        ColorChooserMouseAdapter adapter = new ColorChooserMouseAdapter();
        this.colorChooser.addMouseListener(adapter);
        this.colorChooser.addMouseMotionListener(adapter);
        this.add((Component)this.colorChooser, (Object)"0,1");
    }

    public JComponent getColorChooser() {
        return this.colorChooser;
    }

    private void repaintImage() {
        Graphics2D g2d = this.image.createGraphics();
        g2d.setPaint(this.paletteColorChooserPaint);
        g2d.fillRect(0, 0, 256, 256);
        g2d.dispose();
    }

    private Cursor createLoopCursor() {
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(14, 14);
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(dimension.width, dimension.height, 3);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(LOOP_ICON.getImage(), 0, 0, LOOP_ICON.getImageObserver());
        g2d.dispose();
        return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(7, 7), "Loop Cursor");
    }

    public Color getSideColor() {
        return this.sideColor;
    }

    public void setSideColor(Color sideColor) {
        this.adjusting = true;
        this.sideColor = sideColor;
        this.paletteColorChooserPaint = new PaletteColorChooserPaint(1, 1, 256, 256, sideColor);
        this.paletteColorChooserPaint.setWebSafe(this.webOnlyColors);
        this.repaintImage();
        this.setColor(this.paletteColorChooserPaint.getColor(this.coordinate.x, this.coordinate.y));
        this.adjusting = false;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (!this.adjusting) {
            this.updateSelectionByColor();
        }
        this.firePropertyChanged();
        this.colorChooser.repaint();
    }

    public boolean isWebOnlyColors() {
        return this.webOnlyColors;
    }

    public void setWebOnlyColors(boolean webOnlyColors) {
        this.webOnlyColors = webOnlyColors;
        this.paletteColorChooserPaint.setWebSafe(webOnlyColors);
        this.repaintImage();
        this.colorChooser.repaint();
        this.firePropertyChanged();
    }

    private void updateSelectionByColor() {
        HSBColor hsbColor = new HSBColor(this.color);
        this.coordinate.x = 2 + Math.round(256.0f * hsbColor.getSaturation());
        this.coordinate.y = 2 + Math.round(256.0f - 256.0f * hsbColor.getBrightness());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    private void firePropertyChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : CollectionUtils.copy(this.changeListeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private class ColorChooserMouseAdapter
    extends MouseAdapter {
        private boolean dragging = false;

        private ColorChooserMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragging = true;
            PaletteColorChooser.this.adjusting = true;
            this.updateCoordinate(e.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateCoordinate(e.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragging = false;
            PaletteColorChooser.this.adjusting = false;
            if (!PaletteColorChooser.this.colorChooser.getVisibleRect().contains(e.getPoint())) {
                PaletteColorChooser.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private void updateCoordinate(Point point) {
            PaletteColorChooser.this.coordinate = point;
            if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.x < 2) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.x = 2;
            } else if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.x > 258) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.x = 258;
            }
            if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.y < 2) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y = 2;
            } else if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.y > 258) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y = 258;
            }
            PaletteColorChooser.this.setColor(PaletteColorChooser.this.paletteColorChooserPaint.getColor(((PaletteColorChooser)PaletteColorChooser.this).coordinate.x, ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            PaletteColorChooser.this.setCursor(PaletteColorChooser.this.createLoopCursor());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.dragging) {
                PaletteColorChooser.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

