/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;

@XStreamAlias(value="HSBColor")
public class HSBColor {
    @XStreamAsAttribute
    private float hue = 0.0f;
    @XStreamAsAttribute
    private float saturation = 0.0f;
    @XStreamAsAttribute
    private float brightness = 0.0f;

    public HSBColor() {
    }

    public HSBColor(float hue, float saturation, float brightness) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
    }

    public HSBColor(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public HSBColor(int red, int green, int blue) {
        float[] values = Color.RGBtoHSB(red, green, blue, null);
        this.hue = values[0];
        this.saturation = values[1];
        this.brightness = values[2];
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public float getHue() {
        return this.hue;
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public Color getColor() {
        return new Color(Color.HSBtoRGB(this.hue, this.saturation, this.brightness));
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[h=" + this.getHue() + ",s=" + this.getSaturation() + ",b=" + this.getBrightness() + "]";
    }
}

